/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.pte;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.pte.PteFeeDomain;
import cn.com.qj.bff.domain.pte.PteFeeReDomain;
import cn.com.qj.bff.service.pte.PteFeeService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pte/ptefee"}, name="\u5206\u6da6\u8bbe\u7f6e")
public class PteFeeCon
extends SpringmvcController {
    private static String CODE = "pte.ptefee.con";
    @Autowired
    private PteFeeService pteFeeService;

    @Override
    protected String getContext() {
        return "ptefee";
    }

    @RequestMapping(value={"savePteFee.json"}, name="\u589e\u52a0\u5206\u6da6\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean savePteFee(HttpServletRequest request, PteFeeDomain ptefeeDomain) {
        if (null == ptefeeDomain) {
            this.logger.error(CODE + ".savePteFee", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ptefeeDomain.setTenantCode(this.getTenantCode(request));
        return this.pteFeeService.saveFee(ptefeeDomain);
    }

    @RequestMapping(value={"getPteFee.json"}, name="\u83b7\u53d6\u5206\u6da6\u8bbe\u7f6e\u4fe1\u606f")
    @ResponseBody
    public PteFeeReDomain getPteFee(String feeId) {
        if (StringUtils.isBlank((String)feeId)) {
            this.logger.error(CODE + ".getPteFee", (Object)"param is null");
            return null;
        }
        return this.pteFeeService.getFee(Integer.valueOf(feeId));
    }

    @RequestMapping(value={"updatePteFee.json"}, name="\u66f4\u65b0\u5206\u6da6\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updatePteFee(HttpServletRequest request, PteFeeDomain ptefeeDomain) {
        if (null == ptefeeDomain) {
            this.logger.error(CODE + ".updatePteFee", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ptefeeDomain.setTenantCode(this.getTenantCode(request));
        return this.pteFeeService.updateFee(ptefeeDomain);
    }

    @RequestMapping(value={"deletePteFee.json"}, name="\u5220\u9664\u5206\u6da6\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean deletePteFee(String feeId) {
        if (StringUtils.isBlank((String)feeId)) {
            this.logger.error(CODE + ".deletePteFee", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pteFeeService.deleteFee(Integer.valueOf(feeId));
    }

    @RequestMapping(value={"queryPteFeePage.json"}, name="\u67e5\u8be2\u5206\u6da6\u8bbe\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PteFeeReDomain> queryPteFeePage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pteFeeService.queryFeePage(param);
    }

    @RequestMapping(value={"updatePteFeeState.json"}, name="\u66f4\u65b0\u5206\u6da6\u8bbe\u7f6e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePteFeeState(String feeId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)feeId)) {
            this.logger.error(CODE + ".updatePteFeeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pteFeeService.updateFeeState(Integer.valueOf(feeId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryFeeSettingCache.json"}, name="\u5206\u6da6\u914d\u7f6e\u7f13\u5b58")
    @ResponseBody
    public HtmlJsonReBean queryFeeSettingCache() {
        return this.pteFeeService.queryFeeSettingCache();
    }
}

