/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.om;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.om.OrmOrderDomain;
import cn.com.qj.bff.domain.om.OrmOrderReDomain;
import cn.com.qj.bff.service.om.OrderService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/om/order"}, name="\u8ba2\u8d2d\u4fe1\u606f")
public class OrderCon
extends SpringmvcController {
    private static String CODE = "om.order.con";
    @Autowired
    private OrderService orderService;

    @Override
    protected String getContext() {
        return "order";
    }

    @RequestMapping(value={"saveOrder.json"}, name="\u589e\u52a0\u8ba2\u8d2d\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveOrder(HttpServletRequest request, OrmOrderDomain orderDomain) {
        if (null == orderDomain) {
            this.logger.error(CODE + ".saveOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        orderDomain.setTenantCode(this.getTenantCode(request));
        return this.orderService.saveOrder(orderDomain);
    }

    @RequestMapping(value={"getOrder.json"}, name="\u83b7\u53d6\u8ba2\u8d2d\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public OrmOrderReDomain getOrder(String orderId) {
        if (StringUtils.isBlank((String)orderId)) {
            this.logger.error(CODE + ".getOrder", (Object)"param is null");
            return null;
        }
        return this.orderService.getOrder(Integer.valueOf(orderId));
    }

    @RequestMapping(value={"updateOrder.json"}, name="\u66f4\u65b0\u8ba2\u8d2d\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateOrder(HttpServletRequest request, OrmOrderDomain orderDomain) {
        if (null == orderDomain) {
            this.logger.error(CODE + ".updateOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        orderDomain.setTenantCode(this.getTenantCode(request));
        return this.orderService.updateOrder(orderDomain);
    }

    @RequestMapping(value={"deleteOrder.json"}, name="\u5220\u9664\u8ba2\u8d2d\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteOrder(String orderId) {
        if (StringUtils.isBlank((String)orderId)) {
            this.logger.error(CODE + ".deleteOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.orderService.deleteOrder(Integer.valueOf(orderId));
    }

    @RequestMapping(value={"queryOrderPage.json"}, name="\u67e5\u8be2\u8ba2\u8d2d\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OrmOrderReDomain> queryOrderPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.orderService.queryOrderPage(param);
    }

    @RequestMapping(value={"updateOrderState.json"}, name="\u66f4\u65b0\u8ba2\u8d2d\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOrderState(String orderId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)orderId)) {
            this.logger.error(CODE + ".updateOrderState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.orderService.updateOrderState(Integer.valueOf(orderId), dataState, oldDataState);
    }
}

