/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.pg;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.da.DaPickStatisticsDomain;
import cn.com.qj.bff.domain.pg.PgGgoodsDomain;
import cn.com.qj.bff.domain.pg.PgGgoodsReDomain;
import cn.com.qj.bff.domain.pg.PgGroupDomain;
import cn.com.qj.bff.domain.pg.PgGroupReDomain;
import cn.com.qj.bff.service.da.DaPickStatisticsService;
import cn.com.qj.bff.service.pg.PgGgoodsService;
import cn.com.qj.bff.service.pg.PgGroupService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pg/ggoods"}, name="\u9009\u54c1\u7ec4\u5957\u5546\u54c1\u670d\u52a1")
public class GgoodsCon
extends SpringmvcController {
    private static String CODE = "pg.ggoods.con";
    @Autowired
    private PgGgoodsService pgGgoodsService;
    @Autowired
    private PgGroupService pgGroupService;
    @Autowired
    private DaPickStatisticsService daPickStatisticsService;

    @Override
    protected String getContext() {
        return "ggoods";
    }

    @RequestMapping(value={"saveGgoods.json"}, name="\u589e\u52a0\u9009\u54c1\u7ec4\u5957\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveGgoods(final HttpServletRequest request, String pgGroup) {
        if (null == pgGroup) {
            this.logger.error(CODE + ".saveGgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveGgoods", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        final PgGroupDomain pgGroupDomain = (PgGroupDomain)JsonUtil.buildNormalBinder().getJsonToObject(pgGroup, PgGroupDomain.class);
        if (EmptyUtil.isEmpty((Object)pgGroupDomain.getGroupCode())) {
            this.logger.error(CODE + ".saveGgoods", (Object)"groupCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = this.pgGroupService.updateGroup(pgGroupDomain);
        if (!htmlJsonReBean.isSuccess()) {
            this.logger.error(CODE + ".saveGgoods", (Object)"htmlJsonReBean is false");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u53d8\u66f4 \u8bf7\u5237\u65b0\u91cd\u8bd5!");
        }
        SupQueryResult<PgGgoodsReDomain> pgGgoodsResult = this.pgGgoodsService.queryGgoodsPage((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("tenantCode", GgoodsCon.this.getTenantCode(request));
                this.put("groupCode", pgGroupDomain.getGroupCode());
            }
        });
        String oldSkuCode = "";
        String oldGoodsIds = "";
        if (!EmptyUtil.isEmpty(pgGgoodsResult) && ListUtil.isNotEmpty((Collection)pgGgoodsResult.getList())) {
            for (PgGgoodsReDomain pgGgoodsReDomain : pgGgoodsResult.getList()) {
                oldSkuCode = oldSkuCode + pgGgoodsReDomain.getSkuCode() + ",";
                oldGoodsIds = oldGoodsIds + pgGgoodsReDomain.getGgoodsId() + ",";
            }
            oldGoodsIds = oldGoodsIds.substring(0, oldGoodsIds.length() - 1);
            this.pgGgoodsService.deleteGgoodsBatch(oldGoodsIds);
        }
        if (StringUtils.isNotBlank((String)oldSkuCode)) {
            oldSkuCode = oldSkuCode.substring(0, oldSkuCode.length() - 1);
        }
        int i = 0;
        String newSkuCode = "";
        if (ListUtil.isNotEmpty(pgGroupDomain.getPgGgoodsDomainList())) {
            for (PgGgoodsDomain pgGgoodsDomain : pgGroupDomain.getPgGgoodsDomainList()) {
                pgGgoodsDomain.setGroupCode(pgGroupDomain.getGroupCode());
                pgGgoodsDomain.setTenantCode(this.getTenantCode(request));
                pgGgoodsDomain.setUserCode(userSession.getUserPcode());
                newSkuCode = newSkuCode + pgGgoodsDomain.getSkuCode() + ",";
            }
            if (StringUtils.isNotBlank((String)newSkuCode)) {
                newSkuCode = newSkuCode.substring(0, newSkuCode.length() - 1);
            }
            i = this.minus(newSkuCode.split(","), oldSkuCode.split(","));
            htmlJsonReBean = this.pgGgoodsService.saveGgoodsBatch(pgGroupDomain.getPgGgoodsDomainList());
        }
        if (i > 0) {
            DaPickStatisticsDomain daPickStatisticsDomain = new DaPickStatisticsDomain();
            daPickStatisticsDomain.setUserCode(userSession.getUserCode());
            daPickStatisticsDomain.setUserName(userSession.getUserName());
            daPickStatisticsDomain.setTenantCode(this.getTenantCode(request));
            daPickStatisticsDomain.setPistDate("updateSku");
            daPickStatisticsDomain.setModifySku(i);
            daPickStatisticsDomain.setAppmanageIcode("retailer");
            this.daPickStatisticsService.savePickStatistics(daPickStatisticsDomain);
        }
        return htmlJsonReBean;
    }

    public int minus(String[] arr1, String[] arr2) {
        LinkedList<String> list = new LinkedList<String>();
        LinkedList<String> history = new LinkedList<String>();
        String[] longerArr = arr1;
        String[] shorterArr = arr2;
        if (arr1.length > arr2.length) {
            longerArr = arr2;
            shorterArr = arr1;
        }
        for (String str : longerArr) {
            if (list.contains(str)) continue;
            list.add(str);
        }
        for (String str : shorterArr) {
            if (list.contains(str)) {
                history.add(str);
                list.remove(str);
                continue;
            }
            if (history.contains(str)) continue;
            list.add(str);
        }
        return list.size();
    }

    @RequestMapping(value={"getGgoods.json"}, name="\u83b7\u53d6\u9009\u54c1\u7ec4\u5957\u5546\u54c1\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PgGgoodsReDomain getGgoods(Integer ggoodsId) {
        if (StringUtils.isBlank((Integer)ggoodsId)) {
            this.logger.error(CODE + ".getGgoods", (Object)"param is null");
            return null;
        }
        return this.pgGgoodsService.getGgoods(ggoodsId);
    }

    @RequestMapping(value={"updateGgoods.json"}, name="\u66f4\u65b0\u9009\u54c1\u7ec4\u5957\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateGgoods(HttpServletRequest request, String pgGgoodsDomain) {
        if (null == pgGgoodsDomain) {
            this.logger.error(CODE + ".updateGgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PgGgoodsDomain ggoodsDomain = (PgGgoodsDomain)JsonUtil.buildNormalBinder().getJsonToObject(pgGgoodsDomain, PgGgoodsDomain.class);
        if (EmptyUtil.isEmpty((Object)ggoodsDomain.getGgoodsId()) || EmptyUtil.isEmpty((Object)ggoodsDomain.getGgoodsCode())) {
            this.logger.error(CODE + ".updateGgoods", (Object)"id-code \u4e0d\u80fd\u4e3a\u7a7a");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ggoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.pgGgoodsService.updateGgoods(ggoodsDomain);
    }

    @RequestMapping(value={"deleteGgoods.json"}, name="\u5220\u9664\u9009\u54c1\u7ec4\u5957\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteGgoods(Integer ggoodsId) {
        if (StringUtils.isBlank((Integer)ggoodsId)) {
            this.logger.error(CODE + ".deleteGgoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pgGgoodsService.deleteGgoods(ggoodsId);
    }

    @RequestMapping(value={"queryGgoodsPage.json"}, name="\u67e5\u8be2\u9009\u54c1\u7ec4\u5957\u5546\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public HtmlJsonReBean queryGgoodsPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (EmptyUtil.isEmpty((Object)param.get("groupCode"))) {
            this.logger.error(CODE + ".queryGgoodsPage", (Object)"groupCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "groupCode is null");
        }
        PgGroupReDomain groupCode = this.pgGroupService.getGroupByCode(this.getTenantCode(request), param.get("groupCode") + "");
        if (null == groupCode) {
            this.logger.error(CODE + ".queryGgoodsPage", (Object)"group is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7ec4\u5957\u4e0d\u5b58\u5728");
        }
        SupQueryResult<PgGgoodsReDomain> pgGgoodsReDomainSupQueryResult = this.pgGgoodsService.queryGgoodsPage(param);
        if (!EmptyUtil.isEmpty(pgGgoodsReDomainSupQueryResult) && ListUtil.isNotEmpty((Collection)pgGgoodsReDomainSupQueryResult.getList())) {
            groupCode.setPgGgoodsReDomainList(pgGgoodsReDomainSupQueryResult.getList());
        }
        return new HtmlJsonReBean((Object)groupCode);
    }

    @RequestMapping(value={"updateGgoodsState.json"}, name="\u66f4\u65b0\u9009\u54c1\u7ec4\u5957\u5546\u54c1\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateGgoodsState(String ggoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)ggoodsId)) {
            this.logger.error(CODE + ".updateGgoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pgGgoodsService.updateGgoodsState(Integer.valueOf(ggoodsId), dataState, oldDataState, null);
    }
}

