/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.pg;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.da.DaPickStatisticsDomain;
import cn.com.qj.bff.domain.fm.FmFileReDomainBean;
import cn.com.qj.bff.domain.pg.IfbApprovalDomain;
import cn.com.qj.bff.domain.pg.IfbApprovalHistoryReDomain;
import cn.com.qj.bff.domain.pg.IfbApprovalReDomain;
import cn.com.qj.bff.domain.pg.IfbRequestDomain;
import cn.com.qj.bff.domain.pg.IfbRequestFileReDomain;
import cn.com.qj.bff.domain.pg.IfbRequestReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.service.da.DaPickStatisticsService;
import cn.com.qj.bff.service.fm.FileService;
import cn.com.qj.bff.service.pg.IfbApprovalHistoryService;
import cn.com.qj.bff.service.pg.IfbApprovalService;
import cn.com.qj.bff.service.pg.IfbRequestFileService;
import cn.com.qj.bff.service.pg.IfbRequestService;
import cn.com.qj.bff.service.pg.IfbUserRegionService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import cn.com.qj.bff.util.PdfUtil;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPTable;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Controller
@RequestMapping(value={"/web/pg/ifbRequest"}, name="\u62db\u6807\u7533\u8bf7")
public class IfbRequestCon
extends SpringmvcController {
    private static String CODE = "pg.ifbRequest.con";
    @Autowired
    private IfbRequestService ifbRequestService;
    @Autowired
    private IfbRequestFileService ifbRequestFileService;
    @Autowired
    private IfbApprovalHistoryService ifbApprovalHistoryService;
    @Autowired
    private FileService fileService;
    @Autowired
    private IfbApprovalService ifbApprovalService;
    @Autowired
    private IfbUserRegionService ifbUserRegionService;
    @Autowired
    private DaPickStatisticsService daPickStatisticsService;
    @Autowired
    private UserService userService;

    @Override
    protected String getContext() {
        return "ifbRequest";
    }

    @RequestMapping(value={"saveIfbRequest.json"}, name="\u589e\u52a0\u62db\u6807\u7533\u8bf7")
    @ResponseBody
    public HtmlJsonReBean saveIfbRequest(HttpServletRequest request, String ifbRequestDomain) throws Exception {
        if (null == ifbRequestDomain) {
            this.logger.error(CODE + ".saveIfbRequest", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveIfbRequest", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession-null");
        }
        String userCode = userSession.getUserCode();
        String areaCode = userSession.getAreaCode();
        this.logger.error(CODE + ".saveIfbRequest.areaCode", (Object)areaCode);
        if (StringUtils.isBlank((String)areaCode)) {
            this.logger.error(CODE + ".saveIfbRequest", (Object)"userArea is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5f53\u524d\u7ecf\u9500\u5546\u672a\u7ed1\u5b9a\u533a\u57df");
        }
        IfbRequestDomain domain = (IfbRequestDomain)JsonUtil.buildNormalBinder().getJsonToObject(ifbRequestDomain, IfbRequestDomain.class);
        domain.setTenantCode(this.getTenantCode(request));
        domain.setReUserCode(userCode);
        domain.setReUserName(domain.getCompanyName());
        UmUserinfoReDomainBean userinfo = this.userService.getUserinfoByCode(userSession.getUserPcode(), userSession.getTenantCode());
        domain.setReRdCode(userinfo.getCompanyShortname());
        domain.setAreaCode(areaCode);
        HtmlJsonReBean htmlJsonReBean = this.ifbRequestService.savebRequest(domain);
        if (htmlJsonReBean.isSuccess()) {
            DaPickStatisticsDomain SelectionRecommendation = new DaPickStatisticsDomain();
            SelectionRecommendation.setUserCode(userSession.getUserCode());
            SelectionRecommendation.setUserName(userSession.getUserName());
            SelectionRecommendation.setTenantCode(this.getTenantCode(request));
            SelectionRecommendation.setPistDate("ApplicationSubmission");
            SelectionRecommendation.setRecoGroup(1);
            SelectionRecommendation.setAppmanageIcode("retailer");
            this.daPickStatisticsService.savePickStatistics(SelectionRecommendation);
        }
        return htmlJsonReBean;
    }

    private String exportWord(HttpServletRequest request, IfbRequestDomain domain) throws Exception {
        if (null == domain) {
            this.logger.error(CODE + ".exportRequestPdf", (Object)"IfbRequestDomain is null");
            return null;
        }
        String companyName = domain.getCompanyName() == null ? " " : domain.getCompanyName();
        String brandNames = domain.getBrandNames() == null ? " " : domain.getBrandNames();
        String projectName = domain.getProjectName() == null ? " " : domain.getProjectName();
        String projectCode = domain.getProjectCode() == null ? " " : domain.getProjectCode();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        Date startTime = domain.getAuthStartTime() == null ? null : domain.getAuthStartTime();
        String authStartTime = startTime == null ? "" : simpleDateFormat.format(startTime.getTime());
        Date endTime = domain.getAuthEndTime() == null ? null : domain.getAuthEndTime();
        String authEndTime = endTime == null ? "" : simpleDateFormat.format(endTime.getTime());
        Date lastTime = domain.getLastTime() == null ? new Date() : domain.getLastTime();
        String currentTime = simpleDateFormat.format(lastTime);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("companyName", companyName);
        dataMap.put("brandName", brandNames);
        dataMap.put("projectName", projectName);
        dataMap.put("startDate", authStartTime);
        dataMap.put("endDate", authEndTime);
        dataMap.put("projectCode", projectCode);
        dataMap.put("createDate", currentTime);
        Configuration configuration = new Configuration();
        configuration.setDefaultEncoding("utf-8");
        configuration.setClassForTemplateLoading(((Object)((Object)this)).getClass(), "/");
        File outFile = new File("/pdfExport3" + UUID.randomUUID().toString() + ".doc");
        String outFileName = "\u6388\u6743\u60c5\u51b5\u8bf4\u660e\u51fd-\u5206\u9500\u5546.ftl";
        if (StringUtils.isNotBlank((String)domain.getAuthObjectName()) && domain.getAuthObjectName().equals("\u4e2d\u95f4\u670d\u52a1\u5546")) {
            outFileName = "\u6388\u6743\u60c5\u51b5\u8bf4\u660e\u51fd-\u4e2d\u95f4\u670d\u52a1\u5546.ftl";
        }
        Template t = configuration.getTemplate(outFileName, "utf-8");
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "utf-8"), 10240);
        t.process(dataMap, (Writer)out);
        ((Writer)out).close();
        FileItem fileItem = PdfUtil.createFileItem(outFile);
        CommonsMultipartFile multipartFile = new CommonsMultipartFile(fileItem);
        FmFileReDomainBean fileReDomainBean = this.fileService.saveFileO((MultipartFile)multipartFile, this.getTenantCode(request), null, this.getUserSession(request).getUserPcode());
        return fileReDomainBean.getFileUrl();
    }

    private String exportRequestPdf(HttpServletRequest request, IfbRequestDomain domain) throws Exception {
        if (null == domain) {
            this.logger.error(CODE + ".exportRequestPdf", (Object)"IfbRequestDomain is null");
            return null;
        }
        String fileName = "/pdfExport3" + UUID.randomUUID().toString() + ".pdf";
        Document document = PdfUtil.getDocument(PageSize.A4, 0.0f, 0.0f, 0.0f, 0.0f, fileName, "b&g\u4f01\u4e1a\u8d2d-\u9009\u54c1\u6e05\u5355", "qjclouds");
        document.open();
        Font totelFont = PdfUtil.getChineseFont(10.0f, 1, BaseColor.BLACK);
        Font tatelFont = PdfUtil.getChineseFont(15.0f, 0, BaseColor.BLACK);
        PdfPTable tableTel = new PdfPTable(1);
        tableTel.getDefaultCell().setBorder(0);
        tableTel.getDefaultCell().setPadding(0.0f);
        tableTel.setWidthPercentage(100.0f);
        tableTel.getDefaultCell().setHorizontalAlignment(1);
        PdfUtil.addBlankLines(tableTel, 3, 10.0f);
        document.add((Element)tableTel);
        PdfPTable title = new PdfPTable(1);
        PdfUtil.getCenterNotBoderCell(new Phrase("\u6388\u6743\u8bf4\u660e\u51fd", tatelFont), title);
        document.add((Element)title);
        document.add((Element)tableTel);
        String companyName = domain.getCompanyName() == null ? " " : domain.getCompanyName();
        String brandNames = domain.getBrandNames() == null ? " " : domain.getBrandNames();
        String projectName = domain.getProjectName() == null ? " " : domain.getBrandNames();
        String projectCode = domain.getProjectCode() == null ? " " : domain.getProjectCode();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        Date startTime = domain.getAuthStartTime() == null ? null : domain.getAuthStartTime();
        String authStartTime = startTime == null ? "" : simpleDateFormat.format(startTime.getTime());
        Date endTime = domain.getAuthEndTime() == null ? null : domain.getAuthEndTime();
        String authEndTime = endTime == null ? "" : simpleDateFormat.format(endTime.getTime());
        String currentTime = simpleDateFormat.format(new Date().getTime());
        PdfPTable table1 = new PdfPTable(1);
        PdfUtil.getNotBoderCell(new Phrase("      " + companyName + "   \u662f\u5b9d\u6d01\uff08\u4e2d\u56fd\uff09\u8425\u9500\u6709\u9650\u516c\u53f8\uff08\u201c\u5b9d\u6d01\u8425\u9500\u201d\uff09\u7684\u7b7e\u7ea6\u7ecf\u9500\u5546\uff0c\u9500\u552e\u5b9d\u6d01\u65d7\u4e0b\u5404\u7c7b\u54c1\u724c\u4ea7\u54c1\uff0c\u5305\u62ec  " + brandNames + "\uff0c\u5176\u6709\u6743\u6839\u636e\u81ea\u8eab\u751f\u610f\u9700\u6c42\u51b3\u5b9a\u9500\u552e\u65b9\u5f0f\u5e76\u81ea\u884c\u627f\u62c5\u98ce\u9669\u3002", totelFont), table1);
        document.add((Element)table1);
        PdfPTable table2 = new PdfPTable(1);
        PdfUtil.getNotBoderCell(new Phrase("      " + companyName + "   \u62df\u53c2\u4e0e " + projectName + "\u9879\u76ee\u4ee5\u62d3\u5c55\u5b9d\u6d01\u54c1\u724c\u4ea7\u54c1\u9500\u8def\uff0c\u5e76\u4e3a\u6b64\u76ee\u7684\u4ee5\u54c1\u724c\u540c\u610f\u7684\u65b9\u5f0f\u4f7f\u7528\u4ea7\u54c1\u56fe\u7247\u3001\u5546\u6807\u7b49\u3002\u5b9d\u6d01\u8425\u9500\u4f5c\u4e3a\u4e0a\u8ff0\u54c1\u724c\u7684\u6743\u5229\u4eba\u613f\u610f\u63d0\u4f9b\u5fc5\u8981\u652f\u6301\uff0c\u7279\u6b64\u8bf4\u660e\u3002\u672c\u8bf4\u660e\u51fd\u6709\u6548\u671f\u4ece " + authStartTime + " \u81f3 " + authEndTime + " \u3002\u5b9d\u6d01\u8425\u9500\u6709\u6743\u4ee5\u63d0\u524d30\u5929\u4e66\u9762\u901a\u77e5\u5f62\u5f0f\u4fee\u6539\u6216\u7ec8\u6b62\u672c\u6388\u6743\u3002", totelFont), table2);
        document.add((Element)table2);
        document.add((Element)tableTel);
        document.add((Element)tableTel);
        PdfPTable table3 = new PdfPTable(1);
        PdfUtil.getLeftNoboderCell(new Phrase("\u88ab\u6388\u6743\u4eba\uff1a " + companyName, totelFont), table3, 5.0f);
        document.add((Element)table3);
        table3 = new PdfPTable(1);
        PdfUtil.getLeftNoboderCell(new Phrase("\u6388\u6743\u9879\u76ee\uff1a " + projectName, totelFont), table3, 5.0f);
        document.add((Element)table3);
        table3 = new PdfPTable(1);
        PdfUtil.getLeftNoboderCell(new Phrase("\u63a8\u5e7f\u65f6\u95f4\uff1a " + authStartTime + " \u81f3 " + authEndTime, totelFont), table3, 5.0f);
        document.add((Element)table3);
        table3 = new PdfPTable(1);
        PdfUtil.getLeftNoboderCell(new Phrase("\u9879\u76ee\u7f16\u53f7\uff1a " + projectCode, totelFont), table3, 5.0f);
        document.add((Element)table3);
        table3 = new PdfPTable(1);
        PdfUtil.getLeftNoboderCell(new Phrase("\u54c1\u724c\u8303\u56f4\uff1a " + brandNames, totelFont), table3, 5.0f);
        document.add((Element)table3);
        document.add((Element)tableTel);
        PdfPTable table4 = new PdfPTable(1);
        PdfUtil.getRightNoboderCell(new Phrase("\u5b9d\u6d01\uff08\u4e2d\u56fd\uff09\u8425\u9500\u6709\u9650\u516c\u53f8", tatelFont), table4, 5.0f);
        document.add((Element)table4);
        table4 = new PdfPTable(1);
        PdfUtil.getRightNoboderCell(new Phrase(currentTime, tatelFont), table4, 5.0f);
        document.add((Element)table4);
        document.close();
        File file = new File(fileName);
        FileItem fileItem = PdfUtil.createFileItem(file);
        CommonsMultipartFile multipartFile = new CommonsMultipartFile(fileItem);
        FmFileReDomainBean fileReDomainBean = this.fileService.saveFileO((MultipartFile)multipartFile, this.getTenantCode(request), null, this.getUserSession(request).getUserPcode());
        return fileReDomainBean.getFileUrl();
    }

    @RequestMapping(value={"getIfbRequest.json"}, name="\u83b7\u53d6\u62db\u6807\u7533\u8bf7")
    @ResponseBody
    public IfbRequestReDomain getIfbRequest(final HttpServletRequest request, final String requestCode) {
        if (StringUtils.isBlank((String)requestCode)) {
            this.logger.error(CODE + ".getIfbRequest", (Object)"param is null");
            return null;
        }
        IfbRequestReDomain ifbRequestReDomain = this.ifbRequestService.getbRequestByCode(this.getTenantCode(request), requestCode);
        if (!EmptyUtil.isEmpty((Object)ifbRequestReDomain)) {
            SupQueryResult<IfbApprovalHistoryReDomain> historyPage;
            SupQueryResult<IfbRequestFileReDomain> filePage;
            if (!EmptyUtil.isEmpty((Object)ifbRequestReDomain.getAuthStartTime()) && !EmptyUtil.isEmpty((Object)ifbRequestReDomain.getAuthEndTime()) && IfbRequestCon.getMonthDiff(ifbRequestReDomain.getAuthStartTime(), ifbRequestReDomain.getAuthEndTime()) <= 3) {
                ifbRequestReDomain.setOverTime(true);
            }
            if (!EmptyUtil.isEmpty(filePage = this.ifbRequestFileService.querybRequestFilePage((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("requestCode", requestCode);
                    this.put("tenantCode", IfbRequestCon.this.getTenantCode(request));
                }
            })) && ListUtil.isNotEmpty((Collection)filePage.getList())) {
                ifbRequestReDomain.setIfbRequestFileReDomainList(filePage.getList());
            }
            if (!EmptyUtil.isEmpty(historyPage = this.ifbApprovalHistoryService.querybApprovalHistoryPage((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("requestCode", requestCode);
                    this.put("tenantCode", IfbRequestCon.this.getTenantCode(request));
                }
            })) && ListUtil.isNotEmpty((Collection)historyPage.getList())) {
                ifbRequestReDomain.setIfbApprovalHistoryReDomainList(historyPage.getList());
            }
        }
        return ifbRequestReDomain;
    }

    @RequestMapping(value={"updateIfbRequest.json"}, name="\u66f4\u65b0\u62db\u6807\u7533\u8bf7")
    @ResponseBody
    public HtmlJsonReBean updateIfbRequest(final HttpServletRequest request, String ifbRequestDomain) {
        SupQueryResult<IfbApprovalReDomain> supQueryResult;
        if (null == ifbRequestDomain) {
            this.logger.error(CODE + ".updateIfbRequest", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        IfbRequestDomain ifbRequest = (IfbRequestDomain)JsonUtil.buildNormalBinder().getJsonToObject(ifbRequestDomain, IfbRequestDomain.class);
        ifbRequest.setTenantCode(this.getTenantCode(request));
        final String requestCode = ifbRequest.getRequestCode();
        this.logger.error(CODE + ".updateIfbRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)ifbRequest));
        HtmlJsonReBean htmlJsonReBean = this.ifbRequestService.updatebRequest(ifbRequest);
        if (htmlJsonReBean.isSuccess() && (StringUtils.isNotBlank((String)ifbRequest.getBiddingResult()) || StringUtils.isNotBlank((String)ifbRequest.getCustomerCode())) && !EmptyUtil.isEmpty(supQueryResult = this.ifbApprovalService.querybApprovalPage((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("requestCode", requestCode);
                this.put("tenantCode", IfbRequestCon.this.getTenantCode(request));
            }
        })) && ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
            IfbApprovalDomain ifbApprovalDomain = new IfbApprovalDomain();
            if (StringUtils.isNotBlank((String)ifbRequest.getBiddingResult())) {
                ifbApprovalDomain.setBiddingResult(ifbRequest.getBiddingResult());
            }
            if (StringUtils.isNotBlank((String)ifbRequest.getCustomerCode())) {
                ifbApprovalDomain.setCustomerCode(ifbRequest.getCustomerCode());
            }
            if (StringUtils.isNotBlank((String)ifbRequest.getSalesTracking())) {
                ifbApprovalDomain.setSalesTracking(ifbRequest.getSalesTracking());
            }
            ifbApprovalDomain.setTenantCode(this.getTenantCode(request));
            ifbApprovalDomain.setApprovalId(((IfbApprovalReDomain)supQueryResult.getList().get(0)).getApprovalId());
            htmlJsonReBean = this.ifbApprovalService.updatebApproval(ifbApprovalDomain);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"restartIfbRequest.json"}, name="\u9a73\u56de\u540e\u66f4\u65b0\u63d0\u4ea4\u62db\u6807\u7533\u8bf7")
    @ResponseBody
    public HtmlJsonReBean restartIfbRequest(HttpServletRequest request, String ifbRequestDomain) {
        if (null == ifbRequestDomain) {
            this.logger.error(CODE + ".restartIfbRequest", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        IfbRequestDomain ifbRequest = (IfbRequestDomain)JsonUtil.buildNormalBinder().getJsonToObject(ifbRequestDomain, IfbRequestDomain.class);
        ifbRequest.setTenantCode(this.getTenantCode(request));
        return this.ifbRequestService.restartIfbRequest(ifbRequest);
    }

    @RequestMapping(value={"deleteIfbRequest.json"}, name="\u5220\u9664\u62db\u6807\u7533\u8bf7")
    @ResponseBody
    public HtmlJsonReBean deleteIfbRequest(Integer requestId) {
        if (StringUtils.isBlank((Integer)requestId)) {
            this.logger.error(CODE + ".deleteIfbRequest", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ifbRequestService.deletebRequest(requestId);
    }

    @RequestMapping(value={"queryIfbRequestPage.json"}, name="\u67e5\u8be2\u62db\u6807\u7533\u8bf7\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<IfbRequestReDomain> queryIfbRequestPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ifbRequestService.querybRequestPage(param);
    }

    @RequestMapping(value={"updateIfbRequestState.json"}, name="\u66f4\u65b0\u62db\u6807\u7533\u8bf7\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateIfbRequestState(String requestId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)requestId)) {
            this.logger.error(CODE + ".updateIfbRequestState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ifbRequestService.updatebRequestState(Integer.valueOf(requestId), dataState, oldDataState, null);
    }

    public static int getMonthDiff(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        int year1 = c1.get(1);
        int year2 = c2.get(1);
        int month1 = c1.get(2);
        int month2 = c2.get(2);
        int day1 = c1.get(5);
        int day2 = c2.get(5);
        int yearInterval = year1 - year2;
        if (month1 < month2 || month1 == month2 && day1 < day2) {
            --yearInterval;
        }
        int monthInterval = month1 + 12 - month2;
        if (day1 < day2) {
            --monthInterval;
        }
        int monthsDiff = Math.abs(yearInterval * 12 + (monthInterval %= 12));
        return monthsDiff;
    }
}

