/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.pg;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.pg.PgLabelDomain;
import cn.com.qj.bff.domain.pg.PgLabelReDomain;
import cn.com.qj.bff.service.pg.PgLabelService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pg/label"}, name="\u9009\u54c1\u6807\u7b7e\u670d\u52a1")
public class LabelCon
extends SpringmvcController {
    private static final String CODE = "pg.label.con";
    private static final String STRNULL = "NULL";
    private static final String STRNA = "N/A";
    private static final String STRNULLCH = "\u7a7a";
    private static final String STRZERO = "0";
    private final PgLabelService pgLabelService;

    public LabelCon(PgLabelService pgLabelService) {
        this.pgLabelService = pgLabelService;
    }

    @Override
    protected String getContext() {
        return "label";
    }

    @RequestMapping(value={"saveLabel.json"}, name="\u589e\u52a0\u9009\u54c1\u6807\u7b7e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveLabel(HttpServletRequest request, PgLabelDomain pgLabelDomain) {
        if (null == pgLabelDomain) {
            this.logger.error("pg.label.con.saveLabel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        pgLabelDomain.setTenantCode(this.getTenantCode(request));
        return this.pgLabelService.saveLabel(pgLabelDomain);
    }

    @RequestMapping(value={"saveLabelToImpont.json"}, name="\u5bfc\u5165\u9009\u54c1\u6807\u7b7e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveLabelToImpont(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error("pg.label.con.saveLabelToImpont", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, PgLabelDomain.class);
        if (ListUtil.isEmpty((Collection)list)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        this.assLabelList(request, list);
        HtmlJsonReBean htmlJsonReBean = this.pgLabelService.updateLabelBatch(list);
        if (htmlJsonReBean.isSuccess()) {
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean((Object)list);
    }

    private void assLabelList(HttpServletRequest request, List<PgLabelDomain> list) {
        if (ListUtil.isNotEmpty(list)) {
            for (PgLabelDomain pgLabelDomain : list) {
                pgLabelDomain.setTenantCode(this.getTenantCode(request));
            }
        }
    }

    private PgLabelDomain makePgLabelDomain(PgLabelReDomain pgLabelDomain, PgLabelDomain pgLabelNewDomain) {
        if (null == pgLabelDomain) {
            return null;
        }
        try {
            BeanUtils.copyAllPropertys((Object)pgLabelDomain, (Object)pgLabelNewDomain);
            return pgLabelDomain;
        }
        catch (Exception e) {
            this.logger.error("pg.label.con.makePgLabelDomain", (Throwable)e);
            return null;
        }
    }

    @RequestMapping(value={"getLabel.json"}, name="\u83b7\u53d6\u9009\u54c1\u6807\u7b7e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public PgLabelReDomain getLabel(Integer labelId) {
        if (StringUtils.isBlank((Integer)labelId)) {
            this.logger.error("pg.label.con.getLabel", (Object)"param is null");
            return null;
        }
        return this.pgLabelService.getLabel(labelId);
    }

    @RequestMapping(value={"updateLabel.json"}, name="\u66f4\u65b0\u9009\u54c1\u6807\u7b7e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateLabel(HttpServletRequest request, String pgLabelDomain) {
        if (null == pgLabelDomain) {
            this.logger.error("pg.label.con.updateLabel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PgLabelDomain labelDomain = (PgLabelDomain)JsonUtil.buildNormalBinder().getJsonToObject(pgLabelDomain, PgLabelDomain.class);
        labelDomain.setTenantCode(this.getTenantCode(request));
        return this.pgLabelService.updateLabel(labelDomain);
    }

    @RequestMapping(value={"deleteLabel.json"}, name="\u5220\u9664\u9009\u54c1\u6807\u7b7e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteLabel(Integer labelId) {
        if (StringUtils.isBlank((Integer)labelId)) {
            this.logger.error("pg.label.con.deleteLabel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pgLabelService.deleteLabel(labelId);
    }

    @RequestMapping(value={"queryLabelPage.json"}, name="\u67e5\u8be2\u9009\u54c1\u6807\u7b7e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PgLabelReDomain> queryLabelPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        this.logger.error("pg.label.con.queryLabelPage", (Object)JsonUtil.buildNormalBinder().toJson(param));
        return this.pgLabelService.queryLabelPage(param);
    }

    @RequestMapping(value={"queryLabelLoadCache.json"}, name="\u52a0\u8f7d\u6570\u636e\u7f13\u5b58")
    @ResponseBody
    public HtmlJsonReBean queryLabelLoadCache(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.pgLabelService.queryLabelLoadCache(param);
    }

    @RequestMapping(value={"updateLabelState.json"}, name="\u66f4\u65b0\u9009\u54c1\u6807\u7b7e\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateLabelState(String labelId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)labelId)) {
            this.logger.error("pg.label.con.updateLabelState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pgLabelService.updateLabelState(Integer.valueOf(labelId), dataState, oldDataState, null);
    }

    private static String conventStr(String str) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        if (LabelCon.isStrNull(str).booleanValue()) {
            return "";
        }
        return str;
    }

    private static Boolean isStrNull(String str) {
        if (STRNA.equals(str) || STRNULL.equals(str) || STRNULLCH.equals(str) || STRZERO.equals(str)) {
            return true;
        }
        return false;
    }
}

