/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.util.file;

import cn.com.qj.bff.util.file.FileContent;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;

public class FileUtil {
    public static FileContent getImageByte(String img) {
        ByteArrayOutputStream outStream = null;
        FileContent file = new FileContent();
        String contentType = "";
        try {
            URL url = new URL(img);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            contentType = conn.getContentType();
            InputStream inStream = conn.getInputStream();
            outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            inStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] content = outStream.toByteArray();
        file.setContent(content);
        file.setContent_type(contentType);
        return file;
    }

    public static void main(String[] args) {
        FileContent imageByte = FileUtil.getImageByte("http://vibktprfx-prod-prod-damo-eas-cn-shanghai.oss-cn-shanghai.aliyuncs.com/seg-common-image/2022-04-22/dcdaa231-7db6-45ce-a15d-cf62ed38fed0/image.png?Expires=1650625380");
        System.out.println(imageByte.getContent());
    }

    public static byte[] getFileStream(String url, int width, int height) {
        try {
            BufferedImage tag = null;
            BufferedImage image = null;
            URL httpUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)httpUrl.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            int contentLength = conn.getContentLength();
            if (contentLength < 0) {
                return null;
            }
            image = ImageIO.read(httpUrl);
            tag = new BufferedImage(width, height, 1);
            tag.getGraphics().drawImage(image.getScaledInstance(width, height, 4), 0, 0, null);
            String contentType = conn.getContentType();
            String fileType = FileUtil.checkFileType(contentType);
            if (StringUtils.isBlank((String)fileType)) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)tag, fileType.substring(1, fileType.length()), out);
            return out.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String checkFileType(String contentType) {
        if (StringUtils.isNotBlank((String)contentType) && contentType.equals("image/png")) {
            return ".png";
        }
        if (StringUtils.isNotBlank((String)contentType) && contentType.equals("image/jpeg")) {
            return ".jpeg";
        }
        if (StringUtils.isNotBlank((String)contentType) && contentType.equals("image/jpg")) {
            return ".jpg";
        }
        return "";
    }

    public static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        return outStream.toByteArray();
    }
}

