/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.data;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.da.DaPgStatisticsDomain;
import cn.com.qj.bff.domain.da.DaPgStatisticsReDomain;
import cn.com.qj.bff.domain.pg.ContentStatistics;
import cn.com.qj.bff.service.da.DaPgStatisticsService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/da/daPgStatistics"}, name="\u9009\u54c1\u603b\u7edf\u8ba1")
public class DaPgStatisticsCon
extends SpringmvcController {
    private static String CODE = "da.daPgStatistics.con";
    @Autowired
    private DaPgStatisticsService daPgStatisticsService;

    @Override
    protected String getContext() {
        return "daPgStatistics";
    }

    @RequestMapping(value={"saveDaPgStatistics.json"}, name="\u589e\u52a0\u9009\u54c1\u603b\u7edf\u8ba1")
    @ResponseBody
    public HtmlJsonReBean saveDaPgStatistics(HttpServletRequest request, DaPgStatisticsDomain daPgStatisticsDomain) {
        if (null == daPgStatisticsDomain) {
            this.logger.error(CODE + ".saveDaPgStatistics", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        daPgStatisticsDomain.setTenantCode(this.getTenantCode(request));
        return this.daPgStatisticsService.savePgStatistics(daPgStatisticsDomain);
    }

    @RequestMapping(value={"getDaPgStatistics.json"}, name="\u83b7\u53d6\u9009\u54c1\u603b\u7edf\u8ba1\u4fe1\u606f")
    @ResponseBody
    public DaPgStatisticsReDomain getDaPgStatistics(Integer pgstId) {
        if (StringUtils.isBlank((Integer)pgstId)) {
            this.logger.error(CODE + ".getDaPgStatistics", (Object)"param is null");
            return null;
        }
        return this.daPgStatisticsService.getPgStatistics(pgstId);
    }

    @RequestMapping(value={"updateDaPgStatistics.json"}, name="\u66f4\u65b0\u9009\u54c1\u603b\u7edf\u8ba1")
    @ResponseBody
    public HtmlJsonReBean updateDaPgStatistics(HttpServletRequest request, DaPgStatisticsDomain daPgStatisticsDomain) {
        if (null == daPgStatisticsDomain) {
            this.logger.error(CODE + ".updateDaPgStatistics", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        daPgStatisticsDomain.setTenantCode(this.getTenantCode(request));
        return this.daPgStatisticsService.updatePgStatistics(daPgStatisticsDomain);
    }

    @RequestMapping(value={"deleteDaPgStatistics.json"}, name="\u5220\u9664\u9009\u54c1\u603b\u7edf\u8ba1")
    @ResponseBody
    public HtmlJsonReBean deleteDaPgStatistics(Integer pgstId) {
        if (StringUtils.isBlank((Integer)pgstId)) {
            this.logger.error(CODE + ".deleteDaPgStatistics", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.daPgStatisticsService.deletePgStatistics(pgstId);
    }

    @RequestMapping(value={"queryDaPgStatisticsPage.json"}, name="\u67e5\u8be2\u9009\u54c1\u603b\u7edf\u8ba1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<DaPgStatisticsReDomain> queryDaPgStatisticsPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.daPgStatisticsService.queryPgStatisticsPage(param);
    }

    @RequestMapping(value={"updateDaPgStatisticsState.json"}, name="\u66f4\u65b0\u9009\u54c1\u603b\u7edf\u8ba1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateDaPgStatisticsState(String pgstId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)pgstId)) {
            this.logger.error(CODE + ".updateDaPgStatisticsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.daPgStatisticsService.updatePgStatisticsState(Integer.valueOf(pgstId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"getContentStatistics.json"}, name="\u83b7\u53d6\u5185\u5bb9\u7edf\u8ba1")
    @ResponseBody
    public ContentStatistics getContentStatistics(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.daPgStatisticsService.getContentStatistics(param);
    }

    @RequestMapping(value={"getOverviewStatistics.json"}, name="\u83b7\u53d6\u603b\u89c8\u7edf\u8ba1")
    @ResponseBody
    public SupQueryResult<ContentStatistics> getOverviewStatistics(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.daPgStatisticsService.getOverviewStatistics(param);
    }
}

