/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.util;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;

public class PdfUtil {
    public static final BaseColor SKY_BLUE = new BaseColor(230, 243, 255);

    public static Document getDocument(Rectangle rectangle, float marginLeft, float marginRight, float marginTop, float marginBootom, String fileName, String titel, String author) throws Exception {
        Document document = new Document(rectangle, marginLeft, marginRight, marginTop, marginBootom);
        PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(new File(fileName)));
        document.addTitle(titel);
        document.addAuthor(author);
        return document;
    }

    public static Font getChineseFont(float fontsize, int fontflag, BaseColor fontcolor) {
        Font fontChinese = null;
        try {
            BaseFont bfChinese = BaseFont.createFont((String)"STSongStd-Light", (String)"UniGB-UCS2-H", (boolean)false);
            fontChinese = new Font(bfChinese, fontsize, fontflag, fontcolor);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fontChinese;
    }

    public static PdfPTable getPdFTable(int numCloumns, int widthPercentPage) {
        PdfPTable pdfPTable = new PdfPTable(numCloumns);
        pdfPTable.setWidthPercentage((float)widthPercentPage);
        return pdfPTable;
    }

    public static void getNotBoderCell(Phrase phrase, PdfPTable table, float hight) {
        PdfPCell cell = new PdfPCell(phrase);
        cell.setBorder(0);
        cell.setFixedHeight(hight);
        table.addCell(cell);
    }

    public static void getNotBoderCell(Phrase phrase, PdfPTable table) {
        PdfPCell cell = new PdfPCell(phrase);
        cell.setBorder(0);
        table.addCell(cell);
    }

    public static void getRowsBoderCell(Phrase phrase, PdfPTable table, int rows) {
        PdfPCell cell = new PdfPCell(phrase);
        cell.setBorder(0);
        cell.setRowspan(rows);
        table.addCell(cell);
    }

    public static void getCenterNotBoderCell(Phrase phrase, PdfPTable table) {
        PdfPCell cell = new PdfPCell(phrase);
        cell.setBorder(0);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setVerticalAlignment(1);
        table.addCell(cell);
    }

    public static void getLeftCell(Phrase phrase, PdfPTable table, BaseColor baseColor, float height) {
        PdfPCell cell = new PdfPCell(phrase);
        cell.setUseAscender(true);
        cell.setVerticalAlignment(0);
        if (null != baseColor) {
            cell.setBackgroundColor(baseColor);
        }
        cell.setFixedHeight(height);
        table.addCell(cell);
    }

    public static void getRowSpanCell(Phrase phrase, PdfPTable table, int rows, float height) {
        PdfPCell cell = new PdfPCell(phrase);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setVerticalAlignment(1);
        cell.setFixedHeight(height);
        cell.setRowspan(rows);
        table.addCell(cell);
    }

    public static void getNewCell(Phrase phrase, PdfPTable table, BaseColor baseColor, float height) {
        PdfPCell cell = new PdfPCell(phrase);
        cell.setUseAscender(true);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        if (null != baseColor) {
            cell.setBackgroundColor(baseColor);
        }
        cell.setFixedHeight(height);
        table.addCell(cell);
    }

    public static void getImageCell(String url, float width, float height, PdfPTable table) throws Exception {
        Image instance = Image.getInstance((String)url);
        instance.scaleToFit(width, height);
        instance.setAlignment(0);
        PdfPCell cell = new PdfPCell(instance, true);
        cell.setUseAscender(true);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.disableBorderSide(15);
        table.addCell(cell);
    }

    public static void getImageCell(Image instance, PdfPTable table) {
        PdfPCell cell = new PdfPCell(instance);
        cell.setUseAscender(true);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.disableBorderSide(15);
        table.addCell(cell);
    }

    public static FileItem createFileItem(File file) {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        FileItem item = factory.createItem("textField", "text/plain", true, file.getName());
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        try {
            FileInputStream fis = new FileInputStream(file);
            OutputStream os = item.getOutputStream();
            while ((bytesRead = fis.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return item;
    }

    public static void getNewNoboderCell(Phrase phrase, PdfPTable table, float height) {
        PdfPCell cell = new PdfPCell(phrase);
        cell.setUseAscender(true);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.disableBorderSide(15);
        cell.setFixedHeight(height);
        table.addCell(cell);
    }

    public static void getNewNoboderCell(Phrase phrase, PdfPTable table) {
        PdfPCell cell = new PdfPCell(phrase);
        cell.setUseAscender(true);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.disableBorderSide(15);
        cell.setPadding(5.0f);
        table.addCell(cell);
    }

    public static void getLeftNoboderCell(Phrase phrase, PdfPTable table, float padding) {
        PdfPCell cell = new PdfPCell(phrase);
        cell.setUseAscender(true);
        cell.setHorizontalAlignment(0);
        cell.setVerticalAlignment(5);
        cell.disableBorderSide(15);
        cell.setPadding(padding);
        table.addCell(cell);
    }

    public static void getRightNoboderCell(Phrase phrase, PdfPTable table, float padding) {
        PdfPCell cell = new PdfPCell(phrase);
        cell.setUseAscender(true);
        cell.setHorizontalAlignment(2);
        cell.setVerticalAlignment(5);
        cell.disableBorderSide(15);
        cell.setPadding(padding);
        table.addCell(cell);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] InputStreamByteArray(String filePath) throws IOException {
        byte[] var3;
        FileInputStream in = null;
        try {
            byte[] data;
            in = new FileInputStream(filePath);
            var3 = data = PdfUtil.toByteArray(in);
        }
        finally {
            if (null != in) {
                in.close();
            }
        }
        return var3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = null;
        try {
            byte[] var4;
            int n;
            out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            boolean var3 = false;
            while ((n = in.read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
            byte[] byArray = var4 = out.toByteArray();
            return byArray;
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
    }

    public static void deleteFile(List<String> fileNames) {
        String sPath = null;
        File file = null;
        boolean flag = false;
        try {
            for (int i = 0; i < fileNames.size(); ++i) {
                sPath = fileNames.get(i);
                file = new File(sPath);
                if (!file.exists()) continue;
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void zipFiles(File[] srcFiles, File zipFile) {
        if (!zipFile.exists()) {
            try {
                zipFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        FileInputStream fileInputStream = null;
        try {
            fileOutputStream = new FileOutputStream(zipFile);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            ZipEntry zipEntry = null;
            for (int i = 0; i < srcFiles.length; ++i) {
                int len;
                fileInputStream = new FileInputStream(srcFiles[i]);
                zipEntry = new ZipEntry(srcFiles[i].getName());
                zipOutputStream.putNextEntry(zipEntry);
                byte[] buffer = new byte[1024];
                while ((len = fileInputStream.read(buffer)) > 0) {
                    zipOutputStream.write(buffer, 0, len);
                }
            }
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static PdfPTable addBlankLines(PdfPTable table, int noOfLine, float height) {
        table.getDefaultCell().setFixedHeight(height);
        for (int i = 0; i < noOfLine; ++i) {
            table.addCell(" ");
        }
        return table;
    }
}

