/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.common.config;

import cn.com.qj.bff.springmvc.filter.XssFilter;
import cn.com.qj.bff.springmvc.interceptor.SpringMVCInterceptor;
import com.google.common.collect.Maps;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebConfig
implements WebMvcConfigurer {
    @Bean
    public SpringMVCInterceptor myInterceptor() {
        return new SpringMVCInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.myInterceptor()).addPathPatterns(new String[]{"/**"}).excludePathPatterns(new String[]{"/laserDirect/**"}).excludePathPatterns(new String[]{"/testReload/**"});
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedHeaders(new String[]{"*"}).allowedMethods(new String[]{"POST", "GET"}).allowedOrigins(new String[]{"*"});
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addRedirectViewController("/api-docs", "/swagger-ui.html");
    }

    @Bean
    public HttpMessageConverter<String> responseBodyConverter() {
        StringHttpMessageConverter converter = new StringHttpMessageConverter(Charset.forName("UTF-8"));
        return converter;
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add(this.responseBodyConverter());
    }

    @ConditionalOnMissingBean(value={MultipartResolver.class})
    public StandardServletMultipartResolver multipartResolver() {
        StandardServletMultipartResolver multipartResolver = new StandardServletMultipartResolver();
        multipartResolver.setResolveLazily(true);
        return multipartResolver;
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorPathExtension(false);
    }

    @Bean
    public FilterRegistrationBean xssFilterRegistrationBean() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new XssFilter());
        filterRegistrationBean.setOrder(1);
        filterRegistrationBean.setEnabled(true);
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        HashMap initParameters = Maps.newHashMap();
        initParameters.put("excludes", "/favicon.ico,/img/*,/js/*,/css/*,/web/cms/doclist/updateDoclist*,/web/cms/notice/saveNotice*,/web/cms/doclist/saveDoclist*,/web/cms/doclistBusiness/updateDoclist*,/web/cms/doclistBusiness/saveDoclist*,/web/rs/resourceBase/saveResourceGoods*,/web/rs/updateResourceGoods*,/web/rs/resourceBase/saveTResourceGoods*,/web/rs/resourceGoods/saveResourceGoods*,/web/rs/resourceGoods/updateResourceGoods*,/web/rs/resourcePlat/saveResourceGoods*,/web/rs/resourcePlat/updateResourceGoods*,/web/rs/resourceGoods/getResourceGoodsInfoBySkuNo*,/web/tm/Proapp/getProappConfigByCode*,/web/rs/resourceSup/saveResourceGoods*,/web/rs/resourceSup/updateResourceGoods*,/web/rs/resourceUser/saveResourceGoods*,/web/rs/resourceUser/updateResourceGoods*,/web/pfs/pfsmodeltagvalue/updatePfsModelTagValueDomain*,/web/tm/Proapp/queryProappConfigByChannelAgreement*,/web/rs/resourceBase/updateResourceGoodsForUser*,/web/rs/resourceBase/updateResourceGoodsForPlat*,/web/um/userservice/queryChannelByUserName.json,/web/tm/Tmcm/updateProapp*,/web/tm/Proapp/saveProappConfig*,/web/tm/Proapp/updateProappConfig*,/web/cms/conttitleBusiness*,/web/rs/resourceBase/updateBatchSkuEditsUp*,/web/rs/resourceBase/saveResourceGoodsSmForPlat*,/web/rs/resourceBase/updateResourceGoods*,/web/rs/resourceBase/updateBatchSkuEdits*,/web/pg/gconfirm/saveGconfirm*,/web/qt/questtemp/saveQuest*,/web/qt/questtemp/updateQuesttemp*,/web/pg/pgpackimg/readImage*,/web/pg/gconfirmmini/saveGconfirm*,/web/rs/goodsFile/uploadGoodsFiles*,/web/oc/contract/saveContract*,/web/res/evaluate/saveEvaluateGoods*,/web/oc/contract/saveImportContractStr.json,/web/cms/tginfo/updateTginfo*,/web/cd/cardp/save*,/web/cd/cardp/update*,/web/gt/gift/save*,/web/gt/gift/update*,/web/gt/giftSend/save*,/web/gt/giftSend/update*,/web/cms/notice/saveRuleNotice*,/web/cms/notice/updateNotice*,/web/rs/resourceBase/queryRsSkuPageForRetGoods*,/web/rs/resourceGoods/updateResGooFromTcEdit*,/web/ula/ulaLabel/saveUlaLabel.*,/web/ula/ulaLabel/updateUlaLabel.*,/web/ula/ulaLtypeRule/updateUlaLtypeRule.*");
        initParameters.put("isIncludeRichText", "true");
        filterRegistrationBean.setInitParameters((Map)initParameters);
        return filterRegistrationBean;
    }
}

