/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.common.util;

import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Whitelist;

public class JsoupUtil {
    public static SupperLogUtil logger = new SupperLogUtil(JsoupUtil.class);
    private static final Whitelist whitelist = Whitelist.basicWithImages();
    private static final Document.OutputSettings outputSettings = new Document.OutputSettings().prettyPrint(false);

    public static String clean1(String content) {
        return Jsoup.clean((String)content, (String)"", (Whitelist)whitelist, (Document.OutputSettings)outputSettings);
    }

    public static String stripXSSAndSql(String value) {
        if (value != null) {
            Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
            value = scriptPattern.matcher(value).replaceAll(" ");
            scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42);
            value = scriptPattern.matcher(value).replaceAll(" ");
            scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42);
            value = scriptPattern.matcher(value).replaceAll(" ");
            scriptPattern = Pattern.compile("<[\r\n| | ]*script[\r\n| | ]*>(.*?)</[\r\n| | ]*script[\r\n| | ]*>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("<[\r\n| | ]iframe[\r\n| | ]*>(.*?)</[\r\n| | ]iframe[\r\n| | ]*>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("src[\r\n| | ]*=[\r\n| | ]*[\\\"|\\'](.*?)[\\\"|\\']", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("</[\r\n| | ]*script[\r\n| | ]*>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("<[\r\n| | ]*script(.*?)>", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("eval\\((.*?)\\)", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("e-xpression\\((.*?)\\)", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("javascript[\r\n| | ]*:[\r\n| | ]*", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("vbscript[\r\n| | ]*:[\r\n| | ]*", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("onload(.*?)=", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("onerror(.*?)=", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("onclick(.*?)=", 42);
            value = scriptPattern.matcher(value).replaceAll("rel=");
            scriptPattern = Pattern.compile("onfocus(.*?)", 42);
            value = scriptPattern.matcher(value).replaceAll(" ");
            scriptPattern = Pattern.compile("(<(script|iframe|embed|frame|frameset|object|img|applet|body|html|style|layer|link|ilayer|meta|bgsound))");
            value = scriptPattern.matcher(value).replaceAll(" ");
            scriptPattern = Pattern.compile("alert(.*?)", 42);
            value = scriptPattern.matcher(value).replaceAll(" ");
            scriptPattern = Pattern.compile("confirm(.*?)", 42);
            value = scriptPattern.matcher(value).replaceAll(" ");
            scriptPattern = Pattern.compile("<", 40);
            value = scriptPattern.matcher(value).replaceAll(" ");
            scriptPattern = Pattern.compile(">", 40);
            value = scriptPattern.matcher(value).replaceAll(" ");
        }
        return value;
    }

    public static String clean(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        try {
            s = s.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
            s = s.replaceAll("\\+", "%2B");
            s = URLDecoder.decode(s, "utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        s = JsoupUtil.stripXSSAndSql(s);
        StringBuilder sb = new StringBuilder(s.length() + 16);
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '>': {
                    sb.append("\uff1e");
                    continue block8;
                }
                case '<': {
                    sb.append("\uff1c");
                    continue block8;
                }
                case '&': {
                    sb.append("\uff06");
                    continue block8;
                }
                case '#': {
                    sb.append("\uff03");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        String text = "6/hhrUhp7d0JvfwPGqmSJODtDxXOkz4m5DGmfABM7KRm7WJF/YOHUgY2iCPEBgHgdrKY2egFfB+6u1ANFO7LoiZRz8RwxvZwrOphMZUvlkmRBOzvpGzPnneGjnM+aPzNtqvhRFOJBylMsKUzcGrGiKcoTMCQqWKMIqQCVCfyrbt9JZ19bAGY7sNdwOC7N7KhFT9oJkV50xRYblYJ51yFJQ==";
        System.out.println(text);
        System.out.println(JsoupUtil.clean(text));
    }

    static {
        whitelist.addAttributes(":all", new String[]{"style"});
    }
}

