/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.interceptor.service;

import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.common.service.HtmlIBaseService;
import cn.com.qj.bff.core.auth.AuthBean;
import cn.com.qj.bff.core.auth.AuthCheck;
import cn.com.qj.bff.core.auth.AuthService;
import cn.com.qj.bff.core.auth.PermissonList;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.core.intercepter.AbstractIntercepter;
import cn.com.qj.bff.core.thirdauthlogin.ThirdpartauthServer;
import cn.com.qj.bff.interceptor.bean.AuthThreadLocal;
import cn.com.qj.bff.interceptor.bean.ExtendInterceptor;
import cn.com.qj.bff.interceptor.bean.InterBean;
import cn.com.qj.bff.interceptor.bean.LogLogDomainBean;
import cn.com.qj.bff.interceptor.bean.LogLogHandler;
import cn.com.qj.bff.interceptor.bean.OsOAuthConfigDomain;
import cn.com.qj.bff.interceptor.bean.OsOAuthEnv;
import cn.com.qj.bff.interceptor.service.BaseInterUtil;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.router.TmTenantReDomain;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.util.ContentCachingResponseWrapper;

public abstract class BaseIntercepter
extends AbstractIntercepter {
    private String sys_code = "BaseIntercepter";
    @Autowired
    private HtmlIBaseService htmlIBaseService;
    private static final Map<String, Object> thirdAuthLoginMap = new ConcurrentHashMap<String, Object>();
    @Autowired
    public AuthService authService;

    protected void extend(HttpServletRequest request, HttpServletResponse response, InterBean interBean, AuthBean authBean) {
        if (null == authBean || null == request || null == response) {
            return;
        }
        PermissonList permissonList = authBean.getPermissonList();
        if (null == permissonList) {
            return;
        }
        String className = permissonList.getCustomerInterceptor();
        if (StringUtils.isBlank((String)className)) {
            return;
        }
        if (className.indexOf(".") > 0) {
            try {
                Class<?> clazz = Class.forName(className);
                ExtendInterceptor extendInterceptor = (ExtendInterceptor)((Object)clazz.newInstance());
                if (null == extendInterceptor) {
                    return;
                }
                extendInterceptor.customerHandle(request, response, interBean, authBean);
            }
            catch (Exception e) {
                this.logger.error("extend", (Object)"e", (Throwable)e);
            }
        }
    }

    protected void saveLogLog(LogLogDomainBean logLogDomain) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("log.log.saveLog");
        pmap.putParamToJson("logLogDomainBean", logLogDomain);
        this.htmlIBaseService.sendMesReBeanInAsync(pmap);
    }

    protected String getRequestservice(HttpServletRequest request, String tenantCode) {
        return BaseInterUtil.getRequestservice(request, tenantCode);
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String errCode, String errMsg, String uri, String redirectURL, String tenantCode) {
        if (null == response) {
            return;
        }
        if (this.isJsonRequest(request).booleanValue()) {
            response.setContentType("text/json; charset=" + request.getCharacterEncoding());
            try {
                response.getWriter().print(JsonUtil.buildNormalBinder().toJson((Object)new HtmlJsonReBean(errCode, errMsg, uri)));
            }
            catch (Exception e) {
                this.logger.error("AbstractIntercepter.sendRedirect.json", (Object)errMsg, (Throwable)e);
            }
        } else {
            try (PrintWriter out = response.getWriter();){
                out.println("<html>");
                out.println("<script>");
                if (StringUtils.isNotBlank((String)uri) && uri.indexOf("http") > -1) {
                    out.println("window.open('" + uri + "','_top')");
                } else {
                    out.println("window.open('" + String.format("%s%s/%s?redirectURL=%s", this.getRequestservice(request, tenantCode), request.getContextPath(), uri, redirectURL) + "','_top')");
                }
                out.println("</script>");
                out.println("</html>");
                out.flush();
            }
            catch (Exception e) {
                this.logger.error("AbstractIntercepter.sendRedirect.url", (Object)errMsg, (Throwable)e);
            }
        }
    }

    protected Boolean isJsonRequest(HttpServletRequest request) {
        return BaseInterUtil.isJsonRequest(request);
    }

    private void setHeaderOrigin(HttpServletResponse response, HttpServletRequest request) {
        if (null == response) {
            return;
        }
        String header = BaseInterUtil.ProappEnv + ", " + BaseInterUtil.MemberCcode + ", " + BaseInterUtil.TenantCode + ", " + BaseInterUtil.ProappCode + ", " + BaseInterUtil.TginfoCode + ", " + BaseInterUtil.CookieToken + ", " + BaseInterUtil.COMPANYCODE_KEY + ", " + BaseInterUtil.OrgUsercode_KEY + ", " + BaseInterUtil.CookieKey + ", " + BaseInterUtil.DelearchannelCode + ", " + BaseInterUtil.TginfoCodeDomain + ", " + BaseInterUtil.AGENT + ", " + BaseInterUtil.AGENT1 + ", " + BaseInterUtil.USERAGENT1;
        response.addHeader("Access-Control-Expose-Headers", header);
        if (StringUtils.isEmpty((String)response.getHeader("Access-Control-Allow-Origin"))) {
            response.addHeader("Access-Control-Allow-Origin", request.getHeader("Origin"));
        }
        response.addHeader("Access-Control-Allow-Headers", header + ", Content-Type, Content-Length, Authorization, Accept, X-Requested-With," + BaseInterUtil.TenantCode + "," + BaseInterUtil.ProappCode);
    }

    private List<String> getQuality(String quality, String tenantCode) {
        if (StringUtils.isBlank((String)quality)) {
            return null;
        }
        String[] qualityS = quality.split(",");
        if (null == qualityS) {
            return null;
        }
        ArrayList<String> listAll = new ArrayList<String>();
        for (String string : qualityS) {
            String platkey = string + "-" + "00000000";
            String key = string + "-" + tenantCode;
            List list = SupDisUtil.getMapListJson((String)"UmQualityProapp-list", (String)key, String.class);
            if (ListUtil.isEmpty((Collection)list)) {
                list = SupDisUtil.getMapListJson((String)"UmQualityProapp-list", (String)platkey, String.class);
            }
            if (!ListUtil.isNotEmpty((Collection)list)) continue;
            listAll.addAll(list);
        }
        return listAll;
    }

    private boolean checkquality(String quality, String proappCode, String tenantCode) {
        List<String> list;
        if (StringUtils.isBlank((String)proappCode)) {
            return true;
        }
        if (StringUtils.isBlank((String)quality)) {
            quality = "buy";
        }
        String platbuykey = "buy-00000000";
        String buykey = "buy-" + tenantCode;
        String key = quality + "-" + tenantCode;
        List buylist = SupDisUtil.getMapListJson((String)"UmQualityProapp-list", (String)buykey, String.class);
        if (ListUtil.isEmpty((Collection)buylist)) {
            buylist = SupDisUtil.getMapListJson((String)"UmQualityProapp-list", (String)platbuykey, String.class);
        }
        if (ListUtil.isEmpty(list = this.getQuality(quality, tenantCode)) && ListUtil.isEmpty((Collection)buylist)) {
            this.logger.error(this.sys_code + ".checkquality.str", (Object)key);
            return false;
        }
        ArrayList<String> checklist = new ArrayList<String>();
        if (ListUtil.isNotEmpty((Collection)buylist)) {
            for (String string : buylist) {
                if (!StringUtils.isNotBlank((String)string)) continue;
                checklist.add(string);
            }
        }
        if (ListUtil.isNotEmpty(list)) {
            for (String string : list) {
                if (!StringUtils.isNotBlank((String)string)) continue;
                checklist.add(string);
            }
        }
        if (checklist.contains(proappCode)) {
            return true;
        }
        this.logger.error(this.sys_code + ".checkquality.contains", (Object)(proappCode + "=" + list.toString()));
        return false;
    }

    private boolean checkQualityTginfo(String quality, String proappCode, String tenantCode) {
        String tg;
        if (StringUtils.isBlank((String)quality) || StringUtils.isBlank((String)proappCode) || StringUtils.isBlank((String)tenantCode)) {
            return true;
        }
        String[] qualityS = quality.split(",");
        if (null == qualityS) {
            return true;
        }
        for (String string : qualityS) {
            tg = SupDisUtil.getMap((String)"UmQualityProapp-model", (String)(string + "-" + proappCode + "-" + tenantCode));
            if (!"1".equals(tg)) continue;
            return false;
        }
        tg = SupDisUtil.getMap((String)"UmQualityProapp-model", (String)("buy-" + proappCode + "-" + tenantCode));
        return !"1".equals(tg);
    }

    private boolean checkTginfo(String quality, String proappCode, String tginfoCode, String tenantCode, UserSession userSesionBean) {
        if (null == userSesionBean) {
            return false;
        }
        if (StringUtils.isBlank((String)tginfoCode)) {
            return true;
        }
        if (this.checkQualityTginfo(quality, proappCode, tenantCode)) {
            return true;
        }
        String userinfoCode = userSesionBean.getUserPcode();
        if (StringUtils.isBlank((String)userinfoCode)) {
            return false;
        }
        String memberCode = SupDisUtil.getMap((String)"CmsTginfo-mem", (String)(tginfoCode + "-" + tenantCode));
        if (StringUtils.isBlank((String)memberCode)) {
            return false;
        }
        String companyStr = SupDisUtil.getMap((String)"OrgEmployee-userinfoCode", (String)(userinfoCode + "-" + tenantCode));
        if (StringUtils.isBlank((String)companyStr)) {
            return false;
        }
        String[] companys = companyStr.split(",");
        for (int i = 0; i < companys.length; ++i) {
            String company = companys[i];
            if (!this.check(company, memberCode, tenantCode)) continue;
            return true;
        }
        return false;
    }

    private boolean check(String company, String memberCode, String tenantCode) {
        if (StringUtils.isBlank((String)company)) {
            return false;
        }
        if (StringUtils.isBlank((String)memberCode)) {
            return false;
        }
        String cacheuserinfoCode = SupDisUtil.getMap((String)"OrgCompany-companyCode", (String)(company + "-" + tenantCode));
        if (StringUtils.isBlank((String)cacheuserinfoCode)) {
            return false;
        }
        if (memberCode.equals(cacheuserinfoCode)) {
            return true;
        }
        String companyPcode = SupDisUtil.getMap((String)"OrgCompany-companyPcode", (String)(company + "-" + tenantCode));
        if (StringUtils.isBlank((String)companyPcode)) {
            return false;
        }
        return this.check(companyPcode, memberCode, tenantCode);
    }

    protected String checklicense(HttpServletRequest request) {
        if (null == request) {
            return "request is null";
        }
        TmTenantReDomain tmTenant = (TmTenantReDomain)DisUtil.getMapJson((String)"tmtenant-code", (String)"00000000", TmTenantReDomain.class);
        if (null == tmTenant) {
            return "data is error";
        }
        if (null == tmTenant.getTenantEdate()) {
            return "date is error";
        }
        if (0L < DateUtil.getBetweenDays((Date)new Date(), (Date)tmTenant.getTenantEdate()) && DateUtil.getBetweenDays((Date)new Date(), (Date)tmTenant.getTenantEdate()) <= 7L) {
            return "";
        }
        if (0L >= DateUtil.getBetweenDays((Date)new Date(), (Date)tmTenant.getTenantEdate())) {
            return "license\u5df2\u8fc7\u671f\uff0c\u7cfb\u7edf\u4e0d\u53ef\u7528";
        }
        return "";
    }

    protected boolean filterPer(HttpServletRequest request, HttpServletResponse response) {
        this.setHeaderOrigin(response, request);
        String url = this.getUrl(request);
        String redurl = this.getRedurl(request, url);
        String msg = this.checklicense(request);
        if (StringUtils.isNotBlank((String)msg)) {
            this.sendRedirect(request, response, "license", msg, msg, redurl, null);
            return false;
        }
        InterBean interBean = this.mackeInterBean(request);
        if (null == interBean) {
            this.logger.error(this.sys_code + ".filterPer.interBean", (Object)(url + ":" + request.getMethod() + " interBean is null"));
            this.sendRedirect(request, response, "noresource", "\u975e\u6cd5\u8bbf\u95ee", "noresource", redurl, null);
            return false;
        }
        if (StringUtils.isNotBlank((String)interBean.getMsg())) {
            this.logger.error(this.sys_code + ".filterPer.interBean.Msg", (Object)(url + ":" + request.getMethod() + " interBean Msg is " + interBean.getMsg()));
            this.sendRedirect(request, response, "noresource", interBean.getMsg(), "noresource", redurl, null);
            return false;
        }
        this.putHeader(request, response, interBean);
        AuthBean authBean = this.checkPer(request, interBean);
        if (null == authBean) {
            return false;
        }
        boolean exflag = true;
        if (null != authBean && null != authBean.getUserSession() && null != interBean) {
            if (!interBean.getTenantCode().equals(authBean.getUserSession().getTenantCode())) {
                this.logger.error(this.sys_code + ".filterPer.tenant", (Object)(authBean.getUserSession().getTenantCode() + "-" + interBean.getTenantCode()));
                this.sendRedirect(request, response, "tenant", "\u975e\u6cd5\u8bbf\u95ee4", "noresource", redurl, null);
                return false;
            }
            if (!this.checkquality(authBean.getUserSession().getUserinfoQuality(), interBean.getProappCode(), interBean.getTenantCode())) {
                if (null != authBean.getUserSession().getTwoUserSessionBean() && this.checkquality(authBean.getUserSession().getTwoUserSessionBean().getUserinfoQuality(), interBean.getProappCode(), interBean.getTenantCode())) {
                    this.exchangeUser(authBean.getUserSession(), request, response);
                    exflag = false;
                } else {
                    this.logger.error(this.sys_code + ".filterPer.quality", (Object)(authBean.getUserSession().getUserinfoQuality() + "-" + interBean.getProappCode() + "-" + interBean.getTginfoCode() + "-" + interBean.getTenantCode()));
                    this.sendRedirect(request, response, "quality", "\u975e\u6cd5\u8bbf\u95ee3", "noresource", redurl, null);
                    return false;
                }
            }
        }
        if (StringUtils.isNotBlank((String)interBean.getTginfoCode()) && null != authBean.getUserSession() && StringUtils.isNotBlank((String)authBean.getUserSession().getUserinfoQuality()) && !this.checkTginfo(authBean.getUserSession().getUserinfoQuality(), interBean.getProappCode(), interBean.getTginfoCode(), interBean.getTenantCode(), authBean.getUserSession())) {
            if (exflag && null != authBean.getUserSession().getTwoUserSessionBean() && this.checkTginfo(authBean.getUserSession().getTwoUserSessionBean().getUserinfoQuality(), interBean.getProappCode(), interBean.getTginfoCode(), interBean.getTenantCode(), authBean.getUserSession().getTwoUserSessionBean())) {
                this.exchangeUser(authBean.getUserSession(), request, response);
                exflag = false;
            } else {
                this.logger.error(this.sys_code + ".filterPer.tginfo", (Object)(authBean.getUserSession().getUserinfoQuality() + "-" + interBean.getProappCode() + "-" + interBean.getTginfoCode() + "-" + interBean.getTenantCode()));
                this.sendRedirect(request, response, "tginfo", "\u975e\u6cd5\u8bbf\u95ee2", "noresource", redurl, null);
                return false;
            }
        }
        if (StringUtils.isNotBlank((String)interBean.getChannelCode()) && null != authBean.getUserSession() && MapUtil.isNotEmpty(authBean.getUserSession().getUserinfoAchannelMap()) && StringUtils.isBlank((String)authBean.getUserSession().getUserinfoAchannelMap().get(interBean.getChannelCode()))) {
            this.logger.error(this.sys_code + ".filterPer.channelCode", (Object)(authBean.getUserSession().getUserinfoAchannelMap() + "-" + interBean.getChannelCode()));
            this.sendRedirect(request, response, ".filterPer.channelCode", "\u672a\u5f00\u901a\u6b64\u7ad9\u70b9", "noresource", redurl, null);
            return false;
        }
        this.putSession(request, response, authBean.getUserSession());
        boolean flag = this.filterAuthBean(request, response, authBean, interBean);
        if (!flag) {
            return false;
        }
        if (StringUtils.isNotBlank((String)interBean.getGroup())) {
            BaseInterUtil.putCookieKeyHeader(request, response, BaseInterUtil.CookieToken + "-" + interBean.getGroup());
        }
        this.extendInterceptor(request, response, interBean, authBean);
        this.LogStart(request, response, interBean, authBean);
        AuthThreadLocal.setAuthBean(request, authBean, interBean);
        return true;
    }

    private void exchangeUser(UserSession userSession, HttpServletRequest request, HttpServletResponse response) {
        if (null == userSession || StringUtils.isNotBlank((String)userSession.getTwoUserSessionTockid()) || StringUtils.isNotBlank((String)userSession.getOneUserSessionTockid())) {
            return;
        }
        String one = userSession.getOneUserSessionTockid();
        String two = userSession.getTwoUserSessionTockid();
        try {
            BeanUtils.copyAllPropertys((Object)userSession, (Object)userSession.getTwoUserSessionBean());
            userSession.setOneUserSessionTockid(two);
            userSession.setTwoUserSessionTockid(one);
            BaseInterUtil.putTokenCookie(request, response, null == userSession ? null : userSession.getTicketTokenid());
        }
        catch (Exception e) {
            return;
        }
    }

    protected void extendInterceptor(HttpServletRequest request, HttpServletResponse response, InterBean interBean, AuthBean authBean) {
        this.extend(request, response, interBean, authBean);
    }

    protected void filterEnd(HttpServletRequest request, HttpServletResponse response) {
        this.LogStend(request, response);
    }

    protected void LogStend(HttpServletRequest request, HttpServletResponse response) {
        if (null == request || null == response) {
            return;
        }
        InterBean interBean = AuthThreadLocal.getInterBean(request);
        AuthBean authBean = AuthThreadLocal.getAuthBean(request);
        if (null == interBean || null == authBean) {
            return;
        }
        PermissonList permissonList = authBean.getPermissonList();
        if (null == permissonList) {
            return;
        }
        if (null == permissonList.getPermissionLogEnd() || 1 != permissonList.getPermissionLogEnd()) {
            return;
        }
        Map<String, Object> map = this.wrapperLogLogRequestParam(request);
        if (null == map) {
            map = new HashMap<String, Object>();
        }
        ContentCachingResponseWrapper responseWrapper = new ContentCachingResponseWrapper(response);
        map.put("response", this.invokeHttpByteResponseData(responseWrapper));
        LogLogDomainBean logLogDomain = LogLogHandler.logControlEnd(map, interBean, authBean);
        this.saveLogLog(logLogDomain);
    }

    public String invokeHttpByteResponseData(ContentCachingResponseWrapper response) {
        try {
            String charset = this.getResponseCharset(response);
            return new String(response.getContentAsByteArray(), charset);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getResponseCharset(ContentCachingResponseWrapper response) {
        if (response.getContentType() == null) {
            return StandardCharsets.UTF_8.name();
        }
        boolean isStream = response.getContentType().equalsIgnoreCase("application/octet-stream");
        return isStream && StringUtils.isNotBlank((String)response.getCharacterEncoding()) ? response.getCharacterEncoding() : StandardCharsets.UTF_8.name();
    }

    protected void LogStart(HttpServletRequest request, HttpServletResponse response, InterBean interBean, AuthBean authBean) {
        if (null == request || null == response || null == interBean || null == authBean) {
            return;
        }
        PermissonList permissonList = authBean.getPermissonList();
        if (null == permissonList) {
            return;
        }
        if (null == permissonList.getPermissionLogStart() || 1 != permissonList.getPermissionLogStart()) {
            return;
        }
        Map<String, Object> map = this.wrapperLogLogRequestParam(request);
        LogLogDomainBean logLogDomain = LogLogHandler.logControlStart(map, interBean, authBean);
        this.saveLogLog(logLogDomain);
    }

    private Map<String, Object> wrapperLogLogRequestParam(HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map requestParamtersMap = request.getParameterMap();
        if (MapUtil.isNotEmpty((Map)requestParamtersMap)) {
            for (String key : requestParamtersMap.keySet()) {
                if (null != requestParamtersMap.get(key) && ((String[])requestParamtersMap.get(key)).length == 1) {
                    map.put(key, ((String[])requestParamtersMap.get(key))[0]);
                    continue;
                }
                map.put(key, requestParamtersMap.get(key));
            }
        }
        return map;
    }

    protected void putHeader(HttpServletRequest request, HttpServletResponse response, InterBean interBean) {
        if (null == request || null == response || null == interBean) {
            return;
        }
        BaseInterUtil.putTenantHeader(request, response, interBean.getTenantCode());
        BaseInterUtil.putProappHeader(request, response, interBean.getProappCode());
        BaseInterUtil.putMemberCodeHeader(request, response, interBean.getMemberCode());
        BaseInterUtil.putChannelCodeHeader(request, response, interBean.getChannelCode());
        BaseInterUtil.putProappEnvCodeHeader(request, response, interBean.getProappEnvCode());
        BaseInterUtil.putTginfoHeader(request, response, interBean.getTginfoCode());
        BaseInterUtil.putProappEnvHeader(request, response, interBean.getOauthEnvCode());
        String companyCode = BaseInterUtil.getSessionCompany(request, response);
        BaseInterUtil.setSessionCompany(request, response, companyCode);
        BaseInterUtil.putOrgUsercodeHeader(request, response, interBean.getOrgUsercode());
    }

    protected void putTokenCookie(HttpServletRequest request, HttpServletResponse response, InterBean interBean) {
        BaseInterUtil.putTokenCookie(request, response, interBean);
    }

    protected String getUrl(HttpServletRequest request) {
        return BaseInterUtil.getUrl(request);
    }

    protected String getRedurl(HttpServletRequest request, String url) {
        return BaseInterUtil.getRedurl(request, url);
    }

    protected boolean filterAuthBean(HttpServletRequest request, HttpServletResponse response, AuthBean authBean, InterBean interBean) {
        if (null == interBean || null == request || null == response) {
            return false;
        }
        String url = interBean.getUrl();
        String redurl = interBean.getRedurl();
        String norul = "";
        String host = this.getDomain(request, null);
        String tginfoCode = this.getTginfoCode(request);
        if (null == authBean) {
            request.getSession().setAttribute(BaseInterUtil.UP_URL, (Object)redurl);
            this.logger.debug(this.sys_code + ".preHandle", (Object)(url + ":" + request.getMethod() + " authBean is null"));
            OsOAuthConfigDomain osOAuthConfigReDomain = BaseInterUtil.getOsOAuthConfigDomain(interBean.getProappCode(), interBean.getOauthEnvCode(), interBean.getTenantCode(), host, tginfoCode);
            HashMap<String, String> rmap = new HashMap<String, String>();
            if (null != osOAuthConfigReDomain) {
                rmap.put("norul", null == osOAuthConfigReDomain.getOauthConfigNoresurl() ? "" : osOAuthConfigReDomain.getOauthConfigNoresurl());
                rmap.put("redurl", redurl);
                rmap.put("loginurl", null == osOAuthConfigReDomain.getOauthConfigUrl() ? "" : osOAuthConfigReDomain.getOauthConfigUrl());
                rmap.put("indexurl", null == osOAuthConfigReDomain.getOauthConfigIndexurl() ? "" : osOAuthConfigReDomain.getOauthConfigIndexurl());
            }
            norul = JsonUtil.buildNormalBinder().toJson(rmap);
            this.sendRedirect(request, response, "noresource", "\u8d44\u6e90\u4e0d\u5b58\u5728", norul, redurl, interBean.getTenantCode());
            return false;
        }
        if (AuthBean.anthFlag_nr == authBean.getFlag()) {
            request.getSession().setAttribute(BaseInterUtil.UP_URL, (Object)redurl);
            this.logger.debug(this.sys_code + ".preHandle", (Object)(url + ":" + request.getMethod() + " is no resource"));
            OsOAuthConfigDomain osOAuthConfigReDomain = BaseInterUtil.getOsOAuthConfigDomain(interBean.getProappCode(), interBean.getOauthEnvCode(), interBean.getTenantCode(), host, tginfoCode);
            HashMap<String, String> rmap = new HashMap<String, String>();
            if (null != osOAuthConfigReDomain) {
                rmap.put("norul", null == osOAuthConfigReDomain.getOauthConfigNoresurl() ? "" : osOAuthConfigReDomain.getOauthConfigNoresurl());
                rmap.put("redurl", redurl);
                rmap.put("loginurl", null == osOAuthConfigReDomain.getOauthConfigUrl() ? "" : osOAuthConfigReDomain.getOauthConfigUrl());
                rmap.put("indexurl", null == osOAuthConfigReDomain.getOauthConfigIndexurl() ? "" : osOAuthConfigReDomain.getOauthConfigIndexurl());
            }
            norul = JsonUtil.buildNormalBinder().toJson(rmap);
            this.sendRedirect(request, response, "noresource", "\u8d44\u6e90\u4e0d\u5b58\u57281", norul, redurl, interBean.getTenantCode());
            return false;
        }
        if (AuthBean.anthFlag_nl == authBean.getFlag()) {
            request.getSession().setAttribute(BaseInterUtil.UP_URL, (Object)redurl);
            if (null == authBean.getUserSession()) {
                this.logger.debug(this.sys_code + ".preHandle", (Object)(url + ":" + request.getMethod() + " is no userSession"));
                OsOAuthConfigDomain osOAuthConfigReDomain = BaseInterUtil.getOsOAuthConfigDomain(interBean.getProappCode(), interBean.getOauthEnvCode(), interBean.getTenantCode(), host, tginfoCode);
                HashMap<String, String> rmap = new HashMap<String, String>();
                if (null != osOAuthConfigReDomain) {
                    rmap.put("norul", null == osOAuthConfigReDomain.getOauthConfigUrl() ? "" : osOAuthConfigReDomain.getOauthConfigUrl());
                    rmap.put("redurl", redurl);
                    rmap.put("loginurl", null == osOAuthConfigReDomain.getOauthConfigUrl() ? "" : osOAuthConfigReDomain.getOauthConfigUrl());
                    rmap.put("indexurl", null == osOAuthConfigReDomain.getOauthConfigIndexurl() ? "" : osOAuthConfigReDomain.getOauthConfigIndexurl());
                }
                norul = JsonUtil.buildNormalBinder().toJson(rmap);
                this.sendRedirect(request, response, "nologin", "\u672a\u767b\u5f55", norul, redurl, interBean.getTenantCode());
                return false;
            }
            String loginUrl = authBean.getUserSession().getLoginUrl();
            if (null == loginUrl) {
                loginUrl = "";
            }
            this.logger.debug(this.sys_code + ".preHandle", (Object)(url + ":" + request.getMethod() + " is no login"));
            if (loginUrl.indexOf("/") < 0 && loginUrl.indexOf(".") > 0) {
                String thirdLoginUrl = this.getThirdLoginUrl(request, interBean.getTenantCode(), loginUrl);
                try {
                    if (null == thirdLoginUrl) {
                        thirdLoginUrl = "";
                    }
                    response.sendRedirect(thirdLoginUrl);
                }
                catch (Exception e) {
                    this.logger.error(this.sys_code + ".preHandle", (Object)(url + ":" + request.getMethod() + "--" + loginUrl + ":" + thirdLoginUrl + " is no thirdLoginUrl"));
                }
            } else {
                this.sendRedirect(request, response, "nologin", "\u8bf7\u91cd\u65b0\u767b\u5f55", loginUrl, redurl, interBean.getTenantCode());
            }
            return false;
        }
        if (AuthBean.anthFlag_np == authBean.getFlag() || AuthBean.anthFlag_na == authBean.getFlag() || AuthBean.anthFlag_nb == authBean.getFlag()) {
            request.getSession().setAttribute(BaseInterUtil.UP_URL, (Object)redurl);
            OsOAuthConfigDomain osOAuthConfigReDomain = BaseInterUtil.getOsOAuthConfigDomain(interBean.getProappCode(), interBean.getOauthEnvCode(), interBean.getTenantCode(), host, tginfoCode);
            HashMap<String, String> rmap = new HashMap<String, String>();
            if (null != osOAuthConfigReDomain) {
                rmap.put("norul", null == osOAuthConfigReDomain.getOauthConfigNoperurl() ? "" : osOAuthConfigReDomain.getOauthConfigNoperurl());
                rmap.put("redurl", redurl);
                rmap.put("loginurl", null == osOAuthConfigReDomain.getOauthConfigUrl() ? "" : osOAuthConfigReDomain.getOauthConfigUrl());
                rmap.put("indexurl", null == osOAuthConfigReDomain.getOauthConfigIndexurl() ? "" : osOAuthConfigReDomain.getOauthConfigIndexurl());
            }
            norul = JsonUtil.buildNormalBinder().toJson(rmap);
            String msg = "\u6ca1\u6709\u6743\u9650";
            if (AuthBean.anthFlag_na == authBean.getFlag()) {
                msg = "\u6ca1\u6709\u8ba4\u8bc1";
            } else if (AuthBean.anthFlag_nb == authBean.getFlag()) {
                msg = "\u9ed1\u540d\u5355";
            }
            this.logger.debug(this.sys_code + ".preHandle", (Object)(url + ":" + request.getMethod() + " is no permisson"));
            this.sendRedirect(request, response, "noper", msg, norul, redurl, interBean.getTenantCode());
            return false;
        }
        return true;
    }

    private String getThirdLoginUrl(HttpServletRequest request, String tenantCode, String loginUrl) {
        if (null == request || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)loginUrl)) {
            return null;
        }
        ThirdpartauthServer thirdpartauthServer = this.getThirdAuthServer(loginUrl);
        if (null == thirdpartauthServer) {
            return null;
        }
        String thirdLoginUrl = thirdpartauthServer.getWeChartUrl(this.getRequestservice(request, tenantCode) + request.getContextPath() + request.getServletPath(), thirdpartauthServer.getName(), tenantCode);
        return thirdLoginUrl;
    }

    protected AuthBean checkPer(HttpServletRequest request, InterBean interBean) {
        AuthBean authBean;
        if (null == request || null == interBean) {
            return null;
        }
        AuthCheck authCheck = new AuthCheck();
        authCheck.setTenantCode(interBean.getTenantCode());
        authCheck.setProappCode(interBean.getProappCode());
        authCheck.setToken(interBean.getToken());
        authCheck.setMethod(request.getMethod());
        authCheck.setUrl(request.getServletPath());
        authCheck.setContextPath(request.getContextPath());
        String[] memberCodeS = request.getParameterValues("blakmemberCode");
        if (null != memberCodeS) {
            authCheck.setMemberCode(memberCodeS[0]);
        }
        if (StringUtils.isNotBlank((String)interBean.getToken())) {
            UserSession twouserSession;
            UserSession userSession = this.authService.checkOauth(interBean.getToken(), interBean.getProappCode(), interBean.getTenantCode());
            if (null != userSession && StringUtils.isNotBlank((String)interBean.getOrgUsercode()) && null != userSession.getUserMap() && !userSession.getUserCode().equals(interBean.getOrgUsercode()) && null != (twouserSession = userSession.getUserSession(interBean.getOrgUsercode()))) {
                userSession.setTwoUserSessionTockid(twouserSession.getTicketTokenid());
            }
            if (null == userSession) {
                this.logger.debug(this.sys_code + ".checkPer.userSession", (Object)(interBean.getToken() + ":" + interBean.getProappCode() + ":" + interBean.getTenantCode()));
            }
            authCheck.setUserSession(userSession);
        }
        if (null != (authBean = this.authService.check(authCheck))) {
            authBean.setUserSession(authCheck.getUserSession());
        }
        return authBean;
    }

    protected UserSession getUserSession(InterBean interBean) {
        if (null == interBean) {
            return null;
        }
        if (StringUtils.isNotBlank((String)interBean.getToken()) && StringUtils.isNotBlank((String)interBean.getTenantCode())) {
            return this.authService.checkOauth(interBean.getToken(), interBean.getProappCode(), interBean.getTenantCode());
        }
        return null;
    }

    protected void putSession(HttpServletRequest request, HttpServletResponse response, UserSession userSession) {
        BaseInterUtil.putSession(request, response, userSession);
    }

    protected UserSession getSession(HttpServletRequest request) {
        return BaseInterUtil.getSession(request);
    }

    private InterBean makeEnvInfo(HttpServletRequest request) {
        List<String> envList = this.getEnvInfo(request);
        if (ListUtil.isEmpty(envList)) {
            this.logger.error(this.sys_code + ".makeEnvInfo.getEnvInfo", (Object)"envList is null");
            return null;
        }
        InterBean interBean = new InterBean();
        for (String envinfo : envList) {
            if (StringUtils.isBlank((String)envinfo)) {
                this.logger.error(this.sys_code + ".makeEnvInfo.envinfo", (Object)"envinfo is null");
                return null;
            }
            String[] envinfostr = envinfo.split("\\|");
            if (null == envinfostr || envinfostr.length < 1) {
                this.logger.error(this.sys_code + ".makeEnvInfo.envinfostr", (Object)"envinfostr is null");
                return null;
            }
            String oauthEnvCode = envinfostr[0];
            if (StringUtils.isBlank((String)oauthEnvCode)) {
                this.logger.error(this.sys_code + ".makeEnvInfo.oauthEnvCode", (Object)"oauthEnvCode is null");
                return null;
            }
            String oauthEnvLoginconf = "";
            if (envinfostr.length > 1) {
                oauthEnvLoginconf = envinfostr[1];
            }
            if (StringUtils.isBlank((String)interBean.getOauthEnvCode())) {
                interBean.setOauthEnvCode(oauthEnvCode);
                interBean.setOauthEnvLoginconf(oauthEnvLoginconf);
                continue;
            }
            interBean.setOauthParentEnvCode(oauthEnvCode);
            interBean.setOauthParentEnvLoginconf(oauthEnvLoginconf);
        }
        return interBean;
    }

    private void makeTenant(String domain, String contextPath, String oauthEnvCode, InterBean interBean, HttpServletRequest request, Map<String, String> cookieMap) {
        if (null == interBean || null == request) {
            this.logger.error(this.sys_code + ".makeTenant", (Object)("\u5f02\u5e38\u53c2\u6570 :" + domain + "=" + contextPath + "-" + oauthEnvCode));
            interBean.setMsg("\u5f02\u5e38\u53c2\u6570");
            return;
        }
        interBean.setMsg(null);
        String cacheProappCode = "";
        String cacheTenantCode = "";
        String cacheProappTenantCode = "";
        String tginfoCode = this.getTginfoCode(request, cookieMap);
        String proappCode = interBean.getProappCode();
        String tenantCode = interBean.getTenantCode();
        String tgdomain = BaseInterUtil.getTginfoCodeDomain(request);
        this.logger.debug(this.sys_code + ".makeTenant.tgdomain", (Object)("tgdomain:" + tgdomain + "=" + tenantCode + "-" + cacheTenantCode + "-" + contextPath + "-" + proappCode + "-" + oauthEnvCode + "-" + domain));
        String tginfo = "";
        if (StringUtils.isNotBlank((String)tgdomain)) {
            tginfo = this.getCacheComTenantCode("CmsTginfo-domain", tgdomain, contextPath, oauthEnvCode);
        }
        if (StringUtils.isBlank((String)tgdomain)) {
            tginfo = this.getCacheComTenantCode("CmsTginfo-domain", domain, contextPath, oauthEnvCode);
        }
        if (StringUtils.isNotBlank((String)tginfo)) {
            proappCode = tginfo.split(",")[0];
            if (StringUtils.isBlank((String)tenantCode)) {
                tenantCode = cacheTenantCode = tginfo.split(",")[1];
            }
            tginfoCode = tginfo.split(",")[2];
        }
        this.logger.debug(this.sys_code + ".makeTenant.tginfoCode", (Object)(tginfoCode + "==" + tginfo + " tgdomain:" + tgdomain + "=" + tenantCode + "-" + cacheTenantCode + "-" + contextPath + "-" + proappCode + "-" + oauthEnvCode + "-" + domain));
        interBean.setTginfoCode(tginfoCode);
        interBean.setOrgUsercode(this.getOrgUsercode(request, cookieMap));
        if (StringUtils.isBlank((String)proappCode)) {
            cacheProappTenantCode = this.getCacheComTenantCode("TmProoapp-domain", domain, contextPath, oauthEnvCode);
            this.logger.debug(this.sys_code + ".makeTenant.1", (Object)cacheProappTenantCode);
            if (StringUtils.isNotBlank((String)cacheProappTenantCode)) {
                cacheProappCode = cacheProappTenantCode.split(",")[0];
                if (StringUtils.isBlank((String)tenantCode)) {
                    tenantCode = cacheTenantCode = cacheProappTenantCode.split(",")[1];
                }
            } else {
                cacheProappTenantCode = this.getCacheComTenantCode("TmProappEnv-domain-code", domain, contextPath, oauthEnvCode);
                this.logger.debug(this.sys_code + ".test.2", (Object)cacheProappTenantCode);
                if (StringUtils.isNotBlank((String)cacheProappTenantCode)) {
                    cacheProappCode = cacheProappTenantCode.split(",")[0];
                    cacheTenantCode = cacheProappTenantCode.split(",")[1];
                } else if (StringUtils.isNotBlank((String)tenantCode) && StringUtils.isNotBlank((String)(cacheProappTenantCode = this.getCacheComTenantCode("TmProappEnv-tenant-code", tenantCode, contextPath, oauthEnvCode)))) {
                    cacheProappCode = cacheProappTenantCode.split(",")[0];
                    cacheTenantCode = tenantCode;
                }
            }
            if (StringUtils.isBlank((String)cacheTenantCode) && StringUtils.isBlank((String)tenantCode)) {
                this.logger.error(this.sys_code + ".cacheProappTenantCode0", (Object)("\u5f02\u5e38\u8bbf\u95ee:" + domain + "=" + tenantCode + "-" + cacheTenantCode + "-" + contextPath + "-" + proappCode + "-" + oauthEnvCode));
                interBean.setMsg("\u5f02\u5e38\u8bbf\u95ee");
            } else if (StringUtils.isNotBlank((String)cacheTenantCode) && StringUtils.isNotBlank((String)tenantCode) && !tenantCode.equals(cacheTenantCode)) {
                this.logger.error(this.sys_code + ".cacheProappTenantCode1", (Object)("\u5f02\u5e38\u8bbf\u95ee1:" + domain + "=" + tenantCode + "-" + cacheTenantCode + "-" + contextPath + "-" + proappCode + "-" + oauthEnvCode));
                interBean.setMsg("\u5f02\u5e38\u8bbf\u95ee1");
            } else {
                interBean.setTenantCode(cacheTenantCode);
                interBean.setProappCode(cacheProappCode);
            }
        } else if (StringUtils.isBlank((String)tginfoCode)) {
            cacheProappTenantCode = this.getCacheComTenantCode("TmProappEnv-domain-code", domain, contextPath, oauthEnvCode);
            this.logger.debug(this.sys_code + ".test.3", (Object)cacheProappTenantCode);
            if (StringUtils.isNotBlank((String)cacheProappTenantCode)) {
                cacheProappCode = cacheProappTenantCode.split(",")[0];
                cacheTenantCode = cacheProappTenantCode.split(",")[1];
                if (StringUtils.isBlank((String)cacheProappCode)) {
                    this.logger.error(this.sys_code + ".cacheProappCode", (Object)("\u5f02\u5e38\u8bbf\u95ee2:[" + proappCode + "##" + cacheProappCode + "] " + tenantCode + "-" + contextPath + "-" + oauthEnvCode));
                    interBean.setMsg("\u5f02\u5e38\u8bbf\u95ee2");
                } else if (!cacheProappCode.equals(proappCode)) {
                    this.logger.error(this.sys_code + ".cacheProappTenantCode2", (Object)("\u5f02\u5e38\u8bbf\u95ee2:[" + proappCode + "##" + cacheProappCode + "] " + tenantCode + "-" + contextPath + "-" + oauthEnvCode));
                    interBean.setMsg("\u5f02\u5e38\u8bbf\u95ee2");
                } else if (StringUtils.isBlank((String)cacheTenantCode) && StringUtils.isBlank((String)tenantCode)) {
                    this.logger.error(this.sys_code + ".cacheProappTenantCode3", (Object)("\u5f02\u5e38\u8bbf\u95ee3:" + domain + "=" + tenantCode + "-" + cacheTenantCode + "-" + contextPath + "-" + proappCode + "-" + oauthEnvCode));
                    interBean.setMsg("\u5f02\u5e38\u8bbf\u95ee3");
                } else if (StringUtils.isNotBlank((String)cacheTenantCode) && StringUtils.isNotBlank((String)tenantCode) && !tenantCode.equals(cacheTenantCode)) {
                    this.logger.error(this.sys_code + ".cacheProappTenantCode4", (Object)("\u5f02\u5e38\u8bbf\u95ee4:" + domain + "=" + tenantCode + "-" + cacheTenantCode + "-" + contextPath + "-" + proappCode + "-" + oauthEnvCode));
                    interBean.setMsg("\u5f02\u5e38\u8bbf\u95ee4");
                } else {
                    interBean.setTenantCode(cacheTenantCode);
                    interBean.setProappCode(cacheProappCode);
                }
            } else {
                this.logger.error(this.sys_code + ".cacheProappTenantCode5", (Object)("\u5f02\u5e38\u8bbf\u95ee5:" + domain + "=" + tenantCode + "-" + cacheTenantCode + "-" + contextPath + "-" + proappCode + "-" + oauthEnvCode));
                interBean.setMsg("\u5f02\u5e38\u8bbf\u95ee5");
            }
        } else {
            interBean.setTenantCode(tenantCode);
            interBean.setProappCode(proappCode);
        }
        if (StringUtils.isBlank((String)cacheProappTenantCode)) {
            cacheProappTenantCode = this.getCacheComTenantCode("TmProappEnv-domain-code", domain, contextPath, oauthEnvCode);
        }
        this.logger.debug(this.sys_code + ".set\u6e20\u9053\u4fe1\u606f.", (Object)cacheProappTenantCode);
        if (StringUtils.isNotBlank((String)cacheProappTenantCode)) {
            try {
                interBean.setMemberCode(cacheProappTenantCode.split(",")[2]);
                interBean.setChannelCode(cacheProappTenantCode.split(",")[3]);
                interBean.setProappEnvCode(cacheProappTenantCode.split(",")[4]);
            }
            catch (Exception e) {
                this.logger.error(this.sys_code + ".cacheProappTenantCode6", (Object)(cacheProappTenantCode + "==" + domain + "=" + tenantCode + "-" + cacheTenantCode + "-" + contextPath + "-" + proappCode + "-" + oauthEnvCode));
            }
        }
    }

    protected InterBean mackeInterBean(HttpServletRequest request) {
        InterBean interBean;
        if (null == request) {
            this.logger.error(this.sys_code + ".mackeInterBean.request", (Object)"request is null");
            return null;
        }
        Map<String, String> cookieMap = this.getSaaSCookies(request);
        String tenantCode = this.getTenantCode(request, cookieMap);
        String proappCode = this.getProappCode(request, cookieMap);
        if (StringUtils.isBlank((String)tenantCode) && StringUtils.isNotBlank((String)proappCode)) {
            this.logger.error(this.sys_code + ".mackeInterBean.tenantCode", (Object)"tenantCode is null");
            return null;
        }
        String domain = this.getDomain(request);
        if (StringUtils.isBlank((String)domain)) {
            this.logger.error(this.sys_code + ".mackeInterBean.domain", (Object)"domain is null");
            return null;
        }
        String contextPath = this.getContextPath(request);
        if (null != contextPath && contextPath.indexOf("/") >= 0) {
            contextPath = contextPath.replace("/", "");
        }
        if (null == (interBean = this.makeEnvInfo(request))) {
            this.logger.error(this.sys_code + ".mackeInterBean.getEnvInfo", (Object)"interBean is null");
            return null;
        }
        interBean.setTenantCode(tenantCode);
        interBean.setProappCode(proappCode);
        interBean.setTginfoCode(this.getTginfoCode(request, cookieMap));
        try {
            this.makeTenant(domain, contextPath, interBean.getOauthEnvCode(), interBean, request, cookieMap);
            if (StringUtils.isNotBlank((String)interBean.getMsg()) && StringUtils.isNotBlank((String)interBean.getOauthParentEnvCode())) {
                this.makeTenant(domain, contextPath, interBean.getOauthParentEnvCode(), interBean, request, cookieMap);
            }
        }
        catch (Exception e) {
            this.logger.error(this.sys_code + ".mackeInterBean.makeTenant", (Throwable)e);
        }
        if (StringUtils.isNotBlank((String)interBean.getMsg())) {
            return interBean;
        }
        this.makeGroup(interBean);
        this.makeToken(interBean, request, cookieMap);
        interBean.setUrl(this.getUrl(request));
        interBean.setRedurl(this.getRedurl(request, interBean.getUrl()));
        return interBean;
    }

    public void thirdAuthlogin(InterBean interBean, HttpServletRequest request, String oauthEnvLoginconf) {
        if (null == interBean || null == request || StringUtils.isBlank((String)oauthEnvLoginconf)) {
            return;
        }
        if (StringUtils.isNotBlank((String)interBean.getToken())) {
            return;
        }
        String token = this.getTokenByThirdCode(request, oauthEnvLoginconf, interBean.getTenantCode());
        interBean.setToken(token);
    }

    protected void makeToken(InterBean interBean, HttpServletRequest request, Map<String, String> cookieMap) {
        if (null == interBean || StringUtils.isBlank((String)interBean.getGroup())) {
            return;
        }
        interBean.setToken(BaseInterUtil.getToKen(request, interBean.getGroup(), cookieMap));
        interBean.setHostname(request.getRemoteHost());
        interBean.setIp(this.getIpAddress(request));
    }

    public String getIpAddress(HttpServletRequest request) {
        return BaseInterUtil.getIpAddress(request);
    }

    public static void main(String[] args) {
        String ip = "116.233.79.183,127.0.0.1";
        System.out.println(ip.split(",")[0]);
    }

    protected void makeGroup(InterBean interBean) {
        if (null == interBean || StringUtils.isBlank((String)interBean.getProappCode()) || StringUtils.isBlank((String)interBean.getTenantCode())) {
            return;
        }
        interBean.setGroup(BaseInterUtil.getTokenGroup(interBean.getProappCode(), interBean.getTenantCode(), interBean.getTginfoCode()));
    }

    protected String getTokenByThirdCode(HttpServletRequest request, String oauthEnvLoginconf, String tenantCode) {
        if (null == request || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        ThirdpartauthServer thirdpartauthServer = this.getThirdAuthServer(oauthEnvLoginconf);
        if (null == thirdpartauthServer) {
            return null;
        }
        String thirdCode = thirdpartauthServer.getauthcode(request);
        if (StringUtils.isBlank((String)thirdCode)) {
            return null;
        }
        UserSession user = thirdpartauthServer.getUserinfo(tenantCode, thirdCode);
        if (user == null) {
            return null;
        }
        String token = this.userProcessing(user);
        return token;
    }

    private ThirdpartauthServer getThirdAuthServer(String classpathName) {
        if (StringUtils.isBlank((String)classpathName)) {
            return null;
        }
        ThirdpartauthServer thirdpartauthServer = (ThirdpartauthServer)thirdAuthLoginMap.get(classpathName);
        if (null == thirdpartauthServer) {
            try {
                Class<?> clazz = Class.forName(classpathName);
                thirdpartauthServer = (ThirdpartauthServer)clazz.newInstance();
                if (null != thirdpartauthServer) {
                    thirdAuthLoginMap.put(classpathName, thirdpartauthServer);
                } else {
                    this.logger.debug(this.sys_code + ".getThirdAuthServer.thirdpartauthServer", (Object)"thirdpartauthServer is null");
                }
            }
            catch (Exception e) {
                this.logger.error(this.sys_code + ".getThirdAuthServer.classpathName", (Object)(classpathName + " is ex"), (Throwable)e);
            }
        }
        return thirdpartauthServer;
    }

    private String userProcessing(UserSession user) {
        if (null == user) {
            return null;
        }
        String username = this.authService.registWeChart(user);
        String rs = "";
        rs = StringUtils.isBlank((String)username) ? this.authService.loginWeChart(user.getUserName(), user.getTenantCode()) : this.authService.loginWeChart(username, user.getTenantCode());
        Map map = JsonUtil.buildNonNullBinder().getJsonToMap(rs, String.class, String.class);
        if (null == map) {
            return null;
        }
        return (String)map.get("tokenkey");
    }

    protected String getCacheComTenantCode(String key, String domain, String contextPath, String oauthEnvCode) {
        return BaseInterUtil.getCacheComTenantCode(key, domain, contextPath, oauthEnvCode);
    }

    protected String getTenantCode(HttpServletRequest request, Map<String, String> cookieMap) {
        return BaseInterUtil.getTenantCode(request, cookieMap);
    }

    protected String getTenantCode(HttpServletRequest request) {
        return BaseInterUtil.getTenantCode(request);
    }

    protected String getProappCode(HttpServletRequest request, Map<String, String> cookieMap) {
        return BaseInterUtil.getProappCode(request, cookieMap);
    }

    protected String getOrgUsercode(HttpServletRequest request, Map<String, String> cookieMap) {
        return BaseInterUtil.getOrgUsercode(request, cookieMap);
    }

    protected String getProappCode(HttpServletRequest request) {
        return BaseInterUtil.getProappCode(request);
    }

    protected String getTginfoCode(HttpServletRequest request, Map<String, String> cookieMap) {
        return BaseInterUtil.getTginfoCode(request, cookieMap);
    }

    protected String getTginfoCode(HttpServletRequest request) {
        return BaseInterUtil.getTginfoCode(request);
    }

    protected Map<String, String> getSaaSCookies(HttpServletRequest request) {
        return BaseInterUtil.getSaaSCookies(request);
    }

    protected String getContextPath(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        String contextPath = request.getContextPath();
        return contextPath;
    }

    protected String getDomain(HttpServletRequest request, Map<String, String> cookieMap) {
        if (null == request) {
            return null;
        }
        return BaseInterUtil.getRelDoamin(request, cookieMap);
    }

    protected String getDomain(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        return BaseInterUtil.getRelDoamin(request, null);
    }

    protected List<String> getEnvInfo(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        String userAgent = request.getHeader(BaseInterUtil.AGENT1);
        if (StringUtils.isBlank((String)userAgent)) {
            userAgent = request.getHeader(BaseInterUtil.AGENT);
        }
        if (StringUtils.isBlank((String)userAgent) && StringUtils.isBlank((String)(userAgent = request.getHeader(BaseInterUtil.USERAGENT1)))) {
            return null;
        }
        List osOAuthEnvList = SupDisUtil.getListJson((String)"OsOAuthEnv-oauthEnvMat", OsOAuthEnv.class);
        if (ListUtil.isEmpty((Collection)osOAuthEnvList)) {
            this.logger.error(this.sys_code + ".getEnvInfo.osOAuthEnvList", (Object)userAgent);
            return null;
        }
        String[] keys = null;
        ArrayList<String> envList = new ArrayList<String>();
        block0: for (OsOAuthEnv osOAuthEnv : osOAuthEnvList) {
            if (null == osOAuthEnv || StringUtils.isBlank((String)osOAuthEnv.getOauthEnvMat())) continue;
            for (String str : keys = osOAuthEnv.getOauthEnvMat().split(",")) {
                if (!userAgent.contains(str)) continue;
                if (StringUtils.isBlank((String)osOAuthEnv.getOauthEnvLoginconf())) {
                    osOAuthEnv.setOauthEnvLoginconf("");
                }
                envList.add(osOAuthEnv.getOauthEnvCode() + "|" + osOAuthEnv.getOauthEnvLoginconf());
                continue block0;
            }
        }
        if (ListUtil.isEmpty(envList)) {
            this.logger.error(this.sys_code + ".getEnvInfo.envList", (Object)("envList is null:" + userAgent));
        }
        return envList;
    }
}

