/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.springmvc.interceptor;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.interceptor.service.BaseInterUtil;
import cn.com.qj.bff.interceptor.service.BaseIntercepter;
import cn.com.qj.bff.springmvc.bean.TmProappEnv;
import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class SpringMVCInterceptor
extends BaseIntercepter
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        long s = System.currentTimeMillis();
        this.logger.info("======preHandle\u8bf7\u6c42url======", (Object)(request.getServletPath() + ":" + request.getMethod() + "=" + request.getCharacterEncoding() + "=" + request.getContentType()));
        try {
            boolean flag = this.filterPer(request, response);
            if (!flag) {
                return false;
            }
            String requestservice = this.getRequestservice(request, this.getTenantCode(request));
            String contextPath = request.getContextPath();
            String servletPath = request.getServletPath();
            request.setAttribute("path_servername", (Object)requestservice);
            request.setAttribute("sysAppContextPath", (Object)contextPath);
            request.setAttribute("requestUrl", (Object)servletPath);
            long s1 = System.currentTimeMillis();
            this.logger.debug("====preHandle====", (Object)(s1 - s));
            this.logger.info("======\u8bf7\u6c42\u670d\u52a1\u540d======", (Object)(request.getServerName() + ":" + request.getMethod() + "=" + request.getCharacterEncoding() + "=" + request.getContentType()));
        }
        catch (Exception e) {
            this.logger.error("====preHandle==e==", (Throwable)e);
        }
        return true;
    }

    private void tryPutSession(HttpServletRequest request, HttpServletResponse response, UserSession userSession, Map<String, String> cacheEnvDomain) {
        if (cacheEnvDomain != null && StringUtils.isNotBlank((String)cacheEnvDomain.get(request.getServerName()))) {
            TmProappEnv tmProappEnv = (TmProappEnv)JSON.parseObject((String)cacheEnvDomain.get(request.getServerName()), TmProappEnv.class);
            userSession.setUserinfoParentCode(tmProappEnv.getMemberCode());
            userSession.setUserinfoChannelcode(tmProappEnv.getChannelCode());
            BaseInterUtil.putSession(request, response, userSession);
            UserSession userSession2 = BaseInterUtil.getSession(request);
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        long s = System.currentTimeMillis();
        this.filterEnd(request, response);
        long s1 = System.currentTimeMillis();
        this.logger.debug("====postHandle====", (Object)(s1 - s));
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (null != ex) {
            this.logger.error((Throwable)ex);
        }
    }

    private String assemblyRequestUrlParams(HttpServletRequest request) {
        this.logger.debug("url:" + request.getRequestURI());
        Map map = request.getParameterMap();
        Iterator key = map.keySet().iterator();
        StringBuffer sb = new StringBuffer();
        while (key.hasNext()) {
            String[] value;
            String k = (String)key.next();
            if (StringUtils.isBlank((String)k) || null == (value = (String[])map.get(k))) continue;
            if (value.length == 1) {
                String temp = "";
                if (!StringUtils.isEmpty((String)value[0])) {
                    temp = value[0];
                }
                sb.append(k).append("=").append(temp).append("&");
                request.setAttribute(k.replace(".", ""), (Object)temp);
                continue;
            }
            if (value.length == 0) {
                request.setAttribute(k.replace(".", ""), null);
                continue;
            }
            if (value.length <= 1) continue;
            sb.append(k).append("=").append(value).append("&");
            request.setAttribute(k.replace(".", ""), (Object)value);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }
}

