/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.common.authservice;

import cn.com.qj.bff.common.authservice.AuthServiceImpl;
import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.common.service.HtmlIBaseService;
import cn.com.qj.bff.core.auth.AuthBean;
import cn.com.qj.bff.core.auth.AuthCheck;
import cn.com.qj.bff.core.auth.AuthService;
import cn.com.qj.bff.core.auth.MmMbuser;
import cn.com.qj.bff.core.auth.MmMerberDomain;
import cn.com.qj.bff.core.auth.UserSession;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="authService")
public class UperAuthServiceImpl
extends AuthServiceImpl
implements AuthService {
    private static final String sys_code = "MperAuthServiceImpl";
    @Autowired
    private HtmlIBaseService htmlIBaseService;

    @Override
    public AuthBean check(AuthCheck authCheck) {
        if (null == authCheck) {
            this.logger.error("MperAuthServiceImpl.check", (Object)"authCheck is null");
            return null;
        }
        return this.checkPer(authCheck);
    }

    @Override
    public UserSession checkOauth(String token, String proappCode, String tenantCode) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("os.oauthserver.saasValidateToken");
        pmap.putParam("oauthTokenToken", token);
        pmap.putParam("proappCode", proappCode);
        pmap.putParam("tenantCode", tenantCode);
        UserSession userSession = (UserSession)this.htmlIBaseService.senReObject(pmap, UserSession.class);
        if (null != userSession && userSession.isFlag()) {
            return userSession;
        }
        if (null != userSession) {
            this.logger.error("MperAuthServiceImpl.checkOauth", (Object)userSession.getMsg());
        }
        return null;
    }

    @Override
    public void reloadUserSession(String tokenId, String key, String value, String tenantCode) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("os.oauthserver.reLoadUserSession");
        pmap.putParam("oauthTokenToken", tokenId);
        pmap.putParam("key", key);
        pmap.putParam("value", value);
        pmap.putParam("appmanageIcode", ServletMain.getAppName());
        this.htmlIBaseService.sendMesReBean(pmap);
    }

    @Override
    public String registWeChart(UserSession user) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("mm.merber.queryMbuserPage");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mbuserOpenid", user.getUserName());
        map.put("tenantCode", user.getTenantCode());
        pmap.putParamToJson("map", map);
        SupQueryResult rs = this.htmlIBaseService.sendReSupObject(pmap, MmMbuser.class);
        if (rs != null && rs.getList() != null && rs.getList().size() > 0) {
            return ((MmMbuser)rs.getList().get(0)).getMbuserName();
        }
        MmMerberDomain mUser = new MmMerberDomain();
        mUser.setUserName(user.getUserName());
        mUser.setMbuserOpenid(user.getUserName());
        mUser.setTenantCode(user.getTenantCode());
        mUser.setMerberType(1);
        mUser.setMerberExcode(user.getUserName());
        mUser.setMerberOrg(user.getUseragent());
        mUser.setMbextendSex(user.getMbextendSex());
        mUser.setMbuserNickname(user.getUserNickname());
        mUser.setMbuserImgurl(user.getUserImgpath());
        pmap = new PostParamMap("mm.merber.sendOpenMerber");
        pmap.putParamToJson("mmMerberDomain", mUser);
        this.htmlIBaseService.sendMesReJson(pmap);
        return null;
    }

    @Override
    public String loginWeChart(String userName, String tenantCode) {
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>("os.oauthserver.LoginWithName");
        pmap.putParam("proappCode", ServletMain.getAppName());
        pmap.putParam("browType", "WEB");
        pmap.putParam("tenantCode", tenantCode);
        pmap.putParam("userName", userName);
        return this.htmlIBaseService.sendMesReJson(pmap);
    }
}

