/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.common.authservice;

import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.common.service.HtmlIBaseService;
import cn.com.qj.bff.core.auth.AuthBean;
import cn.com.qj.bff.core.auth.AuthCheck;
import cn.com.qj.bff.core.auth.MenuBean;
import cn.com.qj.bff.core.auth.MenuInfoBean;
import cn.com.qj.bff.core.auth.Permisson;
import cn.com.qj.bff.core.auth.PermissonList;
import cn.com.qj.bff.core.auth.ResBean;
import cn.com.qj.bff.core.auth.UserSession;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.point.RegeditUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.supper.ObjectService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthServiceImpl
extends ObjectService {
    private static final String sys_code = "AuthServiceImpl";
    public static final String UMBLAKMEMBERCODE = "Blakrange-memberCode";
    @Autowired
    private HtmlIBaseService htmlIBaseService;

    public List<MenuInfoBean> getUserPerMenuTree(Map<String, String> userperMap, String proappCode, String tenantCode) {
        return this.getPerMenuTreeByuser(userperMap, proappCode, tenantCode, true, true);
    }

    public List<MenuInfoBean> getUserInfoPerMenuTree(Map<String, String> userperMap, String proappCode, String tenantCode) {
        return this.getPerMenuTreeByuser(userperMap, proappCode, tenantCode, false, true);
    }

    public List<MenuInfoBean> getPerMenuTree(String proappCode, String tenantCode) {
        return this.getPerMenuTreeByuser(null, proappCode, tenantCode, false, false);
    }

    private void makeAction(MenuInfoBean menuInfoBean, String proappCode, String oauthEnvCode, String tenantCode, String userinfoCode) {
        if (null == menuInfoBean) {
            return;
        }
        if (StringUtils.isBlank((String)proappCode)) {
            proappCode = "";
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = "";
        }
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            oauthEnvCode = "";
        }
        if (StringUtils.isBlank((String)userinfoCode)) {
            userinfoCode = "";
        }
        if (StringUtils.isNotBlank((String)menuInfoBean.getMenuAction()) && menuInfoBean.getMenuAction().indexOf("${") >= 0) {
            menuInfoBean.setMenuAction(menuInfoBean.getMenuAction().replace("${tenantCode}", tenantCode));
            menuInfoBean.setMenuAction(menuInfoBean.getMenuAction().replace("${proappCode}", proappCode));
            menuInfoBean.setMenuAction(menuInfoBean.getMenuAction().replace("${oauthEnvCode}", oauthEnvCode));
            menuInfoBean.setMenuAction(menuInfoBean.getMenuAction().replace("${userinfoCode}", userinfoCode));
        }
        if (StringUtils.isNotBlank((String)menuInfoBean.getMenuJspath()) && menuInfoBean.getMenuJspath().indexOf("${") >= 0) {
            menuInfoBean.setMenuJspath(menuInfoBean.getMenuJspath().replace("${tenantCode}", tenantCode));
            menuInfoBean.setMenuJspath(menuInfoBean.getMenuJspath().replace("${proappCode}", proappCode));
            menuInfoBean.setMenuJspath(menuInfoBean.getMenuJspath().replace("${oauthEnvCode}", oauthEnvCode));
            menuInfoBean.setMenuJspath(menuInfoBean.getMenuJspath().replace("${userinfoCode}", userinfoCode));
        }
    }

    private List<MenuInfoBean> getPerMenuTreeByuser(Map<String, String> userperMap, String proappCode, String tenantCode, boolean show, boolean op) {
        long start = System.currentTimeMillis();
        List<MenuInfoBean> menuList = this.navQueryCache(proappCode, tenantCode);
        long start1 = System.currentTimeMillis();
        this.logger.debug("==1==", (Object)(start1 - start));
        if (null == menuList || menuList.isEmpty()) {
            return null;
        }
        String oauthEnvCode = SupDisUtil.getMap((String)"TmProapp-ProappCode", (String)(proappCode + "-" + tenantCode));
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            oauthEnvCode = SupDisUtil.getMap((String)"TmProapp-ProappCode", (String)(proappCode + "-" + "00000000"));
        }
        long start2 = System.currentTimeMillis();
        this.logger.debug("==2==", (Object)(start2 - start1));
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            oauthEnvCode = "";
        }
        ArrayList<MenuInfoBean> treemenu = new ArrayList<MenuInfoBean>();
        String userinfoCode = "";
        if (null != userperMap) {
            userinfoCode = userperMap.get("userinfoCode");
        }
        long start3 = System.currentTimeMillis();
        this.logger.debug("==3==", (Object)(start3 - start2));
        for (MenuInfoBean menuInfoBean : menuList) {
            long start77 = System.currentTimeMillis();
            MenuInfoBean menuInfoBeanre = new MenuInfoBean();
            try {
                BeanUtils.copyAllPropertys((Object)menuInfoBeanre, (Object)menuInfoBean);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.makeAction(menuInfoBeanre, proappCode, oauthEnvCode, tenantCode, userinfoCode);
            long start31 = System.currentTimeMillis();
            List<MenuInfoBean> menuchildList = this.makeMenuCache(menuInfoBean.getProappMenuCode(), proappCode, tenantCode);
            long start32 = System.currentTimeMillis();
            this.logger.debug("==4==", (Object)(start32 - start31));
            if (ListUtil.isEmpty(menuchildList)) {
                if (show || op || null == menuInfoBeanre.getMenuShow() || 1 != menuInfoBeanre.getMenuShow()) {
                    if (show && StringUtils.isBlank((String)menuInfoBeanre.getPermissionCode())) {
                        treemenu.add(menuInfoBeanre);
                    } else if (StringUtils.isNotBlank((String)menuInfoBeanre.getPermissionCode())) {
                        if (this.check(menuInfoBeanre.getPermissionCode(), userperMap, show, op, menuInfoBeanre)) {
                            treemenu.add(menuInfoBeanre);
                        } else {
                            this.logger.debug("==" + menuInfoBeanre.getPermissionCode() + "=" + show + "=" + op + "=" + menuInfoBeanre.getMenuCode());
                        }
                    }
                }
            } else if (show || op || null == menuInfoBeanre.getMenuShow() || 1 != menuInfoBeanre.getMenuShow()) {
                long start331 = System.currentTimeMillis();
                List<MenuInfoBean> menuchildReList = this.makePerOp(menuchildList, userperMap, show, op, proappCode, oauthEnvCode, tenantCode, userinfoCode);
                long start332 = System.currentTimeMillis();
                this.logger.debug("==52==", (Object)(start332 - start331));
                if (null != menuchildReList && !menuchildReList.isEmpty()) {
                    menuInfoBeanre.setChildren(menuchildReList);
                    treemenu.add(menuInfoBeanre);
                }
            }
            long start33 = System.currentTimeMillis();
            this.logger.debug("==5==", (Object)(start33 - start32));
            this.logger.debug("==5all==", (Object)(start33 - start77));
        }
        long start4 = System.currentTimeMillis();
        this.logger.debug("==6==all==", (Object)(start4 - start3));
        if (null == treemenu || treemenu.isEmpty()) {
            return null;
        }
        return treemenu;
    }

    public String getRouter(List<MenuInfoBean> menuchildReList) {
        if (ListUtil.isEmpty(menuchildReList)) {
            return "";
        }
        String target = "";
        for (MenuInfoBean menuInfoBean : menuchildReList) {
            target = this.getRouter(menuInfoBean.getChildren());
            if (!StringUtils.isBlank((String)target)) continue;
            target = menuInfoBean.getMenuTarget();
            return target;
        }
        return target;
    }

    private List<MenuInfoBean> makePerOp(List<MenuInfoBean> menuchildList, Map<String, String> userperMap, boolean show, boolean op, String proappCode, String oauthEnvCode, String tenantCode, String userinfoCode) {
        if (null == menuchildList || menuchildList.isEmpty()) {
            return null;
        }
        ArrayList<MenuInfoBean> menuRelist = new ArrayList<MenuInfoBean>();
        boolean flag = true;
        long start1 = System.currentTimeMillis();
        for (MenuInfoBean menuInfoBean : menuchildList) {
            long start11 = System.currentTimeMillis();
            if (!show && !op && null != menuInfoBean.getMenuShow() && 1 == menuInfoBean.getMenuShow()) continue;
            flag = true;
            MenuInfoBean menuInfoBeanre = new MenuInfoBean();
            try {
                BeanUtils.copyAllPropertys((Object)menuInfoBeanre, (Object)menuInfoBean);
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean child = false;
            this.makeAction(menuInfoBeanre, proappCode, oauthEnvCode, tenantCode, userinfoCode);
            long start12 = System.currentTimeMillis();
            this.logger.debug("==makePerOp1==", (Object)(start12 - start11));
            if (null != menuInfoBean.getChildren() && !menuInfoBean.getChildren().isEmpty()) {
                List<MenuInfoBean> menuRechilelist = this.makePerOp(menuInfoBean.getChildren(), userperMap, show, op, proappCode, oauthEnvCode, tenantCode, userinfoCode);
                if (null != menuRechilelist && !menuRechilelist.isEmpty()) {
                    menuInfoBeanre.setChildren(menuRechilelist);
                    menuRelist.add(menuInfoBeanre);
                    flag = false;
                } else {
                    menuInfoBeanre.setChildren(null);
                    child = true;
                }
            }
            long start13 = System.currentTimeMillis();
            this.logger.debug("==makePerOp2==", (Object)(start13 - start12));
            if (!flag) continue;
            String permissionCode = menuInfoBeanre.getPermissionCode();
            if ((child || !show) && StringUtils.isBlank((String)permissionCode) || StringUtils.isNotBlank((String)permissionCode) && !this.check(permissionCode, userperMap, show, op, menuInfoBeanre)) continue;
            long start14 = System.currentTimeMillis();
            this.logger.debug("==makePerOp3==", (Object)(start14 - start13));
            menuRelist.add(menuInfoBeanre);
        }
        long start2 = System.currentTimeMillis();
        this.logger.debug("==makePerOp==", (Object)(start2 - start1));
        return menuRelist;
    }

    private Permisson getPermisson(String permissionCode) {
        if (StringUtils.isBlank((String)permissionCode)) {
            return null;
        }
        String tenantCode = RegeditUtil.make().getAppTenant();
        Permisson permisson = null;
        if (StringUtils.isNotBlank((String)tenantCode)) {
            permisson = (Permisson)SupDisUtil.getMapJson((String)"UpPermission-permission", (String)(permissionCode + "-" + tenantCode), Permisson.class);
            if (null == permisson) {
                permisson = (Permisson)SupDisUtil.getMapJson((String)"UpPermission-permission", (String)(permissionCode + "-" + "00000000"), Permisson.class);
            }
        } else {
            permisson = (Permisson)SupDisUtil.getMapJson((String)"UpPermission-permission", (String)(permissionCode + "-" + "00000000"), Permisson.class);
        }
        return permisson;
    }

    private String getMenuListStr(String permissionCode) {
        if (StringUtils.isBlank((String)permissionCode)) {
            return null;
        }
        String tenantCode = RegeditUtil.make().getAppTenant();
        String menuListStr = null;
        if (StringUtils.isNotBlank((String)tenantCode)) {
            menuListStr = SupDisUtil.getMap((String)"UpMenu-permissionCode", (String)(permissionCode + "-" + tenantCode));
            if (StringUtils.isBlank((String)menuListStr)) {
                menuListStr = SupDisUtil.getMap((String)"UpMenu-permissionCode", (String)(permissionCode + "-" + "00000000"));
            }
        } else {
            menuListStr = SupDisUtil.getMap((String)"UpMenu-permissionCode", (String)(permissionCode + "-" + "00000000"));
        }
        return menuListStr;
    }

    private boolean check(String permissionCode, Map<String, String> userperMap, boolean show, boolean op, MenuInfoBean menuInfoBeanre) {
        if (StringUtils.isBlank((String)permissionCode) || null == menuInfoBeanre) {
            return true;
        }
        long start1 = System.currentTimeMillis();
        Permisson permisson = this.getPermisson(permissionCode);
        long start2 = System.currentTimeMillis();
        this.logger.debug("==check==", (Object)(start2 - start1));
        if (null == permisson) {
            return false;
        }
        if (!(show || PermissonList.sort_user.equals(permisson.getPermissionSort()) || null != menuInfoBeanre.getChildren() && !menuInfoBeanre.getChildren().isEmpty())) {
            return false;
        }
        if (PermissonList.sort_user.equals(permisson.getPermissionSort())) {
            if (op && (StringUtils.isBlank((String)menuInfoBeanre.getMenuCode()) || null == userperMap || userperMap.isEmpty())) {
                return false;
            }
            if (StringUtils.isNotBlank((String)menuInfoBeanre.getMenuCode()) && null != userperMap && !userperMap.isEmpty()) {
                long start21 = System.currentTimeMillis();
                String menuListStr = this.getMenuListStr(permisson.getPermissionCode());
                long start22 = System.currentTimeMillis();
                this.logger.debug("==check1==", (Object)(start22 - start21));
                if (StringUtils.isBlank((String)menuListStr)) {
                    menuListStr = menuInfoBeanre.getMenuCode();
                }
                if (!this.check(menuListStr, userperMap)) {
                    return false;
                }
            }
        } else if (PermissonList.sort_admin.equals(permisson.getPermissionSort())) {
            if (null == userperMap || !op) {
                return false;
            }
            String userType = userperMap.get("userType");
            if (StringUtils.isBlank((String)userType) || !"0".equals(userType)) {
                return false;
            }
        }
        return true;
    }

    private PermissonList getPermissonList(AuthCheck authCheck) {
        if (null == authCheck) {
            return null;
        }
        String rootperlistKey = authCheck.getUrl();
        String tenantCode = RegeditUtil.make().getAppTenant();
        PermissonList permissonList = null;
        if (StringUtils.isNotBlank((String)tenantCode)) {
            String perlistKey = rootperlistKey + "-" + authCheck.getMethod() + "-" + tenantCode;
            permissonList = (PermissonList)SupDisUtil.getMapJson((String)"UpPermissionList-permissionList", (String)perlistKey, PermissonList.class);
            if (null == permissonList) {
                perlistKey = rootperlistKey + "-*-" + tenantCode;
                permissonList = (PermissonList)SupDisUtil.getMapJson((String)"UpPermissionList-permissionList", (String)perlistKey, PermissonList.class);
            }
            if (!tenantCode.equals("00000000")) {
                if (null == permissonList) {
                    perlistKey = rootperlistKey + "-" + authCheck.getMethod() + "-" + "00000000";
                    permissonList = (PermissonList)SupDisUtil.getMapJson((String)"UpPermissionList-permissionList", (String)perlistKey, PermissonList.class);
                }
                if (null == permissonList) {
                    perlistKey = rootperlistKey + "-*-" + "00000000";
                    permissonList = (PermissonList)SupDisUtil.getMapJson((String)"UpPermissionList-permissionList", (String)perlistKey, PermissonList.class);
                }
            }
        } else {
            String perlistKey = rootperlistKey + "-" + authCheck.getMethod() + "-" + "00000000";
            permissonList = (PermissonList)SupDisUtil.getMapJson((String)"UpPermissionList-permissionList", (String)perlistKey, PermissonList.class);
            if (null == permissonList) {
                perlistKey = rootperlistKey + "-*-" + "00000000";
                permissonList = (PermissonList)SupDisUtil.getMapJson((String)"UpPermissionList-permissionList", (String)perlistKey, PermissonList.class);
            }
        }
        if (null == permissonList) {
            permissonList = this.matchRestfulURI(authCheck);
        }
        return permissonList;
    }

    public AuthBean checkPer(AuthCheck authCheck) {
        if (null == authCheck) {
            this.logger.error("AuthServiceImpl.check1", (Object)"authCheck is null");
            return null;
        }
        String rootperlistKey = authCheck.getUrl();
        String perlistKey = rootperlistKey + "-" + authCheck.getMethod() + "-" + "00000000";
        PermissonList permissonList = this.getPermissonList(authCheck);
        AuthBean authBean = new AuthBean();
        authBean.setFlag(AuthBean.anthFlag_ok);
        if (null == permissonList) {
            this.logger.error("AuthServiceImpl.check2", (Object)(perlistKey + ":perlistStr is null"));
            authBean.setFlag(AuthBean.anthFlag_nr);
        } else {
            authBean.setPermissonList(permissonList);
            Permisson permisson = this.getPermisson(permissonList.getPermissionCode());
            UserSession userSession = authCheck.getUserSession();
            if (null == permisson) {
                authBean.setFlag(AuthBean.anthFlag_nr);
                this.logger.error("AuthServiceImpl.check", (Object)(perlistKey + ":perStr is null"));
            }
            if (PermissonList.sort_public.equals(permissonList.getPermissionListSort())) {
                authBean.setFlag(AuthBean.anthFlag_ok);
            } else if (PermissonList.sort_user.equals(permissonList.getPermissionListSort()) || PermissonList.sort_login.equals(permissonList.getPermissionListSort())) {
                if (StringUtils.isBlankLoop((String[])new String[]{authCheck.getToken(), authCheck.getProappCode(), authCheck.getTenantCode()})) {
                    this.logger.error("AuthServiceImpl.check.null", (Object)(authCheck.getToken() + "=" + authCheck.getProappCode() + "=" + authCheck.getTenantCode()));
                    authBean.setFlag(AuthBean.anthFlag_nl);
                } else if (null == userSession) {
                    this.logger.error("AuthServiceImpl.check.userSession", (Object)(authCheck.getToken() + "=" + authCheck.getProappCode() + "=" + authCheck.getTenantCode()));
                    authBean.setFlag(AuthBean.anthFlag_nl);
                } else if (PermissonList.sort_login.equals(permissonList.getPermissionListSort())) {
                    Integer permissionListType;
                    Integer dataState = userSession.getDataState();
                    if (null == dataState) {
                        dataState = 0;
                    }
                    if (null == (permissionListType = permissonList.getPermissionListType())) {
                        permissionListType = 0;
                    }
                    this.checkByDataState(dataState, permissionListType, authCheck, authBean);
                } else if (PermissonList.sort_user.equals(permissonList.getPermissionListSort())) {
                    ResBean resBean = this.getResbean(permissonList, permisson);
                    authBean.setResBean(resBean);
                    if (null == authBean.getResBean() || StringUtils.isBlank((String)authBean.getResBean().getMenuCode())) {
                        authBean.setFlag(AuthBean.anthFlag_nr);
                        this.logger.error("AuthServiceImpl.check.user.nr", (Object)(perlistKey + ":getMenuCode is null"));
                    } else {
                        Map<String, String> perMap = userSession.getMap();
                        if (null == perMap) {
                            perMap = new HashMap<String, String>();
                        }
                        if (null != userSession.getOneUserSessionBean() && null != userSession.getOneUserSessionBean().getMap() && !userSession.getOneUserSessionBean().getMap().isEmpty()) {
                            perMap.putAll(userSession.getOneUserSessionBean().getMap());
                        }
                        if (null != userSession.getTwoUserSessionBean() && null != userSession.getTwoUserSessionBean().getMap() && !userSession.getTwoUserSessionBean().getMap().isEmpty()) {
                            perMap.putAll(userSession.getTwoUserSessionBean().getMap());
                        }
                        if (null == perMap || perMap.isEmpty()) {
                            authBean.setFlag(AuthBean.anthFlag_np);
                            this.logger.error("AuthServiceImpl.check.user.npnull", (Object)(perlistKey + ":map is null"));
                        } else {
                            Integer permissionListType;
                            Integer dataState = userSession.getDataState();
                            if (null == dataState) {
                                dataState = 0;
                            }
                            if (null == (permissionListType = permissonList.getPermissionListType())) {
                                permissionListType = 0;
                            }
                            this.checkByDataState(dataState, permissionListType, authCheck, authBean);
                            boolean flag = this.check(resBean.getMenuCodeStr(), perMap);
                            if (!flag) {
                                authBean.setFlag(AuthBean.anthFlag_np);
                                this.logger.error("AuthServiceImpl.check.user.np", (Object)(resBean.getUrlPath() + ":menuCode is " + resBean.getMenuCodeStr() + " == " + perMap.toString()));
                            }
                        }
                    }
                }
            } else if (PermissonList.sort_admin.equals(permissonList.getPermissionListSort())) {
                if (StringUtils.isBlankLoop((String[])new String[]{authCheck.getToken(), authCheck.getProappCode(), authCheck.getTenantCode()})) {
                    this.logger.error("AuthServiceImpl.check.admin.null", (Object)(authCheck.getToken() + "=" + authCheck.getProappCode() + "=" + authCheck.getTenantCode()));
                    authBean.setFlag(AuthBean.anthFlag_nl);
                } else {
                    if (null == userSession) {
                        this.logger.error("AuthServiceImpl.check.admin.userSession", (Object)(authCheck.getToken() + "=" + authCheck.getProappCode() + "=" + authCheck.getTenantCode()));
                        authBean.setFlag(AuthBean.anthFlag_nl);
                    }
                    if (0 != userSession.getUserType()) {
                        this.logger.error("AuthServiceImpl.check.admin.type", (Object)(authCheck.getToken() + "=" + authCheck.getProappCode() + "=" + authCheck.getTenantCode()));
                        authBean.setFlag(AuthBean.anthFlag_nl);
                    }
                }
            }
        }
        return authBean;
    }

    private AuthBean checkByDataState(Integer dataState, Integer permissionListType, AuthCheck authCheck, AuthBean authBean) {
        if (null == dataState || null == permissionListType || null == authCheck || null == authBean) {
            return null;
        }
        if (1 == dataState) {
            if (1 == permissionListType) {
                authBean.setFlag(AuthBean.anthFlag_na);
                this.logger.error("AuthServiceImpl.check.user.na");
            }
        } else if (2 == dataState) {
            String supValue = SupDisUtil.getMap((String)UMBLAKMEMBERCODE, (String)("all-" + authCheck.getUserSession().getUserPcode() + "-" + authCheck.getTenantCode()));
            if (StringUtils.isBlank((String)supValue)) {
                supValue = SupDisUtil.getMap((String)UMBLAKMEMBERCODE, (String)(authCheck.getMemberCode() + "-" + authCheck.getUserSession().getUserPcode() + "-" + authCheck.getTenantCode()));
            }
            if (StringUtils.isBlank((String)supValue)) {
                return authBean;
            }
            if (0 != permissionListType) {
                authBean.setFlag(AuthBean.anthFlag_nb);
                this.logger.error("AuthServiceImpl.check.user.nb");
            }
        }
        return authBean;
    }

    private boolean check(String menuCodeStr, Map<String, String> perMap) {
        if (StringUtils.isBlank((String)menuCodeStr) || null == perMap) {
            return false;
        }
        String[] menuCodes = menuCodeStr.split("\\,");
        boolean flag = false;
        block0: for (String menuCode : menuCodes) {
            String[] pmenuCodes;
            if (StringUtils.isNotBlank((String)perMap.get(menuCode))) {
                flag = true;
                break;
            }
            String pmenuStr = SupDisUtil.getMap((String)"UpMenu-menuCode-parent", (String)menuCode);
            if (!StringUtils.isNotBlank((String)pmenuStr)) continue;
            for (String pmenuCode : pmenuCodes = pmenuStr.split("\\,")) {
                if (!StringUtils.isNotBlank((String)perMap.get(pmenuCode))) continue;
                flag = true;
                continue block0;
            }
        }
        return flag;
    }

    private ResBean getResbean(PermissonList permissonList, Permisson permisson) {
        if (null == permissonList || null == permisson) {
            return null;
        }
        ResBean resBean = new ResBean();
        resBean.setUrlPath(permissonList.getPermissionListJspath());
        if (StringUtils.isBlank((String)resBean.getUrlPath())) {
            resBean.setUrlPath(permisson.getPermissionJspath());
        }
        resBean.setMenuName(permisson.getPermissionName());
        String menuListStr = SupDisUtil.getMap((String)"UpMenu-permissionCode", (String)(permisson.getPermissionCode() + "-" + "00000000"));
        if (StringUtils.isNotBlank((String)menuListStr)) {
            MenuBean parentmenuBean;
            String menuCode = menuListStr.split("\\,")[0];
            resBean.setMenuCodeStr(menuListStr);
            MenuBean menuBean = (MenuBean)SupDisUtil.getMapJson((String)"UpMenu-menuCode", (String)(menuCode + "-" + "00000000"), MenuBean.class);
            if (null == menuBean) {
                this.logger.error("AuthServiceImpl.check5", (Object)(permisson.getPermissionCode() + ":menuStr is null "));
                return null;
            }
            if (StringUtils.isBlank((String)resBean.getUrlPath())) {
                resBean.setUrlPath(menuBean.getMenuJspath());
            }
            resBean.setMenuName(menuBean.getMenuName());
            resBean.setMenuCode(menuBean.getMenuCode());
            String menuParentCode = menuBean.getMenuParentCode();
            if (StringUtils.isNotBlank((String)menuParentCode) && null != (parentmenuBean = (MenuBean)SupDisUtil.getMapJson((String)"UpMenu-menuCode-menuCode", (String)(menuParentCode + "-" + "00000000"), MenuBean.class))) {
                resBean.setMenuParentCode(parentmenuBean.getMenuCode());
                resBean.setMenuParentName(parentmenuBean.getMenuName());
            }
            return resBean;
        }
        return null;
    }

    private PermissonList matchRestfulURI(AuthCheck authCheck) {
        String perlistTempKey;
        String[] urls = authCheck.getUrl().split("\\/");
        String url = authCheck.getUrl() + "/";
        PermissonList permissonList = null;
        for (int i = urls.length - 1; i > 0 && null == (permissonList = (PermissonList)SupDisUtil.getMapJson((String)"UpPermissionList-permissionList", (String)(perlistTempKey = (url = url.replace("/" + urls[i] + "/", "/*/")).substring(0, url.length() - 1) + "-*-" + "UpPermissionList-permissionList"), PermissonList.class)); --i) {
        }
        return permissonList;
    }

    public List<MenuInfoBean> navQuery(String proappCode, String tenantCode) {
        List<MenuInfoBean> menuList = this.navQueryCache(proappCode, tenantCode);
        if (ListUtil.isEmpty(menuList)) {
            return null;
        }
        String oauthEnvCode = SupDisUtil.getMap((String)"TmProapp-ProappCode", (String)(proappCode + "-" + tenantCode));
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            oauthEnvCode = SupDisUtil.getMap((String)"TmProapp-ProappCode", (String)(proappCode + "-" + "00000000"));
        }
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            oauthEnvCode = "";
        }
        ArrayList<MenuInfoBean> menuReList = new ArrayList<MenuInfoBean>();
        for (MenuInfoBean menuInfoBean : menuList) {
            MenuInfoBean menuInfoBeanre = new MenuInfoBean();
            try {
                BeanUtils.copyAllPropertys((Object)menuInfoBeanre, (Object)menuInfoBean);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.makeAction(menuInfoBeanre, proappCode, oauthEnvCode, tenantCode, "");
            menuReList.add(menuInfoBeanre);
        }
        return menuReList;
    }

    private List<MenuInfoBean> navQueryCache(String proappCode, String tenantCode) {
        List menuList = null;
        menuList = SupDisUtil.getListJson((String)("TmProappMenuListOne--" + proappCode + "-" + tenantCode), MenuInfoBean.class);
        return menuList;
    }

    private List<MenuInfoBean> makeMenuCache(String menuParentCode, String proappCode, String tenantCode) {
        List menuList = null;
        menuList = SupDisUtil.getListJson((String)("TmProappMenuListChild--" + menuParentCode + "-" + proappCode + "-" + tenantCode), MenuInfoBean.class);
        return menuList;
    }

    public List<MenuInfoBean> makeMenu(String menuParentCode, String proappCode, String tenantCode) {
        List<MenuInfoBean> menuList = this.makeMenuCache(menuParentCode, proappCode, tenantCode);
        if (ListUtil.isEmpty(menuList)) {
            return null;
        }
        String oauthEnvCode = SupDisUtil.getMap((String)"TmProapp-ProappCode", (String)(proappCode + "-" + tenantCode));
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            oauthEnvCode = "";
        }
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            oauthEnvCode = SupDisUtil.getMap((String)"TmProapp-ProappCode", (String)(proappCode + "-" + "00000000"));
        }
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            oauthEnvCode = "";
        }
        ArrayList<MenuInfoBean> menuReList = new ArrayList<MenuInfoBean>();
        for (MenuInfoBean menuInfoBean : menuList) {
            MenuInfoBean menuInfoBeanre = new MenuInfoBean();
            try {
                BeanUtils.copyAllPropertys((Object)menuInfoBeanre, (Object)menuInfoBean);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.makeAction(menuInfoBeanre, proappCode, oauthEnvCode, tenantCode, "");
            menuReList.add(menuInfoBeanre);
        }
        return menuReList;
    }

    public List<MenuBean> loadModleMenu(String menuParentCode, String cachechildKey, String api) {
        this.logger.debug("AuthServiceImpl.loadModleMenu", (Object)("===\u52a0\u8f7d" + api + ".start===="));
        String field = ServletMain.getAppName() + "-" + menuParentCode;
        PostParamMap<String, Object> pmap = new PostParamMap<String, Object>(api);
        pmap.putParam("appmanageIcode", ServletMain.getAppName());
        pmap.putParam("menuParentCode", menuParentCode);
        List menuList = (List)this.htmlIBaseService.senReList(pmap, MenuBean.class);
        SupDisUtil.setMap((String)cachechildKey, (String)field, (String)JsonUtil.buildNormalBinder().toJson((Object)menuList));
        this.logger.debug("AuthServiceImpl.loadModleMenu", (Object)("===\u52a0\u8f7d" + api + ".end===="));
        return menuList;
    }
}

