/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.interceptor.bean;

import cn.com.qj.bff.common.bean.DisChannel;
import cn.com.qj.bff.core.auth.AuthBean;
import cn.com.qj.bff.core.auth.PermissonList;
import cn.com.qj.bff.core.auth.ResBean;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.interceptor.bean.InterBean;
import cn.com.qj.bff.interceptor.bean.LogLogDomainBean;
import cn.com.qj.bff.interceptor.service.BaseInterUtil;
import cn.com.qj.bff.springmvc.bean.TmProappEnv;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;

public class LogLogHandler {
    protected static final SupperLogUtil logger = new SupperLogUtil(LogLogHandler.class);

    public static LogLogDomainBean logControlStart(Map<String, Object> requestParamtersMap, InterBean interBean, AuthBean authBean) {
        return LogLogHandler.makeLog(requestParamtersMap, interBean, authBean, 0L, true);
    }

    public static LogLogDomainBean logControlEnd(Map<String, Object> requestParamtersMap, InterBean interBean, AuthBean authBean) {
        return LogLogHandler.makeLog(requestParamtersMap, interBean, authBean, 0L, false);
    }

    private static LogLogDomainBean makeLog(Map<String, Object> requestParamtersMap, InterBean interBean, AuthBean authBean, Long logType, boolean start) {
        if (null == interBean || null == authBean) {
            return null;
        }
        PermissonList permissonList = authBean.getPermissonList();
        if (null == permissonList) {
            return null;
        }
        UserSession userSession = authBean.getUserSession();
        if (logType == null) {
            logType = 0L;
        }
        Object logBillno = null;
        String msg = "\u64cd\u4f5c\u3010";
        String endmsg = "";
        endmsg = start ? endmsg + "\u3011\u5f00\u59cb" : endmsg + "\u3011\u7ed3\u675f";
        String no = "";
        no = start ? permissonList.getPermissionLogSno() : permissonList.getPermissionLogNno();
        if (StringUtils.isNotBlank((String)no)) {
            no = LogLogHandler.setNoPasswd(requestParamtersMap, no);
            logBillno = BeanUtils.newForceGetProperty(requestParamtersMap, (String)no);
        }
        msg = msg + JsonUtil.buildNormalBinder().toJson(requestParamtersMap);
        msg = msg + endmsg;
        String logBillnoStr = logBillno == null ? "" : logBillno.toString();
        LogLogDomainBean oplog = new LogLogDomainBean();
        if (userSession != null) {
            oplog.setUserCode(userSession.getUserCode());
            oplog.setUserName(userSession.getUserName());
        }
        if (start) {
            oplog.setLogModel("0");
        } else {
            oplog.setLogModel("1");
        }
        ResBean resBean = authBean.getResBean();
        String menuName = "";
        if (null != resBean) {
            if (StringUtils.isNotBlank((String)resBean.getMenuParentName())) {
                menuName = menuName + resBean.getMenuParentName();
            }
            if (StringUtils.isNotBlank((String)menuName)) {
                menuName = menuName + "-";
            }
            if (StringUtils.isNotBlank((String)resBean.getMenuName())) {
                menuName = menuName + resBean.getMenuName();
            }
        }
        oplog.setLogPermisName(menuName);
        oplog.setLogIp(interBean.getIp());
        oplog.setLogUseragent(interBean.getOauthEnvCode());
        oplog.setLogHostname(interBean.getHostname());
        oplog.setTenantCode(interBean.getTenantCode());
        oplog.setAppmanageIcode(ServletMain.getAppName());
        oplog.setLogBillno(logBillnoStr);
        oplog.setLogMessage(msg);
        oplog.setLogPermislistCode(permissonList.getPermissionListCode());
        oplog.setLogPermislistName(permissonList.getPermissionListName());
        oplog.setLogPermisCode(permissonList.getPermissionCode());
        oplog.setLogServername(ServletMain.getAppKey() + "(" + ServletMain.getAppName() + ")");
        oplog.setLogType(String.valueOf(logType));
        oplog.setProappCode(interBean.getProappCode());
        DisChannel disChannel = BaseInterUtil.getChannelModel(interBean.getChannelCode(), interBean.getTenantCode());
        if (null != disChannel) {
            oplog.setGoodsClass(disChannel.getGoodsClass());
            oplog.setChannelName(disChannel.getChannelName());
            oplog.setMemberCode(disChannel.getMemberCode());
            oplog.setMemberMcode(disChannel.getMemberMcode());
            oplog.setMemberName(disChannel.getMemberName());
            oplog.setMemberMname(disChannel.getMemberMname());
        } else {
            String cacheKey = "TmProappEnv-tenant-ProappCode";
            TmProappEnv tmProappEnv = (TmProappEnv)SupDisUtil.getMapJson((String)cacheKey, (String)(interBean.getTenantCode() + "-" + interBean.getProappCode()), TmProappEnv.class);
            if (null != tmProappEnv) {
                oplog.setGoodsClass(tmProappEnv.getGoodsClass());
                oplog.setChannelCode(tmProappEnv.getChannelCode());
                oplog.setMemberCode(tmProappEnv.getMemberCode());
                oplog.setMemberMcode(tmProappEnv.getMemberMcode());
                oplog.setMemberName(tmProappEnv.getMemberName());
                oplog.setMemberMname(tmProappEnv.getMemberMname());
            }
        }
        return oplog;
    }

    private static String setNoPasswd(Map<String, Object> requestParamtersMap, String keyName) {
        String[] s = keyName.split("\\|\\|");
        String reStr = keyName;
        if (null != s) {
            reStr = s[0];
            for (int i = 1; i < s.length; ++i) {
                String passwdStr = (String)BeanUtils.newForceGetProperty(requestParamtersMap, (String)s[i]);
                if (!StringUtils.isNotBlank((String)passwdStr)) continue;
                LogLogHandler.forceSetProperty1(requestParamtersMap, s[i], "******");
            }
        }
        return reStr;
    }

    public static void forceSetProperty1(Object object, String propertyName, Object newValue) {
        String[] s;
        if (null != object && !StringUtils.isBlank((String)propertyName) && null != (s = propertyName.split("\\."))) {
            for (int i = 0; i < s.length; ++i) {
                propertyName = s[i];
                if (i >= s.length - 1) continue;
                object = BeanUtils.forceGetProperty((Object)object, (String)s[i]);
            }
            try {
                if (object instanceof Map) {
                    ((Map)object).put(propertyName, newValue);
                } else {
                    BeanUtils.setObjValue((Object)object, (String)propertyName, (Object)newValue);
                }
            }
            catch (Exception var5) {
                var5.printStackTrace();
            }
        }
    }
}

