/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.interceptor.service;

import cn.com.qj.bff.common.bean.DisChannel;
import cn.com.qj.bff.core.auth.UserInfo;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.interceptor.bean.InterBean;
import cn.com.qj.bff.interceptor.bean.OsOAuthConfigDomain;
import cn.com.qj.bff.springmvc.bean.CmsTginfo;
import cn.com.qj.bff.springmvc.bean.TmProappEnv;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class BaseInterUtil {
    protected static final SupperLogUtil logger = new SupperLogUtil(BaseInterUtil.class);
    public static String TenantCode = "saas-tenantcode";
    public static String CookieToken = "saas-token";
    public static String CookieUser = "saas-user";
    public static String ProappCode = "saas-proappcode";
    public static String MemberCcode = "saas-memberCcode";
    public static String DelearchannelCode = "saas-delearchannelCode";
    public static String CookieKey = "saas-cookieKey";
    public static String TginfoCode = "saas-tginfocode";
    public static String ProappEnv = "saas-proappEnv";
    public static String ResparamTokenkey = "tokenkey";
    public static String SESSION_KEY = "laser_usersession";
    public static String UP_URL = "laser_upurl";
    public static String TginfoCodeDomain = "saas-tgdomain";
    public static String COMPANYCODE_KEY = "saas-companycode";
    public static String OrgUsercode_KEY = "saas-orgusercode";
    public static String Domain = "saas-domain";
    public static String QUA_BUY = "buy";
    public static String QUA_BUS = "bus";
    public static String QUA_SUPPLER = "suppler";
    public static String QUA_MERCHANT = "merchant";
    public static String QUA_PLAT = "plat";

    public static String getCacheComTenantCode(String key, String domain, String contextPath, String oauthEnvCode) {
        if (StringUtils.isBlankLoop((String[])new String[]{domain, contextPath, oauthEnvCode})) {
            return null;
        }
        String checkdomain = domain;
        String cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + contextPath + "-" + oauthEnvCode));
        if (StringUtils.isBlank((String)cacheTenantCode)) {
            cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-*-" + oauthEnvCode));
        }
        int len = checkdomain.split(".").length;
        if (StringUtils.isBlank((String)cacheTenantCode) && len > 1) {
            switch (len) {
                case 2: {
                    checkdomain = "*" + domain.substring(domain.indexOf("."));
                    cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + contextPath + "-" + oauthEnvCode));
                    if (StringUtils.isBlank((String)cacheTenantCode)) {
                        cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-*-" + oauthEnvCode));
                    }
                    if (!StringUtils.isNotBlank((String)cacheTenantCode)) break;
                    return cacheTenantCode;
                }
                case 3: {
                    checkdomain = "*" + domain.substring(domain.indexOf("."));
                    cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + contextPath + "-" + oauthEnvCode));
                    if (StringUtils.isBlank((String)cacheTenantCode)) {
                        cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-*-" + oauthEnvCode));
                    }
                    if (StringUtils.isNotBlank((String)cacheTenantCode)) {
                        return cacheTenantCode;
                    }
                    checkdomain = checkdomain.substring(2);
                    checkdomain = "*" + checkdomain.substring(checkdomain.indexOf("."));
                    cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + contextPath + "-" + oauthEnvCode));
                    if (!StringUtils.isBlank((String)cacheTenantCode)) break;
                    cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-*-" + oauthEnvCode));
                    break;
                }
                case 4: {
                    checkdomain = "*" + domain.substring(domain.indexOf("."));
                    cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + contextPath + "-" + oauthEnvCode));
                    if (StringUtils.isBlank((String)cacheTenantCode)) {
                        cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-*-" + oauthEnvCode));
                    }
                    if (StringUtils.isNotBlank((String)cacheTenantCode)) {
                        return cacheTenantCode;
                    }
                    checkdomain = checkdomain.substring(2);
                    checkdomain = "*" + checkdomain.substring(checkdomain.indexOf("."));
                    cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + contextPath + "-" + oauthEnvCode));
                    if (StringUtils.isBlank((String)cacheTenantCode)) {
                        cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-*-" + oauthEnvCode));
                    }
                    if (StringUtils.isNotBlank((String)cacheTenantCode)) {
                        return cacheTenantCode;
                    }
                    checkdomain = checkdomain.substring(2);
                    checkdomain = "*" + checkdomain.substring(checkdomain.indexOf("."));
                    cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-" + contextPath + "-" + oauthEnvCode));
                    if (!StringUtils.isBlank((String)cacheTenantCode)) break;
                    cacheTenantCode = SupDisUtil.getMap((String)key, (String)(checkdomain + "-*-" + oauthEnvCode));
                }
            }
        }
        if (StringUtils.isBlank((String)cacheTenantCode)) {
            cacheTenantCode = BaseInterUtil.getHost(key, checkdomain, contextPath, oauthEnvCode);
        }
        return cacheTenantCode;
    }

    public static String getHost(String key, String domain, String contextPath, String oauthEnvCode) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        if (StringUtils.isBlankLoop((String[])new String[]{domain, contextPath, oauthEnvCode})) {
            return null;
        }
        if (!"TmProoapp-domain".equals(key)) {
            return null;
        }
        String cacheTenantCode = SupDisUtil.getMap((String)key, (String)("host-" + contextPath + "-" + oauthEnvCode));
        if (StringUtils.isBlank((String)cacheTenantCode)) {
            cacheTenantCode = SupDisUtil.getMap((String)key, (String)("host-*-" + oauthEnvCode));
        }
        return cacheTenantCode;
    }

    public static void putTokenHeader(HttpServletRequest request, HttpServletResponse response, String token) {
        if (null == request || null == response) {
            return;
        }
        if (null == token) {
            token = "";
        }
        response.setHeader(CookieToken, token);
        HttpSession httpSession = request.getSession(true);
        if (null == httpSession) {
            return;
        }
        httpSession.setAttribute(CookieToken, (Object)token);
    }

    public static void putTenantHeader(HttpServletRequest request, HttpServletResponse response, String tenantCode) {
        if (null == request || null == response) {
            return;
        }
        if (null == tenantCode) {
            tenantCode = "";
        }
        response.setHeader(TenantCode, tenantCode);
        HttpSession httpSession = request.getSession(true);
        if (null == httpSession) {
            return;
        }
        httpSession.setAttribute(TenantCode, (Object)tenantCode);
    }

    public static void putCookieKeyHeader(HttpServletRequest request, HttpServletResponse response, String cookieKey) {
        if (null == request || null == response) {
            return;
        }
        if (null == cookieKey) {
            cookieKey = "";
        }
        response.setHeader(CookieKey, cookieKey);
        HttpSession httpSession = request.getSession(true);
        if (null == httpSession) {
            return;
        }
        httpSession.setAttribute(CookieKey, (Object)cookieKey);
    }

    public static void putProappHeader(HttpServletRequest request, HttpServletResponse response, String proappCode) {
        if (null == request || null == response) {
            return;
        }
        if (null == proappCode) {
            proappCode = "";
        }
        response.setHeader(ProappCode, proappCode);
        HttpSession httpSession = request.getSession(true);
        if (null == httpSession) {
            return;
        }
        httpSession.setAttribute(ProappCode, (Object)proappCode);
    }

    public static void putOrgUsercodeHeader(HttpServletRequest request, HttpServletResponse response, String orgUsercode) {
        if (null == request || null == response) {
            return;
        }
        if (null == orgUsercode) {
            orgUsercode = "";
        }
        response.setHeader(OrgUsercode_KEY, orgUsercode);
        HttpSession httpSession = request.getSession(true);
        if (null == httpSession) {
            return;
        }
        httpSession.setAttribute(OrgUsercode_KEY, (Object)orgUsercode);
        BaseInterUtil.putOrgCookie(request, response, BaseInterUtil.getProappCode(request), OrgUsercode_KEY, orgUsercode, BaseInterUtil.getTenantCode(request));
    }

    protected static String getDomain(HttpServletRequest request, Map<String, String> cookieMap) {
        if (null == request) {
            return null;
        }
        String domain = BaseInterUtil.getRelDoamin(request, cookieMap);
        if (StringUtils.isBlank((String)domain)) {
            domain = request.getServerName();
        }
        return domain;
    }

    public static void putOrgCookie(HttpServletRequest request, HttpServletResponse response, String proappCode, String key, String code, String tenantCode) {
        String tginfoCode;
        OsOAuthConfigDomain osOAuthConfigReDomain;
        if (null == key) {
            return;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        if (StringUtils.isBlank((String)proappCode)) {
            return;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        String host = BaseInterUtil.getDomain(request, null);
        if (null == host) {
            host = "";
        }
        if (null == (osOAuthConfigReDomain = BaseInterUtil.getOsOAuthConfigDomain(proappCode, null, tenantCode, host, tginfoCode = BaseInterUtil.getTginfoCode(request))) || StringUtils.isBlank((String)osOAuthConfigReDomain.getOauthConfigCookie())) {
            logger.error("BaseInterUtil.putOrgCookie.null", (Object)(host + "=" + (null == osOAuthConfigReDomain ? "null" : osOAuthConfigReDomain.getOauthConfigCookie())));
            return;
        }
        if (null == code) {
            code = "";
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        String cookieCode = "";
        if (null != cookieMap && cookieMap.isEmpty() && null == (cookieCode = cookieMap.get(key))) {
            cookieCode = "";
        }
        if (code.equals(cookieCode)) {
            return;
        }
        Cookie _cookie = new Cookie(key, code);
        _cookie.setDomain(osOAuthConfigReDomain.getOauthConfigCookie());
        if (StringUtils.isBlank((String)osOAuthConfigReDomain.getOauthConfigCookiep())) {
            osOAuthConfigReDomain.setOauthConfigCookiep("/");
        }
        _cookie.setPath(osOAuthConfigReDomain.getOauthConfigCookiep());
        _cookie.setHttpOnly(true);
        Integer expiry = osOAuthConfigReDomain.getOauthConfigTime();
        if (null == expiry) {
            expiry = 6000;
        }
        _cookie.setMaxAge(expiry.intValue());
        if (StringUtils.isBlank((String)code)) {
            _cookie.setMaxAge(0);
        }
        response.addCookie(_cookie);
    }

    public static void putTginfoHeader(HttpServletRequest request, HttpServletResponse response, String tginfoCode) {
        if (null == request || null == response) {
            return;
        }
        if (null == tginfoCode) {
            tginfoCode = "";
        }
        response.setHeader(TginfoCode, tginfoCode);
        HttpSession httpSession = request.getSession(true);
        if (null == httpSession) {
            return;
        }
        httpSession.setAttribute(TginfoCode, (Object)tginfoCode);
    }

    public static void putProappEnvHeader(HttpServletRequest request, HttpServletResponse response, String proappEnv) {
        if (null == request || null == response) {
            return;
        }
        if (null == proappEnv) {
            proappEnv = "";
        }
        response.setHeader(ProappEnv, proappEnv);
        HttpSession httpSession = request.getSession(true);
        if (null == httpSession) {
            return;
        }
        httpSession.setAttribute(ProappEnv, (Object)proappEnv);
    }

    public static Boolean isJsonRequest(HttpServletRequest request) {
        String url = request.getServletPath();
        return url.endsWith(".json") || StringUtils.isNotBlank((String)request.getHeader("X-Requested-With"));
    }

    public static String getUrl(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        String queryString = request.getQueryString();
        String url = !StringUtils.isEmpty((String)queryString) && queryString.indexOf("=") > 0 ? request.getServletPath() + "?" + queryString : request.getServletPath();
        return url;
    }

    public static String getRedurl(HttpServletRequest request, String url) {
        if (null == request || StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            String redurl = URLEncoder.encode(request.getContextPath() + url, "UTF-8");
            return redurl;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getTokenGroup(HttpServletRequest request, Map<String, String> cookieMap) {
        if (null == request || null == cookieMap) {
            return null;
        }
        String proappCode = BaseInterUtil.getProappCode(request, cookieMap);
        if (StringUtils.isBlank((String)proappCode)) {
            return null;
        }
        String tenantCode = BaseInterUtil.getTenantCode(request, cookieMap);
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String tginfoCode = BaseInterUtil.getTginfoCode(request, cookieMap);
        return BaseInterUtil.getTokenGroup(proappCode, tenantCode, tginfoCode);
    }

    public static String getTokenGroup(String proappCode, String tenantCode, String tginfoCode) {
        if (StringUtils.isBlank((String)proappCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String key = proappCode + "-" + tenantCode;
        String group = null;
        if (StringUtils.isNotBlank((String)tginfoCode)) {
            group = SupDisUtil.getMap((String)"osconfig_key", (String)(tginfoCode + "-" + key));
        }
        if (StringUtils.isBlank(group)) {
            group = SupDisUtil.getMap((String)"osconfig_key", (String)key);
        }
        if (StringUtils.isBlank(group)) {
            key = proappCode + "-" + "00000000";
            group = SupDisUtil.getMap((String)"osconfig_key", (String)key);
        }
        return group;
    }

    public static String getToKen(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        String token = request.getHeader(CookieToken);
        if (StringUtils.isBlank((String)token)) {
            Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
            String group = BaseInterUtil.getTokenGroup(request, cookieMap);
            token = BaseInterUtil.getToKen(request, group, cookieMap);
        }
        return token;
    }

    public static String getToKen(HttpServletRequest request, String group) {
        if (null == request) {
            return null;
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        return BaseInterUtil.getToKen(request, group, cookieMap);
    }

    public static void putTokenCookie(HttpServletRequest request, HttpServletResponse response, String token) {
        if (null == response) {
            return;
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        String proappCode = BaseInterUtil.getProappCode(request, cookieMap);
        if (StringUtils.isBlank((String)proappCode)) {
            return;
        }
        String tenantCode = BaseInterUtil.getTenantCode(request, cookieMap);
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        BaseInterUtil.putTokenCookie(request, response, proappCode, token, tenantCode);
    }

    public static UserInfo getUserInfo(HttpServletRequest request) {
        UserSession userSession = BaseInterUtil.getSession(request);
        if (null == userSession) {
            return null;
        }
        UserInfo userInfo = new UserInfo();
        userInfo.setTicketTokenid(userSession.getTicketTokenid());
        userInfo.setMerberCompname(userSession.getMerberCompname());
        userInfo.setUserCode(userSession.getUserCode());
        userInfo.setUserId(userSession.getUserId());
        userInfo.setUserImgurl(userSession.getUserImgurl());
        userInfo.setUserMsg(userSession.getUserMsg());
        userInfo.setUserName(userSession.getUserName());
        userInfo.setUserNickname(userSession.getUserNickname());
        userInfo.setUserRelname(userSession.getUserRelname());
        userInfo.setUserType(userSession.getUserType());
        userInfo.setCompanyCode(userSession.getCompanyCode());
        userInfo.setEmpType(userSession.getEmpType());
        userInfo.setEmpTypecode(userSession.getEmpTypecode());
        userInfo.setUserInfoCode(userSession.getUserPcode());
        userInfo.setUserPhone(userSession.getUserPhone());
        return userInfo;
    }

    public static void putTokenCookie(HttpServletRequest request, HttpServletResponse response, String proappCode, String token, String tenantCode) {
        String tginfoCode;
        if (null == response) {
            return;
        }
        if (StringUtils.isBlank((String)proappCode)) {
            return;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        String host = BaseInterUtil.getDomain(request, null);
        OsOAuthConfigDomain osOAuthConfigReDomain = BaseInterUtil.getOsOAuthConfigDomain(proappCode, null, tenantCode, host, tginfoCode = BaseInterUtil.getTginfoCode(request));
        if (null == osOAuthConfigReDomain || StringUtils.isBlank((String)osOAuthConfigReDomain.getOauthConfigCookie())) {
            logger.error("BaseInterUtil.putTokenCookie.null", (Object)(host + "=" + proappCode + "=" + (null == osOAuthConfigReDomain ? "null" : osOAuthConfigReDomain.getOauthConfigCookie())));
            return;
        }
        if (null == token) {
            token = "";
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        String tokenKey = CookieToken + "-" + osOAuthConfigReDomain.getAppmanageGroup();
        String cookieToken = "";
        BaseInterUtil.putCookieKeyHeader(request, response, tokenKey);
        if (null != cookieMap && cookieMap.isEmpty() && null == (cookieToken = cookieMap.get(tokenKey))) {
            cookieToken = "";
        }
        if (StringUtils.isNotBlank((String)token) && token.equals(cookieToken)) {
            return;
        }
        Cookie _cookie = new Cookie(CookieToken + "-" + osOAuthConfigReDomain.getAppmanageGroup(), token);
        _cookie.setDomain(osOAuthConfigReDomain.getOauthConfigCookie());
        if (StringUtils.isBlank((String)osOAuthConfigReDomain.getOauthConfigCookiep())) {
            osOAuthConfigReDomain.setOauthConfigCookiep("/");
        }
        _cookie.setPath(osOAuthConfigReDomain.getOauthConfigCookiep());
        _cookie.setHttpOnly(true);
        Integer expiry = osOAuthConfigReDomain.getOauthConfigTime();
        if (null == expiry) {
            expiry = 6000;
        }
        _cookie.setMaxAge(expiry.intValue());
        if (StringUtils.isBlank((String)token)) {
            _cookie.setMaxAge(0);
        }
        response.addCookie(_cookie);
        String json = "";
        if (StringUtils.isBlank((String)token)) {
            json = "";
        } else {
            json = JsonUtil.buildNormalBinder().toJson((Object)BaseInterUtil.getUserInfo(request));
            try {
                json = URLEncoder.encode(json, "utf-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Cookie _cookieuser = new Cookie(CookieUser + "-" + osOAuthConfigReDomain.getAppmanageGroup(), json);
        _cookieuser.setDomain(osOAuthConfigReDomain.getOauthConfigCookie());
        if (StringUtils.isBlank((String)osOAuthConfigReDomain.getOauthConfigCookiep())) {
            osOAuthConfigReDomain.setOauthConfigCookiep("/");
        }
        _cookieuser.setPath(osOAuthConfigReDomain.getOauthConfigCookiep());
        _cookieuser.setHttpOnly(true);
        Integer expiryuser = osOAuthConfigReDomain.getOauthConfigTime();
        if (null == expiryuser) {
            expiry = 6000;
        }
        _cookieuser.setMaxAge(expiryuser.intValue());
        if (StringUtils.isBlank((String)token)) {
            _cookieuser.setMaxAge(0);
        }
        response.addCookie(_cookieuser);
    }

    public static void putTokenCookie(HttpServletRequest request, HttpServletResponse response, InterBean interBean) {
        if (null == interBean || StringUtils.isBlank((String)interBean.getProappCode()) || StringUtils.isBlank((String)interBean.getTenantCode())) {
            return;
        }
        BaseInterUtil.putTokenCookie(request, response, interBean.getProappCode(), interBean.getToken(), interBean.getTenantCode());
    }

    public static OsOAuthConfigDomain getOsOAuthConfigDomain(String proappCode, String oauthEnvCode, String tenantCode, String host, String tginfoCode) {
        if (StringUtils.isBlank((String)proappCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String cacheKey = proappCode;
        OsOAuthConfigDomain cacheOsOAuthConfigReDomain = null;
        if (StringUtils.isNotBlank((String)tginfoCode)) {
            cacheKey = tginfoCode + "-" + proappCode;
            cacheOsOAuthConfigReDomain = (OsOAuthConfigDomain)SupDisUtil.getObjectJson((String)("OsOAuthConfig_Key_new-" + cacheKey + "-" + tenantCode), OsOAuthConfigDomain.class);
        }
        if (null == cacheOsOAuthConfigReDomain) {
            cacheOsOAuthConfigReDomain = (OsOAuthConfigDomain)SupDisUtil.getObjectJson((String)("OsOAuthConfig_Key_new-" + proappCode + "-" + tenantCode), OsOAuthConfigDomain.class);
        }
        if (null == cacheOsOAuthConfigReDomain && null == (cacheOsOAuthConfigReDomain = (OsOAuthConfigDomain)SupDisUtil.getObjectJson((String)("OsOAuthConfig_Key_new-" + cacheKey + "-" + "00000000"), OsOAuthConfigDomain.class))) {
            cacheOsOAuthConfigReDomain = (OsOAuthConfigDomain)SupDisUtil.getObjectJson((String)("OsOAuthConfig_Key_new-" + proappCode + "-" + "00000000"), OsOAuthConfigDomain.class);
        }
        if (null == cacheOsOAuthConfigReDomain) {
            return null;
        }
        OsOAuthConfigDomain osOAuthConfigReDomain = new OsOAuthConfigDomain();
        try {
            BeanUtils.copyAllPropertys((Object)osOAuthConfigReDomain, cacheOsOAuthConfigReDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isNotBlank((String)osOAuthConfigReDomain.getOauthConfigUrl())) {
            osOAuthConfigReDomain.setOauthConfigUrl(osOAuthConfigReDomain.getOauthConfigUrl().replace("${proappCode}", proappCode));
            if (StringUtils.isBlank((String)oauthEnvCode)) {
                oauthEnvCode = "";
            }
            osOAuthConfigReDomain.setOauthConfigUrl(osOAuthConfigReDomain.getOauthConfigUrl().replace("${oauthEnvCode}", oauthEnvCode));
            osOAuthConfigReDomain.setOauthConfigUrl(osOAuthConfigReDomain.getOauthConfigUrl().replace("${tenantCode}", tenantCode));
        }
        if (StringUtils.isNotBlank((String)osOAuthConfigReDomain.getOauthConfigIndexurl())) {
            osOAuthConfigReDomain.setOauthConfigIndexurl(osOAuthConfigReDomain.getOauthConfigIndexurl().replace("${proappCode}", proappCode));
            if (StringUtils.isBlank((String)oauthEnvCode)) {
                oauthEnvCode = "";
            }
            osOAuthConfigReDomain.setOauthConfigIndexurl(osOAuthConfigReDomain.getOauthConfigIndexurl().replace("${oauthEnvCode}", oauthEnvCode));
            osOAuthConfigReDomain.setOauthConfigIndexurl(osOAuthConfigReDomain.getOauthConfigIndexurl().replace("${tenantCode}", tenantCode));
        }
        if (StringUtils.isNotBlank((String)osOAuthConfigReDomain.getOauthConfigNoresurl())) {
            osOAuthConfigReDomain.setOauthConfigNoresurl(osOAuthConfigReDomain.getOauthConfigNoresurl().replace("${proappCode}", proappCode));
            if (StringUtils.isBlank((String)oauthEnvCode)) {
                oauthEnvCode = "";
            }
            osOAuthConfigReDomain.setOauthConfigNoresurl(osOAuthConfigReDomain.getOauthConfigNoresurl().replace("${oauthEnvCode}", oauthEnvCode));
            osOAuthConfigReDomain.setOauthConfigNoresurl(osOAuthConfigReDomain.getOauthConfigNoresurl().replace("${tenantCode}", tenantCode));
        }
        if (StringUtils.isNotBlank((String)osOAuthConfigReDomain.getOauthConfigCookie())) {
            String domain;
            if (osOAuthConfigReDomain.getOauthConfigCookie().indexOf("{host}") >= 0 || osOAuthConfigReDomain.getOauthConfigCookie().indexOf("{.host}") >= 0) {
                if (null == host) {
                    host = "";
                }
                domain = host;
                if (osOAuthConfigReDomain.getOauthConfigCookie().indexOf("..{") >= 0 && host.length() > 2) {
                    if (domain.indexOf(".") > 0 && (domain = domain.substring(domain.indexOf(".") + 1)).indexOf(".") > 0) {
                        domain = domain.substring(domain.indexOf(".") + 1);
                    }
                } else if (osOAuthConfigReDomain.getOauthConfigCookie().indexOf(".{") >= 0 && host.length() > 2 && domain.indexOf(".") > 0) {
                    domain = domain.substring(domain.indexOf(".") + 1);
                }
                if (osOAuthConfigReDomain.getOauthConfigCookie().indexOf("{host}") >= 0) {
                    osOAuthConfigReDomain.setOauthConfigCookie(osOAuthConfigReDomain.getOauthConfigCookie().replace("{host}", domain));
                }
                if (osOAuthConfigReDomain.getOauthConfigCookie().indexOf("{.host}") >= 0) {
                    osOAuthConfigReDomain.setOauthConfigCookie(osOAuthConfigReDomain.getOauthConfigCookie().replace("{.host}", "." + domain));
                }
            }
            if (osOAuthConfigReDomain.getOauthConfigCookie().indexOf("{domain}") >= 0) {
                domain = SupDisUtil.getMap((String)"tmtenant-code_dmain", (String)(tenantCode + "-domain"));
                if (StringUtils.isBlank((String)domain)) {
                    domain = host;
                }
                osOAuthConfigReDomain.setOauthConfigCookie(osOAuthConfigReDomain.getOauthConfigCookie().replace("{domain}", domain));
            }
            if (osOAuthConfigReDomain.getOauthConfigCookie().indexOf("{domain0}") >= 0) {
                domain = SupDisUtil.getMap((String)"tmtenant-code_dmain", (String)(tenantCode + "-domain0"));
                if (StringUtils.isBlank((String)domain)) {
                    domain = host;
                }
                osOAuthConfigReDomain.setOauthConfigCookie(osOAuthConfigReDomain.getOauthConfigCookie().replace("{domain0}", domain));
            }
            if (osOAuthConfigReDomain.getOauthConfigCookie().indexOf("{domain1}") >= 0) {
                domain = SupDisUtil.getMap((String)"tmtenant-code_dmain", (String)(tenantCode + "-domain1"));
                if (StringUtils.isBlank((String)domain)) {
                    domain = host;
                }
                osOAuthConfigReDomain.setOauthConfigCookie(osOAuthConfigReDomain.getOauthConfigCookie().replace("{domain1}", domain));
            }
            if (osOAuthConfigReDomain.getOauthConfigCookie().indexOf("{domain2}") >= 0) {
                domain = SupDisUtil.getMap((String)"tmtenant-code_dmain", (String)(tenantCode + "-domain2"));
                if (StringUtils.isBlank((String)domain)) {
                    domain = host;
                }
                osOAuthConfigReDomain.setOauthConfigCookie(osOAuthConfigReDomain.getOauthConfigCookie().replace("{domain2}", domain));
            }
        }
        return osOAuthConfigReDomain;
    }

    public static String getToKen(HttpServletRequest request, String group, Map<String, String> cookieMap) {
        String token = request.getHeader(CookieToken);
        if (StringUtils.isBlank((String)token) && null != cookieMap) {
            token = cookieMap.get(CookieToken + "-" + group);
        }
        if (StringUtils.isBlank((String)token) && null != request) {
            token = request.getParameter(ResparamTokenkey);
        }
        return token;
    }

    public static void putSession(HttpServletRequest request, HttpServletResponse response, UserSession userSession) {
        if (null == request || null == request.getSession()) {
            return;
        }
        request.getSession().setAttribute(SESSION_KEY, (Object)userSession);
        if (null != userSession) {
            BaseInterUtil.putTenantHeader(request, response, userSession.getTenantCode());
        }
    }

    public static UserSession getSession(HttpServletRequest request) {
        if (null == request || null == request.getSession()) {
            return null;
        }
        return (UserSession)request.getSession().getAttribute(SESSION_KEY);
    }

    public static String getSessionCompany(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies;
        if (null == request || null == request.getSession()) {
            return null;
        }
        String companyCode = request.getHeader(COMPANYCODE_KEY);
        if (StringUtils.isBlank((String)companyCode)) {
            companyCode = (String)request.getSession().getAttribute(COMPANYCODE_KEY);
        }
        if (StringUtils.isBlank((String)companyCode) && null != (cookies = request.getCookies())) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(COMPANYCODE_KEY)) continue;
                companyCode = cookie.getValue();
                return companyCode;
            }
        }
        return companyCode;
    }

    public static void setSessionCompany(HttpServletRequest request, HttpServletResponse response, String companyCode) {
        if (null == request || null == request.getSession()) {
            return;
        }
        if (null == companyCode) {
            companyCode = "";
        }
        response.setHeader(COMPANYCODE_KEY, companyCode);
        request.getSession().setAttribute(COMPANYCODE_KEY, (Object)companyCode);
        BaseInterUtil.putOrgCookie(request, response, BaseInterUtil.getProappCode(request), COMPANYCODE_KEY, companyCode, BaseInterUtil.getTenantCode(request));
    }

    public static String getRequestservice(HttpServletRequest request, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = "00000000";
        }
        String schemeStr = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-scheme-scheme"));
        String ddserverName = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-serverName-serverName"));
        String serverName = request.getServerName();
        if (StringUtils.isNotBlank((String)ddserverName) && serverName.contains(ddserverName)) {
            schemeStr = "https";
        }
        schemeStr = StringUtils.isBlank((String)schemeStr) ? "http" : schemeStr;
        String str = schemeStr + "://" + request.getServerName();
        if (request.getServerPort() != 80) {
            str = str + ":" + request.getServerPort();
        }
        return str;
    }

    public static String getMemberCcode(HttpServletRequest request, Map<String, String> cookieMap) {
        if (null == request) {
            return null;
        }
        String memberCcode = request.getHeader(MemberCcode);
        if (StringUtils.isBlank((String)memberCcode) && null != cookieMap) {
            memberCcode = cookieMap.get(MemberCcode);
        }
        if (StringUtils.isBlank((String)memberCcode)) {
            HttpSession httpSession = request.getSession();
            if (null == httpSession) {
                return null;
            }
            memberCcode = (String)httpSession.getAttribute(MemberCcode);
        }
        return memberCcode;
    }

    public static String getDelearchannelCode(HttpServletRequest request, Map<String, String> cookieMap) {
        if (null == request) {
            return null;
        }
        String memberCcode = request.getHeader(DelearchannelCode);
        if (StringUtils.isBlank((String)memberCcode) && null != cookieMap) {
            memberCcode = cookieMap.get(DelearchannelCode);
        }
        if (StringUtils.isBlank((String)memberCcode)) {
            HttpSession httpSession = request.getSession();
            if (null == httpSession) {
                return null;
            }
            memberCcode = (String)httpSession.getAttribute(DelearchannelCode);
        }
        return memberCcode;
    }

    public static String getTenantCode(HttpServletRequest request, Map<String, String> cookieMap) {
        if (null == request) {
            return null;
        }
        String tenantCode = request.getHeader(TenantCode);
        if (StringUtils.isBlank((String)tenantCode) && null != cookieMap) {
            tenantCode = cookieMap.get(TenantCode);
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            HttpSession httpSession = request.getSession();
            if (null == httpSession) {
                return null;
            }
            tenantCode = (String)httpSession.getAttribute(TenantCode);
        }
        return tenantCode;
    }

    public static String getMemberCcode(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        return BaseInterUtil.getMemberCcode(request, cookieMap);
    }

    public static String getDelearchannelCode(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        return BaseInterUtil.getDelearchannelCode(request, cookieMap);
    }

    public static String getTenantCode(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        return BaseInterUtil.getTenantCode(request, cookieMap);
    }

    public static String getProappCode(HttpServletRequest request, Map<String, String> cookieMap) {
        if (null == request) {
            return null;
        }
        String proappCode = request.getHeader(ProappCode);
        if (StringUtils.isBlank((String)proappCode) && null != cookieMap) {
            proappCode = cookieMap.get(ProappCode);
        }
        if (StringUtils.isBlank((String)proappCode)) {
            HttpSession httpSession = request.getSession();
            if (null == httpSession) {
                return null;
            }
            proappCode = (String)httpSession.getAttribute(ProappCode);
        }
        return proappCode;
    }

    public static String getOrgUsercode(HttpServletRequest request, Map<String, String> cookieMap) {
        if (null == request) {
            return null;
        }
        String orgUsercode = request.getHeader(OrgUsercode_KEY);
        if (StringUtils.isBlank((String)orgUsercode) && null != cookieMap) {
            orgUsercode = cookieMap.get(OrgUsercode_KEY);
        }
        if (StringUtils.isBlank((String)orgUsercode)) {
            HttpSession httpSession = request.getSession();
            if (null == httpSession) {
                return null;
            }
            orgUsercode = (String)httpSession.getAttribute(OrgUsercode_KEY);
        }
        return orgUsercode;
    }

    public static String getRelDoamin(HttpServletRequest request, Map<String, String> cookieMap) {
        if (null == request) {
            return null;
        }
        String domain = request.getHeader(Domain);
        if (StringUtils.isBlank((String)domain) && null != cookieMap) {
            domain = cookieMap.get(Domain);
        }
        if (StringUtils.isBlank((String)domain)) {
            HttpSession httpSession = request.getSession();
            if (null == httpSession) {
                return null;
            }
            domain = (String)httpSession.getAttribute(Domain);
        }
        if (StringUtils.isBlank((String)domain)) {
            domain = request.getServerName();
        }
        return domain;
    }

    public static String getTginfoCode(HttpServletRequest request, Map<String, String> cookieMap) {
        if (null == request) {
            return null;
        }
        String tginfoCode = request.getHeader(TginfoCode);
        if (StringUtils.isBlank((String)tginfoCode) && null != cookieMap) {
            tginfoCode = cookieMap.get(TginfoCode);
        }
        if (StringUtils.isBlank((String)tginfoCode)) {
            HttpSession httpSession = request.getSession();
            if (null == httpSession) {
                return null;
            }
            tginfoCode = (String)httpSession.getAttribute(TginfoCode);
        }
        return tginfoCode;
    }

    public static String getTginfoCodeDomain(HttpServletRequest request, Map<String, String> cookieMap) {
        if (null == request) {
            return null;
        }
        String tginfoCode = request.getHeader(TginfoCodeDomain);
        if (StringUtils.isNotBlank((String)tginfoCode)) {
            return tginfoCode;
        }
        if (StringUtils.isBlank((String)tginfoCode) && null != cookieMap) {
            tginfoCode = cookieMap.get(TginfoCodeDomain);
        }
        if (StringUtils.isNotBlank((String)tginfoCode)) {
            return tginfoCode;
        }
        HttpSession httpSession = request.getSession();
        if (null == httpSession) {
            return null;
        }
        tginfoCode = (String)httpSession.getAttribute(TginfoCodeDomain);
        return tginfoCode;
    }

    public static String getProappCode(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        return BaseInterUtil.getProappCode(request, cookieMap);
    }

    public static String getTginfoCode(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        return BaseInterUtil.getTginfoCode(request, cookieMap);
    }

    public static String getTginfoCodeDomain(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        return BaseInterUtil.getTginfoCodeDomain(request, cookieMap);
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (StringUtils.isNotBlank((String)ip) && ip.indexOf(",") > 0) {
            ip = ip.split(",")[0].trim();
        }
        return ip;
    }

    public static Map<String, String> getSaaSCookies(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        Cookie[] cookies = request.getCookies();
        if (null == cookies || cookies.length == 0) {
            return null;
        }
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        for (Cookie cookie : cookies) {
            if (!cookie.getName().contains("saas-")) continue;
            map.put(cookie.getName(), cookie.getValue());
        }
        return map;
    }

    public static String getGoodsClassByMem(String channelCode, HttpServletRequest request) {
        if (StringUtils.isBlank((String)channelCode)) {
            return null;
        }
        String tenantCode = BaseInterUtil.getTenantCode(request);
        DisChannel disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class);
        if (null == disChannel) {
            return null;
        }
        return disChannel.getGoodsClass();
    }

    public static DisChannel getChannelModel(String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        DisChannel disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class);
        if (null == disChannel) {
            return null;
        }
        return disChannel;
    }

    public static String getNowChannel(HttpServletRequest request) {
        String[] valueStr;
        String channelCode = "";
        String delearchannelCode = BaseInterUtil.getDelearchannelCode(request);
        if (StringUtils.isBlank((String)delearchannelCode) && null != (valueStr = request.getParameterValues("channelCode")) && valueStr.length > 0) {
            delearchannelCode = valueStr[0];
        }
        if (StringUtils.isNotBlank((String)delearchannelCode) && delearchannelCode.equals("delearchannelCode")) {
            channelCode = BaseInterUtil.getChannelByMemCc(BaseInterUtil.getMerchantCode(request), request);
        }
        if (StringUtils.isBlank((String)channelCode) && StringUtils.isBlank((String)(channelCode = BaseInterUtil.getTginfoChannel(request)))) {
            channelCode = BaseInterUtil.getProappChannel(request);
        }
        return channelCode;
    }

    public static String getChannelByMemCc(String memberCcode, HttpServletRequest request) {
        if (StringUtils.isBlank((String)memberCcode)) {
            return null;
        }
        String tenantCode = BaseInterUtil.getTenantCode(request);
        DisChannel disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-memberCcode", (String)(memberCcode + "-2-" + tenantCode), DisChannel.class);
        if (null == disChannel) {
            return null;
        }
        return disChannel.getChannelCode();
    }

    public static String getProappChannel(HttpServletRequest request) {
        String proappCode = BaseInterUtil.getProappCode(request);
        if (StringUtils.isBlank((String)proappCode)) {
            return null;
        }
        String tenantCode = BaseInterUtil.getTenantCode(request);
        TmProappEnv tmProappEnv = (TmProappEnv)SupDisUtil.getMapJson((String)"TmProappEnv-tenant-ProappCode", (String)(tenantCode + "-" + proappCode), TmProappEnv.class);
        if (null == tmProappEnv) {
            return null;
        }
        return tmProappEnv.getChannelCode();
    }

    public static String getTginfoChannel(HttpServletRequest request) {
        String tginfoCode = BaseInterUtil.getTginfoCode(request);
        if (StringUtils.isBlank((String)tginfoCode)) {
            return null;
        }
        String tenantCode = BaseInterUtil.getTenantCode(request);
        CmsTginfo tginfo = (CmsTginfo)SupDisUtil.getMapJson((String)"cms_tginfo_cache", (String)(tginfoCode + "-" + tenantCode), CmsTginfo.class);
        if (null == tginfo) {
            return null;
        }
        return tginfo.getChannelCode();
    }

    public static String getMerchantCode(HttpServletRequest request) {
        UserSession userSession = BaseInterUtil.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        return userSession.getUserPcode();
    }

    public static UserSession getUserSession(HttpServletRequest request) {
        return BaseInterUtil.getSession(request);
    }

    public static void setMapRequest(Map<String, Object> resultMap, HttpServletRequest request) {
        String memberMCode;
        String userPCode;
        String userParentCode;
        String goodsClass;
        String dischannelCode;
        String channelCodeVaule;
        String vaule;
        String memberCcodeVaule = (String)resultMap.get("memberCcode");
        if (StringUtils.isNotBlank((String)memberCcodeVaule) && "memberCcode".equals(memberCcodeVaule)) {
            vaule = BaseInterUtil.getMemberCcode(request);
            if (StringUtils.isNotBlank((String)vaule)) {
                resultMap.put(memberCcodeVaule, vaule);
            } else {
                resultMap.remove("memberCcode");
            }
        }
        if (StringUtils.isNotBlank((String)(channelCodeVaule = (String)resultMap.get("channelCode"))) && "channelCode".equals(channelCodeVaule)) {
            vaule = BaseInterUtil.getChannelCode(request);
            if (StringUtils.isNotBlank((String)vaule)) {
                resultMap.put("channelCode", vaule);
            } else {
                resultMap.remove("channelCode");
            }
        }
        if (StringUtils.isNotBlank((String)channelCodeVaule) && "delearchannelCode".equals(channelCodeVaule)) {
            HttpSession httpSession = request.getSession();
            if (null != httpSession) {
                httpSession.setAttribute(DelearchannelCode, (Object)"delearchannelCode");
            }
            if (StringUtils.isNotBlank((String)(vaule = BaseInterUtil.getChannelByMemCc(BaseInterUtil.getMerchantCode(request), request)))) {
                resultMap.put("channelCode", vaule);
            } else {
                resultMap.remove("channelCode");
            }
        }
        if (StringUtils.isNotBlank((String)(dischannelCode = (String)resultMap.get("dischannelCode")))) {
            resultMap.put("channelCode", dischannelCode);
        }
        String proappCodeVaule = (String)resultMap.get("proappCode");
        if (StringUtils.isNotBlank((String)channelCodeVaule) && "proappCode".equals(proappCodeVaule)) {
            vaule = BaseInterUtil.getProappCode(request);
            if (StringUtils.isNotBlank((String)vaule)) {
                resultMap.put("proappCode", vaule);
            } else {
                resultMap.remove("proappCode");
            }
        }
        String tginfoCodeVaule = (String)resultMap.get("tginfoCode");
        if (StringUtils.isNotBlank((String)channelCodeVaule) && "tginfoCode".equals(tginfoCodeVaule)) {
            vaule = BaseInterUtil.getTginfoCode(request);
            if (StringUtils.isNotBlank((String)vaule)) {
                resultMap.put("tginfoCode", vaule);
            } else {
                resultMap.remove("tginfoCode");
            }
        }
        String tginfoMemberVaule = (String)resultMap.get("tginfoMember");
        if (StringUtils.isNotBlank((String)channelCodeVaule) && "tginfoMember".equals(tginfoMemberVaule)) {
            vaule = BaseInterUtil.getTginfoMember(request);
            if (StringUtils.isNotBlank((String)vaule)) {
                resultMap.put("tginfoMember", vaule);
            } else {
                resultMap.remove("tginfoMember");
            }
        }
        String teananMemberCodeVaule = (String)resultMap.get("teananMemberCode");
        if (StringUtils.isNotBlank((String)channelCodeVaule) && "teananMemberCode".equals(teananMemberCodeVaule)) {
            vaule = BaseInterUtil.getTeananMemberCode(request);
            if (StringUtils.isNotBlank((String)vaule)) {
                resultMap.put("memberCode", vaule);
            }
            resultMap.remove("teananMemberCode");
        }
        if (StringUtils.isNotBlank((String)(goodsClass = (String)resultMap.get("goodsClass"))) && "goodsClass".equals(goodsClass)) {
            vaule = BaseInterUtil.getGoodsClass(request);
            if (StringUtils.isNotBlank((String)vaule)) {
                resultMap.put("goodsClass", vaule);
            } else {
                resultMap.remove("goodsClass");
            }
        }
        if (StringUtils.isNotBlank((String)(userParentCode = (String)resultMap.get("parentCode"))) && "parentCode".equals(userParentCode)) {
            vaule = BaseInterUtil.getUserSession(request).getUserinfoParentCode();
            if (StringUtils.isNotBlank((String)vaule)) {
                resultMap.put("memberCode", vaule);
            } else {
                resultMap.remove("parentCode");
            }
        }
        if (StringUtils.isNotBlank((String)(userPCode = (String)resultMap.get("userPCode"))) && "userPCode".equals(userPCode)) {
            vaule = BaseInterUtil.getUserSession(request).getUserPcode();
            if (StringUtils.isNotBlank((String)vaule)) {
                resultMap.put("memberCode", vaule);
            } else {
                resultMap.remove("memberCode");
            }
        }
        if (StringUtils.isNotBlank((String)(memberMCode = (String)resultMap.get("memberMCode"))) && "memberMCode".equals(userPCode)) {
            if (StringUtils.isNotBlank((String)memberMCode)) {
                resultMap.put("memberMcode", memberMCode);
            } else {
                resultMap.remove("memberMcode");
            }
        }
    }

    public static String getChannelCode(HttpServletRequest request) {
        UserSession userSession = BaseInterUtil.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        String memberCode = userSession.getUserPcode();
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = userSession.getUserinfoParentCode();
        }
        if (StringUtils.isBlank((String)memberCode)) {
            return null;
        }
        String tenantCode = BaseInterUtil.getTenantCode(request);
        DisChannel disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-memberCode", (String)(memberCode + "-0-" + tenantCode), DisChannel.class);
        if (null == disChannel) {
            disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-memberCode", (String)(memberCode + "-2-" + tenantCode), DisChannel.class);
        }
        if (null == disChannel) {
            return null;
        }
        return disChannel.getChannelCode();
    }

    public static String getChannelCodeByType(HttpServletRequest request, String type) {
        DisChannel disChannel = BaseInterUtil.getChannelByType(request, type);
        if (null == disChannel) {
            return null;
        }
        return disChannel.getChannelCode();
    }

    public static String getGoodsClassByType(HttpServletRequest request, String type) {
        DisChannel disChannel = BaseInterUtil.getChannelByType(request, type);
        if (null == disChannel) {
            return null;
        }
        return disChannel.getGoodsClass();
    }

    private static DisChannel getChannelByType(HttpServletRequest request, String type) {
        UserSession userSession = BaseInterUtil.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        String memberCode = "";
        if (QUA_BUS.equals(type) || QUA_PLAT.equals(type) || QUA_SUPPLER.equals(type)) {
            memberCode = userSession.getUserPcode();
        } else if (QUA_MERCHANT.equals(type) || QUA_BUY.equals(type)) {
            memberCode = userSession.getUserinfoParentCode();
        }
        if (StringUtils.isBlank((String)memberCode)) {
            return null;
        }
        String tenantCode = BaseInterUtil.getTenantCode(request);
        DisChannel disChannel = null;
        if (!QUA_SUPPLER.equals(type)) {
            disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-memberCode", (String)(memberCode + "-0-" + tenantCode), DisChannel.class);
            if (null == disChannel) {
                disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-memberCode", (String)(memberCode + "-2-" + tenantCode), DisChannel.class);
            }
        } else {
            disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-memberCode", (String)(memberCode + "-1-" + tenantCode), DisChannel.class);
        }
        if (null == disChannel) {
            return null;
        }
        return disChannel;
    }

    public static String getTginfoMember(HttpServletRequest request) {
        String tginfoCode = BaseInterUtil.getTginfoCode(request);
        if (StringUtils.isBlank((String)tginfoCode)) {
            return null;
        }
        String tenantCode = BaseInterUtil.getTenantCode(request);
        String json = SupDisUtil.getMap((String)"CmsTginfo-mem", (String)(tginfoCode + "-" + tenantCode));
        return json;
    }

    public static String getTeananMemberCode(HttpServletRequest request) {
        String tenantCode = BaseInterUtil.getTenantCode(request);
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode);
        return memberCode;
    }

    public static String getGoodsClass(HttpServletRequest request) {
        UserSession userSession = BaseInterUtil.getUserSession(request);
        if (userSession == null) {
            return null;
        }
        String memberCode = userSession.getUserPcode();
        if (StringUtils.isBlank((String)memberCode)) {
            memberCode = userSession.getUserinfoParentCode();
        }
        if (StringUtils.isBlank((String)memberCode)) {
            return null;
        }
        String tenantCode = BaseInterUtil.getTenantCode(request);
        DisChannel disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-memberCode", (String)(memberCode + "-0-" + tenantCode), DisChannel.class);
        if (null == disChannel) {
            disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-memberCode", (String)(memberCode + "-2-" + tenantCode), DisChannel.class);
        }
        if (null == disChannel) {
            return null;
        }
        return disChannel.getGoodsClass();
    }
}

