/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.order;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.oc.OcContractGoodsDomain;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.domain.oc.OcPackageReDomain;
import cn.com.qj.bff.service.oc.OcContractEngineService;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/contractEngine"}, name="\u8ba2\u5355\u5f15\u64ce\u670d\u52a1")
public class ContractEngineCon
extends SpringmvcController {
    private static String CODE = "oc.contractEngine.con";
    @Autowired
    private OcContractEngineService ocContractEngineService;
    @Autowired
    private OcContractService ocContractService;

    @Override
    protected String getContext() {
        return "contractEngine";
    }

    @RequestMapping(value={"sendContractNext.json"}, name="\u8ba2\u5355\u4e0b\u4e00\u6b65")
    @ResponseBody
    public HtmlJsonReBean sendContractNext(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".sendContractNext", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map<String, Object> map = this.getQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        map.put("userCode", userSession.getUserCode());
        map.put("userName", userSession.getUserName());
        map.remove("tenantCode");
        map.remove("contractBillcode");
        return this.ocContractEngineService.sendContractNext(contractBillcode, tenantCode, map);
    }

    @RequestMapping(value={"sendContractNextBuiMat.json"}, name="\u8ba2\u5355\u4e0b\u4e00\u6b65(\u5168\u6e20\u9053\u5efa\u6750)")
    @ResponseBody
    public HtmlJsonReBean sendContractNextBuiMat(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".sendContractNextBuiMat", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map<String, Object> map = this.getQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        map.put("userCode", userSession.getUserCode());
        map.put("userName", userSession.getUserName());
        map.remove("tenantCode");
        map.remove("contractBillcode");
        return this.ocContractEngineService.sendContractNext(contractBillcode, tenantCode, map);
    }

    @RequestMapping(value={"sendContractNextBySg.json"}, name="\u8ba2\u5355\u4e0b\u4e00\u6b65(\u4e00\u952e\u53d1\u8d27)")
    @ResponseBody
    public HtmlJsonReBean sendContractNextBySg(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".sendContractNextBySg", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Map<String, Object> getContractMap = this.getQueryMapParam("contractBillcode,tenantCode", contractBillcode, this.getTenantCode(request));
        OcContractReDomain contractByCode = this.ocContractService.getContractByCode(getContractMap);
        if (null == contractByCode || 2 != contractByCode.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u4e0d\u5b58\u5728\u6216\u8ba2\u5355\u5df2\u53d1\u8d27");
        }
        String tenantCode = this.getTenantCode(request);
        Map<String, Object> map = this.getQueryMapParams(request);
        if (map.get("updateGoods") != null && map.get("goodsJson") != null) {
            JSONArray jsonArray = JSONArray.json2array((String)map.get("goodsJson").toString());
            OcContractGoodsDomain ocContractGoodsDomain = null;
            for (JSONObject jsonObject : jsonArray) {
                ocContractGoodsDomain = new OcContractGoodsDomain();
                ocContractGoodsDomain.setContractGoodsId(jsonObject.getInteger("code"));
                ocContractGoodsDomain.setGoodsProperty3(jsonObject.getString("batchNo"));
                this.ocContractService.updateContractGoods(ocContractGoodsDomain);
                this.logger.info(CODE + ".sendContractNextBySg.ocContractGoodsDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocContractGoodsDomain));
            }
        }
        this.logger.info(CODE + ".sendContractNextBySg.map", (Object)JsonUtil.buildNormalBinder().toJson(map));
        UserSession userSession = this.getUserSession(request);
        map.put("userCode", userSession.getUserCode());
        map.put("userName", userSession.getUserName());
        map.remove("tenantCode");
        map.remove("contractBillcode");
        return this.ocContractEngineService.sendContractNext(contractBillcode, tenantCode, map);
    }

    @RequestMapping(value={"sendContractNextBatchBySg.json"}, name="\u8ba2\u5355\u4e0b\u4e00\u6b65\u6279\u91cf(\u4e00\u952e\u53d1\u8d27)")
    @ResponseBody
    public HtmlJsonReBean sendContractNextBatchBySg(HttpServletRequest request, String contractBillcodeStr) {
        if (StringUtils.isEmpty((String)contractBillcodeStr)) {
            this.logger.error(CODE + ".sendContractNextBatchBySg", (Object)"contractBillcodeStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        List paramMaps = JsonUtil.buildNonDefaultBinder().getJsonToListByMap(contractBillcodeStr, Object.class);
        if (ListUtil.isEmpty((Collection)paramMaps)) {
            this.logger.error(CODE + ".paramMaps", (Object)("paramMaps is null" + contractBillcodeStr));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramMaps");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Map> list = new ArrayList<Map>();
        UserSession userSession = this.getUserSession(request);
        String contractBillcode = "";
        for (Map paramMap : paramMaps) {
            contractBillcode = String.valueOf(paramMap.get("contractBillcode"));
            if (StringUtils.isEmpty((String)contractBillcode)) {
                list.add(paramMap);
                continue;
            }
            map.put("contractBillcode", contractBillcode);
            map.put("tenantCode", tenantCode);
            SupQueryResult<OcPackageReDomain> ocPackageReDomainSupQueryResult = this.ocContractService.queryPackagePage(map);
            if (ListUtil.isEmpty((Collection)ocPackageReDomainSupQueryResult.getList())) {
                list.add(paramMap);
                continue;
            }
            paramMap.put("packageCode", ((OcPackageReDomain)ocPackageReDomainSupQueryResult.getList().get(0)).getPackageCode());
            paramMap.put("packageId", ((OcPackageReDomain)ocPackageReDomainSupQueryResult.getList().get(0)).getPackageId());
            paramMap.put("userCode", userSession.getUserCode());
            paramMap.put("userName", userSession.getUserName());
            paramMap.remove("tenantCode");
            paramMap.remove("contractBillcode");
            this.ocContractEngineService.sendContractNext(contractBillcode, tenantCode, paramMap);
        }
        return new HtmlJsonReBean(list);
    }

    @RequestMapping(value={"sendBatchContractNext.json"}, name="\u6279\u91cf\u8ba2\u5355\u4e0b\u4e00\u6b65")
    @ResponseBody
    public HtmlJsonReBean sendBatchContractNext(HttpServletRequest request, String contractBillcodes, String currentDataState) {
        if (StringUtils.isEmpty((String)contractBillcodes)) {
            this.logger.error(CODE + ".sendBatchContractNext", (Object)"contractBillcodes is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map<String, Object> map = this.getQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        map.put("userCode", userSession.getUserCode());
        map.put("userName", userSession.getUserName());
        map.remove("tenantCode");
        map.remove("contractBillcode");
        for (String contractBillcode : this.getcodeStrList(contractBillcodes)) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("contractBillcode", contractBillcode);
            param.put("tenantCode", tenantCode);
            OcContractReDomain contractByCode = this.ocContractService.getContractByCode(param);
            if (null == contractByCode) {
                this.logger.error(CODE + ".sendBatchContractNext.contractByCode", (Object)contractByCode);
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u53f7\u6709\u8bef");
            }
            if (Integer.valueOf(currentDataState) == contractByCode.getDataState()) continue;
            this.logger.error(CODE + ".sendBatchContractNext.dataState", (Object)contractByCode.getDataState());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u6709\u8bef");
        }
        for (String contractBillcode : this.getcodeStrList(contractBillcodes)) {
            this.ocContractService.sendContractNext(contractBillcode, tenantCode, map);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"sendDataStateBatchContractNext.json"}, name="\u6279\u91cf\u66f4\u6539\u8ba2\u5355\u8282\u70b9\u72b6\u6001\u4e0b\u4e00\u6b65")
    @ResponseBody
    public HtmlJsonReBean sendDataStateBatchContractNext(HttpServletRequest request, String contractBillcodeStr, String currentDataState) {
        if (StringUtils.isEmpty((String)currentDataState)) {
            this.logger.error(CODE + ".sendDataStateBatchContractNext", (Object)"contractBillcodes is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> map = new HashMap<String, Object>();
        UserSession userSession = this.getUserSession(request);
        map.put("userCode", userSession.getUserCode());
        map.put("userName", userSession.getUserName());
        map.put("tenantCode", tenantCode);
        map.remove("tenantCode");
        map.remove("contractBillcode");
        param.put("tenantCode", tenantCode);
        param.put("dataState", currentDataState);
        SupQueryResult<OcContractReDomain> ocContractReDomainSupQueryResult = this.ocContractService.queryContractPage(param);
        if (ListUtil.isEmpty((Collection)ocContractReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + "sendDataStateBatchContractNext", (Object)currentDataState);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u6709\u8bef");
        }
        for (OcContractReDomain ocContractReDomain : ocContractReDomainSupQueryResult.getList()) {
            this.ocContractService.sendContractNext(ocContractReDomain.getContractBillcode(), tenantCode, map);
        }
        return new HtmlJsonReBean();
    }

    protected List<String> getcodeStrList(String codesStr) {
        String[] codeStr = codesStr.split(",");
        ArrayList<String> codeList = new ArrayList<String>();
        for (String code : codeStr) {
            codeList.add(code);
        }
        return codeList;
    }

    @RequestMapping(value={"sendDataStateBatch.json"}, name="\u6279\u91cf\u66f4\u6539\u8ba2\u5355\u8282\u70b9\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean sendDataStateBatch(HttpServletRequest request, String contractBillcodeStr, String dataState, String oldDataState, String type) {
        if (StringUtils.isEmpty((String)oldDataState) || StringUtils.isEmpty((String)dataState)) {
            this.logger.error(CODE + ".sendDataStateBatch", (Object)"contractBillcodes is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        UserSession userSession = this.getUserSession(request);
        map.put("userCode", userSession.getUserCode());
        map.put("userName", userSession.getUserName());
        map.remove("tenantCode");
        map.remove("contractBillcode");
        param.put("tenantCode", tenantCode);
        param.put("dataState", oldDataState);
        param.put("contractBillcode", contractBillcodeStr);
        SupQueryResult<OcContractReDomain> ocContractReDomainSupQueryResult = this.ocContractService.queryContractPage(param);
        if (ListUtil.isEmpty((Collection)ocContractReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + "sendDataStateBatch", (Object)("oldDataState" + oldDataState + "dataState" + dataState));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u6709\u8bef");
        }
        for (OcContractReDomain ocContractReDomain : ocContractReDomainSupQueryResult.getList()) {
            this.ocContractService.updateContractStateExtend(ocContractReDomain.getContractId(), Integer.valueOf(dataState), ocContractReDomain.getDataState());
            if (!StringUtils.isNotBlank((String)type)) continue;
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("contractBillcode", ocContractReDomain.getContractBillcode());
            map1.put("goodsClass", type);
            list.add(map1);
            this.ocContractService.updateContractBatch(list);
        }
        return new HtmlJsonReBean();
    }
}

