/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.basicsetting;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.core.util.HtmlUtil;
import cn.com.qj.bff.domain.bs.BsAreaDomain;
import cn.com.qj.bff.domain.bs.BsAreaReDomain;
import cn.com.qj.bff.domain.bs.BsProvinceReDomain;
import cn.com.qj.bff.domain.um.UmGroupListReDomain;
import cn.com.qj.bff.service.bs.BsAreaService;
import cn.com.qj.bff.service.bs.BsProvinceService;
import cn.com.qj.bff.service.um.UmGroupService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/bs/area"}, name="\u5730\u533a\u670d\u52a1")
public class AreaCon
extends SpringmvcController {
    private static String CODE = "bs.area.con";
    @Autowired
    private BsAreaService bsAreaService;
    @Autowired
    private BsProvinceService bsProvinceService;
    @Autowired
    private UmGroupService umGroupService;

    @Override
    protected String getContext() {
        return "area";
    }

    @RequestMapping(value={"saveArea.json"}, name="\u589e\u52a0\u5730\u533a\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveArea(HttpServletRequest request, BsAreaDomain bsAreaDomain) {
        if (null == bsAreaDomain) {
            this.logger.error(CODE + ".saveArea", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        bsAreaDomain.setTenantCode(this.getTenantCode(request));
        return this.bsAreaService.saveArea(bsAreaDomain);
    }

    @RequestMapping(value={"getArea.json"}, name="\u83b7\u53d6\u5730\u533a\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public BsAreaReDomain getArea(String areaId) {
        if (StringUtils.isBlank((String)areaId)) {
            this.logger.error(CODE + ".getArea", (Object)"param is null");
            return null;
        }
        return this.bsAreaService.getArea(Integer.valueOf(areaId));
    }

    @RequestMapping(value={"updateArea.json"}, name="\u66f4\u65b0\u5730\u533a\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateArea(HttpServletRequest request, BsAreaDomain bsAreaDomain) {
        if (null == bsAreaDomain) {
            this.logger.error(CODE + ".updateArea", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        bsAreaDomain.setTenantCode(this.getTenantCode(request));
        return this.bsAreaService.updateArea(bsAreaDomain);
    }

    @RequestMapping(value={"deleteArea.json"}, name="\u5220\u9664\u5730\u533a\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteArea(String areaId) {
        if (StringUtils.isBlank((String)areaId)) {
            this.logger.error(CODE + ".deleteArea", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.bsAreaService.deleteArea(Integer.valueOf(areaId));
    }

    @RequestMapping(value={"queryAreaPage.json"}, name="\u67e5\u8be2\u5730\u533a\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<BsAreaReDomain> queryAreaPage(HttpServletRequest request) {
        SupQueryResult<BsAreaReDomain> qest;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
        }
        if (null == param.get("areaParentCode")) {
            param.put("areaParentCode", "-1");
        }
        if (null == (qest = this.bsAreaService.queryAreaPage(param)) || ListUtil.isEmpty((Collection)qest.getList())) {
            param.put("tenantCode", "00000000");
            qest = this.bsAreaService.queryAreaPage(param);
        }
        if (null == qest || ListUtil.isEmpty((Collection)qest.getList())) {
            param.remove("tenantCode");
            qest = this.bsAreaService.queryAreaPage(param);
        }
        if (null == qest || ListUtil.isEmpty((Collection)qest.getList())) {
            param.remove("tenantCode");
            param.remove("areaParentCode");
            qest = this.bsAreaService.queryAreaPage(param);
        }
        this.logger.error("param==============================>", (Object)JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("qest==============================>", (Object)JsonUtil.buildNormalBinder().toJson(qest));
        return qest;
    }

    @RequestMapping(value={"queryNewAreaPage.json"}, name="\u67e5\u8be2\u5730\u533a\u670d\u52a1\u5206\u9875\u5217\u8868(\u4e8c\u6b21\u5f00\u53d1)")
    @ResponseBody
    public SupQueryResult<BsAreaReDomain> queryNewAreaPage(HttpServletRequest request) {
        SupQueryResult<BsAreaReDomain> qest;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
        }
        if (null == param.get("areaParentCode")) {
            param.put("areaParentCode", "-1");
        }
        if (null == (qest = this.bsAreaService.queryNewAreaPage(param)) || ListUtil.isEmpty((Collection)qest.getList())) {
            param.put("tenantCode", "00000000");
            qest = this.bsAreaService.queryAreaPage(param);
        }
        return qest;
    }

    @RequestMapping(value={"updateAreaState.json"}, name="\u66f4\u65b0\u5730\u533a\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateAreaState(String areaId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)areaId)) {
            this.logger.error(CODE + ".updateAreaState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.bsAreaService.updateAreaState(Integer.valueOf(areaId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryAreaPageByTenantCode.json"}, name="\u67e5\u8be2\u5730\u533a\u670d\u52a1\u5206\u9875\u5217\u8868\uff08\u8fc7\u6ee4\u5f53\u524d\u79df\u6237\uff09")
    @ResponseBody
    public SupQueryResult<BsAreaReDomain> queryAreaPageByTenantCode(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        param.put("tenantCode", this.getTenantCode(request));
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.bsAreaService.queryAreaPage(param);
    }

    @RequestMapping(value={"updateBatchAreaByTenantCodeAndChannelId.json"}, name="\u6279\u91cf\u589e\u52a0\u5730\u533a\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateBatchAreaByTenantCodeAndChannelId(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapMemberParam(request);
        BsAreaReDomain bsAreaReDomain = new BsAreaReDomain();
        String[] areaIds = param.get("areaIds").toString().split(",");
        bsAreaReDomain.setAppmanageIcode("11");
        bsAreaReDomain.setAreaRemark(param.get("channelCcode").toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("areaRemark", param.get("channelCcode").toString());
        map.put("appmanageIcode", 0);
        this.bsAreaService.updateByAreaRemark(map);
        for (String areaId : areaIds) {
            if (StringUtils.isBlank((String)areaId)) {
                this.logger.error(CODE + ".updateAreaState", (Object)"param is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
            }
            bsAreaReDomain.setAreaId(Integer.valueOf(areaId));
            bsAreaReDomain.setAppmanageIcode("11");
            this.bsAreaService.updateArea(bsAreaReDomain);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"saveAreaByTenantCode.json"}, name="\u589e\u52a0\u5730\u533a\u670d\u52a1(\u5f53\u524d\u79df\u6237)")
    @ResponseBody
    public HtmlJsonReBean saveArea(HttpServletRequest request, String areaId) {
        if (StringUtils.isBlank((String)areaId)) {
            this.logger.error(CODE + ".saveArea", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        BsAreaReDomain area = this.bsAreaService.getArea(Integer.valueOf(areaId));
        if (null == area) {
            return new HtmlJsonReBean((Object)"\u6ca1\u6709\u6570\u636e");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", this.getTenantCode(request));
        param.put("provinceCode", area.getProvinceCode());
        BsProvinceReDomain bsProvinceReDomain = this.bsProvinceService.getProvinceByCode(param);
        this.logger.error(CODE + ".saveAreaByTenantCode.bsProvinceReDomainSupQueryResult", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)bsProvinceReDomain));
        if (null == bsProvinceReDomain) {
            param.remove("tenantCode");
            BsProvinceReDomain newBsProvinceReDomain = this.bsProvinceService.getProvinceByCode(param);
            if (null == newBsProvinceReDomain) {
                return new HtmlJsonReBean((Object)"\u6ca1\u6709\u6570\u636e1");
            }
            newBsProvinceReDomain.setTenantCode(this.getTenantCode(request));
            newBsProvinceReDomain.setProvinceId(null);
            this.bsProvinceService.saveProvince(newBsProvinceReDomain);
        }
        area.setAreaId(null);
        area.setTenantCode(this.getTenantCode(request));
        return this.bsAreaService.saveArea(area);
    }

    @RequestMapping(value={"saveBatchAreaByTenantCode.json"}, name="\u6279\u91cf\u589e\u52a0\u5730\u533a\u670d\u52a1(\u5f53\u524d\u79df\u6237)")
    @ResponseBody
    public HtmlJsonReBean saveBatchAreaByTenantCode(HttpServletRequest request, String areaIds) {
        if (StringUtils.isBlank((String)areaIds)) {
            this.logger.error(CODE + ".saveBatchAreaByTenantCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List bsAreaReDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(areaIds, BsAreaDomain.class);
        for (BsAreaDomain bsAreaReDomain : bsAreaReDomainList) {
            BsAreaReDomain area = this.bsAreaService.getArea((int)bsAreaReDomain.getAreaId());
            if (null == area) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6ca1\u6709\u6570\u636e");
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tenantCode", this.getTenantCode(request));
            param.put("provinceCode", area.getProvinceCode());
            param.put("perganaCode", "1");
            SupQueryResult<BsProvinceReDomain> bsProvinceReDomain = this.bsProvinceService.queryProvincePage(param);
            this.logger.error(CODE + ".saveAreaByTenantCode.bsProvinceReDomainSupQueryResult", (Object)JsonUtil.buildNonDefaultBinder().toJson(bsProvinceReDomain));
            if (null == bsProvinceReDomain || ListUtil.isEmpty((Collection)bsProvinceReDomain.getList())) {
                param.put("perganaCode", "5");
                SupQueryResult<BsProvinceReDomain> newBsProvinceReDoma = this.bsProvinceService.queryProvincePage(param);
                if (null == newBsProvinceReDoma || ListUtil.isEmpty((Collection)newBsProvinceReDoma.getList())) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6ca1\u6709\u6570\u636e1");
                }
                BsProvinceReDomain newBsProvinceReDomain = (BsProvinceReDomain)newBsProvinceReDoma.getList().get(0);
                newBsProvinceReDomain.setProvinceId(null);
                newBsProvinceReDomain.setPerganaCode("1");
                this.bsProvinceService.saveProvince(newBsProvinceReDomain);
            }
            HashMap<String, Object> par = new HashMap<String, Object>();
            par.put("tenantCode", this.getTenantCode(request));
            par.put("areaCode", area.getAreaCode());
            par.put("appmanageIcode", "1");
            SupQueryResult<BsAreaReDomain> bsAreaReDomain1 = this.bsAreaService.queryAreaPage(par);
            if (null == bsAreaReDomain1 || ListUtil.isEmpty((Collection)bsAreaReDomain1.getList())) {
                area.setAreaId(null);
                area.setTenantCode(this.getTenantCode(request));
                area.setAppmanageIcode("1");
                this.bsAreaService.saveArea(area);
                continue;
            }
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u5730\u533a\u5df2\u6dfb\u52a0");
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"deleteBatchArea.json"}, name="\u5220\u9664\u5730\u533a\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteBatchArea(String areaIds) {
        if (StringUtils.isBlank((String)areaIds)) {
            this.logger.error(CODE + ".deleteBatchArea", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List bsAreaReDomainList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(areaIds, BsAreaDomain.class);
        if (ListUtil.isEmpty((Collection)bsAreaReDomainList)) {
            this.logger.error(CODE + ".deleteBatchArea", (Object)"bsAreaReDomainList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ArrayList<Integer> provinceReDomainList = new ArrayList<Integer>();
        for (BsAreaDomain bsAreaDomain : bsAreaReDomainList) {
            BsAreaReDomain bsAreaReDomain = this.bsAreaService.getArea(bsAreaDomain.getAreaId());
            if (null == bsAreaReDomain) {
                this.logger.error(CODE + ".deleteBatchArea", (Object)"bsAreaReDomain is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
            }
            HashMap<String, Object> par = new HashMap<String, Object>();
            par.put("tenantCode", bsAreaReDomain.getTenantCode());
            par.put("provinceCode", bsAreaReDomain.getProvinceCode());
            par.put("perganaCode", "1");
            SupQueryResult<BsProvinceReDomain> supQueryResult = this.bsProvinceService.queryProvincePage(par);
            if (null == supQueryResult || ListUtil.isEmpty((Collection)supQueryResult.getList())) {
                this.logger.error(CODE + ".deleteBatchArea", (Object)"supQueryResult is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
            }
            provinceReDomainList.add(((BsProvinceReDomain)supQueryResult.getList().get(0)).getProvinceId());
            HtmlJsonReBean htmlJsonReBean = this.bsAreaService.deleteArea((int)bsAreaDomain.getAreaId());
            if (null == htmlJsonReBean || "error".equals(htmlJsonReBean.getSysRecode())) {
                this.logger.error(CODE + "htmlJsonReBean" + JsonUtil.buildNormalBinder().toJson((Object)htmlJsonReBean));
                continue;
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tenantCode", bsAreaReDomain.getTenantCode());
            param.put("appmanageIcode", "2");
            param.put("areaCode", bsAreaReDomain.getAreaCode());
            List<BsAreaReDomain> areaList = this.bsAreaService.queryAreaList(param);
            if (!ListUtil.isNotEmpty(areaList)) continue;
            this.bsAreaService.deleteArea((int)areaList.get(0).getAreaId());
            param.remove("appmanageIcode");
            param.remove("areaCode");
            param.put("memberCode", bsAreaReDomain.getAreaCode());
            SupQueryResult<UmGroupListReDomain> supQueryResult1 = this.umGroupService.queryGroupListPage(param);
            if (null == supQueryResult1 || !ListUtil.isNotEmpty((Collection)supQueryResult1.getList())) continue;
            for (UmGroupListReDomain umGroupList : supQueryResult1.getList()) {
                this.umGroupService.deleteGroupList(umGroupList.getGroupListId());
            }
        }
        HashSet hashSet = new HashSet(provinceReDomainList);
        for (Integer set : hashSet) {
            BsProvinceReDomain bsProvinceReDomain = this.bsProvinceService.getProvince(set);
            if (null == bsProvinceReDomain) {
                this.logger.error(CODE + "bsProvinceReDomain IS NULL");
                continue;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("tenantCode", bsProvinceReDomain.getTenantCode());
            hashMap.put("provinceCode", bsProvinceReDomain.getProvinceCode());
            hashMap.put("appmanageIcode", "1");
            SupQueryResult<BsAreaReDomain> list = this.bsAreaService.queryAreaPage(hashMap);
            if (null != list && !ListUtil.isEmpty((Collection)list.getList())) continue;
            this.bsProvinceService.deleteProvince(set);
            hashMap.put("appmanageIcode", "2");
            SupQueryResult<BsAreaReDomain> bsAreaReDomainSupQueryResult = this.bsAreaService.queryAreaPage(hashMap);
            if (null != bsAreaReDomainSupQueryResult && !ListUtil.isEmpty((Collection)bsAreaReDomainSupQueryResult.getList())) continue;
            hashMap.remove("appmanageIcode");
            hashMap.put("perganaCode", "2");
            SupQueryResult<BsProvinceReDomain> supQueryResult = this.bsProvinceService.queryProvincePage(hashMap);
            if (null == supQueryResult || !ListUtil.isNotEmpty((Collection)supQueryResult.getList())) continue;
            this.bsProvinceService.deleteProvince(((BsProvinceReDomain)supQueryResult.getList().get(0)).getProvinceId());
        }
        return new HtmlJsonReBean();
    }

    public static void main(String[] args) {
    }
}

