/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.promotion;

import cn.com.qj.bff.controller.promotion.ExcelExportTemplate;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.pm.PmPromotionConditionDomain;
import cn.com.qj.bff.domain.pm.PmPromotionDisDomain;
import cn.com.qj.bff.domain.pm.PmPromotionDiscountDomain;
import cn.com.qj.bff.domain.pm.PmPromotionDiscountlistDomain;
import cn.com.qj.bff.domain.pm.PmPromotionDomain;
import cn.com.qj.bff.domain.pm.PmPromotionRangelistDomain;
import cn.com.qj.bff.domain.pm.PmPromotionReDomain;
import cn.com.qj.bff.domain.pm.PmPromotionSupDomain;
import cn.com.qj.bff.domain.pm.PmUserCouponReDomain;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.domain.tm.TmProappEnvReDomain;
import cn.com.qj.bff.service.pm.PmPromotionService;
import cn.com.qj.bff.service.pm.PmUserCouponService;
import cn.com.qj.bff.service.pm.PmUserCouponsendService;
import cn.com.qj.bff.service.rs.RsGoodsClassService;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.service.tm.TmProappService;
import cn.com.qj.bff.springmvc.SpringmvnNewController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class PromotionSupCon
extends SpringmvnNewController {
    private static String CODE = "pm.promotionsup.con";
    @Autowired
    private PmPromotionService pmPromotionService;
    @Autowired
    private RsGoodsClassService rsGoodsClassService;
    @Autowired
    private RsSkuService rsSkuService;
    @Autowired
    private TmProappService tmProappService;
    @Autowired
    private PmUserCouponService pmUserCouponService;
    @Autowired
    private PmUserCouponsendService pmUserCouponsendService;
    protected static String TYPE_PLAT = "plat";
    protected static String TYPE_BUS = "bus";
    protected static String TYPE_USER = "user";
    protected static String TYPE_STORE = "store";

    @Override
    protected String getContext() {
        return "promotionsup";
    }

    protected PmPromotionReDomain getPromotionPro(HttpServletRequest request, Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    protected PmPromotionReDomain getPromotionByCodePro(HttpServletRequest request, String promotionCode) {
        if (StringUtils.isBlank((String)promotionCode)) {
            this.logger.error(CODE + ".getPromotionByCode", (Object)"param is null");
            return null;
        }
        return this.pmPromotionService.getPromotionByCode(this.getTenantCode(request), promotionCode);
    }

    protected HtmlJsonReBean updatePromotionStatePro(String promotionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionService.updatePromotionState(Integer.valueOf(promotionId), dataState, oldDataState, null);
    }

    protected HtmlJsonReBean deletePromotionPlus(String promotionId) {
        String[] pidStrArray;
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".deletePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String pidStr : pidStrArray = promotionId.split(",")) {
            PmPromotionReDomain promotion = this.pmPromotionService.getPromotion(Integer.parseInt(pidStr));
            if (null == promotion || promotion.getDataState() != 0) {
                this.logger.error(CODE + ".updatePromotion", (Object)" datastate canot update");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8425\u9500\u6d3b\u52a8\u5df2\u7ecf\u5f00\u59cb\u6216\u7ed3\u675f\u4e86\uff0c\u4e0d\u80fd\u4fee\u6539");
            }
            this.pmPromotionService.deletePromotion(Integer.parseInt(pidStr));
        }
        return new HtmlJsonReBean();
    }

    protected HtmlJsonReBean promotionStateStart(String promotionId) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionService.updatePromotionState(Integer.valueOf(promotionId), 1, 3, null);
    }

    protected HtmlJsonReBean promotionStateStop(String promotionId) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionService.updatePromotionState(Integer.valueOf(promotionId), 3, 1, null);
    }

    protected SupQueryResult<PmPromotionReDomain> promotionPageAll(HttpServletRequest request, String pbCode, String promotionType, String promotionPcode) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)pbCode)) {
                param.put("pbCode", pbCode);
            }
            if (StringUtils.isNotBlank((String)promotionType)) {
                param.put("promotionType", promotionType);
            }
            if (StringUtils.isNotBlank((String)promotionPcode)) {
                param.put("promotionPcode", promotionPcode);
            }
        }
        return this.pmPromotionService.queryPromotionPage(param);
    }

    protected SupQueryResult<PmPromotionReDomain> promotionPage(HttpServletRequest request, String pbCode, String promotionType, String promotionPcode, Integer promotionOrgin, String type, Map<String, Object> map) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        Map<String, Object> param = this.assemMapMemberParam(request);
        String saveMemberCode = "";
        if (StringUtils.isBlank((String)type)) {
            saveMemberCode = this.checkMemquaPlat(request) ? this.getTeananMemberCode(request) : userSession.getUserPcode();
        } else if (TYPE_PLAT.equals(type)) {
            saveMemberCode = this.getTeananMemberCode(request);
        } else if (TYPE_BUS.equals(type)) {
            saveMemberCode = StringUtils.isNotBlank((String)userSession.getUserinfoParentCode()) ? userSession.getUserinfoParentCode() : userSession.getUserPcode();
        } else if (TYPE_USER.equals(type)) {
            saveMemberCode = userSession.getUserPcode();
        } else if (TYPE_STORE.equals(type)) {
            param.put("memberCcode", userSession.getUserPcode());
        }
        if (null != param) {
            param.put("order", true);
            if (StringUtils.isNotBlank((String)pbCode)) {
                param.put("pbCode", pbCode);
            }
            if (StringUtils.isNotBlank((String)promotionType)) {
                param.put("promotionType", promotionType);
            }
            if (StringUtils.isNotBlank((String)promotionPcode)) {
                param.put("promotionPcode", promotionPcode);
            }
            if (null != promotionOrgin) {
                param.put("promotionOrgin", promotionOrgin);
            }
        }
        if (TYPE_STORE.equals(type)) {
            param.remove("memberCode");
        }
        if (MapUtil.isNotEmpty(map)) {
            param.putAll(map);
        }
        String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
        String excelTemplate = null == param || null == param.get("excelTemplate") ? "" : (String)param.get("excelTemplate");
        Boolean flag = Boolean.valueOf(exportFlag);
        if (flag.booleanValue()) {
            String userCode = null == userSession ? "" : userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            if ("promotionDiscount".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertPromotionDiscountExcelParam());
            } else if ("promotionPreference".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertPromotionPreferenceExcelParam());
            } else if ("promotionEnvelope".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertPromotionEnvelopeExcelParam());
            }
            infoMap.put("userCode", userCode);
            infoMap.put("fileName", null == param.get("fileName") ? "\u8425\u9500\u5bfc\u51fa" : (String)param.get("fileName"));
            this.logger.error(CODE + ".promotionPage.1111", (Object)(param + "=:=" + infoMap));
            try {
                this.exportComExcel(request, param, infoMap, "pm.PmPromotion.queryPromotionPage", excelTemplate);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".promotionPage.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        SupQueryResult<PmPromotionReDomain> pmPromotionReDomainSupQueryResult = this.pmPromotionService.queryPromotionPage(param);
        String gmvFlag = null == param || null == param.get("gmvFlag") ? "false" : (String)param.get("gmvFlag");
        Boolean gmvFlagB = Boolean.valueOf(gmvFlag);
        if (gmvFlagB.booleanValue() && null != pmPromotionReDomainSupQueryResult && ListUtil.isNotEmpty((Collection)pmPromotionReDomainSupQueryResult.getList())) {
            for (PmPromotionReDomain pmPromotionReDomain : pmPromotionReDomainSupQueryResult.getList()) {
                String promotionCode = pmPromotionReDomain.getPromotionCode();
                String tenantCode = pmPromotionReDomain.getTenantCode();
                HashMap<String, Object> parMap = new HashMap<String, Object>();
                parMap.put("promotionCode", promotionCode);
                parMap.put("tenantCode", tenantCode);
                parMap.put("dataState", 1);
                parMap.put("endRow", 1);
                parMap.put("page", 1);
                parMap.put("startRow", 0);
                parMap.put("rows", 1);
                parMap.put("pageSize", 1);
                pmPromotionReDomain.setWoTotal(this.pmUserCouponsendService.queryuserCouponsendPage(parMap).getTotal());
                parMap.put("dataState", 0);
                pmPromotionReDomain.setNotWoTotal(this.pmUserCouponsendService.queryuserCouponsendPage(parMap).getTotal());
            }
        }
        return pmPromotionReDomainSupQueryResult;
    }

    protected SupQueryResult<PmPromotionReDomain> getpromotionPageForStore(HttpServletRequest request, String pbCode, String promotionType, String promotionPcode, Integer promotionOrgin, String type) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)pbCode)) {
                param.put("pbCode", pbCode);
            }
            if (StringUtils.isNotBlank((String)promotionType)) {
                param.put("promotionType", promotionType);
            }
            if (StringUtils.isNotBlank((String)promotionPcode)) {
                param.put("promotionPcode", promotionPcode);
            }
            if (null != promotionOrgin) {
                param.put("promotionOrgin", promotionOrgin);
            }
        }
        return this.pmPromotionService.queryPromotionPage(param);
    }

    protected PmPromotionReDomain getPromotionplus(Integer promotionId) {
        if (StringUtils.isBlank((Integer)promotionId)) {
            this.logger.error(CODE + ".getPromotion", (Object)"param is null");
            return null;
        }
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionService.getPromotion(promotionId);
        return pmPromotionReDomain;
    }

    protected HtmlJsonReBean updatePromotionPlus(HttpServletRequest request, String paramStr, String type) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updatePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updatePromotion", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        if (null == promotionDomain.getPromotionId()) {
            this.logger.error(CODE + ".updatePromotion.PromotionId", (Object)"promotionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "");
        }
        if (!this.checkPromotionDomain(promotionDomain).booleanValue()) {
            this.logger.error(CODE + ".updatePromotionPlus.checkPromotionDomain.error");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        promotionDomain.setTenantCode(this.getTenantCode(request));
        String saveMemberCode = "";
        String saveMemberName = "";
        if (StringUtils.isBlank((String)type)) {
            if (this.checkMemquaPlat(request)) {
                saveMemberCode = this.getTeananMemberCode(request);
                saveMemberName = "\u5e73\u53f0";
            } else {
                saveMemberCode = userSession.getUserPcode();
                saveMemberName = userSession.getMerberCompname();
            }
        } else if (TYPE_PLAT.equals(type)) {
            saveMemberCode = this.getTeananMemberCode(request);
            saveMemberName = "\u5e73\u53f0";
        } else if (TYPE_BUS.equals(type)) {
            if (StringUtils.isNotBlank((String)userSession.getUserinfoParentCode())) {
                saveMemberCode = userSession.getUserinfoParentCode();
                saveMemberName = userSession.getUserinfoParentName();
            } else {
                saveMemberCode = userSession.getUserPcode();
                saveMemberName = userSession.getMerberCompname();
            }
            promotionDomain.setChannelCode(this.getChannelByMem(userSession.getUserPcode(), request));
            promotionDomain.setChannelName(this.getChannelName(promotionDomain.getChannelName(), request));
        } else if (TYPE_USER.equals(type)) {
            saveMemberCode = userSession.getUserPcode();
            saveMemberName = userSession.getMerberCompname();
        }
        promotionDomain.setMemberCode(saveMemberCode);
        promotionDomain.setMemberName(saveMemberName);
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionService.getPromotion(promotionDomain.getPromotionId());
        if (null == pmPromotionReDomain || pmPromotionReDomain.getDataState() != 0 || pmPromotionReDomain.getDataState() != 4) {
            this.logger.error(CODE + ".updatePromotion", (Object)" datastate canot update");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8425\u9500\u6d3b\u52a8\u5df2\u7ecf\u5f00\u59cb\u6216\u7ed3\u675f\u4e86\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        if (null == pmPromotionReDomain && 4 == pmPromotionReDomain.getDataState()) {
            this.pmPromotionService.updatePromotionState(pmPromotionReDomain.getPromotionId(), 0, 4, null);
        }
        return this.pmPromotionService.updatePromotion(promotionDomain);
    }

    protected HtmlJsonReBean savePromotionPlus(HttpServletRequest request, String paramStr, String channelCode, String memberCode, String pbCode, String type) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".savePromotionPlus", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".savePromotionPlus", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        if (null == promotionDomain) {
            this.logger.error(CODE + ".savePromotionPlus", (Object)"promotionDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        promotionDomain.setPbCode(pbCode);
        String saveMemberCode = "";
        String saveMemberName = "";
        if (StringUtils.isBlank((String)type)) {
            if (this.checkMemquaPlat(request)) {
                saveMemberCode = this.getTeananMemberCode(request);
                saveMemberName = "\u5e73\u53f0";
            } else {
                saveMemberCode = userSession.getUserPcode();
                saveMemberName = userSession.getMerberCompname();
            }
        } else if (TYPE_PLAT.equals(type)) {
            saveMemberCode = this.getTeananMemberCode(request);
            saveMemberName = "\u5e73\u53f0";
        } else if (TYPE_BUS.equals(type)) {
            if (StringUtils.isNotBlank((String)userSession.getUserinfoParentCode())) {
                saveMemberCode = userSession.getUserinfoParentCode();
                saveMemberName = userSession.getUserinfoParentName();
            } else {
                saveMemberCode = userSession.getUserPcode();
                saveMemberName = userSession.getMerberCompname();
            }
            promotionDomain.setChannelCode(this.getChannelByMem(userSession.getUserPcode(), request));
            promotionDomain.setChannelName(this.getChannelName(promotionDomain.getChannelName(), request));
        } else if (TYPE_USER.equals(type)) {
            saveMemberCode = userSession.getUserPcode();
            saveMemberName = userSession.getMerberCompname();
            promotionDomain.setChannelCode(this.getChannelByMem(userSession.getUserPcode(), request));
            promotionDomain.setChannelName(this.getChannelName(promotionDomain.getChannelCode(), request));
            promotionDomain.setGoodsClass(this.getGoodsClassByMem(promotionDomain.getChannelCode(), request));
        }
        if (StringUtils.isNotBlank((String)channelCode)) {
            List<PmPromotionDisDomain> pmPromotionDisLists = promotionDomain.getPmPromotionDisList();
            if (null == pmPromotionDisLists) {
                pmPromotionDisLists = new ArrayList<PmPromotionDisDomain>();
                promotionDomain.setPmPromotionDisList(pmPromotionDisLists);
            }
            PmPromotionDisDomain pmPromotionDisDomain = new PmPromotionDisDomain();
            pmPromotionDisDomain.setChannelCode(this.getChannelByMem(userSession.getUserPcode(), request));
            pmPromotionDisDomain.setChannelName(userSession.getUserName());
            pmPromotionDisDomain.setMemberCode(saveMemberCode);
            pmPromotionDisDomain.setMemberName(saveMemberName);
            pmPromotionDisLists.add(pmPromotionDisDomain);
        }
        if (StringUtils.isNotBlank((String)memberCode)) {
            List<PmPromotionSupDomain> pmPromotionSupDomains = promotionDomain.getPmPromotionSupList();
            if (null == pmPromotionSupDomains) {
                pmPromotionSupDomains = new ArrayList<PmPromotionSupDomain>();
                promotionDomain.setPmPromotionSupList(pmPromotionSupDomains);
            }
            PmPromotionSupDomain pmPromotionSupDomain = new PmPromotionSupDomain();
            pmPromotionSupDomain.setPpsupMemcode(saveMemberCode);
            pmPromotionSupDomain.setPpsupName(saveMemberName);
            pmPromotionSupDomains.add(pmPromotionSupDomain);
        }
        promotionDomain.setAppmanageIcode(this.getProappCode(request));
        promotionDomain.setTenantCode(this.getTenantCode(request));
        promotionDomain.setMemberCode(saveMemberCode);
        promotionDomain.setMemberName(saveMemberName);
        return this.pmPromotionService.savePromotion(promotionDomain);
    }

    protected SupQueryResult<RsSkuReDomain> querySkuMotherPage(HttpServletRequest request, String type, String userMemberCode) {
        Map<String, Object> param = null;
        if (StringUtils.isBlank((String)type) && StringUtils.isNotBlank((String)userMemberCode) && null != (param = this.assemMapParam(request))) {
            param.put("memberCode", userMemberCode);
        }
        if (StringUtils.isBlank((String)type) && StringUtils.isBlank((String)userMemberCode)) {
            param = this.checkMemquaPlat(request) ? this.getPlatMemberCodeQueryMapParams(request) : this.getMemberCodeQueryMapParams(request);
        } else if (TYPE_PLAT.equals(type)) {
            param = this.getPlatMemberCodeQueryMapParams(request);
        } else if (TYPE_BUS.equals(type)) {
            param = this.getBusMemberCodeQueryMapParams(request);
        } else if (TYPE_USER.equals(type)) {
            param = this.getMemberCodeQueryMapParams(request);
        }
        if (null != param && null != param.get("goodsClassParentcode") && StringUtils.isNotBlank((String)param.get("goodsClassParentcode").toString())) {
            List<String> classList = this.rsGoodsClassService.getGoodsClass((String)param.get("goodsClassParentcode"), (String)param.get("goodsClassType"), this.getPmChannel(request), this.getTenantCode(request));
            if (ListUtil.isNotEmpty(classList)) {
                String classtreeCode = "";
                for (String string : classList) {
                    if (StringUtils.isNotBlank((String)classtreeCode)) {
                        classtreeCode = classtreeCode + ",";
                    }
                    classtreeCode = classtreeCode + string;
                }
                param.put("classtreeCode", classtreeCode);
            } else {
                return null;
            }
        }
        return this.querySkuMain(param);
    }

    protected SupQueryResult<RsSkuReDomain> querySkuMain(Map<String, Object> param) {
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuService.querySkuOnePage(param);
    }

    public SupQueryResult<TmProappEnvReDomain> queryProappEnvPageUser(HttpServletRequest request, String type, String userMemberCode) {
        Map<String, Object> param = null;
        if (StringUtils.isBlank((String)type) && StringUtils.isBlank((String)userMemberCode)) {
            param = this.checkMemquaPlat(request) ? this.getPlatMemberCodeQueryMapParams(request) : this.getMemberCodeQueryMapParams(request);
        } else if (TYPE_PLAT.equals(type)) {
            param = this.getPlatMemberCodeQueryMapParams(request);
        } else if (TYPE_BUS.equals(type)) {
            UserSession userSession = this.getUserSession(request);
            param = this.assemMapParam(request);
            param.put("tginfoCode", userSession.getUserPcode());
        } else if (TYPE_USER.equals(type)) {
            param = this.getMemberCodeQueryMapParams(request);
        }
        return this.tmProappService.queryProappEnvPage(param);
    }

    public HtmlJsonReBean sendPromotion(Integer promotionId) {
        if (StringUtils.isBlank((Integer)promotionId)) {
            this.logger.error(CODE + ".getPromotion", (Object)"param is null");
            return null;
        }
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionService.getPromotion(promotionId);
        if (null == pmPromotionReDomain) {
            return null;
        }
        return this.pmPromotionService.sendPromotionById(promotionId);
    }

    public HtmlJsonReBean sendPromotionDeleteGoods(Integer promotionId) {
        if (StringUtils.isBlank((Integer)promotionId)) {
            this.logger.error(CODE + ".getPromotion", (Object)"param is null");
            return null;
        }
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionService.getPromotion(promotionId);
        if (null == pmPromotionReDomain) {
            return null;
        }
        return this.pmPromotionService.sendPromotionDeleteGoods(promotionId);
    }

    public SupQueryResult<PmUserCouponReDomain> queryUsercouponPagePlus(HttpServletRequest request, String pbCode, String type, String userMemberCode) {
        Map<String, Object> param = this.assemMapBuyParam(request);
        if (StringUtils.isBlank((String)type) && StringUtils.isNotBlank((String)userMemberCode) && null != (param = this.assemMapParam(request))) {
            param.put("memberCode", userMemberCode);
        }
        if (StringUtils.isBlank((String)type) && StringUtils.isBlank((String)userMemberCode)) {
            param = this.checkMemquaPlat(request) ? this.getPlatMemberCodeQueryMapParams(request) : this.getMemberCodeQueryMapParams(request);
        } else if (TYPE_PLAT.equals(type)) {
            param = this.assemMapParam(request);
        } else if (TYPE_BUS.equals(type)) {
            param = this.assemMapParam(request);
            UserSession userSession = this.getUserSession(request);
            param.put("channelCode", this.getChannelByMem(userSession.getUserPcode(), request));
        } else if (TYPE_USER.equals(type)) {
            param = this.getMemberCodeQueryMapParams(request);
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)pbCode)) {
                param.put("pbCode", pbCode);
            }
        }
        return this.pmUserCouponService.queryUserCouponPage(param);
    }

    public HtmlJsonReBean promotionStateStopAndDelete(String promotionId, Integer oldDataState) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionService.updatePromotionState(Integer.valueOf(promotionId), -1, oldDataState, null);
    }

    public HtmlJsonReBean updatePromotionRangelist(HttpServletRequest request, String paramStr) {
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        if (null == promotionDomain) {
            this.logger.error(CODE + ".savePromotionPlus", (Object)"promotionDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionService.updatePromotionRangelist(promotionDomain);
    }

    @Override
    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        ArrayList<Map<String, Object>> mapList;
        block7: {
            List pmPromotionReDomainList;
            block6: {
                SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
                pmPromotionReDomainList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), PmPromotionReDomain.class);
                if (ListUtil.isEmpty((Collection)pmPromotionReDomainList)) {
                    return null;
                }
                mapList = new ArrayList<Map<String, Object>>();
                if (!"promotionDiscount".equals(excelTemplate) && !"promotionPreference".equals(excelTemplate)) break block6;
                for (PmPromotionReDomain oc : pmPromotionReDomainList) {
                    List<PmPromotionDiscountDomain> pmPromotionDiscountList = oc.getPmPromotionDiscountList();
                    boolean flag = false;
                    if (ListUtil.isNotEmpty(pmPromotionDiscountList)) {
                        for (PmPromotionDiscountDomain pmPromotionDiscountDomain : pmPromotionDiscountList) {
                            Map<String, Object> objectDetailToMap = this.covertMapWtite(pmPromotionDiscountDomain);
                            if (!flag) {
                                Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                Map<String, Object> stringObjectMap = this.coverPromotionDiscountState(objectToMap);
                                objectDetailToMap.putAll(stringObjectMap);
                                flag = true;
                            }
                            mapList.add(objectDetailToMap);
                        }
                        continue;
                    }
                    Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                    Map<String, Object> stringObjectMap = this.coverPromotionDiscountState(objectToMap);
                    mapList.add(stringObjectMap);
                }
                break block7;
            }
            if (!"promotionEnvelope".equals(excelTemplate)) break block7;
            for (PmPromotionReDomain oc : pmPromotionReDomainList) {
                Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                Map<String, Object> stringObjectMap = this.coverPromotionDiscountState(objectToMap);
                mapList.add(stringObjectMap);
            }
        }
        return mapList;
    }

    protected Map<String, Object> covertMapWtite(PmPromotionDiscountDomain pmPromotionDiscountDomain) {
        HashMap<String, Object> orderMaps = new HashMap<String, Object>();
        orderMaps.put("discName", pmPromotionDiscountDomain.getDiscName());
        return orderMaps;
    }

    protected Map<String, Object> coverPromotionDiscountState(Map<String, Object> map) {
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        String lTime = (String)map.get("promotionBegintime") + (String)map.get("promotionEndtime");
        String YTime = (String)map.get("receiveStart") + (String)map.get("receiveEnd");
        map.put("lTime", lTime);
        map.put("YTime", YTime);
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 0: {
                map.put("dataState", "\u672a\u5ba1\u6838");
                break;
            }
            case 1: {
                map.put("dataState", "\u8fdb\u884c\u4e2d");
                break;
            }
            case 2: {
                map.put("dataState", "\u5df2\u7ed3\u675f");
                break;
            }
            case 3: {
                map.put("dataState", "\u5df2\u7ec8\u6b62");
                break;
            }
            case 4: {
                map.put("dataState", "\u672a\u5f00\u59cb");
                break;
            }
            case 5: {
                map.put("dataState", "\u5ba1\u6838\u5931\u8d25");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        return map;
    }

    protected HtmlJsonReBean savePromotionPlusStr(HttpServletRequest request, String paramStr, String channelCode, String memberCode, String pbCode, String type) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".savePromotionPlus", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".savePromotionPlus", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = this.makeRangeList(request, paramStr);
        if (null == promotionDomain) {
            this.logger.error(CODE + ".savePromotionPlus", (Object)"promotionDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        promotionDomain.setPbCode(pbCode);
        String saveMemberCode = "";
        String saveMemberName = "";
        if (StringUtils.isBlank((String)type)) {
            if (this.checkMemquaPlat(request)) {
                saveMemberCode = this.getTeananMemberCode(request);
                saveMemberName = "\u5e73\u53f0";
            } else {
                saveMemberCode = userSession.getUserPcode();
                saveMemberName = userSession.getMerberCompname();
            }
        } else if (TYPE_PLAT.equals(type)) {
            saveMemberCode = this.getTeananMemberCode(request);
            saveMemberName = "\u5e73\u53f0";
        } else if (TYPE_BUS.equals(type)) {
            if (StringUtils.isNotBlank((String)userSession.getUserinfoParentCode())) {
                saveMemberCode = userSession.getUserinfoParentCode();
                saveMemberName = userSession.getUserinfoParentName();
            } else {
                saveMemberCode = userSession.getUserPcode();
                saveMemberName = userSession.getMerberCompname();
            }
            promotionDomain.setChannelCode(this.getChannelByMem(userSession.getUserPcode(), request));
            promotionDomain.setChannelName(this.getChannelName(promotionDomain.getChannelName(), request));
        } else if (TYPE_USER.equals(type)) {
            saveMemberCode = userSession.getUserPcode();
            saveMemberName = userSession.getMerberCompname();
            promotionDomain.setChannelCode(this.getChannelByMem(userSession.getUserPcode(), request));
            promotionDomain.setChannelName(this.getChannelName(promotionDomain.getChannelCode(), request));
            promotionDomain.setGoodsClass(this.getGoodsClassByMem(promotionDomain.getChannelCode(), request));
        }
        if (StringUtils.isNotBlank((String)channelCode)) {
            List<PmPromotionDisDomain> pmPromotionDisLists = promotionDomain.getPmPromotionDisList();
            if (null == pmPromotionDisLists) {
                pmPromotionDisLists = new ArrayList<PmPromotionDisDomain>();
                promotionDomain.setPmPromotionDisList(pmPromotionDisLists);
            }
            PmPromotionDisDomain pmPromotionDisDomain = new PmPromotionDisDomain();
            pmPromotionDisDomain.setChannelCode(this.getChannelByMem(userSession.getUserPcode(), request));
            pmPromotionDisDomain.setChannelName(userSession.getUserName());
            pmPromotionDisDomain.setMemberCode(saveMemberCode);
            pmPromotionDisDomain.setMemberName(saveMemberName);
            pmPromotionDisLists.add(pmPromotionDisDomain);
        }
        if (StringUtils.isNotBlank((String)memberCode)) {
            List<PmPromotionSupDomain> pmPromotionSupDomains = promotionDomain.getPmPromotionSupList();
            if (null == pmPromotionSupDomains) {
                pmPromotionSupDomains = new ArrayList<PmPromotionSupDomain>();
                promotionDomain.setPmPromotionSupList(pmPromotionSupDomains);
            }
            PmPromotionSupDomain pmPromotionSupDomain = new PmPromotionSupDomain();
            pmPromotionSupDomain.setPpsupMemcode(saveMemberCode);
            pmPromotionSupDomain.setPpsupName(saveMemberName);
            pmPromotionSupDomains.add(pmPromotionSupDomain);
        }
        promotionDomain.setAppmanageIcode(this.getProappCode(request));
        promotionDomain.setTenantCode(this.getTenantCode(request));
        promotionDomain.setMemberCode(saveMemberCode);
        promotionDomain.setMemberName(saveMemberName);
        return this.pmPromotionService.savePromotion(promotionDomain);
    }

    public PmPromotionDomain makeRangeList(HttpServletRequest request, String paramStr) {
        SupQueryResult<RsSkuReDomain> skuPage;
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        if (null == promotionDomain) {
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        promotionDomain.setClasstreeShopcode(userSession.getUserCode());
        List<PmPromotionRangelistDomain> pmPromotionRangelistDomains = promotionDomain.getPmPromotionRangeList();
        List<PmPromotionDiscountDomain> pmPromotionDiscountList = promotionDomain.getPmPromotionDiscountList();
        if (ListUtil.isNotEmpty(pmPromotionDiscountList) && ListUtil.isNotEmpty(pmPromotionDiscountList.get(0).getPmPromotionDiscountlistList()) && "0001".equals(promotionDomain.getPbCode())) {
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put("tenantCode", this.getTenantCode(request));
            ArrayList<PmPromotionDiscountlistDomain> Discountlist = new ArrayList<PmPromotionDiscountlistDomain>();
            ArrayList<PmPromotionDiscountlistDomain> removeDiscountlist = new ArrayList<PmPromotionDiscountlistDomain>();
            for (PmPromotionDiscountlistDomain pmDiscountlistDomain : pmPromotionDiscountList.get(0).getPmPromotionDiscountlistList()) {
                para.put("goodsCode", pmDiscountlistDomain.getGoodsCode());
                para.put("spuCode", pmDiscountlistDomain.getPpdlOpurl3());
                skuPage = this.rsSkuService.querySkuPage(para);
                pmDiscountlistDomain.setPpdlOpurl3(null);
                if (null != skuPage && ListUtil.isNotEmpty((Collection)skuPage.getList())) {
                    for (RsSkuReDomain skuReDomain : skuPage.getList()) {
                        PmPromotionDiscountlistDomain promotionDiscountlistDomain = new PmPromotionDiscountlistDomain();
                        if (!StringUtils.isNotBlank((String)skuReDomain.getSkuCode())) continue;
                        try {
                            BeanUtils.copyAllPropertys((Object)promotionDiscountlistDomain, (Object)pmDiscountlistDomain);
                            BeanUtils.copyAllPropertys((Object)promotionDiscountlistDomain, (Object)skuReDomain);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        promotionDiscountlistDomain.setPpdlOpurl(skuReDomain.getDataPic());
                        promotionDiscountlistDomain.setPpdlOpname(skuReDomain.getSkuName());
                        promotionDiscountlistDomain.setSkuNo(skuReDomain.getSkuNo());
                        promotionDiscountlistDomain.setSkuShowno(skuReDomain.getSkuShowno());
                        promotionDiscountlistDomain.setGoodsCode(skuReDomain.getGoodsCode());
                        Discountlist.add(promotionDiscountlistDomain);
                    }
                }
                removeDiscountlist.add(pmDiscountlistDomain);
            }
            promotionDomain.getPmPromotionDiscountList().get(0).getPmPromotionDiscountlistList().removeAll(removeDiscountlist);
            promotionDomain.getPmPromotionDiscountList().get(0).setPmPromotionDiscountlistList(Discountlist);
        }
        if (ListUtil.isNotEmpty(pmPromotionRangelistDomains)) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tenantCode", this.getTenantCode(request));
            ArrayList<PmPromotionRangelistDomain> rengelist = new ArrayList<PmPromotionRangelistDomain>();
            ArrayList<PmPromotionRangelistDomain> removeRengelist = new ArrayList<PmPromotionRangelistDomain>();
            for (PmPromotionRangelistDomain pmProRangelist : pmPromotionRangelistDomains) {
                param.put("goodsCode", pmProRangelist.getGoodsCode());
                param.put("spuCode", pmProRangelist.getPprlOpurl3());
                skuPage = this.rsSkuService.querySkuPage(param);
                pmProRangelist.setPprlOpurl3(null);
                if (null != skuPage && ListUtil.isNotEmpty((Collection)skuPage.getList())) {
                    for (RsSkuReDomain skuReDomain : skuPage.getList()) {
                        PmPromotionRangelistDomain pmProRangelistDomain = new PmPromotionRangelistDomain();
                        if (!StringUtils.isNotBlank((String)skuReDomain.getSkuCode())) continue;
                        try {
                            BeanUtils.copyAllPropertys((Object)pmProRangelistDomain, (Object)pmProRangelist);
                            BeanUtils.copyAllPropertys((Object)pmProRangelistDomain, (Object)skuReDomain);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        pmProRangelistDomain.setPprlOpurl(skuReDomain.getDataPic());
                        pmProRangelistDomain.setPprlOpname(skuReDomain.getSkuName());
                        pmProRangelistDomain.setSkuCode(skuReDomain.getSkuCode());
                        pmProRangelistDomain.setSkuNo(skuReDomain.getSkuNo());
                        pmProRangelistDomain.setSkuShowno(skuReDomain.getSkuShowno());
                        rengelist.add(pmProRangelistDomain);
                    }
                }
                removeRengelist.add(pmProRangelist);
            }
            this.logger.error("removeRengelist:" + JsonUtil.buildNonEmptyBinder().jsonObject(removeRengelist));
            this.logger.error("rengelist:" + JsonUtil.buildNonEmptyBinder().jsonObject(rengelist));
            promotionDomain.getPmPromotionRangeList().removeAll(removeRengelist);
            promotionDomain.setPmPromotionRangeList(rengelist);
            this.logger.error("promotionDomain:" + JsonUtil.buildNonEmptyBinder().toJson((Object)promotionDomain));
        }
        return promotionDomain;
    }

    protected HtmlJsonReBean updatePromotionPlusStr(HttpServletRequest request, String paramStr, String type) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updatePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updatePromotion", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = this.makeRangeList(request, paramStr);
        if (null == promotionDomain) {
            this.logger.error(CODE + ".updatePromotionPlusStr.promotionDomain", (Object)"promotionDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4fee\u6539\u6570\u636e\u4e3a\u7a7a");
        }
        if (null == promotionDomain.getPromotionId()) {
            this.logger.error(CODE + ".updatePromotion.PromotionId", (Object)"promotionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "");
        }
        promotionDomain.setTenantCode(this.getTenantCode(request));
        String saveMemberCode = "";
        String saveMemberName = "";
        if (StringUtils.isBlank((String)type)) {
            if (this.checkMemquaPlat(request)) {
                saveMemberCode = this.getTeananMemberCode(request);
                saveMemberName = "\u5e73\u53f0";
            } else {
                saveMemberCode = userSession.getUserPcode();
                saveMemberName = userSession.getMerberCompname();
            }
        } else if (TYPE_PLAT.equals(type)) {
            saveMemberCode = this.getTeananMemberCode(request);
            saveMemberName = "\u5e73\u53f0";
        } else if (TYPE_BUS.equals(type)) {
            if (StringUtils.isNotBlank((String)userSession.getUserinfoParentCode())) {
                saveMemberCode = userSession.getUserinfoParentCode();
                saveMemberName = userSession.getUserinfoParentName();
            } else {
                saveMemberCode = userSession.getUserPcode();
                saveMemberName = userSession.getMerberCompname();
            }
            promotionDomain.setChannelCode(this.getChannelByMem(userSession.getUserPcode(), request));
            promotionDomain.setChannelName(this.getChannelName(promotionDomain.getChannelName(), request));
        } else if (TYPE_USER.equals(type)) {
            saveMemberCode = userSession.getUserPcode();
            saveMemberName = userSession.getMerberCompname();
        }
        promotionDomain.setMemberCode(saveMemberCode);
        promotionDomain.setMemberName(saveMemberName);
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionService.getPromotion(promotionDomain.getPromotionId());
        if (null == pmPromotionReDomain || pmPromotionReDomain.getDataState() != 5) {
            this.logger.error(CODE + ".updatePromotion", (Object)" datastate canot update");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8425\u9500\u6d3b\u52a8\u5df2\u7ecf\u5f00\u59cb\u6216\u7ed3\u675f\u4e86\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        HtmlJsonReBean htmlJsonReBean = this.pmPromotionService.updatePromotion(promotionDomain);
        if (!"success".equals(htmlJsonReBean.getSysRecode())) {
            this.logger.error(CODE + ".updatePromotion", (Object)"htmlJsonReBean.getSysRecode() is error");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4fee\u6539\u5931\u8d25");
        }
        PmPromotionReDomain pmPromotionReDo = this.pmPromotionService.getPromotion((int)promotionDomain.getPromotionId());
        return this.pmPromotionService.updatePromotionState((int)promotionDomain.getPromotionId(), 0, pmPromotionReDo.getDataState(), null);
    }

    Boolean checkPromotionDomain(PmPromotionDomain promotionDomain) {
        if (null != promotionDomain.getPromotionFrequency() && 0 > promotionDomain.getPromotionFrequency()) {
            this.logger.error(CODE + ".checkPromotionDomain.promotionFrequency", (Object)("\u53c2\u4e0e\u6b21\u6570\u5f02\u5e38" + promotionDomain.getPromotionFrequency()));
            return false;
        }
        if (null != promotionDomain.getCouponOnceNums() && 0 > promotionDomain.getCouponOnceNums()) {
            this.logger.error(CODE + ".checkPromotionDomain.promotionFrequency", (Object)("\u4f18\u60e0\u5238\u5355\u6b21\u603b\u5f20\u6570" + promotionDomain.getCouponOnceNums()));
            return false;
        }
        if ("0002".equals(promotionDomain.getPbCode()) || "0004".equals(promotionDomain.getPbCode())) {
            List<PmPromotionDiscountDomain> pmPromotionDisList = promotionDomain.getPmPromotionDiscountList();
            if (ListUtil.isNotEmpty(pmPromotionDisList)) {
                for (PmPromotionDiscountDomain pmPromotionDisDomain : pmPromotionDisList) {
                    if (null != pmPromotionDisDomain.getDiscAmount() && 0 > pmPromotionDisDomain.getDiscAmount().compareTo(BigDecimal.ZERO)) {
                        this.logger.error(CODE + ".checkPromotionDomain.discAmount", (Object)("\u4f18\u60e0\u6570\u76ee\u5f02\u5e38" + pmPromotionDisDomain.getDiscAmount()));
                        return false;
                    }
                    if (null != pmPromotionDisDomain.getDiscStart() && 0 > pmPromotionDisDomain.getDiscStart().compareTo(new BigDecimal(-1))) {
                        this.logger.error(CODE + ".checkPromotionDomain.discStart", (Object)("\u4f18\u60e0\u5f00\u59cb\u533a\u95f4\u5f02\u5e38" + pmPromotionDisDomain.getDiscStart()));
                        return false;
                    }
                    if (null == pmPromotionDisDomain.getDiscEnd() || 0 <= pmPromotionDisDomain.getDiscStart().compareTo(new BigDecimal(-1))) continue;
                    this.logger.error(CODE + ".checkPromotionDomain.discStart", (Object)("\u4f18\u60e0\u7ed3\u675f\u533a\u95f4" + pmPromotionDisDomain.getDiscEnd()));
                    return false;
                }
            }
            if (ListUtil.isNotEmpty(promotionDomain.getPmPromotionConditionList())) {
                for (PmPromotionConditionDomain pmPromotionConditionDomain : promotionDomain.getPmPromotionConditionList()) {
                    if (null == pmPromotionConditionDomain.getCondAmount() || 0 <= pmPromotionConditionDomain.getCondAmount().compareTo(BigDecimal.ZERO)) continue;
                    this.logger.error(CODE + ".checkPromotionDomain.condAmount", (Object)("\u6761\u4ef6\u6570\u76ee\u5f02\u5e38" + pmPromotionConditionDomain.getCondAmount()));
                    return false;
                }
            }
        }
        return true;
    }

    public static void main(String[] args) {
        PromotionSupCon promotionCon = new PromotionSupCon();
        String json = "{\"promotionUrl\":\"\",\"pbCode\":\"0001\",\"promotionName\":\"\u6d4b\u8bd5111\",\"promotionBegintime\":\"2020-12-18 15:22:48\",\"promotionEndtime\":\"2020-12-19 15:22:49\",\"promotionFrequency\":\"11\",\"promotionMoling\":\"0\",\"activationMode\":1,\"checked2\":\"0\",\"rangeType\":0,\"targetType\":0,\"refundtype\":1,\"promotionOrgin\":0,\"returngoodstype\":1,\"sendtype\":3,\"memo\":\"\",\"promotionTer\":\"0\",\"promotionDis\":\"0\",\"promotionMem\":\"0\",\"promotionSup\":\"0\",\"pmPromotionTargetList\":[],\"pmPromotionRangeList\":[],\"pmPromotionTerminalList\":[],\"pmPromotionConditionList\":[{\"condType\":\"0\",\"condConstraint\":\"0\",\"condAdditional\":\"-1\",\"condAmount\":\"111\"}],\"pmPromotionDiscountList\":[{\"discType\":\"5\",\"discAmount\":\"0\",\"discName\":\"\u6ee1111\u5143\",\"discStart\":\"-1\",\"discEnd\":\"-1\",\"pmPromotionDiscountlistList\":[{\"discountCode\":\"13\",\"discountAmount\":1,\"ppdlOpurl\":\"https://b2bfileserviceqa01.blob.core.chinacloudapi.cn/d-partner-b2b2c-public/202012/b2bc/03fd6a5514874f9fad042f29ebe5bc45.jpg\",\"ppdlOpname\":\"test1218\",\"ppdlOpcode3\":\"yy\"}]}],\"checkedid\":false,\"checked1\":true,\"dataState\":0,\"pmPromotionMemList\":[],\"pmPromotionDisList\":[],\"pmPromotionSupList\":[]}";
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(json, PmPromotionDomain.class);
        Boolean aBoolean = promotionCon.checkPromotionDomain(promotionDomain);
    }
}

