/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.ur;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.dd.DdFalgSettingReDomain;
import cn.com.qj.bff.domain.rs.RsSkuDomain;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.domain.ur.UrOrderUserDomain;
import cn.com.qj.bff.domain.ur.UrUserrightsDomain;
import cn.com.qj.bff.domain.ur.UrUserrightsGoodsDomain;
import cn.com.qj.bff.domain.ur.UrUserrightsGoodsReDomain;
import cn.com.qj.bff.domain.ur.UrUserrightsListDomain;
import cn.com.qj.bff.domain.ur.UrUserrightsListReDomain;
import cn.com.qj.bff.domain.ur.UrUserrightsReDomain;
import cn.com.qj.bff.service.dd.DdFalgSettingService;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.service.ur.UrUserrightsService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/ur/userrights"}, name="\u7528\u6237\u6743\u76ca\u8bbe\u7f6e")
public class UserrightsCon
extends SpringmvcController {
    private static String CODE = "ur.userrights.con";
    @Autowired
    private UrUserrightsService urUserrightsService;
    @Autowired
    private DdFalgSettingService ddFalgSettingService;
    @Autowired
    private RsSkuService rsSkuService;

    @Override
    protected String getContext() {
        return "userrights";
    }

    @RequestMapping(value={"saveUserrightsToJson.json"}, name="\u589e\u52a0\u7528\u6237\u6743\u76ca\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveUserrightsJson(HttpServletRequest request, UrUserrightsDomain urUserrightsDomain, String startDate, String endDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date stDate = formatter.parse(startDate);
            Date enDate = formatter.parse(endDate);
            urUserrightsDomain.setUserruleStart(stDate);
            urUserrightsDomain.setUserruleEnd(enDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (null == urUserrightsDomain) {
            this.logger.error(CODE + ".saveUserrights", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        urUserrightsDomain.setTenantCode(this.getTenantCode(request));
        return this.urUserrightsService.saveUserrights(urUserrightsDomain);
    }

    @RequestMapping(value={"saveUserrights.json"}, name="\u589e\u52a0\u7528\u6237\u6743\u76ca\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveUserrights(HttpServletRequest request, UrUserrightsDomain urUserrightsDomain) {
        if (null == urUserrightsDomain) {
            this.logger.error(CODE + ".saveUserrights", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        urUserrightsDomain.setTenantCode(this.getTenantCode(request));
        return this.urUserrightsService.saveUserrights(urUserrightsDomain);
    }

    @RequestMapping(value={"updateUserrights.json"}, name="\u66f4\u65b0\u7528\u6237\u6743\u76ca\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updateUserrights(HttpServletRequest request, UrUserrightsDomain urUserrightsDomain) {
        if (null == urUserrightsDomain) {
            this.logger.error(CODE + ".updateUserrights", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        urUserrightsDomain.setTenantCode(this.getTenantCode(request));
        return this.urUserrightsService.updateUserrights(urUserrightsDomain);
    }

    @RequestMapping(value={"queryUserrightsPage.json"}, name="\u67e5\u8be2\u7528\u6237\u6743\u76ca\u8bbe\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UrUserrightsReDomain> queryUserrightsPage(HttpServletRequest request) {
        SupQueryResult<UrUserrightsReDomain> urUserrightsReDomainSupQueryResult;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (ListUtil.isNotEmpty((Collection)(urUserrightsReDomainSupQueryResult = this.urUserrightsService.queryUserrightsPage(param)).getList())) {
            HashMap<String, Object> ugMap = new HashMap<String, Object>();
            for (UrUserrightsReDomain urUserrightsReDomain : urUserrightsReDomainSupQueryResult.getList()) {
                ugMap.put("userrightsCode", urUserrightsReDomain.getUserrightsCode());
                ugMap.put("tenantCode", urUserrightsReDomain.getTenantCode());
                SupQueryResult<UrUserrightsListReDomain> urUserrightsList = this.urUserrightsService.queryUserrightsListPage(ugMap);
                urUserrightsReDomain.setUrUserrightsListReDomainList(urUserrightsList.getList());
            }
        }
        return urUserrightsReDomainSupQueryResult;
    }

    @RequestMapping(value={"updateUserrightsState.json"}, name="\u542f\u7528\u7528\u6237\u6743\u76ca\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updateUserrightsState(String userrightsId) {
        if (StringUtils.isBlank((String)userrightsId)) {
            this.logger.error(CODE + ".updateUserrightsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.urUserrightsService.updateUserrightsState(Integer.valueOf(userrightsId), 0, -1);
    }

    @RequestMapping(value={"stoppedUserrightsState.json"}, name="\u505c\u7528\u7528\u6237\u6743\u76ca\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean stoppedUserrightsState(String userrightsId) {
        if (StringUtils.isBlank((String)userrightsId)) {
            this.logger.error(CODE + ".stoppedUserrightsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.urUserrightsService.updateUserrightsState(Integer.valueOf(userrightsId), -1, 0);
    }

    @RequestMapping(value={"queryUserrightsGoodsPage.json"}, name="\u67e5\u8be2\u7528\u6237\u6743\u76ca\u5bf9\u5e94\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public List<RsSkuReDomain> queryUserrightsGoodsPage(HttpServletRequest request) {
        SupQueryResult<UrUserrightsGoodsReDomain> userrightsGoodsList;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (userrightsGoodsList = this.urUserrightsService.queryUserrightsGoodsPage(param)) || userrightsGoodsList.getList().size() <= 0) {
            return null;
        }
        ArrayList<RsSkuReDomain> rsSkuList = new ArrayList<RsSkuReDomain>();
        for (UrUserrightsGoodsReDomain urUserrightsGoodsReDomain : userrightsGoodsList.getList()) {
            HashMap<String, Object> skuMap = new HashMap<String, Object>();
            skuMap.put(urUserrightsGoodsReDomain.getUserrightsGoodsType(), urUserrightsGoodsReDomain.getUserrightsGoodsOpcode());
            skuMap.put("tenantCode", this.getTenantCode(request));
            SupQueryResult<RsSkuReDomain> skuList = this.rsSkuService.querySkuPage(skuMap);
            if (null == skuList || skuList.getList().size() <= 0) continue;
            rsSkuList.add((RsSkuReDomain)skuList.getList().get(0));
        }
        return rsSkuList;
    }

    @RequestMapping(value={"queryUserrightsGoodsPageByMemberGrade.json"}, name="\u67e5\u8be2\u7528\u6237\u6743\u76ca\u9002\u7528\u5bf9\u8c61\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UrUserrightsGoodsReDomain> queryUserrightsGoodsPageByMemberGrade(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.urUserrightsService.queryUserrightsGoodsPage(param);
    }

    @RequestMapping(value={"queryMemberGradeByQY.json"}, name="\u67e5\u8be2\u4f1a\u5458\u7b49\u7ea7")
    @ResponseBody
    public List<DdFalgSettingReDomain> queryMemberGradeByQY(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flagSettingScope", "memberScope");
        map.put("flagSettingType", "memberGrade");
        map.put("tenantCode", tenantCode);
        SupQueryResult<DdFalgSettingReDomain> qlist = this.ddFalgSettingService.queryFalgSettingPage(map);
        if (qlist == null) {
            return null;
        }
        return qlist.getRows();
    }

    @RequestMapping(value={"saveUserrightsGoodsBatch.json"}, name="\u6279\u91cf\u6dfb\u52a0\u7528\u6237\u6743\u76ca\u5bf9\u5e94\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveUserrightsGoodsBatch(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveUserrightsGoodsBatch", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        List userrightsGoodsList = JsonUtil.buildNormalBinder().getJsonToList(paramStr, UrUserrightsGoodsDomain.class);
        UrUserrightsGoodsDomain userrightsGoodsDomain = (UrUserrightsGoodsDomain)userrightsGoodsList.get(0);
        HashMap<String, Object> ugMap = new HashMap<String, Object>();
        ugMap.put("userrightsCode", userrightsGoodsDomain.getUserrightsCode());
        ugMap.put("tenantCode", tenantCode);
        SupQueryResult<UrUserrightsGoodsReDomain> urUserrightsGoodsList = this.urUserrightsService.queryUserrightsGoodsPage(ugMap);
        if (null != urUserrightsGoodsList && urUserrightsGoodsList.getList().size() > 0) {
            for (UrUserrightsGoodsReDomain userrightsGoods : urUserrightsGoodsList.getList()) {
                this.urUserrightsService.deleteUserrightsGoods(userrightsGoods.getUserrightsGoodsId());
            }
        }
        for (UrUserrightsGoodsDomain urUserrightsGoodsDomain : userrightsGoodsList) {
            urUserrightsGoodsDomain.setTenantCode(tenantCode);
        }
        return this.urUserrightsService.saveUserrightsGoodsBatch(userrightsGoodsList);
    }

    @RequestMapping(value={"saveUserrightsList.json"}, name="\u6dfb\u52a0\u8bbe\u7f6e\u9002\u7528\u5bf9\u8c61")
    @ResponseBody
    public HtmlJsonReBean saveUserrightsList(HttpServletRequest request, String params) {
        if (StringUtils.isBlank((String)params)) {
            this.logger.error(CODE + ".saveUserrightsList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List userrightsList = JsonUtil.buildNormalBinder().getJsonToList(params, UrUserrightsListDomain.class);
        String tenantCode = this.getTenantCode(request);
        UrUserrightsListDomain rightsList = (UrUserrightsListDomain)userrightsList.get(0);
        HashMap<String, Object> ugMap1 = new HashMap<String, Object>();
        ugMap1.put("userrightsListOpname", rightsList.getUserrightsListOpname());
        ugMap1.put("tenantCode", tenantCode);
        ugMap1.put("userrightsListOpcode", rightsList.getUserrightsListOpcode());
        SupQueryResult<UrUserrightsListReDomain> urUserrightsList1 = this.urUserrightsService.queryUserrightsListPage(ugMap1);
        if (ListUtil.isNotEmpty((Collection)urUserrightsList1.getList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u4f1a\u5458\u7b49\u7ea7\u5df2\u7ecf\u8bbe\u7f6e");
        }
        HashMap<String, Object> ugMap = new HashMap<String, Object>();
        ugMap.put("userrightsCode", rightsList.getUserrightsCode());
        ugMap.put("tenantCode", tenantCode);
        SupQueryResult<UrUserrightsListReDomain> urUserrightsList = this.urUserrightsService.queryUserrightsListPage(ugMap);
        if (null != urUserrightsList && urUserrightsList.getList().size() > 0) {
            for (UrUserrightsListReDomain userrightsList1 : urUserrightsList.getList()) {
                this.urUserrightsService.deleteUserrightsListByCode(tenantCode, userrightsList1.getUserrightsListCode());
            }
        }
        for (UrUserrightsListDomain urUserrightsListDomain : userrightsList) {
            urUserrightsListDomain.setTenantCode(tenantCode);
        }
        return this.urUserrightsService.saveUserrightsListBatch(userrightsList);
    }

    @RequestMapping(value={"updateUserrightsList.json"}, name="\u4fee\u6539\u8bbe\u7f6e\u9002\u7528\u5bf9\u8c61")
    @ResponseBody
    public HtmlJsonReBean updateUserrightsList(UrUserrightsListDomain urUserrightsListDomain) {
        if (null == urUserrightsListDomain) {
            this.logger.error(CODE + ".updateUserrightsList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.urUserrightsService.updateUserrightsList(urUserrightsListDomain);
    }

    @RequestMapping(value={"queryUserrightsListPage.json"}, name="\u67e5\u8be2\u8bbe\u7f6e\u9002\u7528\u5bf9\u8c61")
    @ResponseBody
    public SupQueryResult<UrUserrightsListReDomain> queryUserrightsListPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.urUserrightsService.queryUserrightsListPage(param);
    }

    @RequestMapping(value={"deleteUserrights.json"}, name="\u5220\u9664\u7528\u6237\u6743\u76ca\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean deleteUserrights(Integer userrightsId) {
        if (StringUtils.isBlank((Integer)userrightsId)) {
            this.logger.error(CODE + ".deleteUserrights", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.urUserrightsService.deleteUserrights(userrightsId);
    }

    @RequestMapping(value={"getUserrights.json"}, name="\u83b7\u53d6\u7528\u6237\u6743\u76ca\u8bbe\u7f6e\u4fe1\u606f")
    @ResponseBody
    public UrUserrightsReDomain getUserrights(Integer userrightsId) {
        if (StringUtils.isBlank((Integer)userrightsId)) {
            this.logger.error(CODE + ".getUserrights", (Object)"param is null");
            return null;
        }
        return this.urUserrightsService.getUserrights(userrightsId);
    }

    @RequestMapping(value={"getTotalDiscountPrice.json"}, name="\u7528\u6237\u6743\u76ca\u5dee\u4ef7\u8ba1\u7b97")
    @ResponseBody
    public HtmlJsonReBean getTotalDiscountPrice(HttpServletRequest request, String rsSkuListStr) {
        if (StringUtils.isBlank((String)rsSkuListStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param rsSkuListStr is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".getTotalDiscountPrice", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String userinfoCode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".getTotalDiscountPrice", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UrOrderUserDomain urOrderUserDomain = new UrOrderUserDomain();
        urOrderUserDomain.setUserCode(userinfoCode);
        urOrderUserDomain.setTenantCode(tenantCode);
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        List rsSkuList = JsonUtil.buildNormalBinder().getJsonToList(rsSkuListStr, RsSkuDomain.class);
        try {
            htmlJsonReBean.setDataObj((Object)this.urUserrightsService.getTotalDiscountPrice(urOrderUserDomain, rsSkuList));
        }
        catch (Exception e) {
            htmlJsonReBean = new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "error", (Object)0);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"commitOrder.json"}, name="\u7528\u6237\u786e\u8ba4\u4e0b\u5355\u64cd\u4f5c", produces={"application/json"}, method={RequestMethod.POST})
    @ResponseBody
    public HtmlJsonReBean commitOrder(HttpServletRequest request, String rsSkuListStr) {
        if (StringUtils.isBlank((String)rsSkuListStr)) {
            this.logger.error(CODE + ".commitOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param rsSkuListStr is null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".commitOrder", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession is null");
        }
        String userinfoCode = userSession.getUserPcode();
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".commitOrder", (Object)"userinfoCode or tenantCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userinfoCode or tenantCode is null");
        }
        List rsSkuList = JsonUtil.buildNormalBinder().getJsonToList(rsSkuListStr, RsSkuDomain.class);
        UrOrderUserDomain urOrderUserDomain = new UrOrderUserDomain();
        urOrderUserDomain.setUserCode(userinfoCode);
        urOrderUserDomain.setTenantCode(tenantCode);
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        try {
            htmlJsonReBean = this.urUserrightsService.commitOrder(urOrderUserDomain, rsSkuList);
        }
        catch (Exception e) {
            htmlJsonReBean.setMsg(e.getMessage());
            this.logger.error(CODE + ".commitOrder", (Object)e.getMessage(), (Throwable)e);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryUserrightsGoodsPagePlus.json"}, name="\u67e5\u8be2\u7528\u6237\u6743\u76ca\u5bf9\u5e94\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<UrUserrightsGoodsReDomain> queryUserrightsGoodsPagePlus(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.urUserrightsService.queryUserrightsGoodsPage(param);
    }

    @RequestMapping(value={"autoSend.json"}, name="\u4e1a\u52a1\u6d41\u6c34\u8c03\u5ea6")
    @ResponseBody
    public HtmlJsonReBean autoSend() {
        return this.urUserrightsService.autoSend();
    }
}

