/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.wo;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.ct.CtCustrelReDomain;
import cn.com.qj.bff.domain.oc.ContractType;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.domain.oc.SkuDomain;
import cn.com.qj.bff.domain.org.OrgUserBean;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.domain.sp.SpScontractDomain;
import cn.com.qj.bff.domain.sp.SpScontractFileDomain;
import cn.com.qj.bff.domain.sp.SpScontractFileReDomain;
import cn.com.qj.bff.domain.sp.SpScontractGoodsDomain;
import cn.com.qj.bff.domain.sp.SpScontractGoodsReDomain;
import cn.com.qj.bff.domain.sp.SpScontractReDomain;
import cn.com.qj.bff.domain.um.UmUserReDomainBean;
import cn.com.qj.bff.service.ct.CtCustrelService;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.service.org.OrgCompanyService;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.service.sp.SpScontractService;
import cn.com.qj.bff.service.um.UserBaseService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/sp/scontract"}, name="\u9500\u552e\u5408\u540c")
public class SpScontractCon
extends SpringmvcController {
    private static String CODE = "sp.scontract.con";
    @Autowired
    private UserService userService;
    @Autowired
    private SpScontractService spScontractService;
    @Autowired
    private OrgCompanyService orgCompanyService;
    @Autowired
    private CtCustrelService ctCustrelService;
    @Autowired
    private UserBaseService userBaseService;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;
    @Autowired
    private OcContractService ocContractService;
    @Autowired
    private RsSkuService rsSkuService;

    @Override
    protected String getContext() {
        return "scontract";
    }

    @RequestMapping(value={"saveScontract.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean saveScontract(HttpServletRequest request, SpScontractDomain spScontractDomain) {
        if (null == spScontractDomain) {
            this.logger.error(CODE + ".saveScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.saveScontract(spScontractDomain);
    }

    @RequestMapping(value={"getScontract.json"}, name="\u83b7\u53d6\u9500\u552e\u5408\u540c\u4fe1\u606f")
    @ResponseBody
    public SpScontractReDomain getScontract(Integer scontractId) {
        if (StringUtils.isBlank((Integer)scontractId)) {
            this.logger.error(CODE + ".getScontract", (Object)"param is null");
            return null;
        }
        return this.spScontractService.getScontract(scontractId);
    }

    @RequestMapping(value={"updateScontract.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean updateScontract(HttpServletRequest request, SpScontractDomain spScontractDomain) {
        if (null == spScontractDomain) {
            this.logger.error(CODE + ".updateScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.updateScontract(spScontractDomain);
    }

    @RequestMapping(value={"deleteScontract.json"}, name="\u5220\u9664\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean deleteScontract(Integer scontractId) {
        if (StringUtils.isBlank((Integer)scontractId)) {
            this.logger.error(CODE + ".deleteScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.deleteScontract(scontractId);
    }

    @RequestMapping(value={"saveScontractStr.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveScontract(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator iterator = scontract.iterator();
        if (iterator.hasNext()) {
            SpScontractDomain scontractStr = (SpScontractDomain)iterator.next();
            HtmlJsonReBean htmlJsonReBean = this.spScontractService.saveScontract(scontractStr);
            return htmlJsonReBean;
        }
        return null;
    }

    private void makeChannelStr(List<SpScontractDomain> spScontractDomainList, HttpServletRequest request) {
        if (ListUtil.isEmpty(spScontractDomainList) || null == request) {
            return;
        }
        for (SpScontractDomain orderDomain : spScontractDomainList) {
            orderDomain.setChannelCode(this.getNowChannel(request));
            orderDomain.setChannelName(this.getChannelName(orderDomain.getChannelCode(), request));
        }
    }

    private OrgUserBean getOrgUserBeanStr(String memberBcode, String userCode, String companyCode, String tenantCode) {
        if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = this.orgCompanyService.getEmpByUserCode(userCode, companyCode, tenantCode);
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        if (StringUtils.isNotBlank((String)memberBcode)) {
            orgUserBean.setMemberBcode(memberBcode);
            SupQueryResult<CtCustrelReDomain> qcust = this.ctCustrelService.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", memberBcode, tenantCode));
            if (null != qcust && ListUtil.isNotEmpty((Collection)qcust.getList())) {
                orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
                orgUserBean.setMemberBname(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelName());
            }
        }
        return orgUserBean;
    }

    public SpScontractDomain makeScontractDomain(SpScontractDomain orderDomain, String contractType, UserSession userSession, String proappCode, OrgUserBean orgUserBean) throws Exception {
        if (null == userSession || null == orderDomain) {
            this.logger.error("makeScontractDomain", (Object)"UserSession is null");
            return null;
        }
        SpScontractDomain contractDomain = new SpScontractDomain();
        try {
            BeanUtils.copyAllPropertys((Object)contractDomain, (Object)orderDomain);
            if (null != orgUserBean) {
                BeanUtils.copyAllPropertys((Object)contractDomain, (Object)orgUserBean);
            }
        }
        catch (Exception e) {
            this.logger.error("makeScontractDomain.ex", (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)contractDomain.getMemberBcode())) {
            contractDomain.setMemberBcode(userSession.getUserPcode());
            contractDomain.setMemberBname(userSession.getMerberCompname());
        }
        contractDomain.setTenantCode(userSession.getTenantCode());
        contractDomain.setAppmanageIcode(proappCode);
        contractDomain.setContractUserurl(userSession.getUserImgurl());
        contractDomain.setUserCode(userSession.getUserCode());
        contractDomain.setUserName(userSession.getUserName());
        String randomCode = RandomUtils.generateRandom((int)6, (Integer)2);
        contractDomain.setContractDelcode(randomCode);
        return contractDomain;
    }

    public List<SpScontractDomain> createScontract(List<SpScontractDomain> orderDomainList, String contractType, UserSession userSession, String proappCode, String oauthEnvCode, OrgUserBean orgUserBean, String contractProperty) {
        if (ListUtil.isEmpty(orderDomainList) || null == userSession) {
            this.logger.error(CODE + ".createScontract", (Object)"param is null");
        }
        ArrayList<SpScontractDomain> orderDomains = new ArrayList<SpScontractDomain>();
        String tenantCode = userSession.getTenantCode();
        for (SpScontractDomain orderDomain : orderDomainList) {
            try {
                SpScontractDomain contractDomain = this.makeScontractDomain(orderDomain, contractType, userSession, proappCode, orgUserBean);
                if (null == contractDomain) {
                    this.logger.error(CODE + ".createScontract");
                    return null;
                }
                if (StringUtils.isBlank((String)contractProperty)) {
                    contractProperty = "0";
                }
                contractDomain.setContractProperty(contractProperty);
                SpScontractDomain spScontractDomain = this.makeSpScontractGoodsDomainList(contractDomain, orderDomain.getGiftSkuIdList());
                orderDomains.add(spScontractDomain);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".createScontract.ex", (Throwable)e);
            }
        }
        return orderDomains;
    }

    public SpScontractDomain makeSpScontractGoodsDomainList(SpScontractDomain spScontractDomain, List<SkuDomain> giftSkuIdList) {
        ArrayList<SpScontractGoodsDomain> spScontractGoodsDomainList = new ArrayList<SpScontractGoodsDomain>();
        BigDecimal goodsNum = BigDecimal.ZERO;
        BigDecimal goodsWeight = BigDecimal.ZERO;
        BigDecimal contractInmoney = BigDecimal.ZERO;
        BigDecimal contractMoney = BigDecimal.ZERO;
        BigDecimal dataBnum = BigDecimal.ZERO;
        BigDecimal dataBweight = BigDecimal.ZERO;
        BigDecimal dataBmoney = BigDecimal.ZERO;
        BigDecimal goodsLogmoney = BigDecimal.ZERO;
        BigDecimal pefMoney = BigDecimal.ZERO;
        BigDecimal pacgeMoney = BigDecimal.ZERO;
        BigDecimal sum = BigDecimal.ZERO;
        this.logger.error(CODE + ".makeSpScontractGoodsDomainList", (Object)JsonUtil.buildNormalBinder().toJson(giftSkuIdList));
        if (ListUtil.isNotEmpty(giftSkuIdList)) {
            for (SkuDomain skuDomain : giftSkuIdList) {
                HashMap<String, Object> map;
                SpScontractGoodsDomain spScontractGoodsDomain = new SpScontractGoodsDomain();
                RsSkuReDomain rsSkuReDomain = null;
                if (null != skuDomain.getSkuId()) {
                    rsSkuReDomain = this.rsSkuService.getSku(skuDomain.getSkuId());
                } else if (StringUtils.isNotBlank((String)skuDomain.getSkuCode())) {
                    map = new HashMap<String, Object>();
                    map.put("skuCode", skuDomain.getSkuCode());
                    map.put("tenantCode", spScontractDomain.getTenantCode());
                    rsSkuReDomain = this.rsSkuService.getSkuByCode(map);
                }
                if (null == rsSkuReDomain) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList.skuCode", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuCode()));
                    return null;
                }
                if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().longValue() <= 0L) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList.rsSkuReDomain", (Object)"GoodsSupplynum is null");
                    return null;
                }
                map = new HashMap();
                map.put("goodsCode", rsSkuReDomain.getGoodsCode());
                map.put("tenantCode", rsSkuReDomain.getTenantCode());
                RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsService.getResourceGoodsByCode(map);
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.toString()));
                    return null;
                }
                if (StringUtils.isBlank((String)spScontractDomain.getMemberCode())) {
                    spScontractDomain.setMemberCode(rsResourceGoodsReDomain.getMemberCode());
                    spScontractDomain.setMemberName(rsResourceGoodsReDomain.getMemberName());
                }
                try {
                    BeanUtils.copyAllPropertys((Object)spScontractGoodsDomain, (Object)rsResourceGoodsReDomain);
                    BeanUtils.copyAllPropertys((Object)spScontractGoodsDomain, (Object)rsSkuReDomain);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".makeSpScontractGoodsDomainList", (Object)("\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    return null;
                }
                spScontractGoodsDomain.setContractGoodsPrice(skuDomain.getGoodsPinprice());
                spScontractDomain.setChannelCode(rsResourceGoodsReDomain.getChannelCode());
                spScontractDomain.setChannelName(rsResourceGoodsReDomain.getChannelName());
                spScontractDomain.setMschannelCode(rsResourceGoodsReDomain.getMschannelCode());
                spScontractDomain.setMschannelName(rsResourceGoodsReDomain.getMschannelName());
                spScontractGoodsDomain.setMemberBcode(spScontractDomain.getMemberBcode());
                spScontractGoodsDomain.setMemberBname(spScontractDomain.getMemberBname());
                spScontractGoodsDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
                spScontractGoodsDomain.setGoodsCamount(skuDomain.getGoodsNum());
                spScontractGoodsDomain.setGoodsCweight(null == skuDomain.getGoodsWeght() ? BigDecimal.ZERO : skuDomain.getGoodsWeght());
                spScontractGoodsDomain.setGoodsNum(skuDomain.getGoodsNum());
                spScontractGoodsDomain.setGoodsWeight(skuDomain.getGoodsWeght());
                if (null == spScontractGoodsDomain.getContractGoodsPrice()) {
                    spScontractGoodsDomain.setContractGoodsPrice(BigDecimal.ZERO);
                }
                sum = sum.add(spScontractGoodsDomain.getContractGoodsPrice().multiply(spScontractGoodsDomain.getGoodsNum()));
                if (null == spScontractGoodsDomain.getGoodsNum()) {
                    spScontractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
                }
                goodsNum = goodsNum.add(spScontractGoodsDomain.getGoodsNum());
                if (null == spScontractGoodsDomain.getGoodsCweight()) {
                    spScontractGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
                }
                goodsWeight = goodsWeight.add(spScontractGoodsDomain.getGoodsCweight());
                if (null == spScontractGoodsDomain.getPricesetRefrice()) {
                    spScontractGoodsDomain.setPricesetRefrice(BigDecimal.ZERO);
                }
                pefMoney = pefMoney.add(spScontractGoodsDomain.getPricesetRefrice());
                if (null == spScontractGoodsDomain.getPricesetNprice()) {
                    spScontractGoodsDomain.setPricesetNprice(BigDecimal.ZERO);
                }
                dataBmoney = dataBmoney.add(spScontractGoodsDomain.getPricesetNprice().multiply(spScontractGoodsDomain.getGoodsNum()));
                spScontractGoodsDomainList.add(spScontractGoodsDomain);
            }
        }
        spScontractDomain.setPricesetRefrice(pefMoney);
        spScontractDomain.setGoodsNum(goodsNum);
        spScontractDomain.setGoodsWeight(goodsWeight);
        spScontractDomain.setDataBweight(goodsWeight);
        spScontractDomain.setContractInmoney(contractInmoney);
        spScontractDomain.setContractMoney(contractMoney.add(goodsLogmoney));
        spScontractDomain.setDataBnum(dataBnum);
        spScontractDomain.setDataBmoney(dataBmoney);
        spScontractDomain.setGoodsLogmoney(goodsLogmoney);
        spScontractDomain.setGoodsPmoney(sum);
        spScontractDomain.setSpScontractGoodsDomainList(spScontractGoodsDomainList);
        return spScontractDomain;
    }

    @RequestMapping(value={"queryScontractPage.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryScontractPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractPage(param);
    }

    @RequestMapping(value={"updateScontractState.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractState(String scontractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractId)) {
            this.logger.error(CODE + ".updateScontractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.updateScontractState(Integer.valueOf(scontractId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"saveScontractFile.json"}, name="\u589e\u52a0\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveScontractFile(HttpServletRequest request, SpScontractFileDomain spScontractFileDomain) {
        if (null == spScontractFileDomain) {
            this.logger.error(CODE + ".saveScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractFileDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.saveScontractFile(spScontractFileDomain);
    }

    @RequestMapping(value={"getScontractFile.json"}, name="\u83b7\u53d6\u9644\u4ef6\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public SpScontractFileReDomain getScontractFile(Integer scontractFileId) {
        if (StringUtils.isBlank((Integer)scontractFileId)) {
            this.logger.error(CODE + ".getScontractFile", (Object)"param is null");
            return null;
        }
        return this.spScontractService.getScontractFile(scontractFileId);
    }

    @RequestMapping(value={"updateScontractFile.json"}, name="\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateScontractFile(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".updateScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SpScontractFileDomain goodsClassDomain = (SpScontractFileDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, SpScontractFileDomain.class);
        goodsClassDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.updateScontractFile(goodsClassDomain);
    }

    @RequestMapping(value={"deleteScontractFile.json"}, name="\u5220\u9664\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteScontractFile(Integer scontractFileId) {
        if (StringUtils.isBlank((Integer)scontractFileId)) {
            this.logger.error(CODE + ".deleteScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.deleteScontractFile(scontractFileId);
    }

    @RequestMapping(value={"queryScontractFilePage.json"}, name="\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractFileReDomain> queryScontractFilePage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractFilePage(param);
    }

    @RequestMapping(value={"updateScontractFileState.json"}, name="\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractFileState(String scontractFileId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractFileId)) {
            this.logger.error(CODE + ".updateScontractFileState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.updateScontractFileState(Integer.valueOf(scontractFileId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"saveScontractGoods.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveScontractGoods(HttpServletRequest request, SpScontractGoodsDomain spScontractGoodsDomain) {
        if (null == spScontractGoodsDomain) {
            this.logger.error(CODE + ".saveScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.saveScontractGoods(spScontractGoodsDomain);
    }

    @RequestMapping(value={"getScontractGoods.json"}, name="\u83b7\u53d6\u9500\u552e\u5408\u540c\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public SpScontractGoodsReDomain getScontractGoods(Integer scontractGoodsId) {
        if (StringUtils.isBlank((Integer)scontractGoodsId)) {
            this.logger.error(CODE + ".getScontractGoods", (Object)"param is null");
            return null;
        }
        return this.spScontractService.getScontractGoods(scontractGoodsId);
    }

    @RequestMapping(value={"updateScontractGoods.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateScontractGoods(HttpServletRequest request, SpScontractGoodsDomain spScontractGoodsDomain) {
        if (null == spScontractGoodsDomain) {
            this.logger.error(CODE + ".updateScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.spScontractService.updateScontractGoods(spScontractGoodsDomain);
    }

    @RequestMapping(value={"deleteScontractGoods.json"}, name="\u5220\u9664\u9500\u552e\u5408\u540c\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteScontractGoods(Integer scontractGoodsId) {
        if (StringUtils.isBlank((Integer)scontractGoodsId)) {
            this.logger.error(CODE + ".deleteScontractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.deleteScontractGoods(scontractGoodsId);
    }

    @RequestMapping(value={"queryScontractGoodsPage.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractGoodsReDomain> queryScontractGoodsPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractGoodsPage(param);
    }

    @RequestMapping(value={"updateScontractGoodsState.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c\u5546\u54c1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateScontractGoodsState(String scontractGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scontractGoodsId)) {
            this.logger.error(CODE + ".updateScontractGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.spScontractService.updateScontractGoodsState(Integer.valueOf(scontractGoodsId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryScontractPageC.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryScontractPageC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractPage(param);
    }

    @RequestMapping(value={"queryScontractFilePageC.json"}, name="C\u7aef\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractFileReDomain> queryScontractFilePageC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractFilePage(param);
    }

    @RequestMapping(value={"queryScontractGoodsPageC.json"}, name="C\u7aef\u67e5\u8be2\u9500\u552e\u5408\u540c\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractGoodsReDomain> queryScontractGoodsPageC(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.spScontractService.queryScontractGoodsPage(param);
    }

    @RequestMapping(value={"queryContractPage.json"}, name="\u5408\u540c\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractService.queryContractPageReDomain(param);
    }

    @RequestMapping(value={"saveScontractStrC.json"}, name="C\u7aef\u589e\u52a0\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveScontractStrC(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator iterator = scontract.iterator();
        if (iterator.hasNext()) {
            SpScontractDomain scontractStr = (SpScontractDomain)iterator.next();
            HtmlJsonReBean htmlJsonReBean = this.spScontractService.saveScontract(scontractStr);
            return htmlJsonReBean;
        }
        return null;
    }

    private HtmlJsonReBean getSpScontractDomains(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        if (null == scontractDomainStr) {
            this.logger.error(CODE + ".saveScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(scontractDomainStr, SpScontractDomain.class);
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error(CODE + ".saveScontract", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveScontract", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrgUserBean orgUserBean = null;
        if (StringUtils.isNotBlank((String)memberBcode)) {
            orgUserBean = this.getOrgUserBeanStr(memberBcode, userSession.getUserCode(), this.getCompanyCode(request), userSession.getTenantCode());
        }
        this.makeChannelStr(orderDomainList, request);
        List<SpScontractDomain> SpScontractDomainList = this.createScontract(orderDomainList, ContractType.CON.getCode(), userSession, this.getProappCode(request), this.getOauthEnvCode(request), orgUserBean, null);
        return new HtmlJsonReBean(SpScontractDomainList);
    }

    @RequestMapping(value={"saveScontractStrNew1.json"}, name="\u589e\u52a0\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean saveScontractNew1(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        Map<String, Object> map = this.assemMapParam(request);
        this.logger.error("\u65b0\u589e\u5408\u540c------------------------------------------------" + map);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator iterator = scontract.iterator();
        if (iterator.hasNext()) {
            Date time;
            Calendar cal;
            Integer DateNum;
            Integer DateType;
            SpScontractDomain scontractStr = (SpScontractDomain)iterator.next();
            if (map.get("takeEffectTime") != null && !"".equals(map.get("takeEffectTime")) && Integer.valueOf(map.get("takeEffectTime").toString()) == 2) {
                DateType = 13;
                DateNum = 0;
                if (map.get("takeInput1") != null && !"".equals(map.get("takeInput1"))) {
                    DateNum = Integer.valueOf(map.get("takeInput1").toString());
                }
                cal = Calendar.getInstance();
                if ("3".equals(map.get("takeRadio1").toString())) {
                    DateType = 12;
                } else if ("6".equals(map.get("takeRadio1").toString())) {
                    DateType = 10;
                } else if ("9".equals(map.get("takeRadio1").toString())) {
                    DateType = 5;
                }
                cal.add(DateType, DateNum);
                time = cal.getTime();
                scontractStr.setContractEffectivedate(time);
            }
            if (map.get("effectiveTime") != null && !"".equals(map.get("effectiveTime"))) {
                if (Integer.valueOf(map.get("effectiveTime").toString()) == 2) {
                    DateType = 13;
                    DateNum = 0;
                    if (map.get("takeInput2") != null && !"".equals(map.get("takeInput2"))) {
                        DateNum = Integer.valueOf(map.get("takeInput2").toString());
                    }
                    cal = Calendar.getInstance();
                    if ("3".equals(map.get("takeRadio2"))) {
                        DateType = 1;
                    } else if ("6".equals(map.get("takeRadio2"))) {
                        DateType = 2;
                    } else if ("9".equals(map.get("takeRadio2"))) {
                        DateType = 5;
                    }
                    cal.add(DateType, DateNum);
                    time = cal.getTime();
                    scontractStr.setContractDepositdate(time);
                }
                if (Integer.valueOf(map.get("effectiveTime").toString()) == 2) {
                    String dateType = "";
                    String dateNum = "";
                    if (map.get("takeInput2") != null && !"".equals(map.get("takeInput2"))) {
                        dateNum = map.get("takeInput2").toString();
                    }
                    if ("3".equals(map.get("takeRadio2"))) {
                        dateType = "\u5e74";
                    } else if ("6".equals(map.get("takeRadio2"))) {
                        dateType = "\u6708";
                    } else if ("9".equals(map.get("takeRadio2"))) {
                        dateType = "\u65e5";
                    }
                    String time2 = dateNum + dateType;
                    scontractStr.setScontractNbcode(time2);
                }
            }
            HtmlJsonReBean htmlJsonReBean = this.spScontractService.saveScontract(scontractStr);
            return htmlJsonReBean;
        }
        return null;
    }

    @RequestMapping(value={"queryScontractPageNew.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryScontractPageNew(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param.get("memberGcode") && !"".equals(param.get("memberGcode"))) {
            if ("0".equals(param.get("memberGcode")) || "1".equals(param.get("memberGcode"))) {
                param.put("order", true);
            } else {
                param.put("order", true);
                param.put("fuzzy", true);
            }
        } else {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult<SpScontractReDomain> result = this.spScontractService.queryScontractPage(param);
        if (null == result || ListUtil.isEmpty((Collection)result.getList())) {
            this.logger.error("result=================>", result);
            return null;
        }
        for (SpScontractReDomain spScontractReDomain : result.getList()) {
            if (null == spScontractReDomain.getContractDepositdate() || null == spScontractReDomain.getContractEffectivedate()) continue;
            Date endDate = spScontractReDomain.getContractDepositdate();
            Date startDate = spScontractReDomain.getContractEffectivedate();
            double times = endDate.getTime() - startDate.getTime();
            times = times / 1000.0 / 3600.0 / 24.0 / 365.0;
            this.logger.error("\u5408\u540c\u5e74\u4efd-----------------------------------" + times);
            DecimalFormat df = new DecimalFormat("#0.0");
            String years = df.format(times);
            if (years.endsWith(".0")) {
                years = years.substring(0, years.length() - 2);
            }
            this.logger.error("\u5408\u540c\u5e74\u4efd-----------------------------------" + years);
            spScontractReDomain.setAreaName(years);
        }
        return result;
    }

    @RequestMapping(value={"updateScontractStr.json"}, name="\u4fee\u6539\u9500\u552e\u5408\u540c\u63a5\u53e3")
    @ResponseBody
    public HtmlJsonReBean updateScontractStr(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        Map<String, Object> map = this.assemMapParam(request);
        this.logger.error("\u4fee\u6539\u9500\u552e\u5408\u540c------------------------------------------------" + map);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator iterator = scontract.iterator();
        if (iterator.hasNext()) {
            SupQueryResult<SpScontractReDomain> spScontractReDomainSupQueryResult;
            Date time;
            Calendar cal;
            Integer DateNum;
            Integer DateType;
            SpScontractDomain scontractStr = (SpScontractDomain)iterator.next();
            if (map.get("takeEffectTime") != null && !"".equals(map.get("takeEffectTime")) && Integer.valueOf(map.get("takeEffectTime").toString()) == 2) {
                DateType = 13;
                DateNum = 0;
                if (map.get("takeInput1") != null && !"".equals(map.get("takeInput1"))) {
                    DateNum = Integer.valueOf(map.get("takeInput1").toString());
                }
                cal = Calendar.getInstance();
                if ("3".equals(map.get("takeRadio1").toString())) {
                    DateType = 12;
                } else if ("6".equals(map.get("takeRadio1").toString())) {
                    DateType = 10;
                } else if ("9".equals(map.get("takeRadio1").toString())) {
                    DateType = 5;
                }
                cal.add(DateType, DateNum);
                time = cal.getTime();
                scontractStr.setContractEffectivedate(time);
            }
            if (map.get("effectiveTime") != null && !"".equals(map.get("effectiveTime"))) {
                if (Integer.valueOf(map.get("effectiveTime").toString()) == 2) {
                    DateType = 13;
                    DateNum = 0;
                    if (map.get("takeInput2") != null && !"".equals(map.get("takeInput2"))) {
                        DateNum = Integer.valueOf(map.get("takeInput2").toString());
                    }
                    cal = Calendar.getInstance();
                    cal.setTime(scontractStr.getContractEffectivedate());
                    if ("3".equals(map.get("takeRadio2"))) {
                        DateType = 1;
                    } else if ("6".equals(map.get("takeRadio2"))) {
                        DateType = 2;
                    } else if ("9".equals(map.get("takeRadio2"))) {
                        DateType = 5;
                    }
                    cal.add(DateType, DateNum);
                    time = cal.getTime();
                    scontractStr.setContractDepositdate(time);
                }
                if (Integer.valueOf(map.get("effectiveTime").toString()) == 2) {
                    String dateType = "";
                    String dateNum = "";
                    if (map.get("takeInput2") != null && !"".equals(map.get("takeInput2"))) {
                        dateNum = map.get("takeInput2").toString();
                    }
                    if ("3".equals(map.get("takeRadio2"))) {
                        dateType = "\u5e74";
                    } else if ("6".equals(map.get("takeRadio2"))) {
                        dateType = "\u6708";
                    } else if ("9".equals(map.get("takeRadio2"))) {
                        dateType = "\u65e5";
                    }
                    String time2 = dateNum + dateType;
                    scontractStr.setScontractNbcode(time2);
                }
            }
            if (map.get("sconId") != null && !"".equals(map.get("sconId"))) {
                this.spScontractService.deleteScontract(Integer.valueOf(map.get("sconId").toString()));
            }
            scontractStr.setDataState(1);
            HtmlJsonReBean htmlJsonReBean = this.spScontractService.saveScontract(scontractStr);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("scontractCode", htmlJsonReBean.getDataObj().toString());
            if (null != param) {
                param.put("order", true);
                param.put("fuzzy", true);
            }
            if (null == (spScontractReDomainSupQueryResult = this.spScontractService.queryScontractPage(param)) || ListUtil.isEmpty((Collection)spScontractReDomainSupQueryResult.getList())) {
                this.logger.error("result=================>", spScontractReDomainSupQueryResult);
            } else {
                Integer scontractId = ((SpScontractReDomain)spScontractReDomainSupQueryResult.getList().get(0)).getScontractId();
                this.spScontractService.updateScontractState(scontractId, 1, null, null);
            }
            return htmlJsonReBean;
        }
        return null;
    }

    @RequestMapping(value={"queryBuyerScontractPage.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<SpScontractReDomain> queryBuyerScontractPage(HttpServletRequest request) {
        SupQueryResult<SpScontractReDomain> result;
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (result = this.spScontractService.queryScontractPage(param)) || ListUtil.isEmpty((Collection)result.getList())) {
            this.logger.error("result=================>", result);
            return null;
        }
        for (SpScontractReDomain spScontractReDomain : result.getList()) {
            if (null != spScontractReDomain.getContractDepositdate() && null != spScontractReDomain.getContractEffectivedate()) {
                Date endDate = spScontractReDomain.getContractDepositdate();
                Date startDate = spScontractReDomain.getContractEffectivedate();
                double times = endDate.getTime() - startDate.getTime();
                times = times / 1000.0 / 3600.0 / 24.0 / 365.0;
                this.logger.error("\u5408\u540c\u5e74\u4efd-----------------------------------" + times);
                DecimalFormat df = new DecimalFormat("#0.0");
                String years = df.format(times);
                if (years.endsWith(".0")) {
                    years = years.substring(0, years.length() - 2);
                }
                this.logger.error("\u5408\u540c\u5e74\u4efd-----------------------------------" + years);
                spScontractReDomain.setAreaName(years);
            }
            if (null != spScontractReDomain.getContractDepositdate() && null != spScontractReDomain.getContractEffectivedate()) {
                long endDate = spScontractReDomain.getContractDepositdate().getTime();
                long startDate = spScontractReDomain.getContractEffectivedate().getTime();
                long nowDate = new Date().getTime();
                Integer buttonState = 0;
                Integer dataState = spScontractReDomain.getDataState();
                if ("0".equals(spScontractReDomain.getMemberGcode()) && dataState != 5) {
                    if (startDate > nowDate) {
                        dataState = 0;
                        buttonState = 1;
                    } else if (nowDate >= startDate && nowDate <= endDate) {
                        if (dataState == 2) {
                            dataState = 2;
                            buttonState = 4;
                        } else if (spScontractReDomain.getMemberCname() != null && !"".equals(spScontractReDomain.getMemberCname())) {
                            if (Double.valueOf(spScontractReDomain.getMemberCname()) == 0.0) {
                                dataState = 4;
                                buttonState = 1;
                            } else {
                                dataState = 1;
                                buttonState = 2;
                            }
                        }
                    } else if (spScontractReDomain.getMemberCname() != null && !"".equals(spScontractReDomain.getMemberCname())) {
                        if (Double.valueOf(spScontractReDomain.getMemberCname()) > 0.0) {
                            dataState = 3;
                            buttonState = 3;
                        } else {
                            dataState = 4;
                            buttonState = 1;
                        }
                    }
                }
                spScontractReDomain.setDataState(dataState);
                spScontractReDomain.setContractUserurl(buttonState.toString());
            }
            if (!spScontractReDomain.getMemberGcode().startsWith("2")) continue;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("scontractCode", spScontractReDomain.getScontractCode());
            params.put("dataState", 1);
            SupQueryResult<SpScontractFileReDomain> spScontractFileReDomainSupQueryResult = this.spScontractService.queryScontractFilePage(params);
            if (null == spScontractFileReDomainSupQueryResult || ListUtil.isEmpty((Collection)spScontractFileReDomainSupQueryResult.getList())) {
                spScontractReDomain.setContractUserurl("5");
                continue;
            }
            spScontractReDomain.setContractUserurl("6");
        }
        return result;
    }

    @RequestMapping(value={"updateScontractNew.json"}, name="\u66f4\u65b0\u9500\u552e\u5408\u540c")
    @ResponseBody
    public HtmlJsonReBean updateScontractNew(HttpServletRequest request, SpScontractDomain spScontractDomain) {
        if (null == spScontractDomain) {
            this.logger.error(CODE + ".updateScontract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        spScontractDomain.setTenantCode(this.getTenantCode(request));
        SpScontractReDomain scontract = this.spScontractService.getScontract(spScontractDomain.getScontractId());
        scontract.setContractDepositdate(spScontractDomain.getContractDepositdate());
        return this.spScontractService.updateScontract(scontract);
    }

    @RequestMapping(value={"updateScontractFileNew.json"}, name="\u66f4\u65b0\u9644\u4ef6\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateScontractFileNew(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".updateScontractFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SpScontractFileDomain goodsClassDomain = (SpScontractFileDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, SpScontractFileDomain.class);
        goodsClassDomain.setTenantCode(this.getTenantCode(request));
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("scontractCode", goodsClassDomain.getScontractCode());
        SupQueryResult<SpScontractFileReDomain> result = this.spScontractService.queryScontractFilePage(param);
        goodsClassDomain.setScontractFileId(((SpScontractFileReDomain)result.getList().get(0)).getScontractFileId());
        goodsClassDomain.setScontractFileCode(((SpScontractFileReDomain)result.getList().get(0)).getScontractFileCode());
        this.logger.error("ScontractFileId----------------------------------------" + ((SpScontractFileReDomain)result.getList().get(0)).getScontractFileId());
        return this.spScontractService.updateScontractFile(goodsClassDomain);
    }

    @RequestMapping(value={"saveBuyerScontractExcelStr.json"}, name="\u5bfc\u5165\u4e70\u5bb6\u5408\u540c\u8868\u683c")
    @ResponseBody
    public HtmlJsonReBean saveBuyerScontractExcel(HttpServletRequest request, String scontractDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBeanStr = this.getSpScontractDomains(request, scontractDomainStr, memberBcode);
        if (null == htmlJsonReBeanStr || !htmlJsonReBeanStr.isSuccess() || null == htmlJsonReBeanStr.getDataObj()) {
            return htmlJsonReBeanStr;
        }
        List scontract = (List)htmlJsonReBeanStr.getDataObj();
        Iterator iterator = scontract.iterator();
        if (iterator.hasNext()) {
            SpScontractDomain scontractStr = (SpScontractDomain)iterator.next();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("scontractObillcode", scontractStr.getScontractObillcode());
            param.put("contractInvstate", 2);
            SupQueryResult<SpScontractReDomain> result = this.spScontractService.queryScontractPage(param);
            HtmlJsonReBean htmlJsonReBean = null;
            if (null == result || ListUtil.isEmpty((Collection)result.getList())) {
                scontractStr.setContractInvstate(1);
                htmlJsonReBean = this.spScontractService.saveScontract(scontractStr);
            } else {
                SpScontractReDomain spScontractReDomain = (SpScontractReDomain)result.getList().get(0);
                spScontractReDomain.setMemberCcode(scontractStr.getMemberCcode());
                spScontractReDomain.setMemberCname(scontractStr.getMemberCname());
                htmlJsonReBean = this.spScontractService.updateScontract(spScontractReDomain);
            }
            return htmlJsonReBean;
        }
        return null;
    }

    @RequestMapping(value={"queryScontractGoodsPageNew1.json"}, name="\u67e5\u8be2\u9500\u552e\u5408\u540c\u5546\u54c1\u5206\u9875\u5217\u8868\uff08\u65b0\uff09")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryScontractGoodsPageNew1(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult<SpScontractGoodsReDomain> result = this.spScontractService.queryScontractGoodsPage(param);
        this.logger.error("\u5408\u540c\u5546\u54c11---------------------------------" + result.getList());
        SupQueryResult rsSkuResult = new SupQueryResult();
        if (null == result || ListUtil.isEmpty((Collection)result.getList())) {
            for (SpScontractGoodsReDomain spScontractGoodsReDomain : result.getList()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("skuCode", spScontractGoodsReDomain.getSkuCode());
                SupQueryResult<RsSkuReDomain> rsSkuReDomainSupQueryResult = this.rsSkuService.querySkuOnePage(map);
                this.logger.error("\u5408\u540c\u5546\u54c12---------------------------------" + rsSkuReDomainSupQueryResult.getRows());
                if (null != rsSkuReDomainSupQueryResult && !ListUtil.isEmpty((Collection)rsSkuReDomainSupQueryResult.getRows())) continue;
                RsSkuReDomain rsSkuReDomain = (RsSkuReDomain)rsSkuReDomainSupQueryResult.getRows().get(0);
                rsSkuReDomain.setPricesetInsideprice(spScontractGoodsReDomain.getPricesetNprice());
                rsSkuResult.getRows().add(rsSkuReDomain);
                rsSkuResult.getList().add(rsSkuReDomain);
            }
        }
        this.logger.error("\u5408\u540c\u5546\u54c13---------------------------------" + rsSkuResult.getRows());
        return rsSkuResult;
    }

    @RequestMapping(value={"forwardQueryScontractPageNew.json"}, name="\u9884\u7ea6\u5355\u5206\u914d\u9500\u552e")
    @ResponseBody
    public HtmlJsonReBean forwardQueryScontractPageNew(HttpServletRequest request, String paramStr) {
        UmUserReDomainBean umUserReDomainBean;
        HtmlJsonReBean htmlJsonReBean = new HtmlJsonReBean();
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (umUserReDomainBean = this.userService.getUserByUserPhone(param.get("userPhone").toString(), param.get("tenantCode").toString()))) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "umUserReDomainBean is null");
        }
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("companyCode", umUserReDomainBean.getCompanyCode());
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put("areaCode", umUserReDomainBean.getAreaCode());
        return htmlJsonReBean;
    }
}

