/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.cms;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.cms.CmsNoticeConfigDomain;
import cn.com.qj.bff.domain.cms.CmsNoticeConfigReDomain;
import cn.com.qj.bff.domain.cms.CmsNoticeDomain;
import cn.com.qj.bff.domain.cms.CmsNoticeReDomain;
import cn.com.qj.bff.domain.cms.CmsTginfoReDomain;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.service.cms.CmsNoticeService;
import cn.com.qj.bff.service.cms.CmsTginfoService;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/cms/noticeBusiness"}, name="\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
public class NoticeBusCon
extends SpringmvcController {
    private static String CODE = "cms.notice.con";
    @Autowired
    private CmsNoticeService cmsNoticeService;
    @Autowired
    private CmsTginfoService cmsTginfoService;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;

    @Override
    protected String getContext() {
        return "notice";
    }

    @RequestMapping(value={"saveNotice.json"}, name="\u589e\u52a0\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveNotice(HttpServletRequest request, CmsNoticeDomain cmsNoticeDomain) {
        if (null == cmsNoticeDomain) {
            this.logger.error(CODE + ".saveNotice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        cmsNoticeDomain.setTenantCode(this.getTenantCode(request));
        return this.cmsNoticeService.saveNotice(cmsNoticeDomain);
    }

    @RequestMapping(value={"getNotice.json"}, name="\u83b7\u53d6\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e\u4fe1\u606f")
    @ResponseBody
    public CmsNoticeReDomain getNotice(Integer noticeId) {
        if (StringUtils.isBlank((Integer)noticeId)) {
            this.logger.error(CODE + ".getNotice", (Object)"param is null");
            return null;
        }
        CmsNoticeReDomain notice = this.cmsNoticeService.getNotice(noticeId);
        if (notice == null) {
            this.logger.error(CODE + ".getNotice.notice", (Object)noticeId);
            return null;
        }
        String tenantCode = notice.getTenantCode();
        SupQueryResult<CmsNoticeConfigReDomain> noticeConfigPage = this.cmsNoticeService.queryNoticeConfigPage(this.getQueryMapParam("noticeCode,tenantCode,dataState", notice.getNoticeCode(), tenantCode, 0));
        if (noticeConfigPage != null && ListUtil.isNotEmpty((Collection)noticeConfigPage.getList())) {
            notice.setCmsNoticeConfigReDomainList(noticeConfigPage.getList());
        }
        return notice;
    }

    @RequestMapping(value={"updateNotice.json"}, name="\u66f4\u65b0\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updateNotice(HttpServletRequest request, CmsNoticeDomain cmsNoticeDomain) {
        if (null == cmsNoticeDomain) {
            this.logger.error(CODE + ".updateNotice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        cmsNoticeDomain.setTenantCode(this.getTenantCode(request));
        return this.cmsNoticeService.updateNotice(cmsNoticeDomain);
    }

    @RequestMapping(value={"deleteNotice.json"}, name="\u5220\u9664\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e")
    @ResponseBody
    public HtmlJsonReBean deleteNotice(Integer noticeId) {
        if (StringUtils.isBlank((Integer)noticeId)) {
            this.logger.error(CODE + ".deleteNotice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cmsNoticeService.deleteNotice(noticeId);
    }

    @RequestMapping(value={"queryNoticePage.json"}, name="\u67e5\u8be2\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CmsNoticeReDomain> queryNoticePage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("colName0", "DATA_STATE");
            param.put("colValue0", "0,1");
        }
        return this.cmsNoticeService.queryNoticePage(param);
    }

    @RequestMapping(value={"updateNoticeState.json"}, name="\u66f4\u65b0\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateNoticeState(String noticeId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)noticeId)) {
            this.logger.error(CODE + ".updateNoticeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.cmsNoticeService.updateNoticeState(Integer.valueOf(noticeId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryNoticeConfigPage.json"}, name="\u67e5\u8be2\u7ad9\u70b9\u5185\u5bb9\u914d\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CmsNoticeConfigReDomain> queryNoticeConfigPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.cmsNoticeService.queryNoticeConfigPage(param);
    }

    @RequestMapping(value={"queryNoticeLoadCache.json"}, name="\u5237\u65b0\u516c\u544a\u7f13\u5b58")
    @ResponseBody
    public HtmlJsonReBean queryNoticeLoadCache() {
        return this.cmsNoticeService.queryNoticeLoadCache();
    }

    @RequestMapping(value={"updateNoticeLoadCacheDataState.json"}, name="\u4fee\u6539\u516c\u544a\u72b6\u6001\uff08\u5b9a\u65f6\u4efb\u52a1\uff09")
    @ResponseBody
    public HtmlJsonReBean updateNoticeLoadCacheDataState(HttpServletRequest request) {
        return this.cmsNoticeService.updateNoticeLoadCacheDataState(this.getTenantCode(request));
    }

    @RequestMapping(value={"saveNoticePlat.json"}, name="\u589e\u52a0\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean saveNoticePlat(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".saveNoticeNew", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CmsNoticeDomain cmsNoticeDomain = (CmsNoticeDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, CmsNoticeDomain.class);
        if (StringUtils.isBlank((String)cmsNoticeDomain.getNoticeSort()) || StringUtils.isBlank((String)cmsNoticeDomain.getPublishingType())) {
            this.logger.error(CODE + ".saveNoticeNew.param", (Object)JsonUtil.buildNormalBinder().toJson((Object)cmsNoticeDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u7f3a\u5c11");
        }
        if ("1".equals(cmsNoticeDomain.getPublishingType()) && (cmsNoticeDomain.getNoticeStart() == null || cmsNoticeDomain.getNoticeEnd() == null)) {
            this.logger.error(CODE + ".saveNoticeNew.time", (Object)JsonUtil.buildNormalBinder().toJson((Object)cmsNoticeDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u7f3a\u5c11");
        }
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        cmsNoticeDomain.setTenantCode(tenantCode);
        cmsNoticeDomain.setMemberCode(userSession.getUserPcode());
        cmsNoticeDomain.setMemberName(userSession.getMerberCompname());
        cmsNoticeDomain.setNoticeType("0");
        HtmlJsonReBean htmlJsonReBean = this.cmsNoticeService.saveNotice(cmsNoticeDomain);
        List<CmsNoticeConfigDomain> cmsNoticeConfigDomainList = cmsNoticeDomain.getCmsNoticeConfigDomainList();
        if (htmlJsonReBean != null && htmlJsonReBean.isSuccess() && ListUtil.isNotEmpty(cmsNoticeConfigDomainList)) {
            String noticeCode = htmlJsonReBean.getDataObj().toString();
            for (CmsNoticeConfigDomain cmsNoticeConfigDomain : cmsNoticeConfigDomainList) {
                cmsNoticeConfigDomain.setTenantCode(tenantCode);
                cmsNoticeConfigDomain.setNoticeCode(noticeCode);
                cmsNoticeConfigDomain.setNoticeConfigType("=");
            }
            this.cmsNoticeService.saveNoticeConfigBatch(cmsNoticeConfigDomainList);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateNoticePlat.json"}, name="\u7f16\u8f91\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean updateNoticePlat(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            this.logger.error(CODE + ".updateNoticeNew", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CmsNoticeDomain cmsNoticeDomain = (CmsNoticeDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, CmsNoticeDomain.class);
        if (null == cmsNoticeDomain.getNoticeId() || StringUtils.isBlank((String)cmsNoticeDomain.getNoticeSort()) || StringUtils.isBlank((String)cmsNoticeDomain.getPublishingType())) {
            this.logger.error(CODE + ".updateNoticeNew.param", (Object)JsonUtil.buildNormalBinder().toJson((Object)cmsNoticeDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u7f3a\u5c11");
        }
        if ("1".equals(cmsNoticeDomain.getPublishingType()) && (cmsNoticeDomain.getNoticeStart() == null || cmsNoticeDomain.getNoticeEnd() == null)) {
            this.logger.error(CODE + ".updateNoticeNew.time", (Object)JsonUtil.buildNormalBinder().toJson((Object)cmsNoticeDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u7f3a\u5c11");
        }
        CmsNoticeReDomain notice = this.cmsNoticeService.getNotice(cmsNoticeDomain.getNoticeId());
        if (null == notice) {
            this.logger.error(CODE + ".updateNoticeNew.param", (Object)JsonUtil.buildNormalBinder().toJson((Object)cmsNoticeDomain));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u516c\u544a\u4e0d\u5b58\u5728");
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)notice, (Object)cmsNoticeDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String tenantCode = this.getTenantCode(request);
        HtmlJsonReBean htmlJsonReBean = this.cmsNoticeService.updateNotice(notice);
        List<CmsNoticeConfigDomain> cmsNoticeConfigDomainList = cmsNoticeDomain.getCmsNoticeConfigDomainList();
        if (htmlJsonReBean != null && htmlJsonReBean.isSuccess() && ListUtil.isNotEmpty(cmsNoticeConfigDomainList)) {
            String noticeCode = notice.getNoticeCode();
            for (CmsNoticeConfigDomain cmsNoticeConfigDomain : cmsNoticeConfigDomainList) {
                cmsNoticeConfigDomain.setNoticeConfigId(null);
                cmsNoticeConfigDomain.setNoticeConfigCode(null);
                cmsNoticeConfigDomain.setTenantCode(tenantCode);
                cmsNoticeConfigDomain.setNoticeCode(noticeCode);
                cmsNoticeConfigDomain.setNoticeConfigType("=");
            }
            this.cmsNoticeService.saveNoticeConfigBatch(cmsNoticeConfigDomainList);
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateNoticeStateNew.json"}, name="\u516c\u544a\u542f\u505c\u7528")
    @ResponseBody
    public HtmlJsonReBean updateNoticeStateNew(HttpServletRequest request, String noticeId, String dataState) {
        if (StringUtils.isBlank((String)noticeId) || StringUtils.isBlank((String)dataState)) {
            this.logger.error(CODE + ".updateNoticeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e0d\u5168");
        }
        CmsNoticeReDomain notice = this.cmsNoticeService.getNotice(Integer.valueOf(noticeId));
        if (notice == null) {
            this.logger.error(CODE + ".updateNoticeState.noticeId", (Object)noticeId);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u516c\u544a\u88ab\u5220\u9664");
        }
        Date date = new Date();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if ("1".equals(dataState)) {
            if (0 != notice.getDataState()) {
                this.logger.error(CODE + ".updateNoticeState.getDataState", (Object)JsonUtil.buildNormalBinder().toJson((Object)notice));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u516c\u544a\u4e0d\u80fd\u53d1\u5e03");
            }
            if (notice.getNoticeEnd() != null && date.getTime() > notice.getNoticeEnd().getTime()) {
                this.logger.error(CODE + ".updateNoticeState.getNoticeEnd", (Object)JsonUtil.buildNormalBinder().toJson((Object)notice));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5f53\u524d\u65f6\u95f4\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff0c\u4e0d\u80fd\u53d1\u5e03");
            }
            map.put("noticeStart", date);
            return this.cmsNoticeService.updateNoticeState(notice.getNoticeId(), 1, 0, map);
        }
        if ("0".equals(dataState)) {
            if (1 != notice.getDataState()) {
                this.logger.error(CODE + ".updateNoticeState.getDataState", (Object)JsonUtil.buildNormalBinder().toJson((Object)notice));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8be5\u516c\u544a\u4e0d\u80fd\u505c\u7528");
            }
            map.put("noticeEnd", date);
            return this.cmsNoticeService.updateNoticeState(notice.getNoticeId(), 0, 1, map);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"deleteNoticeNew.json"}, name="\u5220\u9664\u516c\u544a")
    @ResponseBody
    public HtmlJsonReBean deleteNoticeNew(Integer noticeId) {
        if (StringUtils.isBlank((Integer)noticeId)) {
            this.logger.error(CODE + ".deleteNoticeNew", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        CmsNoticeReDomain notice = this.cmsNoticeService.getNotice(noticeId);
        if (notice == null) {
            this.logger.error(CODE + ".deleteNoticeNew.noticeId", (Object)noticeId);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u516c\u544a\u5f02\u5e38");
        }
        if (1 == notice.getDataState()) {
            this.logger.error(CODE + ".deleteNoticeNew.notice", (Object)JsonUtil.buildNormalBinder().toJson((Object)notice));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u516c\u544a\u6b63    \u5728\u53d1\u5e03\u4e0d\u80fd\u5220\u9664");
        }
        return this.cmsNoticeService.updateNoticeState(noticeId, -1, 0, null);
    }

    @RequestMapping(value={"queryNoticePageList.json"}, name="C\u7aef\u67e5\u8be2\u516c\u544a")
    @ResponseBody
    public List<CmsNoticeDomain> queryNoticePageList(HttpServletRequest request, String noticeType, String goodsCode) throws Exception {
        String tenantCode = this.getTenantCode(request);
        UserSession userSession = this.getUserSession(request);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)goodsCode)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("goodsCode", goodsCode);
            paramMap.put("tenantCode", tenantCode);
            RsResourceGoodsReDomain resourceGoodsByCode = this.rsResourceGoodsService.getResourceGoodsByCode(paramMap);
            if (null == resourceGoodsByCode) {
                throw new Exception("\u5546\u54c1\u53c2\u6570\u5f02\u5e38");
            }
            map.put("goodsNo", resourceGoodsByCode.getGoodsNo());
            map.put("classtreeCode", resourceGoodsByCode.getClasstreeCode());
        }
        String tginfoCode = null;
        if ("wechatmini".equals(this.getOauthEnvCode(request))) {
            String companyCode = "";
            if (null != userSession) {
                String userinfoQuality = userSession.getUserinfoQuality();
                if ("buy".equals(userinfoQuality)) {
                    companyCode = userSession.getUserinfoParentCode();
                }
                if ("company".equals(userinfoQuality)) {
                    companyCode = userSession.getUserPcode();
                }
                HashMap<String, Object> param = new HashMap<String, Object>();
                if (StringUtils.isBlank((String)companyCode)) {
                    companyCode = this.getTeananMemberCode(request);
                }
                param.put("memberCode", companyCode);
                param.put("tenantCode", tenantCode);
                param.put("proappCode", this.getProappCode(request));
                SupQueryResult<CmsTginfoReDomain> cmsTginfoReDomainSupQueryResult = this.cmsTginfoService.queryTginfoPage(param);
                if (ListUtil.isNotEmpty((Collection)cmsTginfoReDomainSupQueryResult.getList())) {
                    tginfoCode = ((CmsTginfoReDomain)cmsTginfoReDomainSupQueryResult.getList().get(0)).getTginfoCode();
                }
            }
        } else {
            tginfoCode = this.getTginfoCode(request);
        }
        if (StringUtils.isBlank((String)tginfoCode)) {
            this.logger.error(CODE + "tginfoMenuCode! wechatmini is null");
            throw new Exception("\u7ad9\u70b9\u53c2\u6570\u4e3a\u7a7a");
        }
        map.put("tginfoCode", tginfoCode);
        this.logger.error(CODE + "queryNoticePageList map", map);
        return this.cmsNoticeService.queryNoticePageList(map, tenantCode, "0");
    }
}

