/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.order;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.domain.oc.OcPackageReDomain;
import cn.com.qj.bff.domain.wl.WlExpressReDomain;
import cn.com.qj.bff.service.oc.OcContractEngineService;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.service.oc.OcRecflowService;
import cn.com.qj.bff.service.wl.WlExpressService;
import cn.com.qj.bff.springmvc.SpringmvcNewController;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/oc/contractEngine"}, name="\u8ba2\u5355\u5f15\u64ce\u670d\u52a1")
public class ContractEngineCon
extends SpringmvcNewController {
    private static String CODE = "oc.contractEngine.con";
    @Autowired
    private OcContractEngineService ocContractEngineService;
    @Autowired
    private OcContractService ocContractService;
    @Autowired
    private WlExpressService wlExpressService;
    @Autowired
    private OcRecflowService ocRecflowService;

    @Override
    protected String getContext() {
        return "contractEngine";
    }

    @RequestMapping(value={"sendContractNext.json"}, name="\u8ba2\u5355\u4e0b\u4e00\u6b65")
    @ResponseBody
    public HtmlJsonReBean sendContractNext(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            logger.error(CODE + ".sendContractNext", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map<String, Object> map = this.getQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        map.put("userCode", userSession.getUserCode());
        map.put("userName", userSession.getUserName());
        map.remove("tenantCode");
        map.remove("contractBillcode");
        return this.ocContractEngineService.sendContractNext(contractBillcode, tenantCode, map);
    }

    @RequestMapping(value={"sendContractNextBuiMat.json"}, name="\u8ba2\u5355\u4e0b\u4e00\u6b65(\u5168\u6e20\u9053\u5efa\u6750)")
    @ResponseBody
    public HtmlJsonReBean sendContractNextBuiMat(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            logger.error(CODE + ".sendContractNextBuiMat", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map<String, Object> map = this.getQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        map.put("userCode", userSession.getUserCode());
        map.put("userName", userSession.getUserName());
        map.remove("tenantCode");
        map.remove("contractBillcode");
        return this.ocContractEngineService.sendContractNext(contractBillcode, tenantCode, map);
    }

    @RequestMapping(value={"sendContractNextBySg.json"}, name="\u8ba2\u5355\u4e0b\u4e00\u6b65(\u4e00\u952e\u53d1\u8d27)")
    @ResponseBody
    public HtmlJsonReBean sendContractNextBySg(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            logger.error(CODE + ".sendContractNextBySg", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map<String, Object> map = this.getQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        map.put("userCode", userSession.getUserCode());
        map.put("userName", userSession.getUserName());
        map.remove("tenantCode");
        map.remove("contractBillcode");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", tenantCode);
        OcContractReDomain contractByCode = this.ocContractService.getContractByCode(param);
        if (2 != contractByCode.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5df2\u53d1\u8d27,\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        logger.error(CODE + ".sendContractNextBySg.map", (Object)JsonUtil.buildNormalBinder().toJson(map));
        return this.ocContractEngineService.sendContractNext(contractBillcode, tenantCode, map);
    }

    @RequestMapping(value={"sendContractNextBatchBySg.json"}, name="\u8ba2\u5355\u4e0b\u4e00\u6b65\u6279\u91cf(\u4e00\u952e\u53d1\u8d27)")
    @ResponseBody
    public HtmlJsonReBean sendContractNextBatchBySg(HttpServletRequest request, String contractBillcodeStr) {
        if (StringUtils.isEmpty((String)contractBillcodeStr)) {
            logger.error(CODE + ".sendContractNextBatchBySg", (Object)"contractBillcodeStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        List paramMaps = JsonUtil.buildNonDefaultBinder().getJsonToListByMap(contractBillcodeStr, Object.class);
        if (ListUtil.isEmpty((Collection)paramMaps)) {
            logger.error(CODE + ".paramMaps", (Object)("paramMaps is null" + contractBillcodeStr));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramMaps");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Map> list = new ArrayList<Map>();
        UserSession userSession = this.getUserSession(request);
        String contractBillcode = "";
        ArrayList<String> errorContractBillcode = new ArrayList<String>();
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("dataState", 1);
        param.put("tenantCode", tenantCode);
        for (Map paramMap : paramMaps) {
            contractBillcode = String.valueOf(paramMap.get("contractBillcode"));
            if (StringUtils.isEmpty((String)contractBillcode)) {
                list.add(paramMap);
                continue;
            }
            param.put("expressCode", paramMap.get("expressCode"));
            param.put("expressName", paramMap.get("expressName"));
            SupQueryResult<WlExpressReDomain> expressPage = this.wlExpressService.queryExpressPage(param);
            if (null == expressPage || ListUtil.isEmpty((Collection)expressPage.getList())) {
                errorContractBillcode.add(contractBillcode);
                continue;
            }
            map.put("contractBillcode", contractBillcode);
            map.put("tenantCode", tenantCode);
            SupQueryResult<OcContractReDomain> ocContractReDomainSupQueryResult = this.ocContractService.queryContractPage(map);
            if (ocContractReDomainSupQueryResult == null || ListUtil.isEmpty((Collection)ocContractReDomainSupQueryResult.getList())) {
                errorContractBillcode.add(contractBillcode);
            }
            if (!ListUtil.isNotEmpty((Collection)ocContractReDomainSupQueryResult.getList()) || ((OcContractReDomain)ocContractReDomainSupQueryResult.getList().get(0)).getDataState() == 2) continue;
            errorContractBillcode.add(contractBillcode);
        }
        if (ListUtil.isNotEmpty(errorContractBillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "error", errorContractBillcode);
        }
        for (Map paramMap : paramMaps) {
            contractBillcode = String.valueOf(paramMap.get("contractBillcode"));
            if (StringUtils.isEmpty((String)contractBillcode)) continue;
            map.put("contractBillcode", contractBillcode);
            map.put("tenantCode", tenantCode);
            SupQueryResult<OcPackageReDomain> ocPackageReDomainSupQueryResult = this.ocContractService.queryPackagePage(map);
            if (ListUtil.isEmpty((Collection)ocPackageReDomainSupQueryResult.getList())) {
                list.add(paramMap);
                continue;
            }
            paramMap.put("packageCode", ((OcPackageReDomain)ocPackageReDomainSupQueryResult.getList().get(0)).getPackageCode());
            paramMap.put("packageId", ((OcPackageReDomain)ocPackageReDomainSupQueryResult.getList().get(0)).getPackageId());
            paramMap.put("userCode", userSession.getUserCode());
            paramMap.put("userName", userSession.getUserName());
            paramMap.remove("tenantCode");
            paramMap.remove("contractBillcode");
            this.ocContractEngineService.sendContractNext(contractBillcode, tenantCode, paramMap);
        }
        return new HtmlJsonReBean(list);
    }

    @RequestMapping(value={"sendContractNextBatchBySgGYS.json"}, name="\u8ba2\u5355\u4e0b\u4e00\u6b65\u6279\u91cf(\u4e00\u952e\u53d1\u8d27)")
    @ResponseBody
    public HtmlJsonReBean sendContractNextBatchBySgGYS(HttpServletRequest request, String contractBillcodeStr) {
        if (StringUtils.isEmpty((String)contractBillcodeStr)) {
            logger.error(CODE + ".sendContractNextBatchBySg", (Object)"contractBillcodeStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        List paramMaps = JsonUtil.buildNonDefaultBinder().getJsonToListByMap(contractBillcodeStr, Object.class);
        if (ListUtil.isEmpty((Collection)paramMaps)) {
            logger.error(CODE + ".paramMaps", (Object)("paramMaps is null" + contractBillcodeStr));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramMaps");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Map> list = new ArrayList<Map>();
        UserSession userSession = this.getUserSession(request);
        String contractBillcode = "";
        ArrayList<String> errorContractBillcode = new ArrayList<String>();
        for (Map paramMap : paramMaps) {
            contractBillcode = String.valueOf(paramMap.get("contractBillcode"));
            if (StringUtils.isEmpty((String)contractBillcode)) {
                list.add(paramMap);
                continue;
            }
            map.put("contractBillcode", contractBillcode);
            map.put("tenantCode", tenantCode);
            SupQueryResult<OcContractReDomain> ocContractReDomainSupQueryResult = this.ocContractService.queryContractPage(map);
            if (ocContractReDomainSupQueryResult == null || ListUtil.isEmpty((Collection)ocContractReDomainSupQueryResult.getList())) {
                errorContractBillcode.add(contractBillcode);
            }
            if (!ListUtil.isNotEmpty((Collection)ocContractReDomainSupQueryResult.getList())) continue;
            if (((OcContractReDomain)ocContractReDomainSupQueryResult.getList().get(0)).getDataState() != 2) {
                errorContractBillcode.add(contractBillcode);
            }
            if (userSession.getUserPcode().equals(((OcContractReDomain)ocContractReDomainSupQueryResult.getList().get(0)).getMemberCcode())) continue;
            errorContractBillcode.add(contractBillcode);
        }
        if (ListUtil.isNotEmpty(errorContractBillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "error", errorContractBillcode);
        }
        for (Map paramMap : paramMaps) {
            contractBillcode = String.valueOf(paramMap.get("contractBillcode"));
            if (StringUtils.isEmpty((String)contractBillcode)) continue;
            map.put("contractBillcode", contractBillcode);
            map.put("tenantCode", tenantCode);
            SupQueryResult<OcPackageReDomain> ocPackageReDomainSupQueryResult = this.ocContractService.queryPackagePage(map);
            if (ListUtil.isEmpty((Collection)ocPackageReDomainSupQueryResult.getList())) {
                list.add(paramMap);
                continue;
            }
            paramMap.put("packageCode", ((OcPackageReDomain)ocPackageReDomainSupQueryResult.getList().get(0)).getPackageCode());
            paramMap.put("packageId", ((OcPackageReDomain)ocPackageReDomainSupQueryResult.getList().get(0)).getPackageId());
            paramMap.put("userCode", userSession.getUserCode());
            paramMap.put("userName", userSession.getUserName());
            paramMap.remove("tenantCode");
            paramMap.remove("contractBillcode");
            this.ocContractEngineService.sendContractNext(contractBillcode, tenantCode, paramMap);
        }
        return new HtmlJsonReBean(list);
    }

    @RequestMapping(value={"sendBatchContractNext.json"}, name="\u6279\u91cf\u8ba2\u5355\u4e0b\u4e00\u6b65")
    @ResponseBody
    public HtmlJsonReBean sendBatchContractNext(HttpServletRequest request, MultipartFile file) {
        if (null == file) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a");
        }
        UserSession userSession = this.getUserSession(request);
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put("menuCode", UUID.randomUUID().toString());
        infoMap.put("fileName", "\u6279\u91cf\u6838\u9500\u8ba2\u5355");
        infoMap.put("tena\u00b7ntCode", userSession.getTenantCode());
        infoMap.put("userCode", userSession.getUserCode());
        infoMap.put("userName", userSession.getUserName());
        infoMap.put("tenantCode", userSession.getTenantCode());
        try {
            this.exportComExcelImport(request, file, infoMap, "", "offsetcontract");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u51c6\u5907\u5bfc\u51fa\u4fe1\u606f\u5f02\u5e38");
        }
        return new HtmlJsonReBean();
    }

    @Override
    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        return null;
    }

    @Override
    protected HtmlJsonReBean importExcelData(String apiRouter, String excelTemplate, ArrayList<String> arrayList, Map<String, Object> infoMap) {
        logger.error(CODE + "==========\u5f00\u59cb\u5bfc\u5165.importExcelData.arrayList==========", (Object)JsonUtil.buildNormalBinder().toJson(arrayList));
        if (arrayList.size() < 2) {
            String error = "\u5f53\u524d\u6570\u636e\u5217\u6570\u4e0d\u8db3\uff08\u81f3\u5c11\u9700\u89812\u5217\uff09";
            logger.error(CODE + ".importExcelData.arrayList error: {}", (Object)error);
            return new HtmlJsonReBean(CODE + ".importExcelData.arrayListError", error);
        }
        StringBuilder errorMsg = new StringBuilder();
        try {
            String tenantCode = this.getStringFromMap(infoMap, "tenantCode", "\u79df\u6237\u7f16\u7801", errorMsg);
            String userCode = this.getStringFromMap(infoMap, "userCode", "\u7528\u6237\u7f16\u7801", errorMsg);
            if (errorMsg.length() > 0) {
                logger.error(CODE + ".sendBatchContractNext.infoMap", (Object)errorMsg.toString());
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, errorMsg.toString().substring(1));
            }
            String contractBillcodes = arrayList.get(1);
            if (StringUtils.isEmpty((String)contractBillcodes)) {
                logger.error(CODE + ".sendBatchContractNext", (Object)"contractBillcodes is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
            }
            logger.error(CODE + ".sendBatchContractNext.contractBillcodes", (Object)contractBillcodes);
            List<String> list = this.getcodeStrList(contractBillcodes);
            for (String contractBillcode : list) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("contractBillcode", contractBillcode);
                param.put("tenantCode", tenantCode);
                OcContractReDomain contractByCode = this.ocContractService.getContractByCode(param);
                if (null == contractByCode) {
                    logger.error(CODE + ".sendBatchContractNext.contractByCode", (Object)JsonUtil.buildNormalBinder().toJson(param));
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u53f7\u6709\u8bef");
                }
                if (contractByCode.getContractPumode() != "1") {
                    logger.error(CODE + ".sendBatchContractNext.contractPumode", (Object)contractByCode.getContractPumode());
                    errorMsg.append("/").append(contractBillcode).append("\u8ba2\u5355\u4e0d\u662f\u81ea\u63d0\u7c7b\u578b");
                }
                if (!Integer.valueOf(3).equals(contractByCode.getDataState())) {
                    logger.error(CODE + ".sendBatchContractNext.dataState", (Object)contractByCode.getDataState());
                    errorMsg.append("/").append(contractBillcode).append("\u8ba2\u5355\u72b6\u6001\u6709\u8bef");
                }
                if (errorMsg.length() <= 0) continue;
                logger.error(CODE + ".sendBatchContractNext.errorMsg", (Object)errorMsg.toString());
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, errorMsg.toString().substring(1));
            }
            infoMap.remove("fileName");
            infoMap.remove("menuCode");
            infoMap.remove("tena\u00b7ntCode");
            for (String contractBillcode : list) {
                this.ocContractService.sendContractNext(contractBillcode, tenantCode, infoMap);
            }
        }
        catch (Exception e) {
            logger.error(CODE + ".sendBatchContractNext.exception", (Throwable)e);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5904\u7406\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return new HtmlJsonReBean();
    }

    private String getStringFromMap(Map<String, Object> map, String key, String desc, StringBuilder errorMsg) {
        Object value = map.get(key);
        if (value == null) {
            errorMsg.append("/").append(desc).append("\u4e3a\u7a7a");
            return null;
        }
        String strValue = value.toString();
        if (StringUtils.isBlank((String)strValue)) {
            errorMsg.append("/").append(desc).append("\u4e3a\u7a7a");
        }
        return strValue;
    }

    @RequestMapping(value={"sendDataStateBatchContractNext.json"}, name="\u6279\u91cf\u66f4\u6539\u8ba2\u5355\u8282\u70b9\u72b6\u6001\u4e0b\u4e00\u6b65")
    @ResponseBody
    public HtmlJsonReBean sendDataStateBatchContractNext(HttpServletRequest request, String contractBillcodeStr, String currentDataState) {
        if (StringUtils.isEmpty((String)currentDataState)) {
            logger.error(CODE + ".sendDataStateBatchContractNext", (Object)"contractBillcodes is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> map = new HashMap<String, Object>();
        UserSession userSession = this.getUserSession(request);
        map.put("userCode", userSession.getUserCode());
        map.put("userName", userSession.getUserName());
        map.put("tenantCode", tenantCode);
        map.remove("tenantCode");
        map.remove("contractBillcode");
        param.put("tenantCode", tenantCode);
        param.put("dataState", currentDataState);
        SupQueryResult<OcContractReDomain> ocContractReDomainSupQueryResult = this.ocContractService.queryContractPage(param);
        if (ListUtil.isEmpty((Collection)ocContractReDomainSupQueryResult.getList())) {
            logger.error(CODE + "sendDataStateBatchContractNext", (Object)currentDataState);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u6709\u8bef");
        }
        for (OcContractReDomain ocContractReDomain : ocContractReDomainSupQueryResult.getList()) {
            this.ocContractService.sendContractNext(ocContractReDomain.getContractBillcode(), tenantCode, map);
        }
        return new HtmlJsonReBean();
    }

    protected List<String> getcodeStrList(String codesStr) {
        String[] codeStr = codesStr.split(",");
        ArrayList<String> codeList = new ArrayList<String>();
        for (String code : codeStr) {
            codeList.add(code);
        }
        return codeList;
    }

    @RequestMapping(value={"sendDataStateBatch.json"}, name="\u6279\u91cf\u66f4\u6539\u8ba2\u5355\u8282\u70b9\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean sendDataStateBatch(HttpServletRequest request, String contractBillcodeStr, String dataState, String oldDataState, String type) {
        if (StringUtils.isEmpty((String)oldDataState) || StringUtils.isEmpty((String)dataState)) {
            logger.error(CODE + ".sendDataStateBatch", (Object)"contractBillcodes is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        UserSession userSession = this.getUserSession(request);
        map.put("userCode", userSession.getUserCode());
        map.put("userName", userSession.getUserName());
        map.remove("tenantCode");
        map.remove("contractBillcode");
        param.put("tenantCode", tenantCode);
        param.put("dataState", oldDataState);
        param.put("contractBillcode", contractBillcodeStr);
        SupQueryResult<OcContractReDomain> ocContractReDomainSupQueryResult = this.ocContractService.queryContractPage(param);
        if (ListUtil.isEmpty((Collection)ocContractReDomainSupQueryResult.getList())) {
            logger.error(CODE + "sendDataStateBatch", (Object)("oldDataState" + oldDataState + "dataState" + dataState));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u6709\u8bef");
        }
        for (OcContractReDomain ocContractReDomain : ocContractReDomainSupQueryResult.getList()) {
            this.ocContractService.updateContractStateExtend(ocContractReDomain.getContractId(), Integer.valueOf(dataState), ocContractReDomain.getDataState());
            if (!StringUtils.isNotBlank((String)type)) continue;
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("contractBillcode", ocContractReDomain.getContractBillcode());
            map1.put("goodsClass", type);
            list.add(map1);
            this.ocContractService.updateContractBatch(list);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"refreshNodeCache.json"}, name="\u8ba2\u5355\u9000\u5355\u7f13\u5b58\u5237\u65b0")
    @ResponseBody
    public HtmlJsonReBean refreshNodeCache(String apiCode) {
        if (StringUtils.isBlank((String)apiCode)) {
            throw new ApiException("apiCode is null");
        }
        return this.ocRecflowService.refreshNodeCache(this.getApiScopeMap(apiCode));
    }

    public String getApiScopeMap(String apiCode) {
        HashMap<String, String> apiMap = new HashMap<String, String>();
        apiMap.put("oc.cflow.queryCflowCache", "oc.cflow.queryCflowCache");
        apiMap.put("oc.cflowPservice.queryCflowPserviceCache", "oc.cflowPservice.queryCflowPserviceCache");
        apiMap.put("oc.contractCtrl.loadContractCtrlProcess", "oc.contractCtrl.loadContractCtrlProcess");
        apiMap.put("oc.contractEngine.queryPprocessLoadDb", "oc.contractEngine.queryPprocessLoadDb");
        apiMap.put("oc.recflow.queryRecflowCache", "oc.recflow.queryRecflowCache");
        apiMap.put("oc.recflowPservice.queryRecflowPserviceCache", "oc.recflowPservice.queryRecflowPserviceCache");
        apiMap.put("oc.refundCtrl.loadRefundCtrlProcess", "oc.refundCtrl.loadRefundCtrlProcess");
        apiMap.put("oc.refundEngine.queryPprocessLoadDb", "oc.refundEngine.queryPprocessLoadDb");
        return apiMap.get(apiCode).toString();
    }
}

