/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.order;

import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.common.util.ExportExcelUtlis;
import cn.com.qj.bff.controller.order.ContractComCon;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.oc.ContractType;
import cn.com.qj.bff.domain.oc.ExcelExportTemplate;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.domain.oc.PackageExpressDomain;
import cn.com.qj.bff.domain.pm.PmUserCouponReDomain;
import cn.com.qj.bff.service.oc.OcContractService;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/empcontract"}, name="\u4ee3\u5ba2\u8ba2\u5355\u670d\u52a1")
public class EmpContractCon
extends ContractComCon {
    private static String CODE = "oc.empcontract.con";

    @Override
    protected String getContext() {
        return "empcontract";
    }

    @RequestMapping(value={"saveExContractGoods.json"}, name="\u8ba2\u5355\u6362\u8d27\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveExContractGoods(HttpServletRequest request, String orderGoodsDomainStr) {
        if (StringUtils.isBlank((String)orderGoodsDomainStr)) {
            logger.error(CODE + ".saveExContractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveExContractGoodsCom(request, orderGoodsDomainStr);
    }

    @RequestMapping(value={"saveContract.json"}, name="\u589e\u52a0\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveContract(HttpServletRequest request, String orderDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBean = this.createOrder(request, orderDomainStr, ContractType.CON.getCode(), memberBcode, "1");
        return htmlJsonReBean;
    }

    @RequestMapping(value={"getContract.json"}, name="\u83b7\u53d6\u8ba2\u5355\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcContractReDomain getContract(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            logger.error(CODE + ".getContract", (Object)"param is null");
            return null;
        }
        return this.getContractCom(contractId);
    }

    @RequestMapping(value={"queryContract.json"}, name="\u5458\u5de5\u8ba2\u5355\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContract(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null != param) {
            param.put("employeeCode", this.getEmp(userSession));
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractForDep.json"}, name="\u90e8\u95e8\u8ba2\u5355\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractForDep(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null != param) {
            param.put("departCode", this.getDep(userSession));
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractForCom.json"}, name="\u516c\u53f8\u8ba2\u5355\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractForCom(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null != param) {
            param.put("companyCode", this.getCom(userSession));
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"offlinePayContractState.json"}, name="\u7ebf\u4e0b\u652f\u4ed8\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean offlinePayContractState(Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            logger.error(CODE + ".offlinePayContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractStateExtendCom(contractId, OcContractService.dataState_2, OcContractService.dataState_1);
    }

    @RequestMapping(value={"cancelContract.json"}, name="\u5458\u5de5\u53d6\u6d88\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean cancelContract(Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            logger.error(CODE + ".updateContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractStateExtendCom(contractId, OcContractService.dataState_no, OcContractService.dataState_1);
    }

    @RequestMapping(value={"getContractByCode.json"}, name="\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5")
    @ResponseBody
    public OcContractReDomain getContractByCode(HttpServletRequest request) {
        Map<String, Object> param = this.getMemberBcodeQueryMapParams(request);
        return this.getContractByCodeCom(request, param);
    }

    @RequestMapping(value={"updateContractSubMoney.json"}, name="\u4fee\u6539\u4ef7\u683c")
    @ResponseBody
    public HtmlJsonReBean updateContractSubMoney(Integer contractId, String subMoney, String remark) {
        if (contractId == null || StringUtils.hasBlank((String[])new String[]{subMoney, remark})) {
            logger.error(CODE + ".saveContracNext", (Object)"params is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractSubMoneyCom(contractId, subMoney, remark);
    }

    @RequestMapping(value={"syncContractState.json"}, name="\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractState(HttpServletRequest request, String contractBillcode) {
        return this.getContrant(request, contractBillcode, -1, 1);
    }

    @RequestMapping(value={"syncContractBatchState.json"}, name="\u6279\u6b21\u53f7\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractBatchState(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u4e3a\u7a7a");
        }
        return this.syncContractBatchStateCom(request, contractBbillcode);
    }

    @RequestMapping(value={"syncContractPayState.json"}, name="\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u652f\u4ed8\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractPayState(HttpServletRequest request, String contractBillcode, String contractSubCode) {
        return this.syncContractPayStateCom(request, contractBillcode, contractSubCode);
    }

    @RequestMapping(value={"syncContractBatchPayState.json"}, name="\u6279\u6b21\u53f7\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u652f\u4ed8\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractBatchPayState(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u4e3a\u7a7a");
        }
        return this.syncContractBatchPayStateCom(request, contractBbillcode);
    }

    @RequestMapping(value={"checkContractPay.json"}, name="\u786e\u5b9a\u662f\u5426\u652f\u51fa\u6210\u529f")
    @ResponseBody
    public HtmlJsonReBean checkContractPay(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            logger.error(CODE + ".checkContractPay", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.checkContractPayCom(request, contractBillcode);
    }

    @RequestMapping(value={"updateShippedPackageExpress.json"}, name="\u4fee\u6539\u5df2\u53d1\u8d27\u7269\u6d41\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateShippedPackageExpress(HttpServletRequest request, Integer packageId, PackageExpressDomain packageExpress) {
        if (packageExpress == null || StringUtils.hasBlank((String[])new String[]{packageExpress.getPackageBillno(), packageExpress.getExpressCode()}) || packageId == null) {
            logger.error(CODE + ".updateShippedPackageExpress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateShippedPackageExpressCom(request, packageId, packageExpress);
    }

    @RequestMapping(value={"confirmReceive.json"}, name="\u786e\u8ba4\u7b7e\u6536")
    @ResponseBody
    public HtmlJsonReBean confirmReceive(HttpServletRequest request, String contractBillcode, Integer packageId) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            logger.error(CODE + ".confirmReceive", (Object)"param is null");
        }
        return this.sendContractNextCom(request, contractBillcode, OcContractService.dataState_3, true);
    }

    @RequestMapping(value={"confirmReceivable.json"}, name="\u786e\u8ba4\u6536\u6b3e")
    @ResponseBody
    public HtmlJsonReBean confirmReceivable(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            logger.error(CODE + ".confirmReceivable.contractBillcode", (Object)"param is null");
        }
        return this.sendContractNextCom(request, contractBillcode, OcContractService.dataState_1, false);
    }

    @ResponseBody
    @RequestMapping(value={"calculateFreightFareBatch.json"}, name="\u6279\u91cf\u8ba1\u7b97\u7269\u6d41\u8d39\u7528")
    public HtmlJsonReBean calculateFreightFareBatch(HttpServletRequest request, String paramStr, String memberBcode) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.calculateFreightFareBatchCom(request, paramStr, memberBcode);
    }

    @ResponseBody
    @RequestMapping(value={"calculateFreightFare.json"}, name="\u8ba1\u7b97\u7269\u6d41\u8d39\u7528")
    public HtmlJsonReBean calculateFreightFare(HttpServletRequest request, String shoppingGoodsIdStr, String skuIdStr, String areaCode, String memberBcode) {
        if (StringUtils.isBlank((String)shoppingGoodsIdStr) && StringUtils.isBlank((String)skuIdStr)) {
            logger.error(CODE + ".calculateFreightFare", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)memberBcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a1");
        }
        return this.calculateFreightFareCom(request, shoppingGoodsIdStr, skuIdStr, areaCode, memberBcode);
    }

    @RequestMapping(value={"updateContractDelcode.json"}, name="\u6838\u63d0\u8d27\u7801")
    @ResponseBody
    public HtmlJsonReBean updateContractDelcode(HttpServletRequest request, String contractBillcode, String contractDelcode) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)contractDelcode)) {
            logger.error(CODE + ".updateContractDelcode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractDelcodeCom(request, contractBillcode, contractDelcode);
    }

    @RequestMapping(value={"queryUserConByGoods.json"}, name="\u6839\u636e\u5546\u54c1\u83b7\u53d6\u5bf9\u5e94\u7684\u4f18\u60e0\u5377")
    @ResponseBody
    public List<PmUserCouponReDomain> queryUserConByGoods(HttpServletRequest request, String pmContractGoodsDomainListStr, String memberBcode, String contractPmode) {
        if (StringUtils.isBlank((String)pmContractGoodsDomainListStr)) {
            logger.error(CODE + ".queryUserConByGoods", (Object)"param is null");
            return null;
        }
        return this.queryUserConByGoodsCom(request, pmContractGoodsDomainListStr, memberBcode, contractPmode, null);
    }

    @RequestMapping(value={"saveContractRule.json"}, name="\u589e\u52a0\u8ba2\u5355\u670d\u52a1\u914d\u7f6e\u6c47\u7387")
    @ResponseBody
    public HtmlJsonReBean saveContractRule(HttpServletRequest request, String orderDomainStr, String memberBcode) {
        HtmlJsonReBean htmlJsonReBean = this.createOrderRule(request, orderDomainStr, ContractType.CON.getCode(), memberBcode, "1");
        return htmlJsonReBean;
    }

    @RequestMapping(value={"exportInvoice.json"}, name="\u5b87\u89c6ERP\u53d1\u7968\u5bfc\u51fa")
    @ResponseBody
    public HtmlJsonReBean exportInvoice(HttpServletRequest request, String contractNo) {
        Map<String, Object> param = this.assemMapParam(request);
        param.put("contractNo", contractNo);
        String fileName = "\u8ba2\u5355\u5546\u54c1\u5217\u8868";
        UserSession userSession = this.getUserSession(request);
        String userCode = null == userSession ? "" : userSession.getUserCode();
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put("headMap", ExcelExportTemplate.covertInvoiceExcelParam());
        infoMap.put("userCode", userCode);
        infoMap.put("fileName", fileName);
        PostParamMap paramMap = new PostParamMap("dms.dmsWuliu.getDmsWuliuByCode");
        paramMap.putParam("contractNo", (Object)contractNo);
        String json = this.htmlIBaseService.sendMesReJson(paramMap);
        try {
            this.exportComExcel(request, infoMap, this.makeMeExcelData(json));
        }
        catch (Exception e) {
            logger.error(CODE + ".exportInvoice", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
        return null;
    }

    private List<Map<String, Object>> makeMeExcelData(String json) {
        JSONArray jsonArray = JSONArray.json2array((String)json);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (JSONObject jsonObject : jsonArray) {
            Map objectToMap = JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)jsonObject), String.class, Object.class);
            mapList.add(objectToMap);
        }
        return mapList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportComExcel(HttpServletRequest request, Map<String, Object> infoMap, List<Map<String, Object>> fromDataList) {
        if (MapUtil.isEmpty(infoMap)) {
            logger.error("SpringmvnNewController.exportComExcel", (Object)"param is null");
            return;
        }
        String tenantCode = MapUtils.getString(infoMap, (Object)"tenantCode");
        if (null == infoMap.get("userCode")) {
            logger.error("SpringmvnNewController.exportComExcel", (Object)"userCode is null");
            return;
        }
        String userCode = (String)infoMap.get("userCode");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        long timeMillis = System.currentTimeMillis();
        String formatData = sdf.format(timeMillis);
        String fileName = null == infoMap.get("fileName") ? "" : (String)infoMap.get("fileName");
        fileName = formatData + "-" + fileName;
        ArrayList<String> excelHeader = new ArrayList<String>();
        Object headMap = infoMap.get("headMap");
        if (null == headMap) {
            logger.error("SpringmvnNewController.exportComExcel.headMap", (Object)(" =:= " + infoMap));
            return;
        }
        List headMapList = JsonUtil.buildNormalBinder().getJsonToListByMap(JsonUtil.buildNormalBinder().toJson(headMap), Object.class);
        if (ListUtil.isEmpty((Collection)headMapList)) {
            logger.error("SpringmvnNewController.exportComExcel.headMapList", (Object)(" is null " + JsonUtil.buildNormalBinder().toJson(headMap)));
            return;
        }
        for (Map map : headMapList) {
            String showName = map.get("showName").toString();
            excelHeader.add(showName);
        }
        String[] headers = excelHeader.toArray(new String[excelHeader.size()]);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        HSSFRow row = sheet.createRow(0);
        for (int i = 0; i < headers.length; i = (int)((short)(i + 1))) {
            HSSFCell cell = row.createCell(i);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
            HSSFCellStyle hSSFCellStyle = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setFontName("\u4eff\u5b8b_GB2312");
            font.setFontHeightInPoints((short)10);
            hSSFCellStyle.setFont(font);
            cell.setCellStyle(hSSFCellStyle);
        }
        ArrayList<String[]> dataList = new ArrayList<String[]>();
        ArrayList<String> data = null;
        for (Map map : fromDataList) {
            data = new ArrayList<String>();
            for (Map map1 : headMapList) {
                String beanName = map1.get("dataName").toString();
                String value = "";
                if (StringUtils.isNotBlank((String)beanName)) {
                    String string = value = null == map.get(beanName) ? "" : String.valueOf(map.get(beanName));
                    if ("null".equals(value)) {
                        value = "";
                    }
                }
                data.add(value);
            }
            String[] array = data.toArray(new String[data.size()]);
            dataList.add(array);
        }
        try {
            ExportExcelUtlis.exportExcel((HSSFSheet)sheet, (HSSFRow)row, (String[])headers, dataList, (String)"yyyy-MM-dd HH:mm:ss", (int)1);
        }
        catch (Exception e) {
            logger.error("SpringmvnNewController.exportComExcel.exportExcel", (Object)"Exception");
            return;
        }
        String fileType = "xls";
        String string = request.getSession().getServletContext().getRealPath("/") + "../../temp/" + fileName + "." + fileType;
        if (StringUtils.isBlank((String)string)) {
            logger.error("SpringmvnNewController.exportComExcel.tempPath", (Object)string);
            return;
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(string);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            logger.error("SpringmvnNewController.exportComExcel.close", (Throwable)e);
            return;
        }
        finally {
            if (null != outputStream) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException beanName) {}
            }
        }
        byte[] bytes = null;
        try {
            bytes = ExportExcelUtlis.InputStreamByteArray((String)string);
        }
        catch (Exception e) {
            logger.error("SpringmvnNewController.exportComExcel.InputStreamByteArray", (Object)"Exception");
            return;
        }
        this.saveExcel(bytes, fileName, userCode, fileType, tenantCode);
    }
}

