/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.order;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.core.util.HttpClientUtil;
import cn.com.qj.bff.domain.id.UmUserDomain;
import cn.com.qj.bff.domain.pm.PmWxCoupon;
import cn.com.qj.bff.domain.pm.PmWxCouponReceiveLog;
import cn.com.qj.bff.service.nm.UmUserService;
import cn.com.qj.bff.service.pm.PmWxCouponService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/web/oc/user"}, name="\u4f18\u60e0\u5377")
public class UserCoupons
extends SpringmvcController {
    @Autowired
    private UmUserService umUserService;
    @Autowired
    private PmWxCouponService wxCouponService;
    private static final String PLATFORM = "TEST";
    private static final String QA = "qa";
    private static final String PROD = "PROD";
    private static final String APP_ID = "wxad7a10a8d720d33f";
    private static final String STOCK_CREATOR_MECHID = "421940716";
    private static final String WX_COUPON_URL = "https://api.mch.weixin.qq.com/v3/marketing/favor/users/wxad7a10a8d720d33f/coupons";
    private static final String CODE = "UserCoupons";

    @Override
    protected String getContext() {
        return CODE;
    }

    @RequestMapping(value={"wxCoupons.json"}, name="\u83b7\u53d6\u5fae\u4fe1\u4f18\u60e0\u5238\u5217\u8868")
    @ResponseBody
    public HtmlJsonReBean wxCoupons(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        if (null == tenantCode) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u627e\u4e0d\u5230\u79df\u6237\u4fe1\u606f");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u4fe1\u606f\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u9646");
        }
        String userCode = userSession.getUserCode();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantCode", tenantCode);
        params.put("userCode", userCode);
        UmUserDomain user = this.umUserService.getUmUserByUserCode(params);
        String openId = user.getUserOpenid();
        if (null == openId) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5fae\u4fe1\u6388\u6743\u8fc7\u671f");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usePlatform", PLATFORM);
        SupQueryResult<PmWxCoupon> couponRes = this.wxCouponService.getWxBaseCoupons(map);
        List coupons = couponRes.getList();
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        logMap.put("tenantCode", tenantCode);
        logMap.put("userOpenId", openId);
        logMap.put("userInfoCode", userSession.getUserPcode());
        SupQueryResult<PmWxCouponReceiveLog> receive = this.wxCouponService.getUserReceiveLog(logMap);
        List recList = receive.getList();
        if (null != recList && recList.size() > 0) {
            for (PmWxCoupon coupon : coupons) {
                for (PmWxCouponReceiveLog log : recList) {
                    if (!coupon.getCouponCode().equals(log.getCouponCode())) continue;
                    coupon.setDataState(0);
                }
            }
        }
        HtmlJsonReBean html = new HtmlJsonReBean(coupons);
        return html;
    }

    @RequestMapping(value={"wxReceiveCoupons.json"}, name="\u9886\u53d6\u5fae\u4fe1\u4f18\u60e0\u5238")
    @ResponseBody
    public HtmlJsonReBean wxReceiveCoupons(HttpServletRequest request, String couponCode) {
        String tenantCode;
        if (null == couponCode) {
            new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4f18\u60e0\u5377\u4ee3\u7801\u4e3a\u7a7a");
        }
        if (null == (tenantCode = this.getTenantCode(request))) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u627e\u4e0d\u5230\u79df\u6237\u4fe1\u606f");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u4fe1\u606f\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u9646");
        }
        String userCode = userSession.getUserCode();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantCode", tenantCode);
        params.put("userCode", userCode);
        UmUserDomain user = this.umUserService.getUmUserByUserCode(params);
        String openId = user.getUserOpenid();
        if (null == openId) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5fae\u4fe1\u6388\u6743\u8fc7\u671f");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(STOCK_CREATOR_MECHID);
        sb.append(DateUtil.getDateString((Date)new Date(), (String)"MMdd"));
        sb.append(new Random().nextInt(100000));
        String outRequestNo = sb.toString();
        HashMap<String, Object> wxParams = new HashMap<String, Object>();
        wxParams.put("stock_id", couponCode);
        wxParams.put("openid", openId);
        wxParams.put("out_request_no", outRequestNo);
        wxParams.put("appid", APP_ID);
        wxParams.put("stock_creator_mchid", STOCK_CREATOR_MECHID);
        String resp = HttpClientUtil.doPost(WX_COUPON_URL, wxParams);
        this.logger.info("UserCoupons.wxReceiveCoupons", (Object)"==============================");
        this.logger.info("UserCoupons.wxReceiveCoupons", (Object)resp);
        Map respMap = JsonUtil.getJsonToMap((String)resp);
        if (null == respMap.get("coupon_id") && null != respMap.get("code")) {
            String code = ((String)respMap.get("code")).toString();
            if (code.equals("NOT_ENOUGH")) {
                return new HtmlJsonReBean("2", "\u545c\u545c\u545c\uff0c\u60a8\u6765\u665a\u5566\uff0c\u5238\u5df2\u9886\u5b8c");
            }
            if (code.equals("RULE_LIMIT")) {
                return new HtmlJsonReBean("1", "\u60a8\u5df2\u7ecf\u9886\u8fc7\u5238\u5566\uff0c\u4e0d\u8981\u8d2a\u5fc3\u54e6");
            }
            return new HtmlJsonReBean("3", "\u54ce\u54df\u5582\uff0c\u597d\u50cf\u51fa\u4e86\u70b9\u95ee\u9898");
        }
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        logMap.put("tenantCode", tenantCode);
        logMap.put("userOpenId", openId);
        logMap.put("userInfoCode", userSession.getUserPcode());
        logMap.put("couponCode", couponCode);
        this.wxCouponService.saveUserReceiveLog(logMap);
        return new HtmlJsonReBean("\u9886\u53d6\u6210\u529f");
    }

    public static void main(String[] args) {
        System.out.println("==========" + DateUtil.getDateString((Date)new Date(), (String)"yyyyMMdd"));
    }
}

