/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.appmanage;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.core.util.HtmlUtil;
import cn.com.qj.bff.domain.am.AmAppapiDomain;
import cn.com.qj.bff.domain.am.AmAppapiReDomain;
import cn.com.qj.bff.service.am.AppapiService;
import cn.com.qj.bff.springmvc.SpringmvnNewController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/am/appapi"})
public class AppapiCon
extends SpringmvnNewController {
    private static String CODE = "am.appapi.con";
    @Autowired
    private AppapiService appapiService;

    @Override
    protected String getContext() {
        return "appapi";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(AmAppapiDomain amAppapi) {
        if (null == amAppapi) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appapiService.saveAppapi(amAppapi);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, String appapiId, ModelMap modelMap) {
        modelMap.put((Object)"appapiReBean", (Object)this.getAppapi(appapiId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, AmAppapiDomain amAppapi) {
        if (null == amAppapi) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appapiService.updateAppapi(amAppapi);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, String appapiId) {
        if (StringUtils.isBlank((String)appapiId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appapiService.deleteAppapi(Integer.valueOf(appapiId));
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, String appapiId, String dataState, String oldDataState) {
        if (StringUtils.isBlank((String)appapiId) || StringUtils.isBlank((String)dataState) || StringUtils.isBlank((String)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.appapiService.updateAppapiState(Integer.valueOf(appapiId), Integer.valueOf(dataState), Integer.valueOf(oldDataState));
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, String appapiId, ModelMap modelMap) {
        modelMap.put((Object)"appapiReBean", (Object)this.getAppapi(appapiId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getAppapi(String appapiId) {
        String rs = "{}";
        if (StringUtils.isBlank((String)appapiId)) {
            this.logger.error(CODE + ".getAppapi", (Object)"appapiId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.appapiService.getAppapi(Integer.valueOf(appapiId)));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public SupQueryResult<AmAppapiReDomain> listQuery(HttpServletRequest request) {
        Map<String, Object> param = HtmlUtil.tranMap(request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.appapiService.queryAppapiPage(param);
    }

    @RequestMapping(value={"getApiAll.json"})
    @ResponseBody
    public AmAppapiReDomain listQueryAll(HttpServletRequest request, String appapiId) {
        if (StringUtils.isBlank((String)appapiId)) {
            this.logger.error(CODE + ".getAppapi", (Object)"appapiId is null");
        }
        return this.appapiService.getAppapiAll(Integer.valueOf(appapiId));
    }

    @RequestMapping(value={"generateSdk"})
    @ResponseBody
    public HtmlJsonReBean generateSdk(HttpServletRequest request, String appapicodes) {
        String str = "";
        return new HtmlJsonReBean(str);
    }

    @RequestMapping(value={"preciseQuery.json"})
    @ResponseBody
    public SupQueryResult<AmAppapiReDomain> preciseQuery(HttpServletRequest request) {
        Map<String, Object> param = HtmlUtil.tranMap(request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
        }
        return this.appapiService.queryAppapiPage(param);
    }

    @RequestMapping(value={"queryApiLoadCache.json"}, name="API\u52a0\u8f7dCACHE")
    @ResponseBody
    public HtmlJsonReBean queryApiLoadCache() {
        return this.appapiService.queryApiLoadCache();
    }

    @RequestMapping(value={"queryApiCache.json"}, name="AP\u7f13\u5b58\u52a0\u8f7d")
    @ResponseBody
    public HtmlJsonReBean queryApiCache() {
        return this.appapiService.queryApiCache();
    }

    @RequestMapping(value={"queryApiRouterCache.json"}, name="APIRouter\u7f13\u5b58\u52a0\u8f7d")
    @ResponseBody
    public HtmlJsonReBean queryApiRouterCache() {
        return this.appapiService.queryApiRouterCache();
    }

    @RequestMapping(value={"queryApiErrorCache.json"}, name="APIError\u7f13\u5b58\u52a0\u8f7d")
    @ResponseBody
    public HtmlJsonReBean queryApiErrorCache() {
        return this.appapiService.queryApiErrorCache();
    }

    @Override
    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        return null;
    }
}

