/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.springmvc;

import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.common.util.ExportExcelUtlis;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.fm.FmFileDomainBean;
import cn.com.qj.bff.domain.fm.FmFileReDomainBean;
import cn.com.qj.bff.domain.fm.FmUsermfileDomain;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.file.FileBean;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public abstract class SpringmvcNewController
extends SpringmvcController {
    protected static final SupperLogUtil logger = new SupperLogUtil(SpringmvcNewController.class);
    private static final ExecutorService pool = Executors.newFixedThreadPool(2);
    private static final String tempPath = "../../temp/";
    private static String ui_page = "page";
    private static String ui_rows = "rows";
    private static String dao_startRow = "startRow";
    private static String dao_endRow = "endRow";
    private static final String TEMP = System.getProperty("java.io.tmpdir");
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");

    protected abstract List<Map<String, Object>> makeExcelData(String var1, String var2, String var3);

    protected abstract HtmlJsonReBean importExcelData(String var1, String var2, ArrayList<String> var3, Map<String, Object> var4);

    private static void updateTaskStatus(String taskId, int progress, String message) {
        String statusKey = "export_task_" + taskId;
        HashMap<String, Object> status = new HashMap<String, Object>();
        status.put("progress", progress);
        status.put("message", message);
        status.put("timestamp", String.valueOf(System.currentTimeMillis()));
        SupDisUtil.set((String)statusKey, (String)JsonUtil.buildNormalBinder().toJson(status), (int)86400);
    }

    private static void updateTaskStatus(String taskId, int progress, int success, int error, int total, String message) {
        String statusKey = "export_task_" + taskId;
        HashMap<String, Object> status = new HashMap<String, Object>();
        status.put("progress", progress);
        status.put("success", success);
        status.put("error", error);
        status.put("total", total);
        status.put("message", message);
        status.put("timestamp", String.valueOf(System.currentTimeMillis()));
        SupDisUtil.set((String)statusKey, (String)JsonUtil.buildNormalBinder().toJson(status), (int)86400);
    }

    public void exportComExcel(HttpServletRequest request, final Map<String, Object> paramMap, final Map<String, Object> infoMap, final String apiRouter, final String excelTemplate) {
        pool.execute(new Runnable(){

            @Override
            public void run() {
                SpringmvcNewController.this.exportComExcelInAsync(SpringmvcNewController.tempPath, paramMap, infoMap, apiRouter, excelTemplate);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportComExcelInAsync(String tempPath, Map<String, Object> paramMap, Map<String, Object> infoMap, String apiRouter, String excelTemplate) {
        FileOutputStream outputStream;
        SXSSFWorkbook workbook;
        block32: {
            block30: {
                block31: {
                    if (MapUtil.isEmpty(paramMap) || MapUtil.isEmpty(infoMap) || StringUtils.isBlank((String)apiRouter)) {
                        logger.error("SpringmvnNewController.exportComExcel", (Object)"param is null");
                        return;
                    }
                    FmUsermfileDomain exportInfo = this.prepareExportInfo(paramMap, infoMap);
                    if (exportInfo == null) {
                        logger.error("\u5bfc\u51faExcel\u5931\u8d25", (Object)"exportInfo is error");
                        return;
                    }
                    List<Map<String, Object>> headMapList = this.headMapList(infoMap);
                    ArrayList<String> excelHeader = new ArrayList<String>();
                    ArrayList<String> exceldataName = new ArrayList<String>();
                    for (Map<String, Object> map : headMapList) {
                        String showName = map.get("showName").toString();
                        String dataName = map.get("dataName").toString();
                        excelHeader.add(showName);
                        exceldataName.add(dataName);
                    }
                    String[] headers = excelHeader.toArray(new String[excelHeader.size()]);
                    String[] dataNames = exceldataName.toArray(new String[exceldataName.size()]);
                    if (headers == null || headers.length == 0) {
                        SpringmvcNewController.updateTaskStatus(exportInfo.getUsermfileCode(), -1, "\u5931\u8d25:headers is null");
                        this.updateUsermfileListStateByCode(exportInfo.getTenantCode(), exportInfo.getUsermfileCode(), -1, null);
                        return;
                    }
                    workbook = null;
                    outputStream = null;
                    try {
                        SpringmvcNewController.updateTaskStatus(exportInfo.getUsermfileCode(), 5, "\u51c6\u5907\u6570\u636e");
                        this.updateUsermfileListStateByCode(exportInfo.getTenantCode(), exportInfo.getUsermfileCode(), 1, null);
                        workbook = new SXSSFWorkbook(100);
                        workbook.setCompressTempFiles(true);
                        SXSSFSheet sheet = workbook.createSheet(exportInfo.getUsermfileUrlname());
                        this.createHeaderRow(workbook, sheet, headers);
                        SupQueryResult<Object> queryResult = this.queryCount(paramMap, apiRouter);
                        if (null == queryResult) {
                            logger.error("SpringmvnNewController.queryResult", (Object)"queryResult is blank");
                            SpringmvcNewController.updateTaskStatus(exportInfo.getUsermfileCode(), -1, "\u5931\u8d25:queryResult is null");
                            this.updateUsermfileListStateByCode(exportInfo.getTenantCode(), exportInfo.getUsermfileCode(), -1, null);
                            return;
                        }
                        int totalRows = this.writeDataToSheet(workbook, sheet, dataNames, paramMap, apiRouter, excelTemplate, exportInfo.getUsermfileCode(), queryResult.getTotal());
                        if (totalRows == 0) {
                            logger.error("SpringmvnNewController.exportComExcel", (Object)"No data to export");
                            SpringmvcNewController.updateTaskStatus(exportInfo.getUsermfileCode(), -1, "\u5931\u8d25: No data to export");
                            this.updateUsermfileListStateByCode(exportInfo.getTenantCode(), exportInfo.getUsermfileCode(), -1, null);
                            return;
                        }
                        File tempFile = new File(tempPath = tempPath + exportInfo.getUsermfileUrlname() + "." + exportInfo.getMfileCtype());
                        File parentDir = tempFile.getParentFile();
                        if (!parentDir.exists() && !parentDir.mkdirs()) {
                            logger.error("SpringmvnNewController.exportComExcel", (Object)"Failed to create temp directory");
                            SpringmvcNewController.updateTaskStatus(exportInfo.getUsermfileCode(), -1, "\u5931\u8d25: Failed to create temp directory");
                            this.updateUsermfileListStateByCode(exportInfo.getTenantCode(), exportInfo.getUsermfileCode(), -1, null);
                            this.closeQuietly(outputStream);
                            if (workbook == null) break block30;
                            break block31;
                        }
                        outputStream = new FileOutputStream(tempPath);
                        workbook.write((OutputStream)outputStream);
                        outputStream.flush();
                        byte[] bytes = ExportExcelUtlis.InputStreamByteArray((String)tempPath);
                        FmFileReDomainBean fileReDomainBean = this.saveExcel(bytes, exportInfo.getUsermfileUrlname(), exportInfo.getUserCode(), exportInfo.getMfileCtype(), exportInfo.getTenantCode());
                        SpringmvcNewController.updateTaskStatus(exportInfo.getUsermfileCode(), 100, "\u5b8c\u6210");
                        this.updateUsermfileListStateByCode(exportInfo.getTenantCode(), exportInfo.getUsermfileCode(), 2, null != fileReDomainBean ? fileReDomainBean.getFileUrl() : null);
                        this.closeQuietly(outputStream);
                        break block32;
                    }
                    catch (Exception e) {
                        logger.error("SpringmvnNewController.exportComExcel", (Object)"Exception during export", (Throwable)e);
                        SpringmvcNewController.updateTaskStatus(exportInfo.getUsermfileCode(), -1, "\u5931\u8d25: " + e.getMessage());
                        this.updateUsermfileListStateByCode(exportInfo.getTenantCode(), exportInfo.getUsermfileCode(), -1, null);
                        return;
                    }
                }
                try {
                    workbook.dispose();
                }
                catch (Exception e) {
                    logger.warn("SpringmvnNewController.exportComExcel", (Object)"Error disposing workbook", (Throwable)e);
                }
            }
            if (tempPath == null) return;
            this.deleteTempFile(tempPath);
            return;
        }
        if (workbook != null) {
            try {
                workbook.dispose();
            }
            catch (Exception e) {
                logger.warn("SpringmvnNewController.exportComExcel", (Object)"Error disposing workbook", (Throwable)e);
            }
        }
        if (tempPath == null) return;
        this.deleteTempFile(tempPath);
        return;
        finally {
            this.closeQuietly(outputStream);
            if (workbook != null) {
                try {
                    workbook.dispose();
                }
                catch (Exception e) {
                    logger.warn("SpringmvnNewController.exportComExcel", (Object)"Error disposing workbook", (Throwable)e);
                }
            }
            if (tempPath != null) {
                this.deleteTempFile(tempPath);
            }
        }
    }

    private List<Map<String, Object>> headMapList(Map<String, Object> infoMap) {
        Object headMap = infoMap.get("headMap");
        if (null == headMap) {
            logger.error("SpringmvnNewController.exportComExcel.headMap", (Object)(" =:= " + infoMap));
            return null;
        }
        List headMapList = JsonUtil.buildNormalBinder().getJsonToListByMap(JsonUtil.buildNormalBinder().toJson(headMap), Object.class);
        if (ListUtil.isEmpty((Collection)headMapList)) {
            logger.error("SpringmvnNewController.exportComExcel.headMapList", (Object)(" is null " + JsonUtil.buildNormalBinder().toJson(headMap)));
            return null;
        }
        return headMapList;
    }

    private void createHeaderRow(SXSSFWorkbook workbook, SXSSFSheet sheet, String[] headers) {
        SXSSFRow row = sheet.createRow(0);
        CellStyle headerStyle = this.createHeaderStyle(workbook);
        for (int i = 0; i < headers.length; ++i) {
            SXSSFCell cell = row.createCell(i);
            cell.setCellValue(headers[i]);
            cell.setCellStyle(headerStyle);
            sheet.trackColumnForAutoSizing(i);
        }
    }

    private CellStyle createHeaderStyle(SXSSFWorkbook workbook) {
        CellStyle style = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontName("\u4eff\u5b8b_GB2312");
        font.setFontHeightInPoints((short)10);
        font.setBold(true);
        style.setFont(font);
        return style;
    }

    private int writeDataToSheet(SXSSFWorkbook workbook, SXSSFSheet sheet, String[] dataNames, Map<String, Object> paramMap, String apiRouter, String excelTemplate, String taskId, long total) {
        int totalRows = 0;
        int page = null == paramMap.get("page") ? 1 : Integer.valueOf(paramMap.get("page").toString());
        CellStyle dataStyle = this.createDataStyle(workbook);
        String api = apiRouter;
        if (null != paramMap.get("sendParamMap")) {
            api = JsonUtil.buildNonDefaultBinder().toJson(paramMap);
        }
        while (true) {
            paramMap.put("page", page);
            SpringmvcNewController.makePage(paramMap);
            PostParamMap pmap = new PostParamMap(apiRouter);
            pmap.putParamToJson("map", paramMap);
            String json = this.htmlIBaseService.sendMesReJson(pmap);
            List<Map<String, Object>> fromDataList = this.makeExcelData(json, api, excelTemplate);
            if (ListUtil.isEmpty(fromDataList)) break;
            for (Map<String, Object> dataMap : fromDataList) {
                SXSSFRow row = sheet.createRow(totalRows + 1);
                for (int i = 0; i < dataNames.length; ++i) {
                    SXSSFCell cell = row.createCell(i);
                    String beanName = dataNames[i];
                    String value = "";
                    if (StringUtils.isNotBlank((String)beanName)) {
                        String string = value = null == dataMap.get(beanName) ? "" : String.valueOf(dataMap.get(beanName));
                        if ("null".equals(value)) {
                            value = "";
                        }
                    }
                    cell.setCellValue(value);
                    cell.setCellStyle(dataStyle);
                }
                if (++totalRows % 100 != 0) continue;
                try {
                    sheet.flushRows(100);
                }
                catch (IOException e) {
                    logger.warn("SpringmvnNewController.exportComExcel", (Object)"Error flushing rows", (Throwable)e);
                }
            }
            int progress = (int)((long)(totalRows * 95) / total) + 5;
            if (progress >= 99) {
                progress = 99;
            }
            SpringmvcNewController.updateTaskStatus(taskId, progress, String.format("\u5bfc\u51fa\u4e2d %d/%d", progress, 100));
            ++page;
        }
        logger.info("SpringmvnNewController.exportComExcel", (Object)("No more data at page " + page));
        for (int i = 0; i < dataNames.length; ++i) {
            sheet.autoSizeColumn(i);
        }
        return totalRows;
    }

    private CellStyle createDataStyle(SXSSFWorkbook workbook) {
        CellStyle style = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontName("\u4eff\u5b8b_GB2312");
        font.setFontHeightInPoints((short)10);
        style.setFont(font);
        return style;
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                logger.warn("SpringmvnNewController.exportComExcel", (Object)"Error closing stream", (Throwable)e);
            }
        }
    }

    private void deleteTempFile(String filePath) {
        try {
            File file = new File(filePath);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            logger.warn("SpringmvnNewController.exportComExcel", (Object)"Error deleting temp file", (Throwable)e);
        }
    }

    private FmFileReDomainBean saveExcel(byte[] bytes, String fileName, String userCode, String fileType, String tenantCode) {
        if (bytes == null || bytes.length <= 0 || StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)tenantCode)) {
            logger.error("SpringmvnNewController.exportComExcel.saveExcel", (Object)(bytes.length + "-" + fileName + "-" + userCode + "--" + fileType + "-" + tenantCode));
            return null;
        }
        FmFileReDomainBean fmFileReDomainBean = new FmFileReDomainBean();
        fmFileReDomainBean.setFileName(fileName);
        fmFileReDomainBean.setFileOwner(userCode);
        fmFileReDomainBean.setFileType("0");
        fmFileReDomainBean.setFileContext(bytes);
        FileBean fileBean = new FileBean();
        fileBean.setBytes(Base64.encodeBase64((byte[])bytes));
        fileBean.setFileType(fileType);
        fileBean.setOriginalFilename(fileName);
        fileBean.setSize(Long.valueOf(1L));
        return this.saveFile(fileBean, tenantCode, "FILE_11", fmFileReDomainBean);
    }

    private FmFileReDomainBean saveFile(FileBean fileBean, String tenantCode, String fileSort, FmFileDomainBean FmFileDomainBeanBean) {
        if (null == FmFileDomainBeanBean || null == fileBean) {
            logger.error("SpringmvnNewController.exportComExcel.saveFile", (Object)"param is null");
            return null;
        }
        FmFileReDomainBean fmFileReDomainBean = null;
        try {
            PostParamMap pmap = new PostParamMap("fm.file.saveFileStr");
            FmFileDomainBeanBean.setFileType("0");
            FmFileDomainBeanBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
            FmFileDomainBeanBean.setTenantCode(tenantCode);
            FmFileDomainBeanBean.setRootPath(tenantCode + "/");
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            fileBeanList.add(fileBean);
            pmap.putParamToJson("fmFileDomainBeanStr", (Object)FmFileDomainBeanBean);
            pmap.putParamToJson("fileBeanListStr", fileBeanList);
            fmFileReDomainBean = (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFileReDomainBean.class);
        }
        catch (Exception e) {
            logger.error("SpringmvnNewController.exportComExcel.saveFile", (Object)"Exception", (Throwable)e);
            return null;
        }
        return fmFileReDomainBean;
    }

    private FmUsermfileDomain prepareExportInfo(Map<String, Object> paramMap, Map<String, Object> infoMap) {
        try {
            String fileName = infoMap.get("fileName") != null ? infoMap.get("fileName").toString() : "export";
            fileName = sdf.format(new Date()) + "-" + fileName;
            FmUsermfileDomain fmUsermfileDomain = new FmUsermfileDomain();
            fmUsermfileDomain.setTenantCode((String)paramMap.get("tenantCode"));
            fmUsermfileDomain.setUserCode(infoMap.get("userCode").toString());
            fmUsermfileDomain.setUsermfileUrlname(fileName);
            fmUsermfileDomain.setMfileCtype("xls");
            fmUsermfileDomain.setMfileType("1");
            fmUsermfileDomain.setMfileSort("FILE_11");
            fmUsermfileDomain.setUsermfileWhere(JsonUtil.buildNonDefaultBinder().toJson(paramMap));
            HtmlJsonReBean htmlJsonReBean = this.saveUsermfile(fmUsermfileDomain);
            if (htmlJsonReBean.isSuccess()) {
                fmUsermfileDomain.setUsermfileCode(htmlJsonReBean.getDataObj().toString());
                return fmUsermfileDomain;
            }
        }
        catch (Exception e) {
            logger.error("\u51c6\u5907\u5bfc\u51fa\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return null;
        }
        return null;
    }

    public static void makePage(Map<String, Object> map) {
        String rows;
        String page;
        if (null == map || map.isEmpty()) {
            return;
        }
        String string = page = null == map.get(ui_page) ? "1" : map.get(ui_page).toString();
        if (null == page) {
            return;
        }
        if (StringUtils.isBlank((String)page)) {
            page = "1";
        }
        String string2 = rows = null == map.get(ui_rows) ? "0" : map.get(ui_rows).toString();
        if (StringUtils.isBlank((String)rows) || "0".equals(rows)) {
            rows = "10";
        }
        map.put(dao_startRow, Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue());
        map.put(dao_endRow, Long.valueOf(Long.valueOf(rows).intValue() * Long.valueOf(page).intValue()).intValue());
        map.put(ui_rows, Long.valueOf(rows).intValue());
        map.put(ui_page, Long.valueOf(page).intValue());
    }

    public SupQueryResult<Object> queryCount(Map<String, Object> paramMap, String apiRouter) {
        paramMap.put(dao_startRow, 0);
        paramMap.put(dao_endRow, 0);
        paramMap.put(ui_rows, 0);
        PostParamMap pmap = new PostParamMap(apiRouter);
        pmap.putParamToJson("map", paramMap);
        return this.htmlIBaseService.sendReSupObject(pmap, Object.class);
    }

    public HtmlJsonReBean saveUsermfile(FmUsermfileDomain fmUsermfileDomain) {
        PostParamMap pmap = new PostParamMap("fm.file.saveUsermfile");
        pmap.putParamToJson("fmUsermfileDomain", (Object)fmUsermfileDomain);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateUsermfileListStateByCode(String tenantCode, String usermfileListCode, Integer dataState, String url) {
        PostParamMap pmap = new PostParamMap("fm.file.updateUsermfileStateByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("usermfileCode", (Object)usermfileListCode);
        pmap.putParam("dataState", (Object)dataState);
        if (StringUtils.isNotBlank((String)url)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("usermfileUrl", url);
            pmap.putParamToJson("map", map);
        }
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public HtmlJsonReBean updateUsermfileListStateByCode(String tenantCode, String usermfileListCode, Integer dataState, String url, String memo) {
        PostParamMap pmap = new PostParamMap("fm.file.updateUsermfileStateByCode");
        pmap.putParam("tenantCode", (Object)tenantCode);
        pmap.putParam("usermfileCode", (Object)usermfileListCode);
        pmap.putParam("dataState", (Object)dataState);
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)url)) {
            map.put("usermfileUrl", url);
        }
        if (StringUtils.isNotBlank((String)memo)) {
            map.put("memo", memo);
        }
        pmap.putParamToJson("map", map);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    public void exportComExcelImport(HttpServletRequest request, MultipartFile multipartFile, final Map<String, Object> infoMap, final String apiRouter, final String excelTemplate) throws IOException {
        try {
            final File file = SpringmvcNewController.uploadFile(multipartFile);
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    FmUsermfileDomain fmUsermfileDomain = SpringmvcNewController.this.prepareExportInfoImport(infoMap);
                    SpringmvcNewController.this.makeWorkbook(file, fmUsermfileDomain, SpringmvcNewController.tempPath, infoMap, apiRouter, excelTemplate);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static File uploadFile(MultipartFile multipartFile) throws IOException {
        String fileName = UUID.randomUUID().toString() + "_" + multipartFile.getOriginalFilename();
        File file = new File(TEMP, fileName);
        try {
            multipartFile.transferTo(file);
            return file;
        }
        catch (IOException e) {
            if (!file.exists() || !file.delete()) {
                // empty if block
            }
            throw e;
        }
    }

    private FmUsermfileDomain prepareExportInfoImport(Map<String, Object> infoMap) {
        try {
            String fileName = infoMap.get("fileName") != null ? infoMap.get("fileName").toString() : "export";
            fileName = sdf.format(new Date()) + "-" + fileName;
            FmUsermfileDomain fmUsermfileDomain = new FmUsermfileDomain();
            fmUsermfileDomain.setTenantCode((String)infoMap.get("tenantCode"));
            fmUsermfileDomain.setUserCode(infoMap.get("userCode").toString());
            fmUsermfileDomain.setUsermfileUrlname(fileName);
            fmUsermfileDomain.setMfileCtype("xlsx");
            fmUsermfileDomain.setMfileType("2");
            fmUsermfileDomain.setMfileSort("FILE_11");
            fmUsermfileDomain.setMenuCode((String)infoMap.get("menuCode"));
            fmUsermfileDomain.setUsermfileCode((String)infoMap.get("menuCode"));
            HtmlJsonReBean htmlJsonReBean = this.saveUsermfile(fmUsermfileDomain);
            if (htmlJsonReBean.isSuccess()) {
                fmUsermfileDomain.setUsermfileCode(htmlJsonReBean.getDataObj().toString());
                return fmUsermfileDomain;
            }
        }
        catch (Exception e) {
            logger.error("\u51c6\u5907\u5bfc\u51fa\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return null;
        }
        return null;
    }

    public static void main(String[] args) {
        ArrayList<Object> rowData = new ArrayList<Object>();
        rowData.add(null);
        rowData.add(null);
        System.out.println(JsonUtil.buildNormalBinder().toJson(rowData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeWorkbook(File file, FmUsermfileDomain exportInfo, String tempPath, Map<String, Object> infoMap, String apiRouter, String excelTemplate) {
        FileInputStream fis = null;
        XSSFWorkbook templateWorkbook = null;
        SXSSFWorkbook sXSSFWorkbook = null;
        FileOutputStream outputStream = null;
        int success = 0;
        int error = 0;
        int lastRowNum = 0;
        try {
            fis = new FileInputStream(file);
            templateWorkbook = new XSSFWorkbook((InputStream)fis);
            XSSFSheet templateSheet = templateWorkbook.getSheetAt(0);
            lastRowNum = templateSheet.getLastRowNum();
            SpringmvcNewController.updateTaskStatus(exportInfo.getUsermfileCode(), 5, success, error, lastRowNum, "\u51c6\u5907\u6570\u636e");
            this.updateUsermfileListStateByCode(exportInfo.getTenantCode(), exportInfo.getUsermfileCode(), 1, null);
            ArrayList<String> excelHeader = new ArrayList<String>();
            Row headerRow = templateSheet.getRow(0);
            if (headerRow != null) {
                for (Cell cell : headerRow) {
                    String cellValueAsString = SpringmvcNewController.getCellValueAsString(cell);
                    if (!StringUtils.isNotBlank((String)cellValueAsString)) continue;
                    excelHeader.add(cellValueAsString);
                }
            }
            int size = excelHeader.size();
            excelHeader.add("\u5904\u7406\u72b6\u6001");
            excelHeader.add("\u5931\u8d25\u539f\u56e0");
            sXSSFWorkbook = new SXSSFWorkbook(100);
            sXSSFWorkbook.setCompressTempFiles(true);
            SXSSFSheet sXSSFSheet = sXSSFWorkbook.createSheet(exportInfo.getUsermfileUrlname());
            String[] headers = excelHeader.toArray(new String[excelHeader.size()]);
            this.createHeaderRow(sXSSFWorkbook, sXSSFSheet, headers);
            CellStyle dataStyle = this.createDataStyle(sXSSFWorkbook);
            int totalRows = 0;
            HashMap<String, Object> sendmap = new HashMap<String, Object>();
            sendmap.putAll(infoMap);
            for (int r = 1; r <= lastRowNum; ++r) {
                SXSSFCell cell;
                Row templateRow = templateSheet.getRow(r);
                if (templateRow == null) continue;
                SXSSFRow dataRow = sXSSFSheet.createRow(++totalRows);
                ArrayList<String> rowData = new ArrayList<String>();
                for (int i = 0; i < size; ++i) {
                    Cell cell2 = templateRow.getCell(i, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
                    rowData.add(SpringmvcNewController.getCellValueAsString(cell2));
                }
                boolean b = r == lastRowNum;
                sendmap.put("finishState", b);
                HtmlJsonReBean processResult = this.importExcelData(apiRouter, excelTemplate, rowData, sendmap);
                String[] dataArray = rowData.toArray(new String[0]);
                for (int i = 0; i < dataArray.length; ++i) {
                    SXSSFCell cell3 = dataRow.createCell(i);
                    cell3.setCellValue(dataArray[i]);
                    cell3.setCellStyle(dataStyle);
                }
                if (processResult.isSuccess()) {
                    ++success;
                    cell = dataRow.createCell(size);
                    cell.setCellValue("\u5904\u7406\u6210\u529f");
                    cell.setCellStyle(dataStyle);
                } else {
                    ++error;
                    cell = dataRow.createCell(size);
                    cell.setCellValue("\u5904\u7406\u5931\u8d25");
                    cell.setCellStyle(dataStyle);
                    cell = dataRow.createCell(size + 1);
                    cell.setCellValue(processResult.getMsg());
                    cell.setCellStyle(dataStyle);
                }
                if (totalRows % 100 == 0) {
                    sXSSFSheet.flushRows(100);
                }
                if (lastRowNum <= 0) continue;
                int progress = Math.min(99, 5 + (int)((double)totalRows * 95.0 / (double)lastRowNum));
                SpringmvcNewController.updateTaskStatus(exportInfo.getUsermfileCode(), progress, success, error, lastRowNum, String.format("\u5bfc\u51fa\u4e2d %d/%d", totalRows, lastRowNum));
            }
            File outputFile = new File(tempPath = tempPath + exportInfo.getUsermfileUrlname() + "." + exportInfo.getMfileCtype());
            File parentDir = outputFile.getParentFile();
            if (!parentDir.exists() && !parentDir.mkdirs()) {
                logger.error("SpringmvnNewController.makeWorkbook", (Object)("\u65e0\u6cd5\u521b\u5efa\u4e34\u65f6\u76ee\u5f55" + parentDir.getAbsolutePath()));
                SpringmvcNewController.updateTaskStatus(exportInfo.getUsermfileCode(), -1, success, error, lastRowNum, "\u65e0\u6cd5\u521b\u5efa\u4e34\u65f6\u76ee\u5f55:" + parentDir.getAbsolutePath());
                this.updateUsermfileListStateByCode(exportInfo.getTenantCode(), exportInfo.getUsermfileCode(), -1, null);
            }
            outputStream = new FileOutputStream(outputFile);
            sXSSFWorkbook.write((OutputStream)outputStream);
            outputStream.flush();
            byte[] fileBytes = ExportExcelUtlis.InputStreamByteArray((String)tempPath);
            FmFileReDomainBean fileResult = this.saveExcel(fileBytes, exportInfo.getUsermfileUrlname(), exportInfo.getUserCode(), exportInfo.getMfileCtype(), exportInfo.getTenantCode());
            SpringmvcNewController.updateTaskStatus(exportInfo.getUsermfileCode(), 100, success, error, lastRowNum, "\u5b8c\u6210");
            this.updateUsermfileListStateByCode(exportInfo.getTenantCode(), exportInfo.getUsermfileCode(), 2, fileResult != null ? fileResult.getFileUrl() : null, success + "\u6761\u6210\u529f," + error + "\u6761\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error("SpringmvnNewController.makeWorkbook", (Object)"\u5bfc\u51fa\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            SpringmvcNewController.updateTaskStatus(exportInfo.getUsermfileCode(), -1, success, error, lastRowNum, "\u5931\u8d25: " + e.getMessage());
            this.updateUsermfileListStateByCode(exportInfo.getTenantCode(), exportInfo.getUsermfileCode(), -1, null);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                logger.warn("\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25", (Object)e);
            }
            if (sXSSFWorkbook != null) {
                try {
                    sXSSFWorkbook.close();
                    sXSSFWorkbook.dispose();
                }
                catch (IOException e) {
                    logger.warn("\u6e05\u7406SXSSFWorkbook\u5931\u8d25", (Object)e);
                }
            }
            try {
                if (templateWorkbook != null) {
                    templateWorkbook.close();
                }
            }
            catch (IOException e) {
                logger.warn("\u5173\u95ed\u6a21\u677f\u5de5\u4f5c\u7c3f\u5931\u8d25", (Object)e);
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                logger.warn("\u5173\u95ed\u8f93\u5165\u6d41\u5931\u8d25", (Object)e);
            }
            if (tempPath != null) {
                this.deleteTempFile(tempPath);
            }
        }
    }

    private static String getCellValueAsString(Cell cell) {
        if (cell == null) {
            return "";
        }
        String cellValue = "";
        int cellType = cell.getCellType();
        switch (cellType) {
            case 1: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = cell.getDateCellValue();
                    cellValue = new SimpleDateFormat("yyyy-MM-dd").format(date);
                    break;
                }
                double value = cell.getNumericCellValue();
                if (Math.abs(value - (double)Math.round(value)) < 1.0E-6) {
                    cellValue = String.valueOf((long)value);
                    break;
                }
                cellValue = String.format("%.2f", value);
                break;
            }
            case 4: {
                cellValue = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 2: {
                cellValue = cell.getCellFormula();
                break;
            }
            case 3: {
                cellValue = "";
                break;
            }
            default: {
                cellValue = cell.toString();
            }
        }
        return cellValue;
    }
}

