/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.resources;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.rs.EditSkuDomain;
import cn.com.qj.bff.domain.rs.ResourcesConstants;
import cn.com.qj.bff.domain.rs.ReturnBean;
import cn.com.qj.bff.domain.rs.RsGoodsFileDomain;
import cn.com.qj.bff.domain.rs.RsGoodsRelDomain;
import cn.com.qj.bff.domain.rs.RsGoodsRelReDomain;
import cn.com.qj.bff.domain.rs.RsGoodsShopDomain;
import cn.com.qj.bff.domain.rs.RsGoodsWhDomain;
import cn.com.qj.bff.domain.rs.RsPropertiesValueDomain;
import cn.com.qj.bff.domain.rs.RsResourceGoodsDomain;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.domain.rs.RsSkuDomain;
import cn.com.qj.bff.domain.rs.RsSkuReDomain;
import cn.com.qj.bff.domain.rs.RsSpecValueDomain;
import cn.com.qj.bff.service.rs.RsGoodsClassService;
import cn.com.qj.bff.service.rs.RsGoodsOtherService;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.service.rs.RsResourceService;
import cn.com.qj.bff.service.rs.RsSkuService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/sku"}, name="\u5546\u54c1SKU")
public class RsSkuCon
extends SpringmvcController {
    @Autowired
    private RsSkuService rsSkuService;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;
    @Autowired
    private RsGoodsOtherService rsGoodsOtherService;
    @Autowired
    private RsResourceService rsResourceService;
    @Autowired
    private RsGoodsClassService rsGoodsClassService;
    private static final String CODE = "rs.sku.con";

    @Override
    protected String getContext() {
        return "sku";
    }

    @RequestMapping(value={"saveSku.json"}, name="\u589e\u52a0\u5546\u54c1SKU")
    @ResponseBody
    public HtmlJsonReBean saveSku(HttpServletRequest request, RsSkuReDomain rsSkuReDomain) {
        if (null == rsSkuReDomain) {
            this.logger.error("rs.sku.con.saveSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSkuReDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSkuService.saveSku(rsSkuReDomain);
    }

    @RequestMapping(value={"getSku.json"}, name="\u83b7\u53d6\u5546\u54c1SKU\u4fe1\u606f")
    @ResponseBody
    public RsSkuReDomain getSku(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error("rs.sku.con.getSku", (Object)"param is null");
            return null;
        }
        return this.rsSkuService.getSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"getSkuFromXn.json"}, name="\u83b7\u53d6\u5546\u54c1SKU\u4fe1\u606f-\u865a\u62df")
    @ResponseBody
    public RsSkuReDomain getSkuFromXn(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error("rs.sku.con.getSkuFromXn", (Object)"param is null");
            return null;
        }
        return this.rsSkuService.getSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"getSkuFromFd.json"}, name="\u83b7\u53d6\u5546\u54c1SKU\u4fe1\u606f-\u798f\u70b9")
    @ResponseBody
    public RsSkuReDomain getSkuFromFd(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error("rs.sku.con.getSkuFromFd", (Object)"param is null");
            return null;
        }
        return this.rsSkuService.getSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"getSkuBySpec.json"}, name="\u6839\u636eSpec\u4fe1\u606f\u53d6\u5546\u54c1SKU")
    @ResponseBody
    public RsSkuReDomain getSkuBySpec(HttpServletRequest request, String specStr, String goodsCode) {
        if (StringUtils.isBlank((String)specStr) || StringUtils.isBlank((String)goodsCode)) {
            this.logger.error("rs.sku.con.getSkuByName", (Object)"param is null");
            return null;
        }
        List<String> specList = Arrays.asList(specStr.split("\\/"));
        return this.rsSkuService.getSkuBySpec(specList, goodsCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"getSkuBySpecNew.json"}, name="\u6839\u636eSpec\u4fe1\u606f\u53d6\u5546\u54c1SKU")
    @ResponseBody
    public RsSkuReDomain getSkuBySpecNew(HttpServletRequest request, String specStr, String goodsCode) {
        if (StringUtils.isBlank((String)specStr) || StringUtils.isBlank((String)goodsCode)) {
            this.logger.error("rs.sku.con.getSkuBySpecNew", (Object)"param is null");
            return null;
        }
        List list = JsonUtil.buildNormalBinder().getJsonToList(specStr, String.class);
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error("rs.sku.con.getSkuBySpecnewStr", (Object)"param is null");
            return null;
        }
        return this.rsSkuService.getSkuBySpec(list, goodsCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"updateSku.json"}, name="\u7f16\u8f91\u5546\u54c1SKU")
    @ResponseBody
    public HtmlJsonReBean updateSku(HttpServletRequest request, RsSkuReDomain rsSkuReDomain) {
        if (null == rsSkuReDomain) {
            this.logger.error("rs.sku.con.updateSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        rsSkuReDomain.setTenantCode(this.getTenantCode(request));
        return this.rsSkuService.updateSku(rsSkuReDomain);
    }

    @RequestMapping(value={"updateSkuFromTc.json"}, name="\u7f16\u8f91\u5546\u54c1SKU-\u5957\u9910")
    @ResponseBody
    public HtmlJsonReBean updateSkuFromTc(String goodsCode, String skuCode, String paramStr) {
        if (null == paramStr) {
            this.logger.error("rs.sku.con.updateSkuFromTc", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List list = JsonUtil.buildNormalBinder().getJsonToList(paramStr, RsSkuDomain.class);
        if (null == list || list.size() <= 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsSkuCode", skuCode);
        map.put("goodsRelType", "3");
        SupQueryResult<RsGoodsRelReDomain> supQueryResult = this.rsGoodsOtherService.queryGoodsRelPage(map);
        if (null == supQueryResult || null == supQueryResult.getList() || supQueryResult.getList().size() <= 0) {
            this.logger.info("rs.sku.con.updateSkuFromTc", (Object)"\u65e0\u5bf9\u5e94\u4fe1\u606f");
        }
        HtmlJsonReBean deleteRes = null;
        this.logger.info("rs.sku.con.updateSkuFromTc", (Object)JsonUtil.buildNonDefaultBinder().toJson(supQueryResult));
        if (ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
            for (RsGoodsRelReDomain rsGoodsRelReDomain : supQueryResult.getList()) {
                deleteRes = this.rsGoodsOtherService.deleteGoodsRel(rsGoodsRelReDomain.getGoodsRelId());
            }
        }
        if (null == deleteRes) {
            this.logger.info("rs.sku.con.updateSkuFromTc", (Object)"\u5173\u8054\u5173\u7cfb\u5220\u9664\u5931\u8d25");
        }
        ArrayList<RsGoodsRelDomain> rsGoodsRelDomainList = new ArrayList<RsGoodsRelDomain>();
        for (RsSkuDomain rsSkuReDomain : list) {
            RsGoodsRelDomain rsGoodsRelDomain = new RsGoodsRelDomain();
            rsGoodsRelDomain.setGoodsSkuCode(skuCode);
            rsGoodsRelDomain.setGoodsRelGcode(rsSkuReDomain.getGoodsCode());
            rsGoodsRelDomain.setGoodsRelType("3");
            rsGoodsRelDomain.setMemberCode(rsSkuReDomain.getMemberCode());
            rsGoodsRelDomain.setMemberName(rsSkuReDomain.getMemberName());
            rsGoodsRelDomain.setSkuCode(rsSkuReDomain.getSkuCode());
            rsGoodsRelDomain.setSkuName(rsSkuReDomain.getSkuName());
            rsGoodsRelDomain.setPricesetNprice(rsSkuReDomain.getPricesetNprice());
            rsGoodsRelDomain.setGoodsNum(rsSkuReDomain.getGoodsNum());
            rsGoodsRelDomain.setDataPic(rsSkuReDomain.getDataPic());
            rsGoodsRelDomain.setTenantCode(rsSkuReDomain.getTenantCode());
            rsGoodsRelDomainList.add(rsGoodsRelDomain);
            this.logger.info("rs.sku.con.updateSkuFromTc.rsGoodsRelDomainList", (Object)JsonUtil.buildNonDefaultBinder().toJson(rsGoodsRelDomainList));
            this.rsSkuService.updateSku(rsSkuReDomain);
        }
        return this.rsGoodsOtherService.saveGoodsRelList(rsGoodsRelDomainList);
    }

    @RequestMapping(value={"deleteSku.json"}, name="\u5220\u9664\u5546\u54c1SKU")
    @ResponseBody
    public HtmlJsonReBean deleteSku(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error("rs.sku.con.deleteSku", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuService.deleteSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"querySkuPage.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuForPla.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u5e73\u53f0\u5546\u54c1\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuForPla(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuNotAudit.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u5f85\u5ba1\u6838\u5546\u54c1\u9875")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuNotAudit(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuPlaStop.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u505c\u7528\u5546\u54c1\u9875")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuPlaStop(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuForPlaAudit.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u4e0a\u67b6\u5546\u54c1\u9875")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuForPlaAudit(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuForSupCannel.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u4f9b\u5e94\u5546\u4e0b\u67b6\u9875")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuForSupCannel(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuNotOnShelf.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u5f85\u4e0a\u67b6\u5546\u54c1\u9875")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuNotOnShelf(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuNotOnShelfOl.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u5f85\u4e0a\u67b6\u5546\u54c1\u9875")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuNotOnShelfOl(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuNotOnShelfForAt.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u5f85\u4e0a\u67b6\u5546\u54c1\u9875")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuNotOnShelfForAt(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuForPass.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuNotOnShelfPalt(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        param.put("goodsOrigin", "0");
        SupQueryResult<RsSkuReDomain> result = this.querySkuMain(param);
        RsResourceGoodsReDomain goodsReDomain = this.rsResourceGoodsService.getResourceGoodsByCode(param);
        List list = result.getList();
        this.makeSkuPic(list, goodsReDomain.getDataPic());
        return result;
    }

    private void makeSkuPic(List<RsSkuReDomain> rsSkuReDomains, String dataPic) {
        for (RsSkuReDomain rsSkuReDomain : rsSkuReDomains) {
            if (!StringUtils.isBlank((String)rsSkuReDomain.getDataPic())) continue;
            rsSkuReDomain.setDataPic(dataPic);
        }
    }

    @RequestMapping(value={"querySkuForPassStore.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u5e73\u53f0\u770b\u95e8\u5e97")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuForPassStore(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        param.put("goodsOrigin", "17");
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuForPassSStore.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u5e73\u53f0\u770b\u95e8\u5e97\u6e20\u9053")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuForPassSStore(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuForStore.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u95e8\u5e97")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuForStore(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        param.put("goodsOrigin", "17");
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuForSStore.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u95e8\u5e97\u7b2c\u4e09\u65b9")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuForSStore(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        param.put("goodsOrigin", "18");
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuForMem.json"}, name="\u5546\u54c1SKU\u5217\u8868-\u5546\u5bb6\u5546\u54c1\u9875")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuForMem(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"updateAuditOrCannel.json"}, name="\u6302\u724c\u4e0a\u67b6or\u4e0b\u67b6")
    @ResponseBody
    public HtmlJsonReBean updateAuditOrCannel(String skuIds, String flag) {
        return this.updateAuditOrCannels(skuIds, flag);
    }

    @RequestMapping(value={"updateAuditOrCannelForPass.json"}, name="\u6302\u724c\u4e0a\u67b6or\u4e0b\u67b6--\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean updateAuditOrCannelPalt(String skuIds, String flag) {
        return this.updateAuditOrCannels(skuIds, flag);
    }

    @RequestMapping(value={"updateAuditOrCannelForPassStore.json"}, name="\u6302\u724c\u4e0a\u67b6or\u4e0b\u67b6--\u5e73\u53f0\u770b\u95e8\u5e97")
    @ResponseBody
    public HtmlJsonReBean updateAuditOrCannelForPassStore(String skuIds, String flag) {
        return this.updateAuditOrCannels(skuIds, flag);
    }

    @RequestMapping(value={"updateAuditOrCannelForPassSStore.json"}, name="\u6302\u724c\u4e0a\u67b6or\u4e0b\u67b6--\u5e73\u53f0\u770b\u95e8\u5e97\u7b2c\u4e09\u65b9")
    @ResponseBody
    public HtmlJsonReBean updateAuditOrCannelForPassSStore(String skuIds, String flag) {
        return this.updateAuditOrCannels(skuIds, flag);
    }

    @RequestMapping(value={"updateAuditOrCannelForStore.json"}, name="\u6302\u724c\u4e0a\u67b6or\u4e0b\u67b6--\u95e8\u5e97")
    @ResponseBody
    public HtmlJsonReBean updateAuditOrCannelForStore(String skuIds, String flag) {
        return this.updateAuditOrCannels(skuIds, flag);
    }

    @RequestMapping(value={"updateAuditOrCannelForSStore.json"}, name="\u6302\u724c\u4e0a\u67b6or\u4e0b\u67b6--\u95e8\u5e97\u7b2c\u4e09\u65b9")
    @ResponseBody
    public HtmlJsonReBean updateAuditOrCannelForSStore(String skuIds, String flag) {
        return this.updateAuditOrCannels(skuIds, flag);
    }

    private HtmlJsonReBean updateAuditOrCannels(String skuIds, String flag) {
        if (StringUtils.isBlank((String)skuIds) || StringUtils.isBlank((String)flag)) {
            this.logger.error("rs.sku.con.updateAuditOrCannel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if ("1".equals(flag)) {
            return this.rsResourceGoodsService.sendUpdateShelveSku(Integer.valueOf(skuIds));
        }
        if ("0".equals(flag)) {
            return this.rsResourceGoodsService.sendUpdateSoldOutSku(Integer.valueOf(skuIds));
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
    }

    @RequestMapping(value={"querySkuPageFromPtFd.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5e73\u53f0\u798f\u70b9")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuPageFromPtFd(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuPageFromSh.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5206\u9500")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuPageFromSh(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuRelation.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5957\u9910\u5173\u8054sku\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuRelation(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        String skuCode = (String)param.get("skuCode");
        if (StringUtils.isBlank((String)skuCode)) {
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("goodsSkuCode", skuCode);
        SupQueryResult<RsGoodsRelReDomain> supQueryResult = this.rsGoodsOtherService.queryGoodsRelPage(map);
        if (null == supQueryResult || null == supQueryResult.getList() || supQueryResult.getList().size() <= 0) {
            return null;
        }
        HashMap<String, Object> skuMap = new HashMap<String, Object>();
        skuMap.put("tenantCode", tenantCode);
        ArrayList<RsSkuReDomain> resultList = new ArrayList<RsSkuReDomain>();
        HashMap<String, String> goodsCodeMap = new HashMap<String, String>();
        for (RsGoodsRelReDomain rsGoodsRelReDomain : supQueryResult.getList()) {
            skuMap.put("skuCode", rsGoodsRelReDomain.getSkuCode());
            RsSkuReDomain rsSkuReDomain = this.rsSkuService.getSkuByCode(skuMap);
            if (!goodsCodeMap.containsKey(rsSkuReDomain.getGoodsCode())) {
                RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsService.getResourceGoodsByCode(this.getQueryMapParam("goodsCode,tenantCode", rsSkuReDomain.getGoodsCode(), tenantCode));
                goodsCodeMap.put(rsSkuReDomain.getGoodsCode(), rsResourceGoodsReDomain.getGoodsName());
            }
            rsSkuReDomain.setGoodsName(String.valueOf(goodsCodeMap.get(rsSkuReDomain.getGoodsCode())));
            resultList.add(rsSkuReDomain);
        }
        SupQueryResult supQueryResult1 = new SupQueryResult();
        supQueryResult1.setList(resultList);
        supQueryResult1.setRows(resultList);
        return supQueryResult1;
    }

    @RequestMapping(value={"querySkuFromLt.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u8f6c\u76d8")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromLt(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("dataOpbillstate", 1);
            param.put("dataState", 2);
        }
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromFdRel.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u798f\u70b9\u53d1\u5e03")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromFdRel(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromXnRel.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u865a\u62df\u53d1\u5e03")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromXnRel(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromXn.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u865a\u62df")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromXn(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromFd.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u798f\u70b9")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromFd(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromReleGoo.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u53d1\u5e03\u5546\u54c1\u9875")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromReleGoo(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuService.querySkuOnePage(param);
    }

    @RequestMapping(value={"querySkuFromRepRel.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5e73\u53f0\u4ee3\u53d1")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromRepRel(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuService.querySkuOnePage(param);
    }

    @RequestMapping(value={"querySkuFromTcEdit.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5957\u9910\u7f16\u8f91")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromTcEdit(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "0");
        this.makeDefPage(param);
        return this.rsSkuService.querySkuOnePage(param);
    }

    @RequestMapping(value={"querySkuFromTc.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5957\u9910\u5546\u54c1")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromTc(HttpServletRequest request) {
        Map<String, Object> param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOriginot", "8");
        this.makeDefPage(param);
        return this.rsSkuService.querySkuOnePage(param);
    }

    @RequestMapping(value={"queryTSkuFromTc.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5957\u9910\u5546\u54c1-\u7248\u672c\u4e8c")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryTSkuFromTc(HttpServletRequest request) {
        Map<String, Object> param = this.getMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("goodsClass", "B2B");
            param.put("goodsType", "00");
            param.put("goodsPro", "0,11");
        }
        this.makeDefPage(param);
        return this.rsSkuService.querySkuOnePage(param);
    }

    @RequestMapping(value={"querySkuFromQy.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u6743\u76ca")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromQy(HttpServletRequest request) {
        return this.querySkuFromQyCom(request);
    }

    @RequestMapping(value={"querySkuFromQyForPlat.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u6743\u76ca\u7ed9\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromQyForPlat(HttpServletRequest request) {
        return this.querySkuFromQyCom(request);
    }

    private SupQueryResult<RsSkuReDomain> querySkuFromQyCom(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        this.makeDefPage(param);
        return this.rsSkuService.querySkuOnePage(param);
    }

    @RequestMapping(value={"querySkuFromJm.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u52a0\u76df")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromJm(HttpServletRequest request, String channelCode) {
        Map<String, Object> param = this.assemMapParam(request);
        param.put("channelCode", channelCode);
        this.logger.info("rs.sku.con.param", (Object)("===:=====" + param));
        return this.querySkuMain(param);
    }

    private SupQueryResult<RsSkuReDomain> querySkuMain(Map<String, Object> param) {
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        this.makeDefPage(param);
        return this.rsSkuService.querySkuOnePage(param);
    }

    @RequestMapping(value={"querySkuFromLb.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u793c\u5305")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromLb(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
            param.put("dataOpbillstate", 1);
            param.put("dataState", 2);
        }
        this.makeDefPage(param);
        return this.rsSkuService.querySkuOnePage(param);
    }

    @RequestMapping(value={"checkGoodsNo.json"}, name="\u6821\u9a8cSKU\u4e2d\u8d27\u54c1\u7f16\u53f7\u662f\u5426\u5b58\u5728")
    @ResponseBody
    public HtmlJsonReBean checkGoodsNo(HttpServletRequest request, String goodsNo, String skuNo, String goodsCode, String skuCode) {
        return this.checkGoodsNoMain(this.getTenantCode(request), goodsNo, skuNo, goodsCode, skuCode);
    }

    private HtmlJsonReBean checkGoodsNoMain(String tenantCode, String goodsNo, String skuNo, String goodsCode, String skuCode) {
        if (StringUtils.isBlank((String)skuNo)) {
            this.logger.error("rs.sku.con.checkGoodsNoMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtils.isNotBlank((String)skuNo)) {
            Map<String, Object> param = this.getQueryMapParam("skuNo,validFlag,tenantCode,skuOldcode", skuNo, true, tenantCode, "-1");
            SupQueryResult<RsSkuReDomain> rsList = this.rsSkuService.querySkuOnePage(param);
            if (null == rsList || null == rsList.getRows() || rsList.getRows().isEmpty()) {
                return new HtmlJsonReBean();
            }
            for (RsSkuReDomain rsSkuReDomain : rsList.getRows()) {
                if (rsSkuReDomain.getDataState() == -1 || StringUtils.isNotBlank((String)skuCode) && skuCode.equals(rsSkuReDomain.getSkuCode())) continue;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d27\u54c1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728");
            }
        }
        return new HtmlJsonReBean();
    }

    protected HtmlJsonReBean checkGoodsNoMain(HttpServletRequest request, String type, String goodsNo, String memberCode, String goodsCode, String channelCode) {
        if (StringUtils.isBlank((String)goodsNo)) {
            this.logger.error("rs.sku.con.checkGoodsNoMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error("rs.sku.con.checkGoodsNoMain.userSession", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateSkuState.json"}, name="\u7f16\u8f91\u5546\u54c1SKU\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateSkuState(String skuId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error("rs.sku.con.updateSkuState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuService.updateSkuState(Integer.valueOf(skuId), dataState, oldDataState);
    }

    @RequestMapping(value={"updateSkuFile.json"}, name="\u66f4\u65b0SKU\u6587\u4ef6(\u56fe\u7247,\u89c6\u9891)\u5217\u8868")
    @ResponseBody
    public HtmlJsonReBean updateSkuFile(HttpServletRequest request, String skuCode, String fileList) {
        return this.upfateSkuFiles(request, skuCode, fileList);
    }

    @RequestMapping(value={"updateSkuFilePass.json"}, name="\u66f4\u65b0SKU\u6587\u4ef6(\u56fe\u7247,\u89c6\u9891)\u5217\u8868--\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean updateSkuFilePalt(HttpServletRequest request, String skuCode, String fileList) {
        return this.upfateSkuFiles(request, skuCode, fileList);
    }

    @RequestMapping(value={"updateSkuFilePassStore.json"}, name="\u66f4\u65b0SKU\u6587\u4ef6(\u56fe\u7247,\u89c6\u9891)\u5217\u8868--\u5e73\u53f0\u95e8\u5e97")
    @ResponseBody
    public HtmlJsonReBean updateSkuFilePassStore(HttpServletRequest request, String skuCode, String fileList) {
        return this.upfateSkuFiles(request, skuCode, fileList);
    }

    @RequestMapping(value={"updateSkuFilePassSStore.json"}, name="\u66f4\u65b0SKU\u6587\u4ef6(\u56fe\u7247,\u89c6\u9891)\u5217\u8868--\u5e73\u53f0\u95e8\u5e97\u7b2c\u4e09\u65b9")
    @ResponseBody
    public HtmlJsonReBean updateSkuFilePassSStore(HttpServletRequest request, String skuCode, String fileList) {
        return this.upfateSkuFiles(request, skuCode, fileList);
    }

    @RequestMapping(value={"updateSkuFileStore.json"}, name="\u66f4\u65b0SKU\u6587\u4ef6(\u56fe\u7247,\u89c6\u9891)\u5217\u8868--\u95e8\u5e97")
    @ResponseBody
    public HtmlJsonReBean updateSkuFileStore(HttpServletRequest request, String skuCode, String fileList) {
        return this.upfateSkuFiles(request, skuCode, fileList);
    }

    @RequestMapping(value={"updateSkuFileSStore.json"}, name="\u66f4\u65b0SKU\u6587\u4ef6(\u56fe\u7247,\u89c6\u9891)\u5217\u8868--\u95e8\u5e97\u7b2c\u4e09\u65b9")
    @ResponseBody
    public HtmlJsonReBean updateSkuFileSStore(HttpServletRequest request, String skuCode, String fileList) {
        return this.upfateSkuFiles(request, skuCode, fileList);
    }

    private HtmlJsonReBean upfateSkuFiles(HttpServletRequest request, String skuCode, String fileList) {
        if (StringUtils.isBlank((String)skuCode) || StringUtils.isBlank((String)fileList)) {
            this.logger.error("rs.sku.con.updateSkuFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List rsGoodsFileDomainList = JsonUtil.buildNonDefaultBinder().getJsonToList(fileList, RsGoodsFileDomain.class);
        for (RsGoodsFileDomain rsGoodsFileDomain : rsGoodsFileDomainList) {
            rsGoodsFileDomain.setTenantCode(this.getTenantCode(request));
        }
        return this.rsSkuService.updateSkuFile(skuCode, this.getTenantCode(request), rsGoodsFileDomainList);
    }

    @RequestMapping(value={"querySkuBySkuCode.json"}, name="\u67e5\u8be2SKU\u5217\u8868")
    @ResponseBody
    public List<RsSkuReDomain> querySkuBySkuCode(HttpServletRequest request, String skuCodeStr) {
        List<String> skuCodeList = this.getGoodsIdList(skuCodeStr);
        HashMap<String, Object> skuParam = new HashMap<String, Object>();
        skuParam.put("tenantCode", this.getTenantCode(request));
        ArrayList<RsSkuReDomain> reDomains = new ArrayList<RsSkuReDomain>();
        for (String skuCode : skuCodeList) {
            skuParam.put("skuCode", skuCode);
            RsSkuReDomain skuReDomain = this.rsSkuService.getSkuByCode(skuParam);
            if (null == skuReDomain) continue;
            reDomains.add(skuReDomain);
        }
        return reDomains.size() > 0 ? reDomains : null;
    }

    private List<String> getGoodsIdList(String skuCodeStr) {
        String[] codeStr = skuCodeStr.split(",");
        ArrayList<String> skuCodeList = new ArrayList<String>();
        for (String code : codeStr) {
            skuCodeList.add(code);
        }
        return skuCodeList;
    }

    @RequestMapping(value={"querySkuByMscCodeFromYy.json"}, name="\u67e5\u8be2SKU\u5206\u9875\u5217\u8868-\u8fd0\u8425\u7aef\u9891\u9053\u7ba1\u7406")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuByMscCodeFromYy(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuService.querySkuOnePage(param);
    }

    @RequestMapping(value={"updateCannelSkuList.json"}, name="sku-\u64a4\u724c")
    @ResponseBody
    public HtmlJsonReBean updateCannelSkuList(String skuIds) {
        if (StringUtils.isBlank((String)skuIds)) {
            this.logger.error("rs.sku.con.updateCannelSkuList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuService.updateCannelSkuList(this.getSkuIdList(skuIds));
    }

    @RequestMapping(value={"updateCanSkuLisFromTc.json"}, name="sku-\u64a4\u724c-\u5957\u9910")
    @ResponseBody
    public HtmlJsonReBean updateCanSkuLisFromTc(String skuIds) {
        if (StringUtils.isBlank((String)skuIds)) {
            this.logger.error("rs.sku.con.updateCanSkuLisFromTc", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuService.updateCannelSkuList(this.getSkuIdList(skuIds));
    }

    @RequestMapping(value={"updateCanSkuLisFromXn.json"}, name="sku-\u64a4\u724c-\u865a\u62df")
    @ResponseBody
    public HtmlJsonReBean updateCanSkuLisFromXn(String skuIds) {
        if (StringUtils.isBlank((String)skuIds)) {
            this.logger.error("rs.sku.con.updateCanSkuLisFromXn", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuService.updateCannelSkuList(this.getSkuIdList(skuIds));
    }

    @RequestMapping(value={"updateCanSkuLisFromFd.json"}, name="sku-\u64a4\u724c-\u798f\u70b9")
    @ResponseBody
    public HtmlJsonReBean updateCanSkuLisFromFd(String skuIds) {
        if (StringUtils.isBlank((String)skuIds)) {
            this.logger.error("rs.sku.con.updateCanSkuLisFromFd", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.rsSkuService.updateCannelSkuList(this.getSkuIdList(skuIds));
    }

    @RequestMapping(value={"updateAuditSkuPass.json"}, name="sku-\u6302\u724c\u5ba1\u6838\u901a\u8fc7")
    @ResponseBody
    public HtmlJsonReBean updateAuditSkuPass(String skuIds) {
        return this.updateAuditSkuPassMain(skuIds);
    }

    @RequestMapping(value={"updateAudSkuPassFromTc.json"}, name="sku-\u6302\u724c\u5ba1\u6838\u901a\u8fc7-\u5957\u9910")
    @ResponseBody
    public HtmlJsonReBean updateAudSkuPassFromTc(String skuIds) {
        return this.updateAuditSkuPassMain(skuIds);
    }

    @RequestMapping(value={"updateAudSkuPassFromXn.json"}, name="sku-\u6302\u724c\u5ba1\u6838\u901a\u8fc7-\u865a\u62df")
    @ResponseBody
    public HtmlJsonReBean updateAudSkuPassFromXn(String skuIds) {
        return this.updateAuditSkuPassMain(skuIds);
    }

    @RequestMapping(value={"updateAudSkuPassFromFd.json"}, name="sku-\u6302\u724c\u5ba1\u6838\u901a\u8fc7-\u798f\u70b9")
    @ResponseBody
    public HtmlJsonReBean updateAudSkuPassFromFd(String skuIds) {
        return this.updateAuditSkuPassMain(skuIds);
    }

    private HtmlJsonReBean updateAuditSkuPassMain(String skuIds) {
        if (StringUtils.isBlank((String)skuIds)) {
            this.logger.error("rs.sku.con.updateAuditSkuPassMain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List<Integer> skuIdList = this.getSkuIdList(skuIds);
        ArrayList<RsSkuDomain> skuList = new ArrayList<RsSkuDomain>();
        for (Integer skuId : skuIdList) {
            RsSkuReDomain rsSkuReDomain = this.rsSkuService.getSku(skuId);
            skuList.add(rsSkuReDomain);
        }
        this.rsSkuService.updateAhSkuList(skuList);
        return this.rsSkuService.updateAuditSkuPass(this.getSkuIdList(skuIds));
    }

    @RequestMapping(value={"querySkuFromSc.json"}, name="\u5546\u54c1SKU-\u5e97\u94fa")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromSc(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        String memberCode = String.valueOf(param.get("memberCode"));
        if (null == memberCode || StringUtils.isBlank((String)memberCode)) {
            this.logger.error("rs.sku.con.querySkuFromSc", (Object)"param is null");
            return null;
        }
        param.put("dataOpbillstate", 1);
        param.put("dataState", 2);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuFromGiftInfo.json"}, name="\u5546\u54c1SKU-\u793c\u5305\u4fe1\u606f")
    @ResponseBody
    public RsSkuReDomain querySkuFromGiftInfo(HttpServletRequest request, String skuCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", this.getTenantCode(request));
        if (StringUtils.isBlank((String)skuCode)) {
            this.logger.error("rs.sku.con.querySkuFromGiftInfo", (Object)"param is null");
            return null;
        }
        param.put("skuCode", skuCode);
        RsSkuDomain rsSkuDomain = this.rsSkuService.getSkuDomainByCode(param);
        if (null == rsSkuDomain) {
            this.logger.error("rs.sku.con.querySkuFromGiftInfo", (Object)"rsSkuReDomain is null");
            return null;
        }
        param.remove("skuCode");
        param.put("goodsCode", rsSkuDomain.getGoodsCode());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsService.getResourceGoodsByCode(param);
        if (null != rsResourceGoodsReDomain) {
            rsSkuDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
            rsSkuDomain.setSkuRemark(rsResourceGoodsReDomain.getGoodsRemark());
        }
        RsSkuReDomain rsSkuReDomain = new RsSkuReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)rsSkuReDomain, (Object)rsSkuDomain);
        }
        catch (Exception e) {
            this.logger.error("rs.sku.con.querySkuFromGiftInfo", (Object)"rsSkuReDomain is null");
        }
        return rsSkuReDomain;
    }

    @RequestMapping(value={"queryHotResources.json"}, name="\u731c\u4f60\u559c\u6b22")
    @ResponseBody
    public SupQueryResult<Map<String, Object>> queryHotResources(HttpServletRequest request, String pageSize) {
        if (StringUtils.isBlank((String)pageSize)) {
            this.logger.error("rs.sku.con.queryHotResources", (Object)"pageSize is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        String channelCode = this.getNowChannel(request);
        String tenantCode = this.getTenantCode(request);
        String userCode = userSession.getUserCode();
        String userPhone = userSession.getUserPhone();
        SupQueryResult queryResult = new SupQueryResult();
        ReturnBean returnBean = this.rsSkuService.queryHotSku(userCode, userPhone, pageSize, channelCode, tenantCode);
        if (null == returnBean) {
            return queryResult;
        }
        queryResult.setList(returnBean.getSourcelist());
        SupPageTools supPageTools = new SupPageTools();
        supPageTools.setRecordCount(returnBean.getCount());
        queryResult.setPageTools(supPageTools);
        queryResult.setTotal((long)returnBean.getCount());
        return queryResult;
    }

    private List<Integer> getSkuIdList(String skuIds) {
        String[] idStr = skuIds.split(",");
        ArrayList<Integer> skuIdList = new ArrayList<Integer>();
        for (String id : idStr) {
            skuIdList.add(Integer.parseInt(id));
        }
        return skuIdList;
    }

    @RequestMapping(value={"querySkuMotherPage.json"}, name="\u5546\u54c1\u6bcd\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuMotherPage(HttpServletRequest request) {
        Map<String, Object> param = this.getPlatMemberCodeQueryMapParams(request);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"querySkuInventory.json"}, name="\u67e5\u8be2\u5546\u54c1\u603b\u5e93\u5b58(\u4e2d\u53f0)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuInventory(HttpServletRequest request) {
        Map<String, Object> param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("goodsOrigin", "0");
        }
        return this.rsSkuService.querySkuOnePage(param);
    }

    @RequestMapping(value={"updateSkuNumBySkuNo.json"}, name="\u7f16\u8f91\u5546\u54c1sku\u603b\u5e93\u5b58")
    @ResponseBody
    public HtmlJsonReBean updateSkuNumBySkuNo(HttpServletRequest request, String skuNo, String goodsNum, String goodsWeight, String tenantCode) {
        if (StringUtils.isBlank((String)skuNo) || null == goodsNum || null == goodsWeight || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("rs.sku.con.updateSendUpdateSkuNum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession session = this.getUserSession(request);
        if (null == session) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u767b\u5f55");
        }
        String memberCode = session.getUserPcode();
        String ste = this.rsResourceService.sendToupdateSkuNum(skuNo, goodsNum, goodsWeight, memberCode, tenantCode);
        return new HtmlJsonReBean((Object)ste);
    }

    @RequestMapping(value={"getSkuByskuId.json"}, name="\u83b7\u53d6SKU\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public RsSkuReDomain getSkuByskuId(String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error("rs.sku.con.getSku", (Object)"param is null");
            return null;
        }
        return this.rsSkuService.getSku(Integer.valueOf(skuId));
    }

    @RequestMapping(value={"querySkuPageForAt.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)--\u7ade\u4ef7")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuPageForAt(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        param.put("dataOpbillstate", 1);
        param.put("dataState", 2);
        return this.querySkuMain(param);
    }

    @RequestMapping(value={"queryResourceSkuPageAt.json"}, name="\u67e5\u8be2\u5546\u54c1\u5206\u9875\u5217\u8868-\u7ade\u4ef7\u5546\u54c1")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryResourceSkuPageAt(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
        }
        param.put("goodsOrigin", "19");
        param.put("validFlag", true);
        param.put("ginfoFlag", true);
        SupQueryResult<RsResourceGoodsReDomain> rsResourceGoodsResult = this.rsResourceGoodsService.queryResourceGoodsPage(param);
        if (ListUtil.isEmpty((Collection)rsResourceGoodsResult.getList())) {
            return null;
        }
        String goodsCodeStr = "";
        for (RsResourceGoodsReDomain rsResourceGoods : rsResourceGoodsResult.getList()) {
            goodsCodeStr = goodsCodeStr + "'" + rsResourceGoods.getGoodsCode() + "',";
        }
        goodsCodeStr = goodsCodeStr.substring(0, goodsCodeStr.length() - 1);
        param.remove("goodsOrigin");
        param.remove("validFlag");
        param.remove("ginfoFlag");
        param.remove("memberCode");
        param.put("goodsCodes", goodsCodeStr);
        return this.rsSkuService.querySkuOnePage(param);
    }

    @RequestMapping(value={"excelExportGoods.json"}, name="excel\u5bfc\u51fa\u8d27\u54c1")
    @ResponseBody
    public HtmlJsonReBean excelExportGoods(HttpServletRequest request) {
        String jsonParam;
        Map<String, Object> param = this.assemMapParam(request);
        if (MapUtil.isEmpty(param)) {
            this.logger.error("rs.sku.con.excelExportGoods", (Object)"param is null");
            return new HtmlJsonReBean((Object)"error");
        }
        UserSession userSession = this.getUserSession(request);
        String userCode = userSession.getUserCode();
        String string = jsonParam = null == param.get("json") ? "" : (String)param.get("json");
        if (StringUtils.isBlank((String)jsonParam)) {
            this.logger.error("rs.sku.con.excelExportGoods", (Object)"json is null");
            return new HtmlJsonReBean((Object)"error");
        }
        Map paramMap = JsonUtil.buildNormalBinder().getJsonToMap(jsonParam, String.class, Object.class);
        paramMap.put("tenantCode", param.get("tenantCode"));
        paramMap.put("row", param.get("row"));
        paramMap.put("page", param.get("page"));
        paramMap.put("userInfoCode", userCode);
        try {
            this.rsSkuService.exportExcel(paramMap, "rs.sku.querySkuOnePage");
        }
        catch (Exception e) {
            this.logger.error("rs.sku.con.excelExportGoods.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
            return new HtmlJsonReBean((Object)"error");
        }
        return new HtmlJsonReBean((Object)"success");
    }

    @RequestMapping(value={"getSkuInfo.json"}, name="\u83b7\u53d6\u5546\u54c1SKU\u4fe1\u606f")
    @ResponseBody
    public RsSkuReDomain getSkuInfo(HttpServletRequest request, String skuId) {
        if (StringUtils.isBlank((String)skuId)) {
            this.logger.error("rs.sku.con.getSku", (Object)"param is null");
            return null;
        }
        RsSkuReDomain rsSkuReDomain = this.rsSkuService.getSku(Integer.valueOf(skuId));
        String tenantCode = this.getTenantCode(request);
        if (!tenantCode.equals(rsSkuReDomain.getTenantCode())) {
            this.logger.error("rs.sku.con.getSku", (Object)"\u4e0d\u80fd\u67e5\u770b\u4e0d\u5c5e\u4e8e\u5f53\u524d\u79df\u6237\u7684\u6570\u636e");
            return null;
        }
        return rsSkuReDomain;
    }

    @RequestMapping(value={"getSkuInfoByCode.json"}, name="\u83b7\u53d6\u5546\u54c1SKU\u4fe1\u606f")
    @ResponseBody
    public RsSkuReDomain getSkuInfoByCode(HttpServletRequest request, String skuCode) {
        if (StringUtils.isBlank((String)skuCode)) {
            this.logger.error("rs.sku.con.getSku", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", tenantCode);
        RsSkuReDomain rsSkuReDomain = this.rsSkuService.getSkuByCode(map);
        if (!tenantCode.equals(rsSkuReDomain.getTenantCode())) {
            this.logger.error("rs.sku.con.getSkuInfoByCode", (Object)"\u4e0d\u80fd\u67e5\u770b\u4e0d\u5c5e\u4e8e\u5f53\u524d\u79df\u6237\u7684\u6570\u636e");
            return null;
        }
        return rsSkuReDomain;
    }

    @RequestMapping(value={"querySkuOnePageSvPageForPlat.json"}, name="\u67e5\u8be2\u670d\u52a1\u5546\u54c1SKU\u5206\u9875\u5217\u8868(\u5e73\u53f0)")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> queryquerySkuOnePageSvPageForPlat(HttpServletRequest request) {
        Map<String, Object> param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "0");
        param.put("goodsType", "07");
        param.put("validFlag", true);
        return this.rsSkuService.querySkuOnePage(param);
    }

    @RequestMapping(value={"saveSkuCopy.json"}, name="\u589e\u52a0\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean saveSkuCopy(HttpServletRequest request, String paramStr) {
        RsSkuReDomain rsSkuReDomain;
        Map<String, Object> param = this.assemMapParam(request);
        if (StringUtils.isEmpty((String)paramStr) || MapUtil.isEmpty(param)) {
            this.logger.error("rs.sku.con.saveSkuCopy", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String isFictitions = null == param.get("isFictitions") ? "" : (String)param.get("isFictitions");
        String isUpdate = null == param.get("isUpdate") ? "" : (String)param.get("isUpdate");
        String goodsType = "06";
        if ("true".equals(isFictitions)) {
            goodsType = "28";
        }
        if (null == (rsSkuReDomain = (RsSkuReDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, RsSkuReDomain.class)) || null != rsSkuReDomain.getSkuId() && StringUtils.isBlank((String)rsSkuReDomain.getGoodsCode())) {
            this.logger.info("rs.sku.con.saveSkuCopy", (Object)("rsSkuReDomain is null" + rsSkuReDomain + "=:=" + paramStr));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        Integer dataOpbillstate = rsSkuReDomain.getDataOpbillstate();
        rsSkuReDomain.setGoodsType(goodsType);
        rsSkuReDomain.setGoodsPro("6");
        RsResourceGoodsReDomain reDomain = this.makeGoodsInfo(request, rsSkuReDomain, isUpdate, isFictitions);
        if (null == reDomain) {
            return null;
        }
        reDomain.setGoodsClass("plat");
        reDomain.getRsSkuDomainList().forEach(x -> x.setGoodsClass("plat"));
        this.logger.error("reDomain====", (Object)JsonUtil.buildNormalBinder().toJson((Object)reDomain));
        HtmlJsonReBean htmlJsonReBean = null;
        if ("true".equals(isUpdate)) {
            if (null != reDomain.getDataOpbillstate() && ResourcesConstants.DATAOPBILLSTATE_1 == reDomain.getDataOpbillstate() || null != dataOpbillstate && ResourcesConstants.DATAOPBILLSTATE_1 == dataOpbillstate) {
                EditSkuDomain editSkuDomain = new EditSkuDomain();
                RsSkuDomain chiSku = new RsSkuDomain();
                if (ListUtil.isNotEmpty(reDomain.getRsSkuDomainList())) {
                    chiSku = reDomain.getRsSkuDomainList().get(0);
                }
                try {
                    BeanUtils.copyAllPropertys((Object)editSkuDomain, (Object)chiSku);
                }
                catch (Exception e) {
                    this.logger.info("rs.sku.con.saveSkuCopy", (Object)("reDomain or chiSku  is null " + rsSkuReDomain.getGoodsCode() + "=:=" + chiSku + "=:=" + this.getTenantCode(request)));
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
                }
                editSkuDomain.setRsSkuFileDomainList(null);
                editSkuDomain.setRsGoodsFileDomainList(null);
                editSkuDomain.setGoodsSort(rsSkuReDomain.getSkuSort());
                if (null != editSkuDomain.getSkuId()) {
                    RsSkuReDomain rsSkuDomain = this.rsSkuService.getSku((int)editSkuDomain.getSkuId());
                    this.logger.info("rs.sku.con.saveSkuCopy.update.oldSku.", (Object)(dataOpbillstate + "=:=" + reDomain.getDataOpbillstate() + "=:=" + rsSkuDomain.getDataOpbillstate()));
                    if (0 == rsSkuDomain.getDataOpbillstate()) {
                        this.rsResourceGoodsService.sendUpdateShelveSku((int)editSkuDomain.getSkuId());
                    }
                }
                htmlJsonReBean = this.rsResourceGoodsService.sendUpdateSkuEdit(editSkuDomain);
            } else {
                htmlJsonReBean = this.rsResourceGoodsService.sendUpdateResourceGoods(reDomain);
            }
        } else {
            if (null != dataOpbillstate && ResourcesConstants.DATAOPBILLSTATE_1 == dataOpbillstate) {
                ArrayList<RsResourceGoodsDomain> rsResourceGoodsDomainList = new ArrayList<RsResourceGoodsDomain>();
                rsResourceGoodsDomainList.add(reDomain);
                this.logger.error("sendSavePassResourceGoodsBatch", (Object)JsonUtil.buildNormalBinder().toJson(rsResourceGoodsDomainList));
                htmlJsonReBean = this.rsResourceGoodsService.sendSavePassResourceGoodsBatch(rsResourceGoodsDomainList);
            } else {
                this.logger.error("sendSaveResourceGoods", (Object)JsonUtil.buildNormalBinder().toJson((Object)reDomain));
                htmlJsonReBean = this.rsResourceGoodsService.sendSaveResourceGoods(reDomain);
            }
            if ("success".equals(htmlJsonReBean.getSysRecode()) && !"true".equals(isFictitions)) {
                this.rsResourceGoodsService.updateGoodsNextState(rsSkuReDomain.getGoodsCode(), this.getTenantCode(request), -1, null);
            }
        }
        return htmlJsonReBean;
    }

    private RsResourceGoodsReDomain makeGoodsInfo(HttpServletRequest request, RsSkuReDomain rsSkuReDomain, String isUpdate, String isFictitions) {
        RsResourceGoodsReDomain reDomain = null;
        if (StringUtils.isNotBlank((String)rsSkuReDomain.getGoodsCode())) {
            reDomain = this.rsResourceGoodsService.getResourceGoodsByCode(this.getQueryMapParam("goodsCode,tenantCode", rsSkuReDomain.getGoodsCode(), this.getTenantCode(request)));
            this.logger.info("rs.sku.con.make.reDomain.", (Object)(JsonUtil.buildNormalBinder().toJson((Object)reDomain) + "=:=" + JsonUtil.buildNormalBinder().toJson((Object)rsSkuReDomain)));
            if (null == reDomain) {
                this.logger.info("rs.sku.con.saveSkuCopy", (Object)("reDomain is null " + rsSkuReDomain.getGoodsCode() + "=:=" + this.getTenantCode(request)));
                return null;
            }
            if (StringUtils.isBlank((String)isUpdate) || "false".equals(isUpdate)) {
                this.clearGoods(reDomain);
            }
        }
        if (null == reDomain) {
            reDomain = new RsResourceGoodsReDomain();
        }
        reDomain.setGoodsName(rsSkuReDomain.getGoodsName());
        reDomain.setGoodsNo(rsSkuReDomain.getSkuNo());
        reDomain.setGoodsNum(rsSkuReDomain.getGoodsNum());
        reDomain.setPricesetNprice(rsSkuReDomain.getPricesetNprice());
        reDomain.setPricesetRefrice(rsSkuReDomain.getPricesetRefrice());
        reDomain.setGoodsSupplynum(rsSkuReDomain.getGoodsSupplynum());
        reDomain.setGoodsSupplyweight(rsSkuReDomain.getGoodsSupplyweight());
        reDomain.setGoodsTopnum(rsSkuReDomain.getGoodsTopnum());
        reDomain.setClasstreeShopcode(rsSkuReDomain.getClasstreeShopcode());
        reDomain.setClasstreeShopname(rsSkuReDomain.getClasstreeShopname());
        reDomain.setChannelCode(rsSkuReDomain.getChannelCode());
        reDomain.setGoodsPro(rsSkuReDomain.getGoodsPro());
        reDomain.setGoodsType(rsSkuReDomain.getGoodsType());
        reDomain.setSaleChannel(rsSkuReDomain.getSaleChannel());
        reDomain.setGoodsSort(rsSkuReDomain.getSkuSort());
        reDomain.setGoodsMinnum(rsSkuReDomain.getGoodsMinnum());
        if ("true".equals(isFictitions)) {
            UserSession userSession = this.getUserSession(request);
            rsSkuReDomain.setGoodsPro("6");
            if (StringUtils.isBlank((String)rsSkuReDomain.getGoodsOrigin())) {
                rsSkuReDomain.setGoodsOrigin("11");
            }
            rsSkuReDomain.setMemberCode(userSession.getUserPcode());
            rsSkuReDomain.setMemberName(null == userSession.getMerberCompname() ? userSession.getUserName() : userSession.getMerberCompname());
            rsSkuReDomain.setMemberCcode(userSession.getUserPcode());
            rsSkuReDomain.setMemberCname(userSession.getCompanyShortname());
            rsSkuReDomain.setTenantCode(this.getTenantCode(request));
            rsSkuReDomain.setGinfoCode(rsSkuReDomain.getSkuNo());
            rsSkuReDomain.setSkuBarcode(rsSkuReDomain.getSkuNo());
            rsSkuReDomain.setGoodsClass("B2B");
            if (null != rsSkuReDomain.getSkuId()) {
                rsSkuReDomain.setSkuId(null);
            }
            if (null != rsSkuReDomain.getGoodsCode()) {
                rsSkuReDomain.setGoodsCode(null);
            }
            if (StringUtils.isBlank((String)reDomain.getPntreeCode())) {
                reDomain.setPntreeCode("100000262");
            }
            if (StringUtils.isBlank((String)reDomain.getPntreeName())) {
                reDomain.setPntreeName("PG");
            }
            if (StringUtils.isBlank((String)reDomain.getMemberMcode())) {
                reDomain.setMemberMcode(this.getTeananMemberCode(request));
            }
            try {
                BeanUtils.copyAllPropertys((Object)reDomain, (Object)rsSkuReDomain);
            }
            catch (Exception e) {
                this.logger.info("rs.sku.con.saveSkuCopy", (Object)("reDomain is null " + rsSkuReDomain.getGoodsCode() + "=:=" + this.getTenantCode(request)));
                return null;
            }
        }
        List<RsSkuDomain> rsSkuDomains = reDomain.getRsSkuDomainList();
        this.logger.info("rs.sku.con.saveSkuCopy", (Object)("reDomain: " + isUpdate + "=:=" + JsonUtil.buildNormalBinder().toJson((Object)reDomain) + "=:=" + JsonUtil.buildNormalBinder().toJson((Object)rsSkuReDomain)));
        if (null == rsSkuDomains) {
            rsSkuDomains = new ArrayList<RsSkuDomain>();
            rsSkuDomains.add(rsSkuReDomain);
            reDomain.setRsSkuDomainList(rsSkuDomains);
        } else {
            for (RsSkuDomain rsSkuDomain : rsSkuDomains) {
                rsSkuDomain.setGoodsName(rsSkuReDomain.getGoodsName());
                rsSkuDomain.setGoodsNo(rsSkuReDomain.getSkuNo());
                rsSkuDomain.setGoodsNum(rsSkuReDomain.getGoodsNum());
                rsSkuDomain.setPricesetNprice(rsSkuReDomain.getPricesetNprice());
                rsSkuDomain.setPricesetRefrice(rsSkuReDomain.getPricesetRefrice());
                rsSkuDomain.setGoodsSupplynum(rsSkuReDomain.getGoodsSupplynum());
                rsSkuDomain.setGoodsSupplyweight(rsSkuReDomain.getGoodsSupplyweight());
                rsSkuDomain.setGoodsTopnum(rsSkuReDomain.getGoodsTopnum());
                rsSkuDomain.setClasstreeShopcode(rsSkuReDomain.getClasstreeShopcode());
                rsSkuDomain.setClasstreeShopname(rsSkuReDomain.getClasstreeShopname());
                rsSkuDomain.setSkuSort(rsSkuReDomain.getSkuSort());
                rsSkuDomain.setGoodsMinnum(rsSkuReDomain.getGoodsMinnum());
            }
        }
        return reDomain;
    }

    private RsResourceGoodsReDomain clearGoods(RsResourceGoodsReDomain rsResourceGoodsReDomain) {
        if (null == rsResourceGoodsReDomain) {
            this.logger.error("rs.sku.con,clearGoods.param is null");
            return null;
        }
        rsResourceGoodsReDomain.setGoodsId(null);
        rsResourceGoodsReDomain.setGoodsCode(null);
        if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsSpecValueDomainList())) {
            for (RsSpecValueDomain rsSpecValueDomain : rsResourceGoodsReDomain.getRsSpecValueDomainList()) {
                rsSpecValueDomain.setSpecValueId(null);
                rsSpecValueDomain.setSpecValueCode(null);
            }
        }
        if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsGoodsFileDomainList())) {
            for (RsGoodsFileDomain rsGoodsFileDomain : rsResourceGoodsReDomain.getRsGoodsFileDomainList()) {
                rsGoodsFileDomain.setGoodsFileId(null);
                rsGoodsFileDomain.setGoodsFileCode(null);
            }
        }
        if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsGoodsWhDomainList())) {
            for (RsGoodsWhDomain rsGoodsWhDomain : rsResourceGoodsReDomain.getRsGoodsWhDomainList()) {
                rsGoodsWhDomain.setGoodsWhId(null);
                rsGoodsWhDomain.setGoodsWhCode(null);
            }
        }
        if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsGoodsShopDomainList())) {
            for (RsGoodsShopDomain rsGoodsShopDomain : rsResourceGoodsReDomain.getRsGoodsShopDomainList()) {
                rsGoodsShopDomain.setGoodsShopId(null);
                rsGoodsShopDomain.setGoodsShopCode(null);
            }
        }
        if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsGoodsRelDomainList())) {
            for (RsGoodsRelDomain rsGoodsRelDomain : rsResourceGoodsReDomain.getRsGoodsRelDomainList()) {
                rsGoodsRelDomain.setGoodsRelId(null);
                rsGoodsRelDomain.setGoodsRelCode(null);
            }
        }
        if (ListUtil.isNotEmpty(rsResourceGoodsReDomain.getRsPropertiesValueDomainList())) {
            for (RsPropertiesValueDomain rsPropertiesValueDomain : rsResourceGoodsReDomain.getRsPropertiesValueDomainList()) {
                rsPropertiesValueDomain.setPropertiesValueId(null);
                rsPropertiesValueDomain.setPropertiesValueCode(null);
            }
        }
        rsResourceGoodsReDomain.setDataState(null);
        rsResourceGoodsReDomain.setRsSkuDomainList(this.clearSkuList(rsResourceGoodsReDomain.getRsSkuDomainList()));
        return rsResourceGoodsReDomain;
    }

    private List<RsSkuDomain> clearSkuList(List<RsSkuDomain> rsSkuDomainList) {
        ArrayList<RsSkuDomain> rsSkuDomains = new ArrayList<RsSkuDomain>();
        for (RsSkuDomain rsSkuDomain : rsSkuDomainList) {
            rsSkuDomains.add(this.clearSku(rsSkuDomain));
        }
        return rsSkuDomains;
    }

    private RsSkuDomain clearSku(RsSkuDomain rsSkuDomain) {
        if (null == rsSkuDomain) {
            this.logger.error("rs.sku.con.clearSku.");
            return null;
        }
        rsSkuDomain.setSkuId(null);
        rsSkuDomain.setSkuCode(null);
        rsSkuDomain.setGoodsCode(null);
        if (null != rsSkuDomain.getPropertiesList() && rsSkuDomain.getPropertiesList().size() > 0) {
            for (RsPropertiesValueDomain rsPropertiesValueDomain : rsSkuDomain.getPropertiesList()) {
                rsPropertiesValueDomain.setPropertiesValueId(null);
                rsPropertiesValueDomain.setPropertiesValueCode(this.createUUIDString());
            }
        }
        if (null != rsSkuDomain.getSpecList() && rsSkuDomain.getSpecList().size() > 0) {
            for (RsSpecValueDomain rsSpecValueDomain : rsSkuDomain.getSpecList()) {
                rsSpecValueDomain.setSpecValueId(null);
                rsSpecValueDomain.setSpecValueCode(this.createUUIDString());
            }
        }
        if (null != rsSkuDomain.getRsGoodsFileDomainList() && rsSkuDomain.getRsGoodsFileDomainList().size() > 0) {
            for (RsGoodsFileDomain rsGoodsFileDomain : rsSkuDomain.getRsGoodsFileDomainList()) {
                rsGoodsFileDomain.setGoodsFileId(null);
                rsGoodsFileDomain.setGoodsFileCode(this.createUUIDString());
            }
        }
        if (null != rsSkuDomain.getRsGoodsRelDomainList() && rsSkuDomain.getRsGoodsRelDomainList().size() > 0) {
            for (RsGoodsRelDomain rsGoodsRelDomain : rsSkuDomain.getRsGoodsRelDomainList()) {
                rsGoodsRelDomain.setGoodsRelId(null);
                rsGoodsRelDomain.setGoodsRelCode(this.createUUIDString());
            }
        }
        return rsSkuDomain;
    }

    public static void main(String[] args) {
    }

    @RequestMapping(value={"querySkuFromTcStr.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5957\u9910\u5546\u54c1")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromTcStr(HttpServletRequest request) {
        Map<String, Object> param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "0");
        return this.rsSkuService.querySkuOnePage(param);
    }

    @RequestMapping(value={"querySkuFromTcToStr.json"}, name="\u5546\u54c1SKU\u5217\u8868(\u5206\u9875)-\u5957\u9910\u5546\u54c1")
    @ResponseBody
    public SupQueryResult<RsSkuReDomain> querySkuFromTcToStr(HttpServletRequest request) {
        Map<String, Object> param = this.getPlatMemberCodeQueryMapParams(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsOrigin", "8");
        return this.rsSkuService.querySkuOnePage(param);
    }
}

