/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.appmanage;

import cn.com.qj.bff.common.send.PostParamMap;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.core.util.HtmlUtil;
import cn.com.qj.bff.domain.am.AmRouteRuleDomain;
import cn.com.qj.bff.domain.am.AmRouteRuleReDomain;
import cn.com.qj.bff.service.am.RouteRuleService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/am/routeRule"})
public class RouteRuleCon
extends SpringmvcController {
    private static String CODE = "am.routeRule.con";
    @Autowired
    private RouteRuleService routeRuleService;

    @Override
    protected String getContext() {
        return "routeRule";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(AmRouteRuleDomain amRouteRuleDomain) {
        if (null == amRouteRuleDomain) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.routeRuleService.saveRouteRule(amRouteRuleDomain);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, Integer routeRuleId, ModelMap modelMap) {
        modelMap.put((Object)"routeRuleReBean", (Object)this.getRouteRule(routeRuleId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, AmRouteRuleDomain amRouteRuleDomain) {
        if (null == amRouteRuleDomain) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.routeRuleService.updateRouteRule(amRouteRuleDomain);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, Integer routeRuleId) {
        if (StringUtils.isBlank((Integer)routeRuleId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.routeRuleService.deleteRouteRule(routeRuleId);
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, Integer routeRuleId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)routeRuleId) || StringUtils.isBlank((Integer)dataState) || StringUtils.isBlank((Integer)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.routeRuleService.updateRouteRuleState(routeRuleId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, Integer routeRuleId, ModelMap modelMap) {
        modelMap.put((Object)"routeRuleReBean", (Object)this.getRouteRule(routeRuleId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getRouteRule(Integer routeRuleId) {
        String rs = "{}";
        if (StringUtils.isBlank((Integer)routeRuleId)) {
            this.logger.info(CODE + ".getRouteRule", (Object)"routeRuleId is null");
        } else {
            PostParamMap pmap = new PostParamMap("am.appmanage.getRouteRule");
            pmap.putParam("routeRuleId", (Object)routeRuleId);
            rs = this.htmlIBaseService.sendMesReJson(pmap);
        }
        return rs;
    }

    @RequestMapping(value={"getRouteRule.json"})
    @ResponseBody
    public AmRouteRuleReDomain getRouteRuleFor(Integer routeRuleId) {
        if (StringUtils.isBlank((Integer)routeRuleId)) {
            this.logger.error(CODE + ".getRouteRuleFor", (Object)"param is null");
            return null;
        }
        return this.routeRuleService.getRouteRule(routeRuleId);
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request, @RequestParam(required=false) String routerDire) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            if (null != routerDire) {
                param.put("routeDire", routerDire);
            }
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.routeRuleService.queryRouteRulePage(param);
    }

    @RequestMapping(value={"queryRouteRuleLoadCache.json"}, name="RouteRule\u52a0\u8f7dCACHE")
    @ResponseBody
    public HtmlJsonReBean queryRouteRuleLoadCache() {
        return this.routeRuleService.queryRouteRuleCache();
    }
}

