/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.eq;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.eq.EqAuctionEnrollReDomain;
import cn.com.qj.bff.domain.eq.EqAuctionGoodsDomain;
import cn.com.qj.bff.domain.oc.OcContractReDomain;
import cn.com.qj.bff.service.eq.EqAuctionEnrollServiceRepository;
import cn.com.qj.bff.service.eq.EqAuctionGoodsServiceRepository;
import cn.com.qj.bff.service.eq.EqAuctionServiceRepository;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/eq/auction"}, name="\u8be2\u62a5\u4ef7")
public class EqAuctionController
extends SpringmvcController {
    private static String CODE = "eq.auction.con";
    @Autowired
    private EqAuctionServiceRepository auctionServiceRepository;
    @Autowired
    private EqAuctionGoodsServiceRepository eqAuctionGoodsServiceRepository;
    @Autowired
    private EqAuctionEnrollServiceRepository eqAuctionEnrollServiceRepository;
    @Autowired
    protected OcContractService ocContractService;

    @Override
    protected String getContext() {
        return "auction";
    }

    @RequestMapping(value={"queryEqAuctionList.json"}, name="\u83b7\u53d6\u62a5\u4ef7\u5355\u5217\u8868")
    @ResponseBody
    public SupQueryResult<EqAuctionEnrollReDomain> queryEqAuctionList(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (param != null) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("memberBcode", this.getUserSession(request).getUserPcode());
            param.put("dataState", 1);
        }
        String tenantCode = this.getTenantCode(request);
        if (param.get("goodsName") != null && StringUtils.isNotBlank((String)param.get("goodsName").toString())) {
            String goodsName = param.get("goodsName").toString();
            StringBuffer codes = new StringBuffer();
            HashSet<String> hash = null;
            HashMap<String, Object> goodsMap = new HashMap<String, Object>();
            goodsMap.put("goodsName", goodsName);
            goodsMap.put("tenantCode", tenantCode);
            goodsMap.put("fuzzy", true);
            SupQueryResult<EqAuctionGoodsDomain> supQueryResult = this.eqAuctionGoodsServiceRepository.queryAuctionGoodsPage(goodsMap);
            if (supQueryResult != null && ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
                for (EqAuctionGoodsDomain eqAuctionGoodsDomain : supQueryResult.getList()) {
                    if (StringUtils.isNotBlank((String)codes.toString())) {
                        codes.append(",");
                    }
                    codes.append(eqAuctionGoodsDomain.getAuctionEnrollCode());
                }
            }
            if (StringUtils.isBlank((String)codes.toString())) {
                return null;
            }
            hash = new HashSet<String>(Arrays.asList(codes.toString().split(",")));
            codes = new StringBuffer();
            for (String item : hash) {
                if (StringUtils.isNotBlank((String)codes.toString())) {
                    codes.append(",");
                }
                codes.append(item);
            }
            goodsMap.clear();
            goodsMap.put("auctionEnrollCode", codes.toString());
            goodsMap.put("tenantCode", tenantCode);
            goodsMap.put("order", true);
            SupQueryResult<EqAuctionEnrollReDomain> reDomainSupQueryResult = this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(goodsMap);
            if (reDomainSupQueryResult != null && ListUtil.isNotEmpty((Collection)reDomainSupQueryResult.getList())) {
                HashMap<String, Object> goodsMaps = new HashMap<String, Object>();
                for (EqAuctionEnrollReDomain enrollReDomain : reDomainSupQueryResult.getList()) {
                    String contractNbillcode = enrollReDomain.getAuctionEnrollCode();
                    HashMap<String, Object> ocMap = new HashMap<String, Object>();
                    ocMap.put("contractNbillcode", contractNbillcode);
                    ocMap.put("tenantCode", tenantCode);
                    ocMap.put("fuzzy", false);
                    SupQueryResult<OcContractReDomain> queryResult = this.ocContractService.queryContractPage(ocMap);
                    if (queryResult != null && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
                        String contractBillcode = ((OcContractReDomain)queryResult.getList().get(0)).getContractBillcode();
                        enrollReDomain.setContractBillcode(contractBillcode);
                    }
                    String auctionEnrollCode = enrollReDomain.getAuctionEnrollCode();
                    goodsMaps.put("auctionEnrollCode", auctionEnrollCode);
                    goodsMaps.put("fuzzy", false);
                    SupQueryResult<EqAuctionGoodsDomain> queryAuctionGoodsPage = this.eqAuctionGoodsServiceRepository.queryAuctionGoodsPage(goodsMaps);
                    if (queryAuctionGoodsPage == null || !ListUtil.isNotEmpty((Collection)queryAuctionGoodsPage.getList())) continue;
                    enrollReDomain.setGoodsCount(queryAuctionGoodsPage.getList().size());
                    enrollReDomain.setEqAuctionGoodsDomainList(Arrays.asList((EqAuctionGoodsDomain)queryAuctionGoodsPage.getList().get(0)));
                    BigDecimal sumMoney = new BigDecimal("0");
                    for (EqAuctionGoodsDomain eqAuctionGoodsDomain : queryAuctionGoodsPage.getList()) {
                        sumMoney = sumMoney.add(eqAuctionGoodsDomain.getPricesetNprice().subtract(eqAuctionGoodsDomain.getPricesetPrefprice()));
                    }
                    enrollReDomain.setPreferentialPrice(sumMoney);
                }
            }
            return reDomainSupQueryResult;
        }
        SupQueryResult<EqAuctionEnrollReDomain> supQueryResult = this.eqAuctionEnrollServiceRepository.queryAuctionEnrollPage(param);
        if (supQueryResult != null && ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
            HashMap<String, Object> goodsMap = new HashMap<String, Object>();
            for (EqAuctionEnrollReDomain enrollReDomain : supQueryResult.getList()) {
                String auctionEnrollCode = enrollReDomain.getAuctionEnrollCode();
                HashMap<String, Object> ocMap = new HashMap<String, Object>();
                ocMap.put("contractNbillcode", auctionEnrollCode);
                ocMap.put("tenantCode", tenantCode);
                ocMap.put("fuzzy", false);
                SupQueryResult<OcContractReDomain> result = this.ocContractService.queryContractPage(ocMap);
                if (result != null && ListUtil.isNotEmpty((Collection)result.getList())) {
                    String contractBillcode = ((OcContractReDomain)result.getList().get(0)).getContractBillcode();
                    enrollReDomain.setContractBillcode(contractBillcode);
                }
                goodsMap.put("auctionEnrollCode", auctionEnrollCode);
                goodsMap.put("fuzzy", false);
                SupQueryResult<EqAuctionGoodsDomain> queryAuctionGoodsPage = this.eqAuctionGoodsServiceRepository.queryAuctionGoodsPage(goodsMap);
                if (queryAuctionGoodsPage == null || !ListUtil.isNotEmpty((Collection)queryAuctionGoodsPage.getList())) continue;
                enrollReDomain.setGoodsCount(queryAuctionGoodsPage.getList().size());
                enrollReDomain.setEqAuctionGoodsDomainList(Arrays.asList((EqAuctionGoodsDomain)queryAuctionGoodsPage.getList().get(0)));
                BigDecimal sumMoney = new BigDecimal("0");
                for (EqAuctionGoodsDomain eqAuctionGoodsDomain : queryAuctionGoodsPage.getList()) {
                    sumMoney = sumMoney.add(eqAuctionGoodsDomain.getPricesetNprice().subtract(eqAuctionGoodsDomain.getPricesetPrefprice()));
                }
                enrollReDomain.setPreferentialPrice(sumMoney);
            }
        }
        return supQueryResult;
    }

    @RequestMapping(value={"getEqAuctionGoodsPage.json"}, name="\u67e5\u770b\u62a5\u4ef7\u5355\u5173\u8054\u5546\u54c1")
    @ResponseBody
    public SupQueryResult<EqAuctionGoodsDomain> getEqAuctionGoodsPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (param != null) {
            param.put("order", true);
            param.put("fuzzy", false);
        }
        return this.eqAuctionGoodsServiceRepository.queryAuctionGoodsPage(param);
    }

    @RequestMapping(value={"getEqAuction.json"}, name="\u67e5\u770b\u62a5\u4ef7\u5355\u8be6\u60c5")
    @ResponseBody
    public EqAuctionEnrollReDomain getEqAuction(String auctionEnrollId) {
        if (StringUtils.isBlank((String)auctionEnrollId)) {
            return null;
        }
        return this.eqAuctionEnrollServiceRepository.getAuctionEnroll(Integer.valueOf(auctionEnrollId));
    }

    @RequestMapping(value={"updateEqAuctionEnroll.json"}, name="\u63a5\u6536\u62d2\u7edd\u62a5\u4ef7\u5355")
    @ResponseBody
    public HtmlJsonReBean updateEqAuctionEnroll(String auctionEnrollId, String dataOpbillstate) {
        if (StringUtils.isBlank((String)auctionEnrollId) || StringUtils.isBlank((String)dataOpbillstate)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "auctionEnrollId or dataOpbillstate is null");
        }
        EqAuctionEnrollReDomain auctionEnroll = this.eqAuctionEnrollServiceRepository.getAuctionEnroll(Integer.valueOf(auctionEnrollId));
        auctionEnroll.setDataOpbillstate(Integer.valueOf(dataOpbillstate));
        return this.eqAuctionEnrollServiceRepository.updateAuctionEnroll(auctionEnroll);
    }
}

