/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.co;

import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.co.CoCorderDomain;
import cn.com.qj.bff.domain.co.CoCorderGoodsDomain;
import cn.com.qj.bff.domain.co.CoCorderGoodsReDomain;
import cn.com.qj.bff.domain.co.CoCorderReDomain;
import cn.com.qj.bff.domain.dd.DdFalgSettingDomain;
import cn.com.qj.bff.domain.dd.DdFalgSettingReDomain;
import cn.com.qj.bff.domain.oc.OcShoppingGoodsDomain;
import cn.com.qj.bff.domain.um.UmUserinfoQuaReDomain;
import cn.com.qj.bff.domain.um.UmUserinfoReDomainBean;
import cn.com.qj.bff.service.co.CoCorderService;
import cn.com.qj.bff.service.dd.DdFalgSettingService;
import cn.com.qj.bff.service.um.UserBaseService;
import cn.com.qj.bff.service.um.UserService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/co/corder"}, name="\u5408\u540c\u8ba2\u5355")
public class CorderCon
extends SpringmvcController {
    private static String CODE = "co.corder.con";
    @Autowired
    private CoCorderService coCorderService;
    @Autowired
    private UserBaseService userBaseService;
    @Autowired
    UserService userService;
    @Autowired
    private DdFalgSettingService ddFalgSettingService;

    @Override
    protected String getContext() {
        return "corder";
    }

    @RequestMapping(value={"saveCorder.json"}, name="\u589e\u52a0\u5408\u540c\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean saveCorder(HttpServletRequest request, CoCorderDomain coCorderDomain) {
        if (null == coCorderDomain) {
            this.logger.error(CODE + ".saveCorder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        coCorderDomain.setTenantCode(this.getTenantCode(request));
        return this.coCorderService.saveCorder(coCorderDomain);
    }

    @RequestMapping(value={"getCorder.json"}, name="\u83b7\u53d6\u5408\u540c\u8ba2\u5355\u4fe1\u606f")
    @ResponseBody
    public CoCorderReDomain getCorder(Integer corderId) {
        if (StringUtils.isBlank((Integer)corderId)) {
            this.logger.error(CODE + ".getCorder", (Object)"param is null");
            return null;
        }
        return this.coCorderService.getCorder(corderId);
    }

    @RequestMapping(value={"updateCorder.json"}, name="\u66f4\u65b0\u5408\u540c\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean updateCorder(HttpServletRequest request, CoCorderDomain coCorderDomain) {
        if (null == coCorderDomain) {
            this.logger.error(CODE + ".updateCorder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        coCorderDomain.setTenantCode(this.getTenantCode(request));
        return this.coCorderService.updateCorder(coCorderDomain);
    }

    @RequestMapping(value={"deleteCorder.json"}, name="\u5220\u9664\u5408\u540c\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean deleteCorder(Integer corderId) {
        if (StringUtils.isBlank((Integer)corderId)) {
            this.logger.error(CODE + ".deleteCorder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.coCorderService.deleteCorder(corderId);
    }

    @RequestMapping(value={"queryCorderPage.json"}, name="\u67e5\u8be2\u5408\u540c\u8ba2\u5355\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CoCorderReDomain> queryCorderPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.coCorderService.queryCorderPage(param);
    }

    @RequestMapping(value={"updateCorderState.json"}, name="\u66f4\u65b0\u5408\u540c\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateCorderState(String corderId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)corderId)) {
            this.logger.error(CODE + ".updateCorderState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.coCorderService.updateCorderState(Integer.valueOf(corderId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"downLoadFile.json"}, name="\u4e0b\u8f7d\u6587\u4ef6")
    @ResponseBody
    public ResponseEntity<byte[]> downLoadFile(String fileName) {
        if (null == fileName) {
            this.logger.error(CODE + ".fileName", (Object)"param is null");
            return null;
        }
        return this.coCorderService.downLoadFile(fileName);
    }

    @RequestMapping(value={"saveCorderStr.json"}, name="\u589e\u52a0\u5408\u540c\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean saveCorderStr(HttpServletRequest request, String coCorderDomainStr) {
        CoCorderReDomain coCorderDomain = (CoCorderReDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(coCorderDomainStr, CoCorderReDomain.class);
        if (null == coCorderDomain) {
            this.logger.error(CODE + ".saveCorderStr", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        coCorderDomain.setMemberBcode(userSession.getUserPcode());
        coCorderDomain.setMemberBname(userSession.getMerberCompname());
        String channelCodec = this.getNowChannel(request);
        coCorderDomain.setChannelCode(channelCodec);
        if (ListUtil.isNotEmpty(coCorderDomain.getCoCorderGoodsReDomainList())) {
            List<CoCorderGoodsReDomain> reDomains = coCorderDomain.getCoCorderGoodsReDomainList();
            for (CoCorderGoodsReDomain reDomain : reDomains) {
                reDomain.setChannelCode(channelCodec);
            }
        } else if (ListUtil.isNotEmpty(coCorderDomain.getCoCorderGoodsDomainList())) {
            List<CoCorderGoodsDomain> domains = coCorderDomain.getCoCorderGoodsDomainList();
            for (CoCorderGoodsDomain domain : domains) {
                domain.setChannelCode(channelCodec);
            }
        }
        coCorderDomain.setTenantCode(this.getTenantCode(request));
        return this.coCorderService.saveCorderStr(coCorderDomain);
    }

    @RequestMapping(value={"saveCorderForShoppingGoods.json"}, name="\u4ece\u8d2d\u7269\u8f66\u589e\u52a0\u5408\u540c\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean saveCorderForShoppingGoods(HttpServletRequest request, String shppinGoodsListStr) {
        List ocShoppingGoodsDomainList = JsonUtil.buildNonDefaultBinder().getJsonToList(shppinGoodsListStr, OcShoppingGoodsDomain.class);
        HashSet<String> set = new HashSet<String>();
        set.add("1");
        set.add("2");
        set.add("3");
        if (ListUtil.isEmpty((Collection)ocShoppingGoodsDomainList)) {
            this.logger.error(CODE + ".saveCorderForShoppingGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            this.logger.error(CODE + ".saveCorderForShoppingGoods", (Object)"userSession is null");
            return new HtmlJsonReBean("error", "\u767b\u5f55\u72b6\u6001\u5f02\u5e38");
        }
        if (userSession.getUserinfoLevel() < 1 || userSession.getUserinfoLevel() > 4) {
            this.logger.error(CODE + ".saveCorderForShoppingGoods", (Object)"\u7528\u6237\u7b49\u7ea7\u9519\u8bef\u6216\u4e3a\u7a7a");
            return new HtmlJsonReBean("error", "\u7528\u6237\u7b49\u7ea7\u4e3a\u7a7a,\u8bf7\u8054\u7cfb\u4e1a\u52a1\u5458\u8fdb\u884c\u8ba4\u8bc1\u7b49\u7ea7");
        }
        ArrayList<CoCorderDomain> coCorderDomainList = new ArrayList<CoCorderDomain>();
        Map<String, List<OcShoppingGoodsDomain>> collect = ocShoppingGoodsDomainList.stream().collect(Collectors.groupingBy(OcShoppingGoodsDomain::getGoodsProperty));
        for (String key : collect.keySet()) {
            if (set.contains(key)) continue;
            this.logger.info(CODE + ".saveCorderForShoppingGoods", (Object)"\u4e0d\u5141\u8bb8\u73b0\u8d27\u53d1\u8d77\u4ea4\u671f");
            return new HtmlJsonReBean("error", "\u4e0d\u5141\u8bb8\u73b0\u8d27\u53d1\u8d77\u4ea4\u671f");
        }
        for (String key : collect.keySet()) {
            if (!set.contains(key)) continue;
            CoCorderReDomain coCorderDomain = new CoCorderReDomain();
            HtmlJsonReBean htmlJsonReBeanR = this.initCorderDomain(request, coCorderDomain);
            if (!htmlJsonReBeanR.isSuccess()) {
                return htmlJsonReBeanR;
            }
            coCorderDomain.setContractProperty(key);
            ArrayList<CoCorderGoodsDomain> coCorderGoodsDomainList = new ArrayList<CoCorderGoodsDomain>();
            for (int i = 0; i < collect.get(key).size(); ++i) {
                OcShoppingGoodsDomain ocShoppingGoodsDomain = collect.get(key).get(i);
                CoCorderGoodsDomain coCorderGoodsDomain = this.initCorderGoodsDomain(request, ocShoppingGoodsDomain);
                coCorderGoodsDomainList.add(coCorderGoodsDomain);
                if (!"3".equals(key)) continue;
                coCorderGoodsDomain.setSkuNo("DZ01");
            }
            coCorderDomain.setCoCorderGoodsDomainList(coCorderGoodsDomainList);
            coCorderDomainList.add(coCorderDomain);
        }
        return this.limitUserSaveCorder(userSession, coCorderDomainList);
    }

    private HtmlJsonReBean limitUserSaveCorder(UserSession userSession, List<CoCorderDomain> coCorderDomainList) {
        Date nowDate;
        Date preSaveCoderDate;
        UmUserinfoQuaReDomain umUserinfoQuaReDomain;
        Integer userinfoLevel = userSession.getUserinfoLevel();
        HashMap<String, Object> ddFlagMap = new HashMap<String, Object>();
        ddFlagMap.put("flagSettingType", "userLevel");
        SupQueryResult<DdFalgSettingReDomain> ddFlagUserLevel = this.ddFalgSettingService.queryFalgSettingPage(ddFlagMap);
        if (ListUtil.isEmpty((Collection)ddFlagUserLevel.getList())) {
            this.logger.error(CODE + ".saveCorderForShoppingGoods.queryFalgSettingPage is null");
            return new HtmlJsonReBean("error", CODE + ".limitUserSaveCorder:ddFalgSetting is null");
        }
        List ddFlagUserLevels = ddFlagUserLevel.getList();
        DdFalgSettingDomain ddFalgSettingReDomain = null;
        for (DdFalgSettingReDomain ddFlag : ddFlagUserLevels) {
            if (!Integer.valueOf(ddFlag.getFlagSettingPro()).equals(userinfoLevel)) continue;
            ddFalgSettingReDomain = ddFlag;
        }
        if (ddFalgSettingReDomain == null) {
            this.logger.error(CODE + ".limitUserSaveCorder.queryFalgSettingPage is null");
            return new HtmlJsonReBean("error", "\u975e\u6cd5\u7b49\u7ea7");
        }
        Integer userLevelLimitCount = Integer.valueOf(ddFalgSettingReDomain.getFlagSettingInfo());
        HashMap<String, Object> queryUserinfoQueMap = new HashMap<String, Object>();
        queryUserinfoQueMap.put("userinfoCode", userSession.getUserPcode());
        queryUserinfoQueMap.put("userinfoQuaKey", "userSaveCorderCount");
        List<UmUserinfoQuaReDomain> umUserinfoQuaReDomains = this.userService.queryUserinfoQuaList(queryUserinfoQueMap);
        if (ListUtil.isEmpty(umUserinfoQuaReDomains) || umUserinfoQuaReDomains.size() > 1) {
            umUserinfoQuaReDomain = this.initUserinfoQua(userSession);
            HtmlJsonReBean htmlJsonReBean = this.userService.saveUserinfoQua(umUserinfoQuaReDomain);
            String umUserinfoQuaCode = (String)htmlJsonReBean.getDataObj();
            HtmlJsonReBean userinfoQuaByCode = this.userService.getUserinfoQuaByCode(userSession.getTenantCode(), umUserinfoQuaCode);
            umUserinfoQuaReDomain = (UmUserinfoQuaReDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject((String)userinfoQuaByCode.getDataObj(), UmUserinfoQuaReDomain.class);
        } else {
            umUserinfoQuaReDomain = umUserinfoQuaReDomains.get(0);
        }
        if (StringUtils.isBlank((String)umUserinfoQuaReDomain.getUserinfoQuaVaule())) {
            umUserinfoQuaReDomain.setUserinfoQuaVaule("0");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        if (StringUtils.isBlank((String)umUserinfoQuaReDomain.getUserinfoQuaVaule1())) {
            umUserinfoQuaReDomain.setUserinfoQuaVaule(sdf.format(new Date()));
        }
        String preSaveCoderDateStr = umUserinfoQuaReDomain.getUserinfoQuaVaule1();
        try {
            preSaveCoderDate = DateUtils.parseDate((String)preSaveCoderDateStr, (String)"yyyy-MM-dd hh:mm:ss");
            nowDate = new Date();
        }
        catch (ParseException e) {
            this.logger.error(CODE, (Object)(".limitUserSaveCorder" + e));
            return new HtmlJsonReBean("error", "\u65f6\u95f4\u8f6c\u6362\u51fa\u73b0\u5f02\u5e38:" + e);
        }
        this.logger.info(CODE + ".saveCorderForShoppingGoods::", (Object)JsonUtil.buildNonDefaultBinder().toJson(coCorderDomainList));
        if (this.isMoreThanOneDayDifference(preSaveCoderDate, nowDate)) {
            umUserinfoQuaReDomain.setUserinfoQuaVaule(String.valueOf(0));
        }
        Integer saveCorderCount = Integer.valueOf(umUserinfoQuaReDomain.getUserinfoQuaVaule());
        if (!this.isMoreThanOneDayDifference(preSaveCoderDate, nowDate) && userLevelLimitCount > 0 && userLevelLimitCount.compareTo(saveCorderCount) <= 0) {
            this.logger.info(CODE + ".limitUserSaveCorder", (Object)"\u54a8\u8be2\u6b21\u6570\u5df2\u7528\u5b8c");
            return new HtmlJsonReBean("error", "\u54a8\u8be2\u6b21\u6570\u5df2\u7528\u5b8c");
        }
        HtmlJsonReBean svaeCorderRes = this.coCorderService.saveCorderBatch(coCorderDomainList);
        if (!svaeCorderRes.isSuccess()) {
            this.logger.error(CODE + ".limitUserSaveCorder", (Object)"saveCorderBatch is error");
            return new HtmlJsonReBean("error", "\u63d0\u4ea4\u54a8\u8be2\u5931\u8d25");
        }
        umUserinfoQuaReDomain.setUserinfoQuaVaule(String.valueOf(saveCorderCount + 1));
        umUserinfoQuaReDomain.setUserinfoQuaVaule1(sdf.format(nowDate));
        HtmlJsonReBean htmlJsonReBean = this.userService.updateUserinfoQua(umUserinfoQuaReDomain);
        if (!htmlJsonReBean.isSuccess()) {
            return htmlJsonReBean;
        }
        return svaeCorderRes;
    }

    private UmUserinfoQuaReDomain initUserinfoQua(UserSession userSession) {
        UmUserinfoQuaReDomain umUserinfoQuaReDomain = new UmUserinfoQuaReDomain();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        umUserinfoQuaReDomain.setUserinfoCode(userSession.getUserPcode());
        umUserinfoQuaReDomain.setUserinfoQuaKey("userSaveCorderCount");
        umUserinfoQuaReDomain.setUserinfoQuaVaule("0");
        umUserinfoQuaReDomain.setUserinfoQuaVaule1(sdf.format(new Date()));
        umUserinfoQuaReDomain.setTenantCode(userSession.getTenantCode());
        return umUserinfoQuaReDomain;
    }

    public boolean isMoreThanOneDayDifference(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        cal1.set(11, 0);
        cal1.set(12, 0);
        cal1.set(13, 0);
        cal1.set(14, 0);
        cal2.set(11, 0);
        cal2.set(12, 0);
        cal2.set(13, 0);
        cal2.set(14, 0);
        long diffInMillis = cal2.getTimeInMillis() - cal1.getTimeInMillis();
        long diffInDays = diffInMillis / 86400000L;
        return diffInDays > 1L;
    }

    private CoCorderGoodsDomain initCorderGoodsDomain(HttpServletRequest request, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        CoCorderGoodsDomain coCorderGoodsDomain = new CoCorderGoodsDomain();
        UserSession userSession = this.getUserSession(request);
        try {
            BeanUtils.copyAllPropertys((Object)coCorderGoodsDomain, (Object)ocShoppingGoodsDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".saveCorderForShoppingGoods.initCorderGoodsDomain", (Object)("\u5c5e\u6027\u62f7\u8d1d." + e));
            throw new RuntimeException(e);
        }
        coCorderGoodsDomain.setContractGoodsCode(ocShoppingGoodsDomain.getShoppingGoodsCode());
        coCorderGoodsDomain.setDataOpbillstate(0);
        coCorderGoodsDomain.setChannelCode(this.getNowChannel(request));
        coCorderGoodsDomain.setTenantCode(this.getTenantCode(request));
        return coCorderGoodsDomain;
    }

    private HtmlJsonReBean initCorderDomain(HttpServletRequest request, CoCorderDomain corderdDomain) {
        UserSession userSession = this.getUserSession(request);
        corderdDomain.setMemberBcode(userSession.getUserPcode());
        corderdDomain.setMemberBname(userSession.getMerberCompname());
        corderdDomain.setChannelCode(this.getNowChannel(request));
        corderdDomain.setTenantCode(this.getTenantCode(request));
        corderdDomain.setContractAppraise(0);
        corderdDomain.setCorderSdate(new Date());
        UmUserinfoReDomainBean userinfo = this.userService.getUserInfoByUserinfoCode(userSession.getUserPcode(), this.getTenantCode(request));
        if (null == userinfo) {
            this.logger.error(CODE + ".saveCorderForShoppingGoods.initCorder", (Object)"userInfo is null");
            return new HtmlJsonReBean(null, "userInfo is null");
        }
        String employeeCode = userinfo.getEmployeeCode();
        String employeeName = userinfo.getEmployeeName();
        String goodsSupplierCode = userinfo.getUserinfoDiscode();
        String goodsSupplierName = userinfo.getUserinfoDisname();
        if (StringUtils.isBlank((String)employeeCode)) {
            this.logger.error(CODE + ".saveCorderForShoppingGoods.initCorder", (Object)"EmployeeCode is null");
            return new HtmlJsonReBean(null, "EmployeeCode is null");
        }
        corderdDomain.setEmployeeCode(employeeCode);
        corderdDomain.setEmployeeName(employeeName);
        corderdDomain.setGoodsSupplierCode(goodsSupplierCode);
        corderdDomain.setGoodsSupplierName(goodsSupplierName);
        corderdDomain.setAreaCode(userinfo.getCityCode());
        corderdDomain.setAreaName(userinfo.getCityName());
        corderdDomain.setCoCorderGoodsDomainList(new ArrayList<CoCorderGoodsDomain>());
        return new HtmlJsonReBean((Object)corderdDomain);
    }
}

