/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.oc;

import cn.com.qj.bff.common.bean.DisChannel;
import cn.com.qj.bff.core.auth.UserSession;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.oc.OcContractGoodsDomain;
import cn.com.qj.bff.domain.oc.OcContractGoodsReDomain;
import cn.com.qj.bff.domain.rs.RsResourceGoodsReDomain;
import cn.com.qj.bff.domain.rs.RsSkuDomain;
import cn.com.qj.bff.service.oc.OcContractService;
import cn.com.qj.bff.service.rs.RsResourceGoodsService;
import cn.com.qj.bff.service.rs.RsResourceService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/occontractgoods"}, name="\u8ba2\u5355")
public class OccontractgoodsCon
extends SpringmvcController {
    private static String CODE = "oc.occontractgoods.con";
    @Autowired
    private OcContractService ocContractService;
    @Autowired
    RsResourceService rsResourceService;
    @Autowired
    private RsResourceGoodsService rsResourceGoodsService;

    @Override
    protected String getContext() {
        return "occontractgoods";
    }

    @RequestMapping(value={"saveOcContractGoods.json"}, name="\u589e\u52a0\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean saveOcContractGoods(HttpServletRequest request, OcContractGoodsDomain occontractgoodsDomain) {
        if (null == occontractgoodsDomain) {
            this.logger.error(CODE + ".saveOcContractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        occontractgoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractService.saveContractGoods(occontractgoodsDomain);
    }

    @RequestMapping(value={"getOcContractGoods.json"}, name="\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f")
    @ResponseBody
    public OcContractGoodsReDomain getOcContractGoods(Integer contractGoodsId) {
        if (StringUtils.isBlank((Integer)contractGoodsId)) {
            this.logger.error(CODE + ".getOcContractGoods", (Object)"param is null");
            return null;
        }
        return this.ocContractService.getContractGoods(contractGoodsId);
    }

    @RequestMapping(value={"updateOcContractGoods.json"}, name="\u66f4\u65b0\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean updateOcContractGoods(HttpServletRequest request, OcContractGoodsDomain occontractgoodsDomain) {
        if (null == occontractgoodsDomain) {
            this.logger.error(CODE + ".updateOcContractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        occontractgoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractService.updateContractGoods(occontractgoodsDomain);
    }

    @RequestMapping(value={"deleteOcContractGoods.json"}, name="\u5220\u9664\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean deleteOcContractGoods(Integer contractGoodsId) {
        if (StringUtils.isBlank((Integer)contractGoodsId)) {
            this.logger.error(CODE + ".deleteOcContractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractService.deleteContractGoods(contractGoodsId);
    }

    @RequestMapping(value={"queryOcContractGoodsPage.json"}, name="\u67e5\u8be2\u8ba2\u5355\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractGoodsReDomain> queryOcContractGoodsPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractService.queryContractGoodsPage(param);
    }

    @RequestMapping(value={"updateOcContractGoodsState.json"}, name="\u66f4\u65b0\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOcContractGoodsState(String contractGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractGoodsId)) {
            this.logger.error(CODE + ".updateOcContractGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractService.updateContractGoodsState(Integer.valueOf(contractGoodsId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryContractGoodsSumRanking.json"}, name="\u8ba2\u5355\u9500\u552e\u6392\u884c")
    @ResponseBody
    public HtmlJsonReBean queryContractGoodsSumRanking(HttpServletRequest request, Integer dataState) {
        if (StringUtils.isBlank((Integer)dataState)) {
            this.logger.error(CODE + ".queryContractGoodsSumRanking", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String channelCode = "";
        String tenantCode = this.getTenantCode(request);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", dataState);
        map.put("contractType", "50");
        map.put("tenantCode", tenantCode);
        HtmlJsonReBean htmlJsonReBean = this.ocContractService.queryContractGoodsSumRanking(map);
        UserSession userSession = this.getUserSession(request);
        DisChannel disChannel = this.getChannelByMemRe(userSession.getUserPcode(), request);
        if (null != disChannel) {
            channelCode = disChannel.getChannelCode();
        }
        if (htmlJsonReBean.isSuccess()) {
            List jsonToList = JsonUtil.buildNonDefaultBinder().getJsonToListByMap(htmlJsonReBean.getDataObj().toString(), Object.class);
            this.logger.error(CODE + ".queryContractGoodsSumRanking", (Object)JsonUtil.buildNormalBinder().toJson((Object)jsonToList));
            if (ListUtil.isNotEmpty((Collection)jsonToList)) {
                block0: for (Map objectMap : jsonToList) {
                    if (null == objectMap.get("SKU_NO")) {
                        this.logger.error(CODE + ".queryContractGoodsSumRanking.\u5546\u54c1\u7f16\u53f7\u4e0d\u5b58\u5728", (Object)JsonUtil.buildNormalBinder().toJson((Object)objectMap));
                        continue;
                    }
                    Map<String, Object> GoodsMap = this.getPageQueryMapParams(request);
                    GoodsMap.put("skuNo", objectMap.get("SKU_NO"));
                    GoodsMap.put("goodsClass", "B2B-STORE");
                    GoodsMap.put("channelCode", channelCode);
                    GoodsMap.put("goodsType", "00");
                    RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceService.getResourceGoodsReDomain(GoodsMap);
                    if (null == rsResourceGoodsReDomain) {
                        this.logger.error(CODE + ".queryContractGoodsSumRanking.\u672a\u627e\u5230\u8be5\u5546\u54c1", (Object)JsonUtil.buildNormalBinder().toJson(map));
                        continue;
                    }
                    if (!ListUtil.isNotEmpty((rsResourceGoodsReDomain = this.rsResourceGoodsService.getRsGoodMemPriceReBean(rsResourceGoodsReDomain, userSession, rsResourceGoodsReDomain.getChannelCode(), rsResourceGoodsReDomain.getTenantCode())).getRsSkuDomainList())) continue;
                    for (RsSkuDomain rsSkuDomain : rsResourceGoodsReDomain.getRsSkuDomainList()) {
                        if (null == objectMap.get("SKU_NO") || !objectMap.get("SKU_NO").toString().equals(rsSkuDomain.getSkuNo())) continue;
                        this.logger.error(CODE + ".queryContractGoodsSumRanking.sku", (Object)JsonUtil.buildNormalBinder().toJson((Object)rsSkuDomain));
                        objectMap.put("PRICESET_NPRICE", rsSkuDomain.getPricesetNprice());
                        continue block0;
                    }
                }
                htmlJsonReBean.setDataObj((Object)jsonToList);
                return htmlJsonReBean;
            }
        }
        return htmlJsonReBean;
    }
}

