/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.tk;

import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.tk.TkTaskDomain;
import cn.com.qj.bff.domain.tk.TkTaskReDomain;
import cn.com.qj.bff.service.tk.TkTaskService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/tk/task"}, name="\u4efb\u52a1")
public class TaskCon
extends SpringmvcController {
    private static String CODE = "tk.task.con";
    @Autowired
    private TkTaskService tkTaskService;

    @Override
    protected String getContext() {
        return "task";
    }

    @RequestMapping(value={"saveTask.json"}, name="\u589e\u52a0\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveTask(HttpServletRequest request, TkTaskDomain tkTaskDomain) {
        if (null == tkTaskDomain) {
            this.logger.error(CODE + ".saveTask", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        tkTaskDomain.setTenantCode(this.getTenantCode(request));
        return this.tkTaskService.saveTask(tkTaskDomain);
    }

    @RequestMapping(value={"getTask.json"}, name="\u83b7\u53d6\u4efb\u52a1\u4fe1\u606f")
    @ResponseBody
    public TkTaskReDomain getTask(Integer taskId) {
        if (StringUtils.isBlank((Integer)taskId)) {
            this.logger.error(CODE + ".getTask", (Object)"param is null");
            return null;
        }
        return this.tkTaskService.getTask(taskId);
    }

    @RequestMapping(value={"updateTask.json"}, name="\u66f4\u65b0\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateTask(HttpServletRequest request, TkTaskDomain tkTaskDomain) {
        if (null == tkTaskDomain) {
            this.logger.error(CODE + ".updateTask", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        tkTaskDomain.setTenantCode(this.getTenantCode(request));
        return this.tkTaskService.updateTask(tkTaskDomain);
    }

    @RequestMapping(value={"deleteTask.json"}, name="\u5220\u9664\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteTask(Integer taskId) {
        if (StringUtils.isBlank((Integer)taskId)) {
            this.logger.error(CODE + ".deleteTask", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tkTaskService.deleteTask(taskId);
    }

    @RequestMapping(value={"queryTaskPage.json"}, name="\u67e5\u8be2\u4efb\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TkTaskReDomain> queryTaskPage(HttpServletRequest request) {
        Map<String, Object> param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.tkTaskService.queryTaskPage(param);
    }

    @RequestMapping(value={"getTaskBytaskOpcode.json"}, name="\u66f4\u5177\u6765\u6e90CODE\u83b7\u53d6\u4efb\u52a1\u5355")
    @ResponseBody
    public TkTaskReDomain getTaskBytaskOpcode(HttpServletRequest request, String taskOpcode) {
        if (StringUtils.isBlank((String)taskOpcode)) {
            this.logger.error(CODE + ".getTaskBytaskOpcode", (Object)"taskOpcode is null");
            return null;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", this.getTenantCode(request));
        param.put("taskOpcode", taskOpcode);
        SupQueryResult<TkTaskReDomain> tkTaskReDomainSupQueryResult = this.tkTaskService.queryTaskPage(param);
        if (null == tkTaskReDomainSupQueryResult || ListUtil.isEmpty((Collection)tkTaskReDomainSupQueryResult.getList())) {
            this.logger.error(CODE + ".getTaskBytaskOpcode.tkTaskReDomainSupQueryResult", (Object)"tkTaskReDomainSupQueryResult is null");
            return null;
        }
        return (TkTaskReDomain)tkTaskReDomainSupQueryResult.getList().get(0);
    }

    @RequestMapping(value={"updateIssueTask.json"}, name="\u5206\u53d1\u4efb\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateIssueTask(HttpServletRequest request, String tkTaskDomainStr) {
        if (StringUtils.isBlank((String)tkTaskDomainStr)) {
            this.logger.error(CODE + ".updateTask", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        TkTaskDomain jsonToObject = (TkTaskDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(tkTaskDomainStr, TkTaskDomain.class);
        if (null == jsonToObject) {
            this.logger.error(CODE + ".updateTask.jsonToObject", (Object)"jsonToObject is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "jsonToObject is null");
        }
        jsonToObject.setTenantCode(this.getTenantCode(request));
        this.tkTaskService.updateTask(jsonToObject);
        return this.tkTaskService.updateTaskState(jsonToObject.getTaskId(), 1, 0, null);
    }

    @RequestMapping(value={"updateTaskStateComplete.json"}, name="\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u4e3a\u5df2\u5b8c\u6210")
    @ResponseBody
    public HtmlJsonReBean updateTaskStateComplete(String taskId) {
        if (StringUtils.isBlank((String)taskId)) {
            this.logger.error(CODE + ".updateTaskState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tkTaskService.updateTaskState(Integer.valueOf(taskId), 2, 1, null);
    }
}

