/*
 * Decompiled with CFR 0.152.
 */
package cn.com.qj.bff.controller.tenant;

import cn.com.qj.bff.core.auth.UserInfo;
import cn.com.qj.bff.core.bean.HtmlJsonReBean;
import cn.com.qj.bff.domain.am.AmDepartReDomain;
import cn.com.qj.bff.domain.tm.TmTenantDomain;
import cn.com.qj.bff.domain.tm.TmTenantReDomain;
import cn.com.qj.bff.service.am.AmDepartService;
import cn.com.qj.bff.service.tm.TmTenantService;
import cn.com.qj.bff.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/tm/tenant"}, name="\u79df\u6237\u4fe1\u606f")
public class TenantCon
extends SpringmvcController {
    private static String CODE = "tm.tenant.con";
    @Autowired
    private TmTenantService tmTenantService;
    @Autowired
    private AmDepartService amDepartService;

    @Override
    protected String getContext() {
        return "tenant";
    }

    @RequestMapping(value={"saveTenant.json"}, name="\u589e\u52a0\u79df\u6237\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveTenant(TmTenantDomain tmTenantDomain) {
        if (null == tmTenantDomain) {
            this.logger.error(CODE + ".saveTenant", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        this.logger.info(CODE + ".saveTenant", (Object)tmTenantDomain.getProappCode());
        return this.tmTenantService.saveTenant(tmTenantDomain);
    }

    @RequestMapping(value={"getTenant.json"}, name="\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public TmTenantReDomain getTenant(String tenantId) {
        if (StringUtils.isBlank((String)tenantId)) {
            this.logger.error(CODE + ".getTenant", (Object)"param is null");
            return null;
        }
        return this.tmTenantService.getTenant(Integer.valueOf(tenantId));
    }

    @RequestMapping(value={"getTenantByNow.json"}, name="\u83b7\u53d6\u5f53\u524d\u79df\u6237\u4fe1\u606f")
    @ResponseBody
    public TmTenantReDomain getTenantByNow(HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", this.getTenantCode(request));
        return this.tmTenantService.getTenantByCode(map);
    }

    @RequestMapping(value={"updateTenant.json"}, name="\u66f4\u65b0\u79df\u6237\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateTenant(TmTenantDomain tmTenantDomain) {
        if (null == tmTenantDomain) {
            this.logger.error(CODE + ".updateTenant", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmTenantService.updateTenant(tmTenantDomain);
    }

    @RequestMapping(value={"deleteTenant.json"}, name="\u5220\u9664\u79df\u6237\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteTenant(String tenantId) {
        if (StringUtils.isBlank((String)tenantId)) {
            this.logger.error(CODE + ".deleteTenant", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmTenantService.deleteTenant(Integer.valueOf(tenantId));
    }

    @RequestMapping(value={"queryTenantPage.json"}, name="\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TmTenantReDomain> queryTenantPage(HttpServletRequest request) {
        return this.fetchQuery(request);
    }

    @RequestMapping(value={"queryTenantPageFromFilesort.json"}, name="\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5206\u9875\u5217\u8868-\u56fe\u7247\u5206\u7c7b")
    @ResponseBody
    public SupQueryResult<TmTenantReDomain> queryTenantPageFromFilesort(HttpServletRequest request) {
        return this.fetchQuery(request);
    }

    @RequestMapping(value={"queryTenantPageFromGe.json"}, name="\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5206\u9875\u5217\u8868-\u8fdb\u5ea6\u5b9a\u4e49")
    @ResponseBody
    public SupQueryResult<TmTenantReDomain> queryTenantPageFromGe(HttpServletRequest request) {
        return this.fetchQuery(request);
    }

    @RequestMapping(value={"queryTenantPageFromMsc.json"}, name="\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5206\u9875\u5217\u8868-\u9891\u9053\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TmTenantReDomain> queryTenantPageFromMsc(HttpServletRequest request) {
        return this.fetchQuery(request);
    }

    @RequestMapping(value={"queryTenantFromDisBySer.json"}, name="\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5206\u9875\u5217\u8868-\u6280\u672f\u4e2d\u53f0\u6e20\u9053")
    @ResponseBody
    public SupQueryResult<TmTenantReDomain> queryTenantFromDisBySer(HttpServletRequest request) {
        return this.fetchQuery(request);
    }

    public SupQueryResult<TmTenantReDomain> fetchQuery(HttpServletRequest request) {
        Map<String, Object> param = this.makeMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.tmTenantService.queryTenantPage(param);
    }

    @RequestMapping(value={"updateTenantState.json"}, name="\u66f4\u65b0\u79df\u6237\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateTenantState(String tenantId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)tenantId)) {
            this.logger.error(CODE + ".updateTenantState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.tmTenantService.updateTenantState(Integer.valueOf(tenantId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryTenantCache.json"}, name="\u79df\u6237\u52a0\u8f7d\u7f13\u5b58")
    @ResponseBody
    public HtmlJsonReBean queryTenantCache() {
        return this.tmTenantService.queryTenantCache();
    }

    @RequestMapping(value={"queryTenantPageStr.json"}, name="\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TmTenantReDomain> queryTenantPageStr(HttpServletRequest request) {
        Map<String, Object> param = this.makeMapParam(request);
        UserInfo userInfo = this.getUserInfo(request);
        Object page = param.get("page");
        Object rows = param.get("rows");
        if (null != param) {
            param.put("order", true);
        }
        param.put("userCode", userInfo.getUserCode());
        SupQueryResult<TmTenantReDomain> departReDomainSupQueryNewResult = new SupQueryResult<TmTenantReDomain>();
        param.put("page", null);
        param.put("rows", null);
        SupQueryResult<AmDepartReDomain> departReDomainList = this.amDepartService.queryDepartPage(param);
        if (ListUtil.isEmpty((Collection)departReDomainList.getList())) {
            this.logger.error(CODE + ".queryTenantPageStr", (Object)"departReDomainList is null");
            return departReDomainSupQueryNewResult;
        }
        param.put("page", page);
        param.put("rows", rows);
        StringBuilder tenantCodes = new StringBuilder();
        for (AmDepartReDomain depart : departReDomainList.getList()) {
            tenantCodes.append(depart.getTenantCode() + ",");
        }
        param.put("tenantCode", tenantCodes);
        departReDomainSupQueryNewResult = this.tmTenantService.queryToTenantCodes(param);
        return departReDomainSupQueryNewResult;
    }

    @RequestMapping(value={"queryTenantPageStrToParam.json"}, name="\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<TmTenantReDomain> queryTenantPageStrToParam(HttpServletRequest request, String tenantCode, String tenantCompname, Integer dataState) {
        Map<String, Object> param = this.makeMapParam(request);
        if (null != param) {
            param.put("tenantCode", tenantCode);
            param.put("tenantCompname", tenantCompname);
            param.put("dataState", dataState);
            param.put("order", true);
        }
        SupQueryResult<TmTenantReDomain> departReDomainSupQuer = new SupQueryResult<TmTenantReDomain>();
        if (StringUtils.isBlank((String)tenantCode)) {
            departReDomainSupQuer = this.queryTenantPageStr(request);
        }
        if (StringUtils.isNotBlank((String)tenantCode)) {
            return this.tmTenantService.queryToTenantCodes(param);
        }
        return departReDomainSupQuer;
    }
}

