/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.gift.utils;

import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.crypto.ECKeyUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.crypto.symmetric.SM4;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yqbsoft.laser.bus.ext.data.gift.utils.ByteUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Client {
    private static String SYS_CODE = "gi.Esbfacade";
    private String url;
    private String appId;
    private String key_version;
    private String sm2key;
    private String sm2privateKey;
    private String sm4key;
    private int connectTimeout = 3000;
    private int readTimeout = 15000;

    public Client(String url, String appId, String key_version, String sm2key, String sm2privateKey, String sm4key) {
        this.url = url;
        this.appId = appId;
        this.key_version = key_version;
        this.sm2key = sm2key;
        this.sm2privateKey = sm2privateKey;
        this.sm4key = sm4key;
    }

    public void setTimeout(int connectTimeout, int readTimeout) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    private static String getStringFromException(Throwable e) {
        String result = "";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        e.printStackTrace(ps);
        try {
            result = bos.toString("UTF-8");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static byte[] encryptMD5(String data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data.getBytes("UTF-8"));
        }
        catch (GeneralSecurityException gse) {
            String msg = Client.getStringFromException(gse);
            throw new IOException(msg);
        }
        return bytes;
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex);
        }
        return sign.toString();
    }

    public static String signRequest(Map<String, String> params, String appsecret) throws IOException {
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        for (Object key : keys) {
            if ("sign".equals(key)) continue;
            if (query.length() > 0) {
                query.append(';');
            }
            int len = ((String)key).length();
            query.append(String.format("%02d", len)).append('-').append((String)key).append(':');
            String value = params.get(key);
            len = value.length();
            query.append(String.format("%04d", len)).append('-').append(value);
        }
        query.append(appsecret);
        byte[] bytes = Client.encryptMD5(query.toString());
        return Client.byte2hex(bytes);
    }

    public String execute(String txn_type, String req_id, Map<String, String> map) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        String secretKey = this.sm4key;
        byte[] keyData = ByteUtils.fromHexString(secretKey);
        SM4 sm4 = SmUtil.sm4((byte[])keyData);
        String reqId = IdUtil.getSnowflakeNextIdStr();
        HashMap<String, String> comm = new HashMap<String, String>();
        comm.put("app_id", this.appId);
        comm.put("req_id", req_id);
        comm.put("key_version", this.key_version);
        comm.put("txn_type", txn_type);
        String data = objectMapper.writeValueAsString(map);
        System.out.println(reqId + "|\u672a\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570|" + data);
        String secretData = sm4.encryptHex(data, StandardCharsets.UTF_8);
        System.out.println(reqId + "|\u672a\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570|" + secretData);
        comm.put("data", secretData);
        SM2 sm2Sign = new SM2(ECKeyUtil.toSm2PrivateParams((String)this.sm2privateKey), null);
        String signContent = (String)comm.get("app_id") + (String)comm.get("req_id") + (String)comm.get("txn_type") + (String)comm.get("data");
        comm.put("sign", sm2Sign.signHex(HexUtil.encodeHexStr((String)signContent)));
        String msg = objectMapper.writeValueAsString(comm);
        String urlEncode = null;
        try {
            urlEncode = URLEncoder.encode(msg, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        HttpRequest request = HttpUtil.createPost((String)this.url);
        request.header("Content-Type", "application/json;charset=utf-8");
        request.body(urlEncode);
        HttpResponse response = request.execute();
        String body = response.body();
        String decode = URLDecoder.decode(body);
        Map responseMap = null;
        try {
            responseMap = (Map)objectMapper.readValue(decode, Map.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String res_id = responseMap.get("res_id").toString();
        String dataRes = responseMap.get("data").toString();
        String res_code = responseMap.get("res_code").toString();
        String signRes = responseMap.get("sign").toString();
        String signStrRes = res_id + dataRes + res_code;
        SM2 sm2ResVerifySign = new SM2(null, ECKeyUtil.toSm2PublicParams((String)this.sm2key));
        boolean verifyResSign = sm2ResVerifySign.verifyHex(HexUtil.encodeHexStr((String)signStrRes), signRes);
        if (verifyResSign && "000000".equals(res_code)) {
            dataRes = sm4.decryptStr(dataRes);
            return dataRes;
        }
        return decode;
    }
}

