/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.gift.utils;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.ECGenParameterSpec;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;

public class SM2Util {
    public KeyPair geneSM2KeyPair() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        ECGenParameterSpec sm2Spec = new ECGenParameterSpec("sm2p256v1");
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", (Provider)new BouncyCastleProvider());
        kpg.initialize(sm2Spec);
        KeyPair keyPair = kpg.generateKeyPair();
        return keyPair;
    }

    public String getPriKeyHexString(PrivateKey privateKey) {
        BCECPrivateKey s = (BCECPrivateKey)privateKey;
        String priKeyHexString = Hex.toHexString((byte[])s.getD().toByteArray());
        if (null != priKeyHexString && priKeyHexString.length() == 66 && "00".equals(priKeyHexString.substring(0, 2))) {
            return priKeyHexString.substring(2);
        }
        return priKeyHexString;
    }

    public String getPubKeyHexString(PublicKey publicKey) {
        BCECPublicKey p = (BCECPublicKey)publicKey;
        return Hex.toHexString((byte[])p.getQ().getEncoded(false));
    }

    public String encrypt(PublicKey publicKey, String data) {
        BCECPublicKey p = (BCECPublicKey)publicKey;
        return SM2Util.encrypt(Hex.toHexString((byte[])p.getQ().getEncoded(false)), data);
    }

    public String decrypt(PrivateKey privateKey, String cipherData) {
        BCECPrivateKey s = (BCECPrivateKey)privateKey;
        return this.decrypt(Hex.toHexString((byte[])s.getD().toByteArray()), cipherData);
    }

    public static String encrypt(String pubKeyHexString, String data) {
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        ECPoint pukPoint = sm2ECParameters.getCurve().decodePoint(Hex.decode((String)pubKeyHexString));
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKeyParameters, new SecureRandom()));
        byte[] arrayOfBytes = null;
        try {
            byte[] in = data.getBytes();
            arrayOfBytes = sm2Engine.processBlock(in, 0, in.length);
        }
        catch (Exception e) {
            System.out.println("SM2\u52a0\u5bc6\u65f6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
        }
        return Hex.toHexString((byte[])arrayOfBytes);
    }

    public String decrypt(String priKeyHexString, String cipherData) {
        if (!cipherData.startsWith("04")) {
            cipherData = "04" + cipherData;
        }
        byte[] cipherDataByte = Hex.decode((String)cipherData);
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        BigInteger privateKeyD = new BigInteger(priKeyHexString, 16);
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, domainParameters);
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(false, (CipherParameters)privateKeyParameters);
        String result = "";
        try {
            byte[] arrayOfBytes = sm2Engine.processBlock(cipherDataByte, 0, cipherDataByte.length);
            return new String(arrayOfBytes);
        }
        catch (Exception e) {
            System.out.println("SM2\u89e3\u5bc6\u65f6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
            return result;
        }
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        String M = "encryption standard";
        System.out.println("\n\u660e\u6587\uff1a" + M);
        SM2Util sm2 = new SM2Util();
        KeyPair keyPair = sm2.geneSM2KeyPair();
        PublicKey publicKey = keyPair.getPublic();
        String pubKeyHexString = sm2.getPubKeyHexString(publicKey);
        System.out.println("\u516c\u94a5\uff1a" + pubKeyHexString);
        PrivateKey privateKey = keyPair.getPrivate();
        String priKeyHexString = sm2.getPriKeyHexString(privateKey);
        System.out.println("\u79c1\u94a5\uff1a" + priKeyHexString);
        String cipherData = SM2Util.encrypt(pubKeyHexString, M);
        System.out.println("\u5bc6\u6587\uff1a" + cipherData);
        String text = sm2.decrypt(priKeyHexString, cipherData);
        System.out.println("\u89e3\u5bc6\uff1a" + text);
    }
}

