/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.gift.utils;

import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.bouncycastle.util.encoders.Hex;

public class SM4Util {
    private static final String ENCODING = "UTF-8";
    public static final String ALGORITHM_NAME = "SM4";
    public static final String ALGORITHM_NAME_ECB_PADDING = "SM4/ECB/PKCS5Padding";
    public static final int DEFAULT_KEY_SIZE = 256;

    public static String generateKey() throws Exception {
        return Hex.toHexString((byte[])SM4Util.generateKey(256));
    }

    public static byte[] generateKey(int keySize) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM_NAME, "BC");
        kg.init(keySize, new SecureRandom());
        return kg.generateKey().getEncoded();
    }

    private static Cipher generateEcbCipher(String algorithmName, int mode, byte[] key) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithmName, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
        cipher.init(mode, sm4Key);
        return cipher;
    }

    public static String encryptEcb(String hexKey, String paramStr) {
        try {
            String cipherText = "";
            byte[] keyData = ByteUtils.fromHexString((String)hexKey);
            byte[] srcData = paramStr.getBytes(ENCODING);
            byte[] cipherArray = SM4Util.encrypt_Ecb_Padding(keyData, srcData);
            cipherText = ByteUtils.toHexString((byte[])cipherArray);
            return cipherText;
        }
        catch (Exception e) {
            return paramStr;
        }
    }

    public static byte[] encrypt_Ecb_Padding(byte[] key, byte[] data) throws Exception {
        Cipher cipher = SM4Util.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 1, key);
        return cipher.doFinal(data);
    }

    public static String decryptEcb(String hexKey, String cipherText) {
        String decryptStr = "";
        byte[] keyData = ByteUtils.fromHexString((String)hexKey);
        byte[] cipherData = ByteUtils.fromHexString((String)cipherText);
        byte[] srcData = new byte[]{};
        try {
            srcData = SM4Util.decrypt_Ecb_Padding(keyData, cipherData);
            decryptStr = new String(srcData, ENCODING);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return decryptStr;
    }

    public static byte[] decrypt_Ecb_Padding(byte[] key, byte[] cipherText) throws Exception {
        Cipher cipher = SM4Util.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 2, key);
        return cipher.doFinal(cipherText);
    }

    public static boolean verifyEcb(String hexKey, String cipherText, String paramStr) throws Exception {
        boolean flag = false;
        byte[] keyData = ByteUtils.fromHexString((String)hexKey);
        byte[] cipherData = ByteUtils.fromHexString((String)cipherText);
        byte[] decryptData = SM4Util.decrypt_Ecb_Padding(keyData, cipherData);
        byte[] srcData = paramStr.getBytes(ENCODING);
        flag = Arrays.equals(decryptData, srcData);
        return flag;
    }

    public static void main(String[] args) {
        try {
            String json = "{\"name\":\"jz\"}";
            System.out.println("\u660e\u6587\uff1a" + json);
            String key = SM4Util.generateKey();
            System.out.println("\u5bc6\u94a5\uff1a" + key);
            String cipher = SM4Util.encryptEcb(key, json);
            System.out.println("\u5bc6\u6587\uff1a" + cipher);
            System.out.println("\u6570\u636e\u662f\u5426\u6709\u6548\uff1a" + SM4Util.verifyEcb(key, cipher, json));
            String res = SM4Util.decryptEcb(key, cipher);
            System.out.println("\u89e3\u5bc6\u540e\u6570\u636e\uff1a" + res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

