/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.gift.utils;

import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.crypto.ECKeyUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.crypto.symmetric.SM4;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyPwdTest {
    private static final Logger log = LoggerFactory.getLogger(VerifyPwdTest.class);
    public static String privateKey = "44ae55430bb5c8423c1375256e990439c5f188fd1d6b4ce361454e183ec45425";
    public static String publicKey = "044cac459fc90dd6d8d9dbcaeb212937869d169af034639e7530d1ef565cf119113434b00d5b88f8626abd2fc6419e85e7dc3169182f5bb5c267d70b949c7f0a3d";
    public static String SysPublicKey = "0425e89208ec97dd6926562e7acea428f7b5a79139080c0e4782bf0fb5be10ee47f7474529be149028a02c050a6a250a1b74d03a4022052d972e9da79d029d6713";
    public static String URL = "https://app.psp.zihexin.cn/gift/comm/txn";

    public static void main(String[] args) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String secretKey = "36a44c22c1b63af2e5ed8bfb584e325d";
        byte[] keyData = ByteUtils.fromHexString((String)secretKey);
        SM4 sm4 = SmUtil.sm4((byte[])keyData);
        String reqId = IdUtil.getSnowflakeNextIdStr();
        HashMap<String, String> comm = new HashMap<String, String>();
        comm.put("app_id", "202310261009");
        comm.put("req_id", reqId);
        comm.put("key_version", "1");
        comm.put("txn_type", "verifyPwd");
        HashMap<String, String> biz = new HashMap<String, String>();
        biz.put("card_no", "8410237800805439");
        biz.put("pwd", "411252");
        String data = objectMapper.writeValueAsString(biz);
        log.info("{}|\u672a\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570|{}", (Object)reqId, (Object)data);
        System.out.println(reqId + "|\u672a\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570|" + data);
        String secretData = sm4.encryptHex(data, StandardCharsets.UTF_8);
        log.info("{}|\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570|{}", (Object)reqId, (Object)secretData);
        System.out.println(reqId + "|\u672a\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570|" + secretData);
        comm.put("data", secretData);
        SM2 sm2Sign = new SM2(ECKeyUtil.toSm2PrivateParams((String)privateKey), null);
        String signContent = (String)comm.get("app_id") + (String)comm.get("req_id") + (String)comm.get("txn_type") + (String)comm.get("data");
        System.out.println(reqId + "|\u52a0\u7b7e\u539f\u6587|" + signContent);
        comm.put("sign", sm2Sign.signHex(HexUtil.encodeHexStr((String)signContent)));
        System.out.println(reqId + "|\u52a0\u7b7e\u7ed3\u679c|" + (String)comm.get("sign"));
        String msg = objectMapper.writeValueAsString(comm);
        log.info("{}|\u8bf7\u6c42\u62a5\u6587|{}", (Object)reqId, (Object)msg);
        System.out.println(reqId + "|\u8bf7\u6c42\u62a5\u6587|" + msg);
        String urlEncode = null;
        try {
            urlEncode = URLEncoder.encode(msg, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        log.info("{}|urlEncode|{}", (Object)reqId, (Object)urlEncode);
        System.out.println(reqId + "|urlEncode|" + urlEncode);
        HttpRequest request = HttpUtil.createPost((String)URL);
        request.header("Content-Type", "application/json;charset=utf-8");
        request.body(urlEncode);
        HttpResponse response = request.execute();
        System.out.println(reqId + "|\u54cd\u5e94\u7801|" + response.getStatus());
        String body = response.body();
        System.out.println(reqId + "|\u54cd\u5e94\u5185\u5bb9|" + body);
        String decode = URLDecoder.decode(body);
        System.out.println(reqId + "|\u54cd\u5e94\u5185\u5bb9URLDecoder|" + decode);
        Map map = null;
        try {
            map = (Map)objectMapper.readValue(decode, Map.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String res_id = map.get("res_id").toString();
        String dataRes = map.get("data").toString();
        String res_code = map.get("res_code").toString();
        String signRes = map.get("sign").toString();
        String signStrRes = res_id + dataRes + res_code;
        SM2 sm2ResVerifySign = new SM2(null, ECKeyUtil.toSm2PublicParams((String)SysPublicKey));
        boolean verifyResSign = sm2ResVerifySign.verifyHex(HexUtil.encodeHexStr((String)signStrRes), signRes);
        System.out.println(reqId + "|\u54cd\u5e94\u62a5\u6587\u9a8c\u7b7e\u7ed3\u679c|" + verifyResSign);
        dataRes = sm4.decryptStr(dataRes);
        System.out.println(reqId + "|\u4e1a\u52a1\u53c2\u6570\u89e3\u5bc6|" + dataRes);
    }
}

