/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.gst.service.impl;

import com.yqbsoft.laser.bus.ext.data.gst.domain.CallbackResult;
import com.yqbsoft.laser.bus.ext.data.gst.domain.PtePtrade;
import com.yqbsoft.laser.bus.ext.data.gst.response.HtmlJsonBean;
import com.yqbsoft.laser.bus.ext.data.gst.response.Token;
import com.yqbsoft.laser.bus.ext.data.gst.service.GstPayService;
import com.yqbsoft.laser.bus.ext.data.gst.util.HttpClientUtil;
import com.yqbsoft.laser.bus.ext.data.gst.util.JsonUtil;
import com.yqbsoft.laser.bus.ext.data.gst.util.PayHttpClientUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GstPayServiceImpl
extends BaseServiceImpl
implements GstPayService {
    private static final String SYS_CODE = "GstPayServiceImpl";
    private static final Logger logger = LoggerFactory.getLogger(GstPayServiceImpl.class);
    private static final Object lock = new Object();
    private static final String GST_ACCESS_TOKEN = "gst_pay_access_token";
    private static final String GST_REFRESH_TOKEN = "gst_pay_refresh_token";
    public static final String DdFalgSettingKey = "DdFalgSetting-key";
    public static final String TENANT_CODE = "00000000";
    private static final String FORM_URLENCODED = "application/x-www-form-urlencoded";

    @Override
    public String savePay(PtePtrade ptePtrade) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Map extMap = com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToMap(ptePtrade.getExtension(), String.class, Object.class);
        param.put("thirdOrderNumber", ptePtrade.getPtradeSeqno());
        param.put("appCode", "wxfabd8a35f0447c55");
        param.put("sdkVersion", "1.0");
        param.put("systemCode", "LNShopIntegral");
        param.put("appUUID", extMap.get("openId"));
        param.put("payType", "20201");
        param.put("orderForm", "20201");
        param.put("payDesc", "\u79ef\u5206\u5c0f\u7a0b\u5e8f\u5546\u57ce\u652f\u4ed8");
        int payMoney = ptePtrade.getOrderAmount().multiply(new BigDecimal(100)).intValue();
        param.put("payMoney", payMoney);
        param.put("businessType", "");
        return PayHttpClientUtil.post("http://192.168.174.102:8000/gst-pay/simplePayEncryption?apikey=ee76094f84cc5e4e11821d1dc4a3e7fa", param);
    }

    @Override
    public HtmlJsonBean payCallback(Map<String, Object> param) {
        String json = com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param);
        logger.error("GstPayServiceImpl.payCallback.param", (Object)json);
        if (null == param.get("thirdOrderNumber")) {
            return new HtmlJsonBean("-1", "\u53c2\u6570\u9519\u8bef\uff0c\u4e1a\u52a1\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        String thirdOrderNumber = param.get("thirdOrderNumber").toString();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ptradeSeqno", thirdOrderNumber);
        map.put("ptradeExtension", json);
        map.put("tenantCode", param.get("tenantCode"));
        paramMap.put("map", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(map));
        String jsonResult = this.internalInvoke("pte.ptradeBase.sendCallBack", paramMap);
        CallbackResult callbackResult = CallbackResult.SUCCESS;
        if (StringUtils.isNotBlank((String)jsonResult) && (callbackResult = (CallbackResult)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(jsonResult, CallbackResult.class)).isSuccess()) {
            return new HtmlJsonBean();
        }
        return new HtmlJsonBean("-1", "\u64cd\u4f5c\u5931\u8d25");
    }

    @Override
    public String saveRefund(PtePtrade ptePtrade) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Map extMap = com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToMap(ptePtrade.getExtension(), String.class, Object.class);
        param.put("appCode", "appCode");
        param.put("sdkVersion", "appCode");
        param.put("appUUID", extMap.get("openId"));
        param.put("payDesc", "\u79ef\u5206\u5c0f\u7a0b\u5e8f\u5546\u57ce\u9000\u6b3e");
        param.put("thirdOrderNumber", ptePtrade.getPtradeOldseqno());
        param.put("systemCode", "LNShopIntegral");
        param.put("payType", "20201");
        param.put("orderForm", "20201");
        int refundFee = ptePtrade.getOrderAmount().multiply(new BigDecimal(100)).intValue();
        param.put("refundFee", refundFee);
        param.put("userId", ptePtrade.getOpuserCode());
        param.put("userName", ptePtrade.getOpuserName());
        return PayHttpClientUtil.post("http://192.168.174.102:8000/gst-refund/wechatPayRefundForShop?apikey=ee76094f84cc5e4e11821d1dc4a3e7fa", param);
    }

    @Override
    public HtmlJsonBean refundCallback(Map<String, Object> param) {
        String json = com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(param);
        logger.error("GstPayServiceImpl.refundCallback.param", (Object)json);
        if (null == param.get("out_refund_no")) {
            return new HtmlJsonBean("-1", "\u53c2\u6570\u9519\u8bef\uff0c\u4e1a\u52a1\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        String thirdOrderNumber = param.get("out_refund_no").toString();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ptradeSeqno", thirdOrderNumber);
        map.put("ptradeExtension", json);
        map.put("tenantCode", param.get("tenantCode"));
        paramMap.put("map", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(map));
        String jsonResult = this.internalInvoke("pte.ptradeBase.sendCallBack", paramMap);
        CallbackResult callbackResult = CallbackResult.SUCCESS;
        if (StringUtils.isNotBlank((String)jsonResult) && (callbackResult = (CallbackResult)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(jsonResult, CallbackResult.class)).isSuccess()) {
            return new HtmlJsonBean();
        }
        return new HtmlJsonBean("-1", "\u64cd\u4f5c\u5931\u8d25");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToken() {
        String token = DisUtil.getRemot((String)GST_ACCESS_TOKEN);
        if (StringUtils.isNotBlank((String)token)) {
            return token;
        }
        Object object = lock;
        synchronized (object) {
            token = DisUtil.getRemot((String)GST_ACCESS_TOKEN);
            if (StringUtils.isNotBlank((String)token)) {
                return token;
            }
            String tokenStr = this.getTokenMain();
            Token tokenDomain = this.makeTokenDomain(tokenStr);
            String accessToken = tokenDomain.getAccess_token();
            if (StringUtils.isBlank((String)accessToken)) {
                logger.error("GstPayServiceImpl.getToken.tokenDomain:{}", (Object)JsonUtil.object2Json(tokenDomain));
                throw new ApiException("access_token\u4e3a\u7a7a");
            }
            DisUtil.set((String)GST_ACCESS_TOKEN, (String)accessToken, (int)tokenDomain.getExpires_in());
            return accessToken;
        }
    }

    String getTokenMain() {
        Map<String, String> body = this.makeBodyMap();
        Map<String, String> headers = this.makeHeadersMap();
        String tokenStr = null;
        try {
            logger.info("GstPayServiceImpl.getTokenMain \u8bf7\u6c42\u53c2\u6570, url:{}, headers:{}, body:{}", new Object[]{"http://192.168.174.102:8000/blade-auth/gstpay/oauth/token?apikey=ee76094f84cc5e4e11821d1dc4a3e7fa", JsonUtil.object2Json(headers), JsonUtil.object2Json(body)});
            tokenStr = HttpClientUtil.invokePost("http://192.168.174.102:8000/blade-auth/gstpay/oauth/token?apikey=ee76094f84cc5e4e11821d1dc4a3e7fa", headers, body);
            logger.info("GstPayServiceImpl.getTokenMain \u54cd\u5e94\u7ed3\u679c, url:{}, responseStr:{}", (Object)"http://192.168.174.102:8000/blade-auth/gstpay/oauth/token?apikey=ee76094f84cc5e4e11821d1dc4a3e7fa", (Object)tokenStr);
        }
        catch (Exception e) {
            logger.error("GstPayServiceImpl.getTokenMain.e:{}", (Throwable)e);
            return null;
        }
        return tokenStr;
    }

    private Token makeTokenDomain(String tokenStr) {
        if (tokenStr == null) {
            throw new ApiException("\u83b7\u53d6token\u5931\u8d25");
        }
        Token tokenDomain = JsonUtil.json2Object(tokenStr, Token.class);
        if (tokenDomain == null) {
            logger.error("GstPayServiceImpl.getToken.tokenStr:{}", (Object)tokenStr);
            throw new ApiException("\u8f6c\u6362token\u5931\u8d25");
        }
        return tokenDomain;
    }

    private Map<String, String> makeHeadersMap() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-type", FORM_URLENCODED);
        headers.put("Tenant-Id", GstPayServiceImpl.getTenantId(null));
        headers.put("Authorization", GstPayServiceImpl.getAuthorization(null));
        return headers;
    }

    private Map<String, String> makeBodyMap() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("grant_type", "password");
        param.put("username", GstPayServiceImpl.getUsername(null));
        param.put("password", GstPayServiceImpl.getPassword(null));
        String refreshToken = DisUtil.getRemot((String)GST_REFRESH_TOKEN);
        if (StringUtils.isNotBlank((String)refreshToken)) {
            param.put("refresh_token", refreshToken);
        }
        return param;
    }

    private static String getAuthorization(String tenantCode) {
        return GstPayServiceImpl.getDdFalgSetting(tenantCode, "gst", "Pay_Authorization");
    }

    private static String getTenantId(String tenantCode) {
        return GstPayServiceImpl.getDdFalgSetting(tenantCode, "gst", "Pay_Tenant-Id");
    }

    private static String getUsername(String tenantCode) {
        return GstPayServiceImpl.getDdFalgSetting(tenantCode, "gst", "Pay_username");
    }

    private static String getPassword(String tenantCode) {
        return GstPayServiceImpl.getDdFalgSetting(tenantCode, "gst", "Pay_password");
    }

    public static String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = TENANT_CODE;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)DdFalgSettingKey, (String)field);
    }
}

