/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.gst.util;

import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.Charsets;
import org.jsoup.helper.StringUtil;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.Base64Utils;

public class AesUtil {
    public static final Charset DEFAULT_CHARSET = Charsets.UTF_8;

    public static String genAesKey() {
        return RandomUtils.generateRandom((int)32, (Integer)0);
    }

    public static byte[] encrypt(String content, String aesTextKey) {
        return AesUtil.encrypt(content.getBytes(DEFAULT_CHARSET), aesTextKey);
    }

    public static byte[] encrypt(String content, Charset charset, String aesTextKey) {
        return AesUtil.encrypt(content.getBytes(charset), aesTextKey);
    }

    public static byte[] encrypt(byte[] content, String aesTextKey) {
        return AesUtil.encrypt(content, Objects.requireNonNull(aesTextKey).getBytes(DEFAULT_CHARSET));
    }

    public static String encryptToBase64(String content, String aesTextKey) {
        return Base64Utils.encodeToString((byte[])AesUtil.encrypt(content, aesTextKey));
    }

    public static String encryptToBase64(String content) {
        String aesTextKey = AesUtil.getSecretkey(null);
        return Base64Utils.encodeToString((byte[])AesUtil.encrypt(content, aesTextKey));
    }

    private static String getSecretkey(String tenantCode) {
        return AesUtil.getDdFalgSetting(tenantCode, "gst", "Pay_Secretkey");
    }

    public static String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = "00000000";
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    public static String encryptToBase64(byte[] content, String aesTextKey) {
        return Base64Utils.encodeToString((byte[])AesUtil.encrypt(content, aesTextKey));
    }

    @Nullable
    public static String decryptFormBase64ToString(@Nullable String content, String aesTextKey) {
        byte[] hexBytes = AesUtil.decryptFormBase64(content, aesTextKey);
        if (hexBytes == null) {
            return null;
        }
        return new String(hexBytes, DEFAULT_CHARSET);
    }

    @Nullable
    public static byte[] decryptFormBase64(@Nullable String content, String aesTextKey) {
        if (StringUtil.isBlank((String)content)) {
            return null;
        }
        return AesUtil.decryptFormBase64(content.getBytes(DEFAULT_CHARSET), aesTextKey);
    }

    public static byte[] decryptFormBase64(byte[] content, String aesTextKey) {
        return AesUtil.decrypt(Base64Utils.decode((byte[])content), aesTextKey);
    }

    public static String decryptToString(byte[] content, String aesTextKey) {
        return new String(AesUtil.decrypt(content, aesTextKey), DEFAULT_CHARSET);
    }

    public static byte[] decrypt(byte[] content, String aesTextKey) {
        return AesUtil.decrypt(content, Objects.requireNonNull(aesTextKey).getBytes(DEFAULT_CHARSET));
    }

    public static byte[] encrypt(byte[] content, byte[] aesKey) {
        return AesUtil.aes(Pkcs7Encoder.encode(content), aesKey, 1);
    }

    public static byte[] decrypt(byte[] encrypted, byte[] aesKey) {
        return Pkcs7Encoder.decode(AesUtil.aes(encrypted, aesKey, 2));
    }

    private static byte[] aes(byte[] encrypted, byte[] aesKey, int mode) {
        Assert.isTrue((aesKey.length == 32 ? 1 : 0) != 0, (String)"IllegalAesKey, aesKey's length must be 32");
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(aesKey, 0, 16));
            cipher.init(mode, (Key)keySpec, iv);
            return cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String key = "SSx0rlC7gQs7zEZPa8s5BI9la7Utic7P";
        String json = "{\"orderForm\":\"20201\",\"payDesc\":\"\u79ef\u5206\u5c0f\u7a0b\u5e8f\u5546\u57ce\u652f\u4ed8\",\"appUUID\":\"oSBEg7Y3jWFtXDwa1R68WTVpSEqc\",\"payType\":\"20201\",\"payMoney\":\"230\",\"systemCode\":\"LNShopIntegral\",\"sdkVersion\":\"1.0\",\"appCode\":\"wxfabd8a35f0447c55\",\"businessType\":\"\",\"thirdOrderNumber\":\"871353485154607105\"}";
        String s1 = AesUtil.encryptToBase64(json, key);
        s1 = "tg0Rpu+DwJYC3YR5++73wPhlj0rkG6bauSUfSuPQ+UncZ0BOE4rGYiyTdHfTK/C0HTR9BHiW/nRsuRf9liGVtFDikwlC624YKkyCYtjjK7nQkHRCE7752h1IDmHQTZOxjTgvuGWKGS645UmMPypw1AQzVDG3iuriilCWv8ZvoLJwnObc9f/lBJj+TfOQb6yKOIoACKuURgk0NV0NYeVFrht26XqIJ/IWL1KCXQKrblBD+V90M5AJqhf8JjStxphDALZTXtEJTFVya/m+1xKnydsVqVQ9Toz2PGGnaw+rI+T9VbiwkeE1E+NfZqHxPSdM/5H7Mx2i3JZ4191X0uETtx3OxVTZRyR98OqeaU16pzon3Wj6fsWSCO3cguXRPXcZ";
        String s = AesUtil.decryptFormBase64ToString(s1, key);
        System.out.println(s);
    }

    private static class Pkcs7Encoder {
        private static final int BLOCK_SIZE = 32;

        private Pkcs7Encoder() {
        }

        private static byte[] encode(byte[] src) {
            int count = src.length;
            int amountToPad = 32 - count % 32;
            byte pad = (byte)(amountToPad & 0xFF);
            byte[] pads = new byte[amountToPad];
            for (int index = 0; index < amountToPad; ++index) {
                pads[index] = pad;
            }
            int length = count + amountToPad;
            byte[] dest = new byte[length];
            System.arraycopy(src, 0, dest, 0, count);
            System.arraycopy(pads, 0, dest, count, amountToPad);
            return dest;
        }

        private static byte[] decode(byte[] decrypted) {
            byte pad = decrypted[decrypted.length - 1];
            if (pad < 1 || pad > 32) {
                pad = 0;
            }
            if (pad > 0) {
                return Arrays.copyOfRange(decrypted, 0, decrypted.length - pad);
            }
            return decrypted;
        }
    }
}

