/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.gst.service.impl;

import com.yqbsoft.laser.bus.ext.data.gst.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.bus.ext.data.gst.domain.OcContractReDomain;
import com.yqbsoft.laser.bus.ext.data.gst.domain.OcRefundReDomain;
import com.yqbsoft.laser.bus.ext.data.gst.domain.OcRefundproDomain;
import com.yqbsoft.laser.bus.ext.data.gst.response.GstQueryResult3;
import com.yqbsoft.laser.bus.ext.data.gst.response.GstResult;
import com.yqbsoft.laser.bus.ext.data.gst.response.UseCard;
import com.yqbsoft.laser.bus.ext.data.gst.service.GstOrderService;
import com.yqbsoft.laser.bus.ext.data.gst.service.impl.GstGoodsServiceImpl;
import com.yqbsoft.laser.bus.ext.data.gst.util.HttpClientUtil;
import com.yqbsoft.laser.bus.ext.data.gst.util.JsonUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GstOrderServiceImpl
extends BaseServiceImpl
implements GstOrderService {
    private static final String SYS_CODE = "GstGoodsServiceImpl";
    private static final Logger logger = LoggerFactory.getLogger(GstGoodsServiceImpl.class);

    @Override
    public String cardLock(OcContractReDomain ocContractDomain) {
        if (ocContractDomain == null || ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            return "error";
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("memId", ocContractDomain.getUserName());
        params.put("thirdPartyOrderNumber", ocContractDomain.getContractBillcode());
        ArrayList mapList = new ArrayList();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("stockId", ocContractGoodsDomain.getSkuNo());
            map.put("quantity", ocContractGoodsDomain.getGoodsCamount());
            mapList.add(map);
        }
        params.put("goodsList", mapList);
        GstResult result = HttpClientUtil.postToResult("http://192.168.174.102:8000/sopapi/api/wft/external/apiAuth/couponexternal/couponStockLock", params);
        if (result != null && !"0".equals(result.getCode())) {
            logger.error("GstGoodsServiceImpl.cardLock.\u5361\u5238\u9501\u5b9a\u5931\u8d25,contractBillcode:{},msg:{}", (Object)ocContractDomain.getContractBillcode(), (Object)result.getMsg());
            return "error";
        }
        return "success";
    }

    @Override
    public String createOrder(OcContractReDomain ocContractDomain) {
        if (ocContractDomain == null || ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            return "error";
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("memId", ocContractDomain.getUserName());
        params.put("thirdPartyOrderNumber", ocContractDomain.getContractBillcode());
        ArrayList mapList = new ArrayList();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("stockId", ocContractGoodsDomain.getSkuNo());
            map.put("quantity", ocContractGoodsDomain.getGoodsCamount());
            mapList.add(map);
        }
        params.put("goodsList", mapList);
        GstResult result = HttpClientUtil.postToResult("http://192.168.174.102:8000/sopapi/api/wft/external/apiAuth/couponexternal/sendByIntegralShop", params);
        if (result != null && !"0".equals(result.getCode())) {
            logger.error("GstGoodsServiceImpl.createOrder.\u865a\u62df\u5546\u54c1\u4e0b\u5355\u5931\u8d25,contractBillcode:{},msg:{}", (Object)ocContractDomain.getContractBillcode(), (Object)result.getMsg());
            return "error";
        }
        return "success";
    }

    @Override
    public String cancelCardLock(OcContractReDomain ocContractDomain) {
        if (ocContractDomain == null || ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            return "error";
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("memId", ocContractDomain.getUserName());
        params.put("thirdPartyOrderNumber", ocContractDomain.getContractBillcode());
        GstResult result = HttpClientUtil.postToResult("http://192.168.174.102:8000/sopapi/api/wft/external/apiAuth/couponexternal/couponStockUnLock", params);
        if (result != null && !"0".equals(result.getCode())) {
            logger.error("GstGoodsServiceImpl.cancelCardLock.\u865a\u62df\u5546\u54c1\u4e0b\u5355\u5931\u8d25,contractBillcode:{},msg:{}", (Object)ocContractDomain.getContractBillcode(), (Object)result.getMsg());
            return "error";
        }
        return "success";
    }

    @Override
    public GstQueryResult3<UseCard> queryOrderCardList(Map<String, Object> param) {
        if (MapUtil.isEmpty(param)) {
            return new GstQueryResult3<UseCard>();
        }
        GstQueryResult3<UseCard> queryResult = HttpClientUtil.postToQueryResult3("http://192.168.174.102:8000/sopapi/api/wft/external/apiAuth/couponexternal/listCouponStatusForShop", param);
        if (queryResult == null || !queryResult.isSuccess().booleanValue()) {
            logger.error("GstGoodsServiceImpl.queryCardStatus.\u8ba2\u5355\u5361\u5238\u67e5\u8be2\u5931\u8d25,param:{}", (Object)JsonUtil.object2Json(param));
            return queryResult;
        }
        return queryResult;
    }

    @Override
    public String cancelCard(OcRefundReDomain ocRefundDomain) {
        if (ListUtil.isEmpty(ocRefundDomain.getOcRefundproDomainList())) {
            return "error";
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("memId", ocRefundDomain.getEmployeeCode());
        param.put("thirdPartyOrderNumber", ocRefundDomain.getContractBillcode());
        param.put("afterSalesTrackingNumber", ocRefundDomain.getRefundCode());
        param.put("deprecationType", 1);
        param.put("applicationTime", new Date());
        String str = "success";
        for (OcRefundproDomain ocRefundproDomain : ocRefundDomain.getOcRefundproDomainList()) {
            param.put("seriNo", ocRefundproDomain.getContractproKey());
            GstResult gstResult = HttpClientUtil.postToResult("http://192.168.174.102:8000/sopapi/api/wft/external/apiAuth/couponexternal/cancelByIntegralShop", param);
            if (gstResult != null && "0".equals(gstResult.getCode())) continue;
            str = "error";
        }
        return str;
    }

    @Override
    public void queryIssueCard(String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractType", "07");
        map.put("childFlag", true);
        map.put("dataState", 2);
        List<OcContractReDomain> ocContractReDomains = this.inInvokeToQuery("oc.contract.queryContractPageReDomain", map, OcContractReDomain.class);
        for (OcContractReDomain ocContractReDomain : ocContractReDomains) {
            Boolean aBoolean = this.checkIssueCard(ocContractReDomain);
            if (!aBoolean.booleanValue()) continue;
            this.sendContractNext(tenantCode, ocContractReDomain.getContractBillcode());
        }
    }

    Boolean checkIssueCard(OcContractReDomain ocContractReDomain) {
        boolean flag = true;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("memId", ocContractReDomain.getEmployeeCode());
        param.put("thirdPartyOrderNumber", ocContractReDomain.getContractBillcode());
        GstQueryResult3 queryResult = HttpClientUtil.postToQueryResult3("http://192.168.174.102:8000/sopapi/api/wft/external/apiAuth/couponexternal/listCouponStatusForShop", param);
        if (queryResult == null || !queryResult.isSuccess().booleanValue()) {
            logger.error("GstGoodsServiceImpl.queryCardStatus.\u865a\u62df\u5546\u54c1\u72b6\u6001\u67e5\u8be2\u5931\u8d25,contractBillcode:{}", (Object)ocContractReDomain.getContractBillcode());
            return false;
        }
        for (UseCard datum : queryResult.getData()) {
            if (1 == datum.getCouponStatus()) continue;
            flag = false;
        }
        return flag;
    }

    private void sendContractNext(String tenantCode, String contractBillcode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", tenantCode);
        String s = this.inInvokeApi("oc.contractEngine.sendContractNext", param);
    }

    public String inInvokeApi(String apiCode, Map<String, Object> map) {
        String result = this.internalInvoke(apiCode, map);
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        return result;
    }

    public <T> T inInvokeApi(String apiCode, Map<String, Object> map, Class<T> clazz) {
        String result = this.internalInvoke(apiCode, map);
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        return JsonUtil.json2Object(result, clazz);
    }

    public <T> List<T> inInvokeToQuery(String apiCode, Map<String, Object> map, Class<T> clazz) {
        String result = this.internalInvoke(apiCode, map);
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        QueryResult queryResult = JsonUtil.json2Object(result, QueryResult.class);
        if (queryResult == null || ListUtil.isEmpty((Collection)queryResult.getList())) {
            return null;
        }
        return JsonUtil.json2ObjectList(JsonUtil.object2Json(queryResult.getList()), clazz);
    }
}

