/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.gst.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.yqbsoft.laser.bus.ext.data.gst.response.GstQueryResult;
import com.yqbsoft.laser.bus.ext.data.gst.response.GstQueryResult2;
import com.yqbsoft.laser.bus.ext.data.gst.response.GstQueryResult3;
import com.yqbsoft.laser.bus.ext.data.gst.response.GstResult;
import com.yqbsoft.laser.bus.ext.data.gst.response.HtmlJsonReBean;
import com.yqbsoft.laser.bus.ext.data.gst.response.SupResult;
import com.yqbsoft.laser.bus.ext.data.gst.response.VirtualGoods;
import com.yqbsoft.laser.bus.ext.data.gst.service.GstTokenService;
import com.yqbsoft.laser.bus.ext.data.gst.util.AesUtil;
import com.yqbsoft.laser.bus.ext.data.gst.util.EncryptUtil;
import com.yqbsoft.laser.bus.ext.data.gst.util.JsonUtil;
import com.yqbsoft.laser.bus.ext.data.gst.util.SslUtil;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class HttpClientUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientUtil.class);
    @Autowired
    private static GstTokenService gstTokenService;
    public static final String DdFalgSettingKey = "DdFalgSetting-key";
    public static final String TENANT_CODE = "00000000";
    private static PoolingHttpClientConnectionManager httpClientConnectionManager;
    private static CloseableHttpClient httpClient;
    private static CloseableHttpClient httpsClient;
    private static HttpConfig httpConfig;
    private static SSLConnectionSocketFactory sslsf;
    private static final String HTTP_CONF_FILE_NAME = "fenxiao-httpconf.properties";
    private static final String encryptToBase64Api = "/sopapi/api/wft/external/apiAuth/couponexternal";
    private static final int MAX_TOTAL_CONNECTION = 800;
    private static final int MAX_PER_ROUTE = 150;
    private static String UTF_8;

    public static void setGstTokenService(GstTokenService gstTokenService) {
        HttpClientUtil.gstTokenService = gstTokenService;
    }

    private HttpClientUtil() {
    }

    private static void loadConf() {
        if (httpConfig == null) {
            httpConfig = new HttpConfig();
        }
        Properties properties = new Properties();
        try {
            InputStream inputStream = HttpClientUtil.class.getClassLoader().getResourceAsStream(HTTP_CONF_FILE_NAME);
            if (inputStream == null) {
                LOGGER.warn("httpConfig file={} does not exist", (Object)HTTP_CONF_FILE_NAME);
                return;
            }
            properties.load(inputStream);
            int maxTotalConnection = Integer.parseInt(properties.getProperty("max_total_connection"));
            int maxPerRoute = Integer.parseInt(properties.getProperty("max_per_route"));
            LOGGER.info("max_total_connection={}, max_per_route={}", (Object)maxTotalConnection, (Object)maxPerRoute);
            httpConfig.setMaxTotalConnection(maxTotalConnection);
            httpConfig.setMaxPerRoute(maxPerRoute);
        }
        catch (IOException e) {
            LOGGER.warn("read httpConfig from file={} failed", (Object)HTTP_CONF_FILE_NAME, (Object)e);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("read httpConfig from file={} failed", (Object)HTTP_CONF_FILE_NAME, (Object)e);
        }
        catch (Exception e) {
            LOGGER.warn("read httpConfig from file={} failed", (Object)HTTP_CONF_FILE_NAME, (Object)e);
        }
    }

    private static void initHttps() {
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(new KeyManager[0], new TrustManager[]{trustManager}, new SecureRandom());
            sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("\u521d\u59cb\u5316https\u652f\u6301\u5931\u8d25", (Throwable)e);
        }
        catch (KeyManagementException e) {
            LOGGER.error("\u521d\u59cb\u5316https\u652f\u6301\u5931\u8d25", (Throwable)e);
        }
    }

    public static void checkPage(Map<String, Object> param) {
        if (null != param) {
            int page = 1;
            int rows = 10;
            if (null == param.get("page")) {
                param.put("size", rows);
                param.put("current", page);
            } else {
                rows = Integer.parseInt(String.valueOf(param.get("rows")));
                page = Integer.parseInt(String.valueOf(param.get("page")));
                if (rows > 100) {
                    rows = 100;
                }
                param.remove("rows");
                param.remove("page");
                param.put("size", rows);
                param.put("current", page);
            }
        } else {
            param = new HashMap<String, Object>();
            param.put("size", 1);
            param.put("current", 10);
        }
    }

    public static <T> GstQueryResult<T> postToQueryResult(String url, Map<String, Object> param, Class<T> clazz) {
        String responseStr = HttpClientUtil.post(url, param);
        if (StringUtils.isBlank((String)responseStr)) {
            return new GstQueryResult();
        }
        TypeReference typeRef = new TypeReference<GstQueryResult<T>>(){};
        return (GstQueryResult)JsonUtil.json2Object(responseStr, typeRef);
    }

    public static <T> GstQueryResult<T> postToQueryResultByVirtualGoods(String url, Map<String, Object> param) {
        String responseStr = HttpClientUtil.post(url, param);
        if (StringUtils.isBlank((String)responseStr)) {
            return new GstQueryResult();
        }
        TypeReference<GstQueryResult<VirtualGoods>> typeRef = new TypeReference<GstQueryResult<VirtualGoods>>(){};
        return (GstQueryResult)JsonUtil.json2Object(responseStr, (TypeReference)typeRef);
    }

    public static <T> GstQueryResult2<T> spuPostToQueryResult(String url, Map<String, Object> param, Class<T> clazz) {
        String responseStr = HttpClientUtil.postSup(url, param);
        if (StringUtils.isBlank((String)responseStr)) {
            return new GstQueryResult2();
        }
        GstQueryResult2 response = JsonUtil.json2Object(responseStr, GstQueryResult2.class);
        T supResult = JsonUtil.json2Object(JsonUtil.object2Json(response.getData()), clazz);
        response.setData(supResult);
        return response;
    }

    public static void main(String[] args) {
        String responseStr = "{\"code\":200,\"success\":true,\"data\":{\"result\":\"SQ2hKYYyy7KKHI2-Pjm0tOfFNsKErd2YK1-_Ns-adALeFJqXv75j8fGxJGVhk3xgr4BRJvR2xQjctPZLnCSWFLBUsurn_rpDsPpP2rSZ4lHRBgcpN9ppeSknSO7atD3L_G6WUOYww1HXPUwWVKzZEbgO76aeiL8hsbRGxOv_d83hjkRXHSdTmq8N17DAjsFaOyRe774ROQnPQqScAZ3-p7klhPokfQ3-kW25A6t-hKFTDF0cW1SmmFAUHO_SKCeumFgQ9rT5xEIglkvIvjCkqlrrK3MRtWSJxsaHZv7bwFDbj0L-UqCqBRMP8gEjRoR72BrkSrSFCVB5insPHxLVkns6WJGw0NRWennJmG7qOPJ4EqhoE2NAury4bL16luRNqZmMV6f-xTFGkc27kP4x93Nx8RhP5N23aMvZw8wd1sQJsuy3JcaQmejFKxvU8ss-3y84HmNqbJ6oFGoSrEWTYydaLUVxGI1F1Hlu7P5-MfBVSltYyNmqw4hWXal4o6LDjdhLUCd5gy4sCSMLpbEi8biU_bKf-P3Uh3SjBZ1KfepCq1liQPUKV2QdD7uLq9PfoqQewRPLhvrDB_lbIN4OGKiOW_vBYF-ntr8i4J89I1I6Uoym1GX8HVwORqqPWAZNJZnPoy5yI91LOfTbdOYO6xCSU3DqR277rBUKxcbwP9GSFkLdUapCrSJc48UnkDlPq8MwDEprCjTNatZVKK_s01lTiuRYlgQ_s_QjI8og_7wM1foEb9ocvIfcEgNmtyN_7d88EXPmWYVtJD_cHB9aEZ-PtDcsFFJnTzFp6q-0z0s4R1rCFVzuQw8hbG815m0VV90xxhU1hCsHJF2VR_XqhKE3C-4rbOH_Ywn4bhphGpsdBVD3If5CYGO7SdWS9Zx0i20hweKaaFE1YGCjxVOc8LSh235VIdImuCo7ap9sjF1y902og7qGJ_Y0z1ajcJUtzykRTHnblK9l0GpIpyamySCb20pgo6-KSBU05hCyx0EpcxDiIYz4qtDWSSVTUJMccBNHUB5PeYl961uCLvxZMl1pw8xJ77RVnMcvTkwRZEBCFa1aCTASlPT6jGxbX8u-2XmTXEg9_QpbRHJh3Du17YzzYRNd0ABxymyn931eBSI8aqQeRVb6T5xu5CiCxa5tZX2F_HSvzJlv-q3yfg7jIV00a-RiiSu6ZnmqUK1_no-n84BCeMGBi6sfGxUhSZeoFQed_N6Z3A3ITqEO5AUyL4um1GVcyozTw-a9fagZbWcTu2MytYUXCycpOVO4g7xxg9aKn76Z0xcv9cwXHJZVi5-0JFNlWHj6b9Iui9tbGJAtYJMarkgwqhmbL7C1qzF9pU8dx0hf3Le-PYCPFKcCNYd5uXQIIm2bYu_eV7BZRjBtjz0XKaDwhSrnW7yNnIVrkKjUwFyQ689ughQFTPUne-zjFZcjrEamcTj2YLSaetjGTH2WvGMYW6jR6eDFd23svZMEKuj3unMtcD0PNacBGzyU7rhiGasY7NHtJB4Bed-9iHCjz7iqMoylGke4oR8XgkRIzIHigQ3gYRsUaaLDYazS7cy45yQr5YHW1b2zKNOUkaEN-MAkq3b-6XiQUVPrC6ddfthQMBn-dsDTNmnsENbEx0l302RFOpALLS98onCqBeDEo67UDZezau5Z3ZOD7oFNMWc1fKhR8LZW6S0OyeuK-Q6mf5O_UhbGVd75yGnT80ByLNTXRHCcYFTXbAJ0iOf0aieIpk5lr7gC5uFZJHul2n1JvxfZi3uBD3m4UCMrnNui3Yo2Hn0gWKCeabXZpiF9t7htdD0HXR2mVaeOjoBbGC7MOAwuQWIMx0dKYAHJfPBLSUuuAf4a4gzpgvcPeC9pOaGg06yeCpRRu7bYBbKvtOR735c7loWWIaAwUrdpbqmebdAiN3O7sM0fs0oe4F_oneQN3hVPc4hDA2F7ELXJfoZFzfr1Qsa-Muz1p4ngX-id5A3eFU9ziEMDYXsQPNcUDz3JeRl_E-U8dANdt7wKBq0QN53m5WmcaZm986cKGDPU4SoquJwnLx8nBXDWktepeWbaTUcNjkWEaXdIzLLmjGEMCJlIKsB_FHOxY07fP2_CGq3cajjAma_BgbPJ5rgftm1mZrRT4WY__RQMoHbr7edH6adUEKLZbW6RdguXGgVh3wV_LoLfGiLBfoDnrQ60ceCMi5mo9X0_gpQSelnnhkv-pYtXTkchw9p1OnFSP5ncMYhaBSj3EMYf9Mv1KSb6mAHdymgS22xh7dZyalRtys0_27stQBvMi2o7RAlEIqeL2mvIcfVz4l-80lDIM-rreuE4hVVeBhRal3xpnuaKI95Dm81ETq0Df2JuHm6z2qx_1gFEZEJFTJSG6rtalxCDEebLO2FRoj_BF6tmKShtNjFsQR03llfCgfMXDHyC7lZcwoHVTtyP01zxt2g7LV5sg1o_OeMfuCWk17hagwfv9zvbB-CiyjmBdnRzw4HSYp5iAPomaEpSkK0Qvy6qU8tBnnu8SFaT0_2HZ2FtSefJxiwkPwGqFagurh3PZKmgcNAEKpKHwaFeJcotRTInQf6Nu6n53277HRbH6tWSllCos34SSQXLS5EXMb9xiKhzVvRh2kV9YtcSP_j7S4P5vnu0By5dhTD8bYX6GbLPyD5DwTrBnkHFMx3DMZB2egSghXDxnXw3RItYiDCm5lnGoHwEOTLvoKdPqO3IRt4PBSNhCXtd0EzmeBbiqo-WEQRh3RiceyHCbK-D1pTQ3kMvqCNXoBy1hAse62HzX1ZXrjqkTnR00lMxzjDA-cNZX8RclTZZJOdO_DvkP1HAI0Jvqj--heosPIjCDN4OAUetfgVy5MPWfqaiyF0zKDpkbxI32Y1APDy55CYPhIDNzxOqiMjq6KBBrzkI_mCfrCxQi2V8UYrWRu1d9MLoObMY5KUbWCx6WkXg6TZ-VO5sYX9Z_hZmHoaobLw4aaN0s21IlDJb4FSJ6mc_-vPC-2dxI_kDrNKWqQaS5i_KCPds3avGJFBoOFl9FR0MeaiG7hJT-ZVghvBI84r0sJ1PtRTKym6DCdOiIqtaI0qWWTuvK8il4KExZU8EyO9hLC8C-SsBk_EsmCKD9PppJVqvd7_fMSSnQWW0Hl_uscoPRAEzUS8GAWoU0GMnyhvk0NgX630IWtxsF3MpRiZtl2QQBhgWR7FC_sAPExZ6DMQmJurwefMv3_Kdr6WS_2igIm7ddvfjsxhw3RFzKAntRlY9lKaNIwVfi89It4H3bQQ_falI9TU7oVbbAVaRKPlXrs-w6uNtYAQ5EBnwotH2YLg3NUx_jltS3g5pJSVHwrvtM0K64_BP5_rKJtHypebWHQBJwZ97LeVjSPayzXY66Bv7IjTPwD4r02NiJWy6VLUufA38UM3I_ZxrugWtsTQAin4W2UvxMoemotJtY9P9EVmYtJDSLw-DFVT-eOQGjcnGPOWTf_Q4pmkLt50s4Yd-_AP_P2UW7gdjTDjfP2sq3C0u5ertcGnGBKdJsl07FPwvuYA9ygU3zvo6_dYNqJ4_Mpt4QEmEX4KLlbSquur8kbYNXDcMeGJ-8HKKr9xKYii5NpHKdi7sgGd3K4ci2V5bk8kJKiYYRWmFYgGZVUWgUmqLbZ5ueFi-ACWDaewqfRXGyjVqHaCIr3yvhVcHqMTk3vO1jVLLe2N_3yejRgKpybVmkfjbd4adTPrzQRhRX_3NjBx6DnTTXjBFJQm-QZ8opjccW9ybGt40WIhX7i008m_FWFn3WQMPPBIG3let6YC0jBZEzWwPcceDs5wRTWhh3hxf6EXmJtT0a7L74P6dX-tBekMx--4riWcYgI2ZVpT9GyjLWvbmim2CAHzEEBksAx83jqDvYcN5NRCUWZRCG3HFeCvvQUQHKEoAUYQEg0GlIttrdY6ptIYeU9UQGVN0JeexRZEH_DaaqnK9uJcT38H2loSNiOuOtAKCkU4cHQSGooKhPlXosLepZiETniZczdHUDX74J1F8fTyUVCgvPw1I2uRkjDmO7sCIAZI1RlN9g442N8VrR7OQSdjh4e8QT-OwLnnOUjDJgaUkG3YIJfMfoWZRB1d2Rq18Z-0r7DkVyAJ6lEk7vVA83uOMs7dPCqy-8jHIXinKk9ar_x_F8Gpu7XAo2SRMm05eaF8YiEzd9L3q7KeVfiNYXNyFg0mEGqOR490B-A-61kQlk6stgD0nHoRZmojSVDR0EBDYpDWgPDvFSm-VLAYs_CUh6BsLf2HYLKGsy8iGjKxoaOFvYcC6XxwFfd0_NZNXpoVrodE2wNp2HY-YCdwii2qnemiy_yDq7lfaNhcZCOomfS5E53lt5nRJBkCV4tYgeXaViV7HyGrcoZm9LHIWEq87xv-Eqr6YZpGTB_XOUtnnqK4mwOsYOQa07vHoh7NW8Z5LQsltaOMwTQ26wwsbhCxMWh-ItBDbyYcueeLZzzY61jidqvZrC9RKm7abryMitaX5voIhoFVlUO27dtAncaTSP8FrFQgDnPXnZPPibOsXZKRaJQcC1jAgrXpXxMCXHFn2BV-rY3wEeBW4VwQfv6NfidLAwbBFnkq76jUxjnu40fILJWomYKT-rkG8UFOWQ8M7hiOSIAZgMV6liK3baTNPcUUlXfvRYsRgkCqYrzbgah6r6erzhG1ZqbizPKjqFnngGV92AnXj7ByrlPW6ObJaVWQ_kWg5tWhVidUPjhJE6CpkHXyrxRQN4BFzlXW_fhmLrpX8ckrpwnN-WA9MabmLqnkOFVEQNiQ2h85eBKEnpffU0Bqk8v_o0JxTdB61EA5oFIU7Rj82QcSDjvKxajbaNwJMCKFL_8r6ABmCTvjDMHcFHzUWeRYAXYh30DbPDf_bmQoKT6cXfJbrwF5SM5Ocg6qly1v9jswzgAzV-gRv2hy8h9wSA2a3I3_t3zwRc-ZZhW0kP9wcH1oRn4-0NywUUmdPMWnqr7TPSzhHWsIVXO5DDyFsbzXmbRVX3THGFTWEKwckXZVH9eqEoTcL7its4f9jCfhuGmEam9KzLjTQb1BKZm3b3QBrG8wN9k7ZJdqfNhBILvb7L_4jn-wcDz-wEPJvKzeL0tH1hQUylPDKHRNFjE1-DuLkYemRxPfL-Gab59ZUctdS8UEETALWbHTpaHj9QrevPPOPYchodHC7TVYmcQ1JJeYtGdsX8rsv2o2VFUrmzDYXfzdlOuNmH0DrTDzZyq8DslRiv20wQ0_bFQooZzyfSXfKqyPG2auv7VKOZVQ3c9HpDCCeRqb6041NQ3N_4bX-huN5NQPtzC9yJubaUqMyELCbWDAz4IrEiDk-YuovsCJoim_moATzQBGDi9WpHhy5Pz15KHoE0BPgBvzlsm3-HYMzpgdSu_Tl86C7PmMvdqsQpCiZ-JeFCqrYDDZf65Tvv9Fvb6p1xXioOP3I6q4oKRfgTPU4f4KA5j6u8HYRHkO_tlh9FYOBErWXaE1ufUhCbvLneZPuAQgJ2IUfQ9QFW7nc4L44f4KA5j6u8HYRHkO_tlh9CEUIIJVSFCsq8jtiTHvydkZQ3_GD9viMEWGgSll1gQVDcEIebMHI9y_wSxT8j8y9aN7Df846iRgiMABMkbda_bHgKvbiJcWL_edsQRSDoxevCuquITV6Udk8-tWE-TYZlqEK2e35t-Eq43jxcC9cjX4ClZ96ybSTj8tR-LAuOUZ5hAagWWVbzq3i1st9ehvrk3rovV_z5_bLka1WGu2ds2hNEGpPJ5jsMswVl7WSTk8xmKZv80gobpTd9H1mw9bGLYDoROY9BjZUI0IDP-Ke_w6PciZ9A9auMcXvukuI9oKPvVhBYTqPniRgCGZJwuUutVMNxZ1mVZKwar5BbjyTC63D2074PdDR3O_osHokBNLRy2MAxW_Cu4l8NSe69yxxvAMTN-arB-MjuuiLvzd-ogt-TfnkynWYQVigfkfHet-DTeLW1Mw5hB1mMm7Er6z3kn3CnS5qEWg30GB-G7NlfoqQwnLQsa6uAlYg52pJ0HYO3wGoN9GD5FTqXuhJWXy_\",\"accessKey\":\"V7k06z3z/3sXhUNoQub2cw==\"},\"msg\":\"\u64cd\u4f5c\u6210\u529f\"}";
        GstQueryResult2 response = JsonUtil.json2Object(responseStr, GstQueryResult2.class);
        SupResult supResult = JsonUtil.json2Object(JsonUtil.object2Json(response.getData()), SupResult.class);
        response.setData(supResult);
        System.out.println(((SupResult)response.getData()).getAccessKey());
    }

    public static <T> GstQueryResult<T> postToQueryResult(String url, String param, Class<T> clazz) {
        String responseStr = HttpClientUtil.post(url, param);
        if (StringUtils.isBlank((String)responseStr)) {
            return new GstQueryResult();
        }
        TypeReference typeRef = new TypeReference<GstQueryResult<T>>(){};
        return (GstQueryResult)JsonUtil.json2Object(responseStr, typeRef);
    }

    public static <T> GstQueryResult2<T> postToQueryResult2(String url, Map<String, Object> param) {
        String responseStr = HttpClientUtil.post(url, param);
        if (StringUtils.isBlank((String)responseStr)) {
            return new GstQueryResult2();
        }
        TypeReference typeRef = new TypeReference<GstQueryResult2<T>>(){};
        return (GstQueryResult2)JsonUtil.json2Object(responseStr, typeRef);
    }

    public static <T> GstQueryResult2<T> postToQueryResult2(String url, String param) {
        String responseStr = HttpClientUtil.post(url, param);
        if (StringUtils.isBlank((String)responseStr)) {
            return new GstQueryResult2();
        }
        TypeReference typeRef = new TypeReference<GstQueryResult2<T>>(){};
        return (GstQueryResult2)JsonUtil.json2Object(responseStr, typeRef);
    }

    public static <T> GstQueryResult2<T> postFromToQueryResult2(String url, Map<String, Object> param) {
        String responseStr = HttpClientUtil.postFrom(url, param);
        if (StringUtils.isBlank((String)responseStr)) {
            return new GstQueryResult2();
        }
        TypeReference typeRef = new TypeReference<GstQueryResult2<T>>(){};
        return (GstQueryResult2)JsonUtil.json2Object(responseStr, typeRef);
    }

    public static <T> GstQueryResult3<T> postToQueryResult3(String url, Map<String, Object> param) {
        String responseStr = HttpClientUtil.post(url, param);
        if (StringUtils.isBlank((String)responseStr)) {
            return new GstQueryResult3();
        }
        TypeReference typeRef = new TypeReference<GstQueryResult2<T>>(){};
        return (GstQueryResult3)JsonUtil.json2Object(responseStr, typeRef);
    }

    public static <T> GstQueryResult3<T> postToQueryResult3(String url, String param) {
        String responseStr = HttpClientUtil.post(url, param);
        if (StringUtils.isBlank((String)responseStr)) {
            return new GstQueryResult3();
        }
        TypeReference typeRef = new TypeReference<GstQueryResult3<T>>(){};
        return (GstQueryResult3)JsonUtil.json2Object(responseStr, typeRef);
    }

    public static GstResult postToResult(String url, Map<String, Object> param) {
        String responseStr = HttpClientUtil.post(url, param);
        if (StringUtils.isBlank((String)responseStr)) {
            return null;
        }
        return JsonUtil.json2Object(responseStr, GstResult.class);
    }

    public static String post(String url, Map<String, Object> param) {
        try {
            String body = JsonUtil.object2Json(param, false);
            LOGGER.info("HttpClient \u8bf7\u6c42\u660e\u6587\u53c2\u6570, url:{}, body:{}", (Object)url, (Object)body);
            String secretkey = null;
            if (url.contains(encryptToBase64Api)) {
                secretkey = HttpClientUtil.getSecretkey(null);
                body = AesUtil.encryptToBase64(body, secretkey);
            }
            LOGGER.info("HttpClient \u8bf7\u6c42\u5bc6\u6587\u53c2\u6570, url:{}, body:{}", (Object)url, (Object)body);
            String responseStr = HttpClientUtil.invokePost(url, body, "application/json; charset=utf-8");
            LOGGER.info("HttpClient \u54cd\u5e94\u5bc6\u6587\u7ed3\u679c, url:{}, responseStr:{}", (Object)url, (Object)responseStr);
            if (url.contains(encryptToBase64Api)) {
                responseStr = AesUtil.decryptFormBase64ToString(responseStr, secretkey);
                LOGGER.info("HttpClient \u54cd\u5e94\u660e\u6587\u7ed3\u679c, url:{}, responseStr:{}", (Object)url, (Object)responseStr);
            }
            return responseStr;
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u5931\u8d25, url:{}, e:{} ", (Object)url, (Object)e);
            return null;
        }
    }

    public static String post(String url, String body) {
        try {
            LOGGER.info("HttpClient \u8bf7\u6c42\u660e\u6587\u53c2\u6570, url:{}, body:{}", (Object)url, (Object)body);
            String secretkey = null;
            if (url.contains(encryptToBase64Api)) {
                secretkey = HttpClientUtil.getSecretkey(null);
                body = AesUtil.encryptToBase64(body, secretkey);
            }
            LOGGER.info("HttpClient \u8bf7\u6c42\u5bc6\u6587\u53c2\u6570, url:{}, body:{}", (Object)url, (Object)body);
            String responseStr = HttpClientUtil.invokePost(url, body, "application/json; charset=utf-8");
            LOGGER.info("HttpClient \u54cd\u5e94\u5bc6\u6587\u7ed3\u679c, url:{}, responseStr:{}", (Object)url, (Object)responseStr);
            if (url.contains(encryptToBase64Api)) {
                responseStr = AesUtil.decryptFormBase64ToString(responseStr, secretkey);
                LOGGER.info("HttpClient \u54cd\u5e94\u660e\u6587\u7ed3\u679c, url:{}, responseStr:{}", (Object)url, (Object)responseStr);
            }
            return responseStr;
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u5931\u8d25, url:{}, e:{} ", (Object)url, (Object)e);
            return null;
        }
    }

    public static String postFrom(String url, Map<String, Object> param) {
        try {
            LOGGER.info("HttpClient \u8bf7\u6c42\u53c2\u6570, url:{}, body:{}", (Object)url, (Object)JsonUtil.object2Json(param));
            String responseStr = HttpClientUtil.invokePost(url, param);
            LOGGER.info("HttpClient \u54cd\u5e94\u7ed3\u679c, url:{}, responseStr:{}", (Object)url, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u5931\u8d25, url:{}, e:{} ", (Object)url, (Object)e);
            return null;
        }
    }

    private static Map<String, String> smsHeadersMap() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-type", "application/json; charset=utf-8");
        headers.put("Tenant-Id", HttpClientUtil.getDdFalgSetting(null, "gst", "Sms_Tenant-Id"));
        headers.put("Authorization", HttpClientUtil.getDdFalgSetting(null, "gst", "Sms_Authorization"));
        headers.put("Blade-Auth", "bearer " + gstTokenService.getSmsToken());
        return headers;
    }

    private static Map<String, String> invHeadersMap() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-type", "application/json; charset=utf-8");
        return headers;
    }

    private static Map<String, String> supHeadersMap() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-type", "application/json");
        return headers;
    }

    public static String postSms(String url, Map<String, String> param) {
        try {
            Map<String, String> headers = HttpClientUtil.smsHeadersMap();
            LOGGER.info("HttpClient.postSms \u8bf7\u6c42\u53c2\u6570, url:{}, param:{}, headers:{}", new Object[]{url, JsonUtil.object2Json(param), JsonUtil.object2Json(headers)});
            String body = JsonUtil.object2Json(param, false);
            String responseStr = HttpClientUtil.invokePost(url, headers, body);
            LOGGER.info("HttpClient.postSms \u54cd\u5e94\u7ed3\u679c, url:{}, responseStr:{}", (Object)url, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u5931\u8d25, url:{}, e:{} ", (Object)url, (Object)e);
            return null;
        }
    }

    public static String postinv(String url, Map<String, Object> param) {
        try {
            Map<String, String> headers = HttpClientUtil.invHeadersMap();
            LOGGER.info("HttpClient.postinv \u8bf7\u6c42\u53c2\u6570, url:{}, param:{}, headers:{}", new Object[]{url, JsonUtil.object2Json(param), JsonUtil.object2Json(headers)});
            String body = JsonUtil.object2Json(param, false);
            String content = EncryptUtil.aesEncrypt(body, HttpClientUtil.getDdFalgSetting(null, "gst", "Inv_Aes_Key"));
            param = new HashMap<String, Object>();
            param.put("content", content);
            LOGGER.info("HttpClient.postinv \u54cd\u5e94\u7ed3\u679c, url:{}, param:{}, content:{}", new Object[]{url, JsonUtil.object2Json(param), content});
            String responseStr = HttpClientUtil.invokePost(url, headers, JsonUtil.object2Json(param));
            LOGGER.info("HttpClient.postinv \u54cd\u5e94\u7ed3\u679c, url:{}, responseStr:{}", (Object)url, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u5931\u8d25, url:{}, e:{} ", (Object)url, (Object)e);
            return null;
        }
    }

    public static String postSup(String url, Map<String, Object> param) {
        try {
            Map<String, String> headers = HttpClientUtil.supHeadersMap();
            LOGGER.info("HttpClient.postinv \u8bf7\u6c42\u53c2\u6570, url:{}, param:{}", (Object)url, (Object)JsonUtil.object2Json(param));
            String body = JsonUtil.object2Json(param, false);
            String accessKey = HttpClientUtil.getDdFalgSetting(null, "gst", "Sup_Aes_Key");
            String content = EncryptUtil.aesEncrypt(body, accessKey);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("content", content);
            map.put("accessKey", accessKey);
            LOGGER.info("HttpClient.postinv \u8bf7\u6c42\u53c2\u6570, url:{}, data:{}, content:{}", new Object[]{url, JsonUtil.object2Json(map), content});
            String responseStr = HttpClientUtil.invokePost(url, headers, JsonUtil.object2Json(map));
            LOGGER.info("HttpClient.postinv \u54cd\u5e94\u7ed3\u679c, url:{}, responseStr:{}", (Object)url, (Object)responseStr);
            return responseStr;
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u5931\u8d25, url:{}, e:{} ", (Object)url, (Object)e);
            return null;
        }
    }

    public static <T> HtmlJsonReBean<T> post(String url, Map<String, Object> param, Class<T> clazz) {
        String json = HttpClientUtil.post(url, param);
        return new HtmlJsonReBean<T>(JsonUtil.json2Object(json, clazz));
    }

    public static <T> HtmlJsonReBean<T> SupPost(String url, Map<String, Object> param, Class<T> clazz) {
        String json = HttpClientUtil.postSup(url, param);
        return new HtmlJsonReBean<T>(JsonUtil.json2Object(json, clazz));
    }

    public static String invokePost(String url, Map<String, String> headers, Map<String, String> params) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> param : headers.entrySet()) {
                httpPost.addHeader(param.getKey(), param.getValue());
            }
        }
        if (params != null && params.size() > 0) {
            ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> param : params.entrySet()) {
                pairs.add(new BasicNameValuePair(param.getKey(), param.getValue()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, UTF_8));
        }
        return HttpClientUtil.sendRequest(url, (HttpRequestBase)httpPost);
    }

    public static String invokePost(String url, Map<String, String> headers, String body) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        if (headers != null && headers.size() > 0) {
            for (Map.Entry<String, String> param : headers.entrySet()) {
                httpPost.addHeader(param.getKey(), param.getValue());
            }
        }
        if (body != null) {
            httpPost.setEntity((HttpEntity)new StringEntity(body, Charset.forName(UTF_8)));
        }
        return HttpClientUtil.sendRequest(url, (HttpRequestBase)httpPost);
    }

    public static String invokePost(String url, String body, String contentType) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Authorization", HttpClientUtil.getAuthorization(null));
        httpPost.addHeader("Content-type", contentType);
        httpPost.setHeader("Blade-Auth", "bearer " + HttpClientUtil.getToken());
        httpPost.setEntity((HttpEntity)new StringEntity(body, Charset.forName(UTF_8)));
        return HttpClientUtil.sendRequest(url, (HttpRequestBase)httpPost);
    }

    public static String invokePost(String url, Map<String, Object> body) throws Exception {
        ArrayList<NameValuePair> formParams = new ArrayList<NameValuePair>();
        for (String key : body.keySet()) {
            formParams.add((NameValuePair)new BasicNameValuePair(key, body.get(key).toString()));
        }
        return HttpClientUtil.postFormData(url, formParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String postFormData(String url, List<NameValuePair> params) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                HttpEntity entity = response.getEntity();
                if (entity == null) return null;
                String string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                return string;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String getToken() {
        String token = gstTokenService.getToken();
        return token;
    }

    private static String getAuthorization(String tenantCode) {
        return HttpClientUtil.getDdFalgSetting(tenantCode, "gst", "Authorization");
    }

    private static String getSecretkey(String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = TENANT_CODE;
        }
        return HttpClientUtil.getDdFalgSetting(tenantCode, "gst", "secretkey");
    }

    private static String sendRequest(String url, HttpRequestBase request) throws Exception {
        String responseStr;
        CloseableHttpClient client = url.startsWith("https") ? httpsClient : httpClient;
        long st = System.currentTimeMillis();
        int status = 0;
        try {
            SslUtil.ignoreSsl();
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            status = response.getStatusLine().getStatusCode();
            if (entity != null) {
                responseStr = EntityUtils.toString((HttpEntity)entity, (String)UTF_8);
                response.close();
            } else {
                responseStr = "";
            }
        }
        catch (SocketTimeoutException e) {
            LOGGER.error("HttpClient.sendRequest, url:{}, use_time:{} ms", new Object[]{request.getURI(), System.currentTimeMillis() - st, e});
            throw e;
        }
        catch (ClientProtocolException e) {
            LOGGER.error("HttpClient.sendRequest, url:{}, use_time:{} ms", new Object[]{request.getURI(), System.currentTimeMillis() - st, e});
            throw e;
        }
        catch (IOException e) {
            LOGGER.error("HttpClient.sendRequest, url:{}, use_time:{} ms", new Object[]{request.getURI(), System.currentTimeMillis() - st, e});
            throw e;
        }
        finally {
            request.releaseConnection();
        }
        LOGGER.info("HttpClient Success, status:{}, url:{}, use_time:{} ms", new Object[]{status, request.getURI(), System.currentTimeMillis() - st});
        return responseStr;
    }

    private static RequestConfig buildRequestConfig(Integer connTimeout, Integer readTimeout) {
        RequestConfig.Builder customReqConf = RequestConfig.custom();
        if (connTimeout != null) {
            customReqConf.setConnectTimeout(connTimeout.intValue());
        }
        if (readTimeout != null) {
            customReqConf.setSocketTimeout(connTimeout.intValue());
        }
        return customReqConf.build();
    }

    private static void valueForUriBuilder(String url, URIBuilder uriBuilder) {
        Integer apartIndex = url.indexOf("?");
        if (apartIndex == -1) {
            uriBuilder.setPath(url);
        } else {
            uriBuilder.setPath(url.substring(0, apartIndex));
            uriBuilder.setCustomQuery(url.substring(apartIndex + 1, url.length()));
        }
    }

    public static String getDdFalgSetting(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = TENANT_CODE;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)DdFalgSettingKey, (String)field);
    }

    static {
        httpClientConnectionManager = new PoolingHttpClientConnectionManager();
        httpClient = null;
        httpsClient = null;
        httpConfig = null;
        sslsf = null;
        UTF_8 = "UTF-8";
        HttpClientUtil.initHttps();
        HttpClientUtil.loadConf();
        httpClientConnectionManager.setMaxTotal(httpConfig.getMaxTotalConnection());
        httpClientConnectionManager.setDefaultMaxPerRoute(httpConfig.getMaxPerRoute());
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager).build();
        httpsClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager).build();
        LOGGER.info("HttpClient initialization");
    }

    static class HttpConfig {
        private int maxTotalConnection = 800;
        private int maxPerRoute = 150;

        HttpConfig() {
        }

        public int getMaxTotalConnection() {
            return this.maxTotalConnection;
        }

        public void setMaxTotalConnection(int maxTotalConnection) {
            this.maxTotalConnection = maxTotalConnection;
        }

        public int getMaxPerRoute() {
            return this.maxPerRoute;
        }

        public void setMaxPerRoute(int maxPerRoute) {
            this.maxPerRoute = maxPerRoute;
        }
    }

    static interface AcceptType {
        public static final String ACCEPT_JSON = "application/json";
        public static final String ACCEPT_ANNY = "*/*";
    }

    static interface ContentType {
        public static final String FORM_URLENCODED = "application/x-www-form-urlencoded";
        public static final String JSON = "application/json; charset=utf-8";
        public static final String DATA = "text/json;charset=UTF-8";
    }
}

