/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.gst.service.impl;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.yqbsoft.laser.bus.ext.data.gst.domain.PteBalanceamt;
import com.yqbsoft.laser.bus.ext.data.gst.domain.PteBalancelist;
import com.yqbsoft.laser.bus.ext.data.gst.response.Data;
import com.yqbsoft.laser.bus.ext.data.gst.response.GstQueryResult;
import com.yqbsoft.laser.bus.ext.data.gst.response.GstQueryResult2;
import com.yqbsoft.laser.bus.ext.data.gst.response.HtmlJsonBean;
import com.yqbsoft.laser.bus.ext.data.gst.response.HtmlJsonReBean;
import com.yqbsoft.laser.bus.ext.data.gst.response.SupResult;
import com.yqbsoft.laser.bus.ext.data.gst.service.GstSupplierService;
import com.yqbsoft.laser.bus.ext.data.gst.supbase.SupBaseService;
import com.yqbsoft.laser.bus.ext.data.gst.util.EncryptUtil;
import com.yqbsoft.laser.bus.ext.data.gst.util.HttpClientUtil;
import com.yqbsoft.laser.bus.ext.data.gst.util.RequestUrl;
import com.yqbsoft.laser.bus.ext.data.gst.vo.GstUserSupplierVo;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;

public class GstSupplierServiceImpl
extends SupBaseService
implements GstSupplierService {
    private static final String SYS_CODE = "GstUserServiceImpl";
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");

    @Override
    public HtmlJsonReBean<GstUserSupplierVo> getUserSupplierDetail(Map<String, Object> param) throws Exception {
        if (param.get("orgNo") == null) {
            return HtmlJsonReBean.error("\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        GstQueryResult2<SupResult> supResultGstQueryResult = HttpClientUtil.spuPostToQueryResult(RequestUrl.getUserSupplierDetail, param, SupResult.class);
        if (supResultGstQueryResult.getSuccess().booleanValue()) {
            String json = EncryptUtil.aesDecrypt(supResultGstQueryResult.getData().getResult(), supResultGstQueryResult.getData().getAccessKey());
            GstUserSupplierVo data = (GstUserSupplierVo)JsonUtil.buildNormalBinder().getJsonToObject(json, GstUserSupplierVo.class);
            if (null == data) {
                return HtmlJsonReBean.error("\u64cd\u4f5c\u5931\u8d25\uff01");
            }
            HtmlJsonReBean<GstUserSupplierVo> htmlJsonReBean = new HtmlJsonReBean<GstUserSupplierVo>();
            htmlJsonReBean.setDataObj(data);
            return htmlJsonReBean;
        }
        return HtmlJsonReBean.error("\u64cd\u4f5c\u5931\u8d25\uff01");
    }

    @Override
    public HtmlJsonReBean supplierLogin(Map<String, Object> param) throws Exception {
        if (param.get("account") == null || param.get("password") == null) {
            return new HtmlJsonReBean("-1", "\u53c2\u6570\u4e3a\u7a7a");
        }
        GstQueryResult2<Object> supResultGstQueryResult = HttpClientUtil.spuPostToQueryResult(RequestUrl.supplierLogin, param, Object.class);
        if (supResultGstQueryResult.getSuccess().booleanValue()) {
            return new HtmlJsonReBean();
        }
        return new HtmlJsonReBean("-1", "\u64cd\u4f5c\u5931\u8d25");
    }

    @Override
    public GstQueryResult<GstUserSupplierVo> queryUserSupplierPage(Map<String, Object> param) throws Exception {
        param.remove("startRow");
        param.remove("endRow");
        param.remove("tenantCode");
        param.remove("fuzzy");
        param.remove("order");
        HttpClientUtil.checkPage(param);
        GstQueryResult2<SupResult> supResultGstQueryResult = HttpClientUtil.spuPostToQueryResult(RequestUrl.queryUserSupplierPage, param, SupResult.class);
        if (supResultGstQueryResult.getSuccess().booleanValue()) {
            String json = EncryptUtil.aesDecrypt(supResultGstQueryResult.getData().getResult(), supResultGstQueryResult.getData().getAccessKey());
            GstQueryResult<GstUserSupplierVo> queryResult = new GstQueryResult<GstUserSupplierVo>();
            Data data = (Data)JsonUtil.buildNormalBinder().getJsonToObject(json, Data.class);
            queryResult.setData(data);
            return queryResult;
        }
        return new GstQueryResult<GstUserSupplierVo>();
    }

    @Override
    public HtmlJsonBean passwordUpdate(Map<String, Object> param) throws Exception {
        if (param.get("account") == null || param.get("password") == null) {
            return new HtmlJsonBean("-1", "\u53c2\u6570\u4e3a\u7a7a");
        }
        GstQueryResult2<Object> supResultGstQueryResult = HttpClientUtil.spuPostToQueryResult(RequestUrl.passwordUpdate, param, Object.class);
        if (supResultGstQueryResult.getSuccess().booleanValue()) {
            return new HtmlJsonBean();
        }
        return new HtmlJsonBean("-1", "\u4fee\u6539\u5931\u8d25");
    }

    @Override
    public String statusUpdate(Map<String, Object> resStream) throws Exception {
        String accessKey = GstSupplierServiceImpl.getDdFalgSetting(null, "gst", "Sup_Aes_Key");
        if (MapUtil.isEmpty(resStream)) {
            return EncryptUtil.aesEncrypt(JsonUtil.buildNormalBinder().toJson((Object)new HtmlJsonBean("-1", "\u53c2\u6570\u4e3a\u7a7a")), accessKey);
        }
        if (null == resStream.get("content")) {
            return EncryptUtil.aesEncrypt(JsonUtil.buildNormalBinder().toJson((Object)new HtmlJsonBean("-1", "\u53c2\u6570\u4e3a\u7a7a")), accessKey);
        }
        String content = resStream.get("content").toString();
        Map param = new HashMap();
        try {
            String contentJson = EncryptUtil.aesDecrypt(content, accessKey);
            this.logger.error("GstUserServiceImpl.statusUpdate.param", (Object)contentJson);
            param = JsonUtil.buildNormalBinder().getJsonToMap(contentJson, String.class, String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String json = JsonUtil.buildNormalBinder().toJson(param);
        this.logger.error("GstUserServiceImpl.statusUpdate.json", (Object)json);
        if (null == param.get("payStatus")) {
            return EncryptUtil.aesEncrypt(JsonUtil.buildNormalBinder().toJson((Object)new HtmlJsonBean("-1", "\u53c2\u6570\u9519\u8bef")), accessKey);
        }
        if (null == param.get("stlNo")) {
            return EncryptUtil.aesEncrypt(JsonUtil.buildNormalBinder().toJson((Object)new HtmlJsonBean("-1", "\u53c2\u6570\u9519\u8bef\uff0c\u7ed3\u7b97\u5355\u53f7\u4e3a\u7a7a")), accessKey);
        }
        if (null == param.get("payDate")) {
            return EncryptUtil.aesEncrypt(JsonUtil.buildNormalBinder().toJson((Object)new HtmlJsonBean("-1", "\u53c2\u6570\u9519\u8bef\uff0c\u7ed3\u7b97\u65f6\u95f4\u4e3a\u7a7a")), accessKey);
        }
        if ("2".equals(param.get("payStatus"))) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("gmtPaySubmit", this.getDate((String)param.get("payDate")));
            this.updateBalanceByCode("2023072819990101", (String)param.get("stlNo"), 1, 0, map);
        } else if ("3".equals(param.get("payStatus"))) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("gmtPaySubmit", this.getDate((String)param.get("payDate")));
            this.updateBalanceByCode("2023072819990101", (String)param.get("stlNo"), -1, 0, map);
        }
        return EncryptUtil.aesEncrypt(JsonUtil.buildNormalBinder().toJson((Object)new HtmlJsonBean()), accessKey);
    }

    private Date getDate(String dateStr) {
        if (StringUtils.isBlank((String)dateStr)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        try {
            Date date = sdf.parse(dateStr);
            return date;
        }
        catch (Exception e) {
            this.logger.error("GstUserServiceImpl.getDate.e", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        String dateStr = "20240911";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        try {
            Date date = sdf.parse(dateStr);
            System.out.println(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public HtmlJsonBean fileUpload(Map<String, Object> map) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String currentDate = sdf.format(new Date());
        String fileName = "JFSC_ParkPay_" + currentDate;
        this.generateTxtFile(fileName);
        this.compressFile(fileName);
        this.downloadFileFromSftp(fileName + ".gz", currentDate);
        return null;
    }

    public void generateTxtFile(String fileName) {
        File directory = new File("/data/doc/");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        fileName = "/data/doc/" + fileName;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));){
            List<PteBalanceamt> pteBalanceamts = this.queryBalanceamtPage(null);
            if (ListUtil.isEmpty(pteBalanceamts)) {
                throw new ApiException("GstUserServiceImpl.generateTxtFile.balanceamtByCode", "\u7ed3\u7b97\u5355\u4e3a\u7a7a\uff01");
            }
            BigDecimal BalanceAmount = BigDecimal.ZERO;
            for (PteBalanceamt pteBalanceamt : pteBalanceamts) {
                BalanceAmount = BalanceAmount.add(pteBalanceamt.getBalanceAmount());
            }
            List<PteBalancelist> pteBalancelists = this.queryBalancelist(null);
            if (ListUtil.isEmpty(pteBalancelists)) {
                throw new ApiException("GstUserServiceImpl.generateTxtFile.ex", "\u7ed3\u7b97\u5355\u4e3a\u7a7a\uff01");
            }
            writer.write("HEAD:" + pteBalancelists.size() + "|" + this.makeBigDecimal(BalanceAmount) + "|\n");
            for (PteBalancelist pteBalancelist : pteBalancelists) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(pteBalancelist.getOpuserCode() + "|");
                stringBuffer.append(pteBalancelist.getOpuserName() + "|");
                stringBuffer.append(this.makeBigDecimal(pteBalancelist.getBalanceFee()) + "|");
                stringBuffer.append(this.dateFormat.format(pteBalancelist.getGmtPayout()) + "|");
                stringBuffer.append(this.dateFormat.format(pteBalancelist.getGmtPaid()) + "|");
                stringBuffer.append(pteBalancelist.getBalanceDate() + "|");
                stringBuffer.append(pteBalancelist.getBalanceTime() + "|");
                stringBuffer.append(pteBalancelist.getBalanceFee2().intValue() + "|");
                stringBuffer.append(this.makeBigDecimal(pteBalancelist.getBalanceFee3()) + "|");
                stringBuffer.append(this.makeBigDecimal(pteBalancelist.getBalanceFee4()) + "|");
                stringBuffer.append(this.makeBigDecimal(pteBalancelist.getBalanceFee5()) + "|");
                stringBuffer.append(this.makeBigDecimal(pteBalancelist.getBalanceAmount1()) + "|");
                stringBuffer.append(this.makeBigDecimal(pteBalancelist.getBalanceFee1()) + "|");
                stringBuffer.append(this.makeBigDecimal(pteBalancelist.getBalanceAmount()) + "|");
                stringBuffer.append(pteBalancelist.getBalancelistCode() + "|\n");
                writer.write(stringBuffer.toString());
            }
        }
        catch (Exception e) {
            this.logger.error("GstUserServiceImpl.generateTxtFile", (Throwable)e);
        }
    }

    private String makeBigDecimal(BigDecimal bigDecimal) {
        if (null == bigDecimal || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            return "0";
        }
        return bigDecimal.setScale(2, 1).toString();
    }

    public void compressFile(String fileName) {
        File directory = new File("/data/doc/");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        fileName = "/data/doc/" + fileName;
        try (GZIPOutputStream gzipOut = new GZIPOutputStream(new FileOutputStream(fileName + ".gz"));){
            File file = new File(fileName);
            byte[] buffer = new byte[1024];
            try (FileInputStream in = new FileInputStream(file);){
                int len;
                while ((len = in.read(buffer)) > 0) {
                    gzipOut.write(buffer, 0, len);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("GstUserServiceImpl.compressFile", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFileFromSftp(String fileName, String currentDate) {
        String password;
        String user;
        String host = GstSupplierServiceImpl.getDdFalgSetting(null, "host", "host");
        if (StringUtils.isBlank((String)host)) {
            host = "192.168.174.43";
        }
        String portStr = GstSupplierServiceImpl.getDdFalgSetting(null, "port", "port");
        int port = 22;
        if (StringUtils.isNotBlank((String)portStr)) {
            port = Integer.parseInt(portStr);
        }
        if (StringUtils.isBlank((String)(user = GstSupplierServiceImpl.getDdFalgSetting(null, "user", "user")))) {
            user = "swift";
        }
        if (StringUtils.isBlank((String)(password = GstSupplierServiceImpl.getDdFalgSetting(null, "password", "password")))) {
            password = "qazwsx@1331";
        }
        String remoteDir = GstSupplierServiceImpl.getDdFalgSetting(null, "remoteDir", "remoteDir");
        remoteDir = StringUtils.isBlank((String)password) ? "/home/sftp/swift/acc/checkfile/pointsMall/" + currentDate + "/" : remoteDir + currentDate + "/";
        File directory = new File("/data/doc/");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        fileName = "/data/doc/" + fileName;
        JSch jsch = new JSch();
        Session session = null;
        Channel channel = null;
        ChannelSftp sftpChannel = null;
        try {
            session = jsch.getSession(user, host, port);
            session.setPassword(password);
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.connect();
            channel = session.openChannel("sftp");
            channel.connect();
            sftpChannel = (ChannelSftp)channel;
            try {
                sftpChannel.cd(remoteDir);
            }
            catch (Exception e) {
                sftpChannel.mkdir(remoteDir);
            }
            File localFile = new File(fileName);
            sftpChannel.put((InputStream)new FileInputStream(localFile), remoteDir + localFile.getName());
            this.logger.error("GstUserServiceImpl.downloadFileFromSftp.sftpChannel", (Object)JsonUtil.buildNormalBinder().toJson((Object)sftpChannel));
        }
        catch (Exception e) {
            this.logger.error("GstUserServiceImpl.downloadFileFromSftp", (Throwable)e);
        }
        finally {
            if (sftpChannel != null) {
                sftpChannel.exit();
            }
            if (channel != null) {
                channel.disconnect();
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }
}

