/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.bus.ext.data.gst.service.impl;

import com.yqbsoft.laser.bus.ext.data.gst.domain.InvInvlist;
import com.yqbsoft.laser.bus.ext.data.gst.domain.InvInvlistDomain;
import com.yqbsoft.laser.bus.ext.data.gst.domain.InvInvlistGoodsDomain;
import com.yqbsoft.laser.bus.ext.data.gst.domain.InvReturn;
import com.yqbsoft.laser.bus.ext.data.gst.domain.InvUserinv;
import com.yqbsoft.laser.bus.ext.data.gst.domain.Invoice;
import com.yqbsoft.laser.bus.ext.data.gst.domain.OrderDetail;
import com.yqbsoft.laser.bus.ext.data.gst.service.GstInvService;
import com.yqbsoft.laser.bus.ext.data.gst.supbase.InvoiceBaseService;
import com.yqbsoft.laser.bus.ext.data.gst.util.EncryptUtil;
import com.yqbsoft.laser.bus.ext.data.gst.util.HttpClientUtil;
import com.yqbsoft.laser.bus.ext.data.gst.util.JsonUtil;
import com.yqbsoft.laser.bus.ext.data.gst.util.RequestUrl;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GstInvServiceImpl
extends InvoiceBaseService
implements GstInvService {
    private static final String SYS_CODE = "GstInvServiceImpl";
    private static final Logger logger = LoggerFactory.getLogger(GstInvServiceImpl.class);

    @Override
    public String saveInv(InvInvlistDomain invInvlist) {
        HashMap<String, Object> map;
        Invoice invoice = new Invoice();
        invoice.setSysNo("jifenshangcheng");
        invoice.setOrderNo(invInvlist.getInvlistOpcode());
        if ("1".equals(invInvlist.getUserinvType())) {
            invoice.setFplxdm("82");
        } else if ("2".equals(invInvlist.getUserinvType())) {
            invoice.setFplxdm("81");
        } else {
            return "error";
        }
        if ("1".equals(invInvlist.getUserinvSort())) {
            invoice.setTitleType("1");
        } else if ("2".equals(invInvlist.getUserinvSort())) {
            invoice.setTitleType("2");
        } else {
            return "error";
        }
        invoice.setXhdwsbh(GstInvServiceImpl.getDdFalgSetting(null, "gst", "Inv_xhdwsbh"));
        InvUserinv invUserinv = JsonUtil.json2Object(invInvlist.getInvlistText(), InvUserinv.class);
        invoice.setGhdwmc(invInvlist.getUserinvMember());
        invoice.setGhdwsbh(invUserinv.getUserinvNo());
        invoice.setGhdwdzdh(invUserinv.getUserinvPhone());
        invoice.setGhdwyhzh(invUserinv.getUserinvBankno());
        invoice.setBz(invInvlist.getInvlistMeno());
        invoice.setEmail(invUserinv.getUserinvUeamil());
        ArrayList<OrderDetail> orderDetails = new ArrayList<OrderDetail>();
        for (InvInvlistGoodsDomain invInvlistGoods : invInvlist.getInvInvlistGoodsDomainList()) {
            OrderDetail orderDetail = new OrderDetail();
            orderDetail.setSpmc(invInvlistGoods.getGoodsName() + "" + invInvlistGoods.getSkuName());
            if (null == invInvlistGoods.getContractGoodsRefnum()) {
                invInvlistGoods.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            BigDecimal subtract = invInvlistGoods.getGoodsCamount().subtract(invInvlistGoods.getContractGoodsRefnum());
            orderDetail.setSpsl(subtract.setScale(2, 1).toString());
            orderDetail.setHsbz("1");
            orderDetail.setHsdj(invInvlistGoods.getPricesetNprice().setScale(2, 1).toString());
            BigDecimal multiply = invInvlistGoods.getPricesetNprice().multiply(subtract);
            orderDetail.setHsje(multiply.setScale(2, 1).toString());
            orderDetail.setSpbm(invInvlistGoods.getGoodsProperty1());
            orderDetail.setZkzje("0");
            orderDetails.add(orderDetail);
        }
        invoice.setOrderDetails(orderDetails);
        String postinv = HttpClientUtil.postinv(RequestUrl.saveInv, JsonUtil.json2Map(JsonUtil.object2Json(invoice)));
        if (StringUtils.isBlank((String)postinv)) {
            return "error";
        }
        InvReturn invReturn = JsonUtil.json2Object(postinv, InvReturn.class);
        if ("10000".equals(invReturn.getCode())) {
            map = new HashMap<String, Object>();
            this.updateInvlistStateByCode(invInvlist.getTenantCode(), invInvlist.getInvlistCode(), 1, 0, map);
            return "success";
        }
        map = new HashMap();
        map.put("invlistDatastr", invReturn.getMsg());
        this.updateInvlistStateByCode(invInvlist.getTenantCode(), invInvlist.getInvlistCode(), -1, 0, map);
        return "error";
    }

    @Override
    public String queryInvPage(Map<String, Object> param) {
        return HttpClientUtil.postinv(RequestUrl.queryInvPage, JsonUtil.json2Map(JsonUtil.object2Json(param)));
    }

    @Override
    public String queryInvStatus(Map<String, Object> param) {
        return HttpClientUtil.postinv(RequestUrl.queryInvStatus, JsonUtil.json2Map(JsonUtil.object2Json(param)));
    }

    @Override
    public void loadInvStatus(String tenantCode) {
        List<InvInvlist> invInvlists = this.queryInvlistPage(tenantCode);
        if (ListUtil.isEmpty(invInvlists)) {
            return;
        }
        for (InvInvlist invInvlist : invInvlists) {
            this.updateInvStatus(invInvlist);
        }
    }

    @Override
    public void updateInvStatus(InvInvlist invInvlist) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("sysNo", "jifenshangcheng");
        param.put("orderNos", invInvlist.getInvlistOpcode());
        String postinv = this.queryInvStatus(param);
        if (StringUtils.isBlank((String)postinv)) {
            return;
        }
        InvReturn invReturn = JsonUtil.json2Object(postinv, InvReturn.class);
        if ("10000".equals(invReturn.getCode())) {
            try {
                String ddFalgSetting = GstInvServiceImpl.getDdFalgSetting(null, "gst", "Inv_Aes_Key");
                String datajson = EncryptUtil.aesDecrypt(invReturn.getData(), ddFalgSetting);
                List<Map> mapList = JsonUtil.json2ObjectList(datajson, Map.class);
                for (Map kpztmap : mapList) {
                    if ("2".equals(kpztmap.get("kpzt"))) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("invlistDatastr", invReturn.getMsg());
                        this.updateInvlistStateByCode(invInvlist.getTenantCode(), invInvlist.getInvlistCode(), -1, 1, map);
                        return;
                    }
                    if (!"1".equals(kpztmap.get("kpzt"))) {
                        return;
                    }
                    HashMap<String, Object> queryparam = new HashMap<String, Object>();
                    queryparam.put("sysNo", "jifenshangcheng");
                    queryparam.put("orderNo", invInvlist.getInvlistOpcode());
                    String json = this.queryInvPage(queryparam);
                    if (StringUtils.isBlank((String)json) || !"10000".equals((invReturn = JsonUtil.json2Object(json, InvReturn.class)).getCode())) continue;
                    String invjson = EncryptUtil.aesDecrypt(invReturn.getData(), ddFalgSetting);
                    Map datamap = JsonUtil.json2Map(invjson);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("invlistOurl", datamap.get("pdfUrl"));
                    map.put("invlistOcode1", datamap.get("internalPdfUrl"));
                    map.put("invlistOcode2", datamap.get("fphm"));
                    this.updateInvlistStateByCode(invInvlist.getTenantCode(), invInvlist.getInvlistCode(), 2, 1, map);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        String json = "{RgCYfgCbrmRUXBcUXJQYdG0v3KpuIMeqRcFDrH5yZEIxhrDGdDQzfriaANfiyX2AxzBdP8uTotj4OUfvooGYXzECuzVK55jrzjzjbo3wRn6KyBrHjffUcAXdbYzMelJCwSo7S2XxgbjWfiGbC2USPs5OU3QsQSwM28CbZhEAbHTzV84ahzooc4Q5OMf8IEzMZBWQR_LfnS0qClj1hGkRFAMybc1ptc-r3mUnZRXNW2m5wKmdvsA10g9Rq5mzteGx5cSxZ54wHj1SqFoeCiDHOPhKG9qWww0myhgDCgOQnn3CL2WEnpC3z6m9PAOXI-PRl5pvBGV6KHMF7y3BeF8QwJwuTsZOJKkXuKEvLuqsDf8WfSWiZ_vFM5VHsF75gts_DwEYNpus-YheSt5Xm5MaT1Sa2UxOcp6FtwtUwn1AOpBJOgaVhT_b80C2I8Z65mTFhsowUegOk8GW0MsSXLan5BaqiQ_fTzsXcxOaAu0meibVjKVNA9zvEogRssmZJo6nHLM6l8CX6N8HZcOu45s-tBAQ5hchnh3uDh5jcWbhz7CXt6xTNk0JI69W8HQ19fGcGANgJ8XD0tECxBjBPJ4yjwH6DwY3lpup7mnVqdYf5sMg2PAlblvn795CbgZE78yOrQw35N4hTzNFN8fqATWet0xKcdcmjHFdJFd4ogfkB-ysFZ3WKCmMNIWmELSX6GiBDSYKVD_4Ojw-_mh3p9SCh2AocqBt7FAyV-0pqaY9ypplmdIgo4sCLhBLWfOCSQBkhnIaJyDveH2iUtr4zlJ7GmuAqkp9lLFUMQPgl4HgUEOv_cexU8BQG4g_ukwpseQ448bYdS3Xk3Bc1heL8qImjTKvuYp98Wpi9SrBISnZ9BFiS8yAjbjxQdG5K9jedjGxMIvWGvVUMyg-wmrgnTyH2KLVyY3fch5VTr9T7YNGGdQHFfJTr-OpV4W8QgwXvwbf9Y38xD1llfziDf7gCeWv1gHWIfpmQfWF3TVv66v573CeDHSBK7BGs3m7zPrfmB-mQcpj5OGJ4oOmvQpJ2v_ed4gxNcSgeZiMxkXpZ7moejg9QT4zKi8Vt5JjCVLS8pSI74zvgyge3xOGhYjlKTcd5cHxTqV7SyDeoDZa9NLVHSwbw1_tTIDCuHJcGcIa7LLbkO2ZrAC6wT_S_L45UzUkb2m9L-hEya7i5F6UaZiiKpknZFfl9s_5-b5bSMJ20yxXL5_yG2TV54ypaa4rUCIutXX7LkfWC1dmiGW9Onz9rp_XN1nNQ7b-A7KFTjODI4pgomHnoXvA6jgf8ecuTtKFNYGu0nTPlXBU1CsssxAzHjFTP32wuoNT0duVMbbaHmJDNamzbCR-1V6_dIwjJroSav9ewPaukpSKL_lnvXAlvx5IlXg2g5QyfoCFgdyiFjvdMjpBEyV0HI63dUZn4WWthfgpKnJ7Zo9-RAKFDKsjDWi6L1m-dNoZMDC4pFjo576tTRH7G_e9BXAxLEasOzm3N6gXRQM-hnin2iQwLoXwj82CZU4LPVKZfWANTN9WtnmkxHlG5RDctCCXv_P-cv7D-cxT2aLxPq8LAV7gIPvpjLo-AaEyzg74zbZEnRsTFciyUNWC-QYKPExd9ji2uXuYHA";
        try {
            String invjson = EncryptUtil.aesDecrypt(json, "p0M9KZ06XlFoI+VqGHA1TQ==");
            System.out.println(invjson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

