/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.haihang.service.impl;

import com.hnair.opcnet.api.complextype.PageParam;
import com.hnair.opcnet.api.ods.hr.HrOrg;
import com.hnair.opcnet.api.ods.hr.HrOrgRequest;
import com.hnair.opcnet.api.ods.hr.HrOrgResponse;
import com.hnair.opcnet.api.v2.ApiResponse;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.data.domain.org.OrgCompanyReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.org.OrgEmployeeDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.org.OrgEmployeeReDomain;
import com.yqbsoft.laser.service.ext.bus.data.domain.um.UmUserinfoReDomain;
import com.yqbsoft.laser.service.ext.bus.haihang.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.ext.bus.haihang.domain.UmUserReDomainBean;
import com.yqbsoft.laser.service.ext.bus.haihang.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.ext.bus.haihang.request.HrOrgAndEmpApiV1Impl;
import com.yqbsoft.laser.service.ext.bus.haihang.request.HrOrgAndEmpApiV2Impl;
import com.yqbsoft.laser.service.ext.bus.haihang.service.DataHaihangHrService;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataHaihangHrServiceImpl
extends BaseServiceImpl
implements DataHaihangHrService {
    private static final String SYS_CODE = "hh.DataHaihangHrServiceImpl";
    private static String ui_page = "page";
    private static String ui_rows = "rows";
    private static String dao_startRow = "startRow";
    private static String dao_endRow = "endRow";

    @Override
    public String updateStaffInfoPage(String tenantCode, Map<String, String> map) throws ApiException {
        return "success";
    }

    @Override
    public String updateStaffInfoJob(String tenantCode) throws ApiException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date(System.currentTimeMillis());
        Calendar calendar = Calendar.getInstance();
        date.setTime(date.getTime() - 3600000L);
        calendar.setTime(date);
        calendar.add(5, -1);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("startUpdatedTime", formatter.format(calendar.getTime()));
        param.put("endUpdatedTime", formatter.format(date));
        return "success";
    }

    @Override
    public ApiResponse findEmpsV3(Map<String, String> map) throws ApiException {
        HrOrgAndEmpApiV2Impl hrOrgAndEmpApiImpl = new HrOrgAndEmpApiV2Impl();
        return hrOrgAndEmpApiImpl.findEmpsV3(map);
    }

    @Override
    public HrOrgResponse findOrgs(Map<String, String> map) throws ApiException {
        HrOrgAndEmpApiV1Impl hrOrgAndEmpApiV1 = new HrOrgAndEmpApiV1Impl();
        HrOrgRequest hrOrgRequest = new HrOrgRequest();
        PageParam pageParam = new PageParam();
        pageParam.setPageIndex(Integer.valueOf(map.get("rows")));
        pageParam.setPageSize(Integer.valueOf(map.get("page")));
        hrOrgRequest.setPageParam(pageParam);
        hrOrgRequest.setNodeId(map.get("nodeId"));
        return hrOrgAndEmpApiV1.findOrgs(hrOrgRequest);
    }

    void updateStaffInfo(String tenantCode, Map<String, String> param) throws ApiException {
        Integer page = 1;
        int rows = 100;
        HrOrgAndEmpApiV1Impl hrOrgAndEmpApiV1 = new HrOrgAndEmpApiV1Impl();
        HrOrgAndEmpApiV2Impl hrOrgAndEmpApiV2 = new HrOrgAndEmpApiV2Impl();
        HrOrgRequest hrOrgRequest = new HrOrgRequest();
        PageParam pageParam = new PageParam();
        pageParam.setPageIndex(Integer.valueOf(1));
        pageParam.setPageSize(Integer.valueOf(20));
        hrOrgRequest.setPageParam(pageParam);
        HashMap<String, HrOrg> companyMap = new HashMap<String, HrOrg>();
        HashMap<String, String> qjCompanyMap = new HashMap<String, String>();
        long total = 0L;
        do {
            int updateUserFlag = 0;
            int updateEmpFlag = 0;
            QueryResult<OrgEmployeeReDomain> employeePage = this.queryEmployeePage(page, rows, tenantCode);
            total = employeePage.getTotal();
            List employeeList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)employeePage.getList()), OrgEmployeeReDomain.class);
            if (ListUtil.isEmpty((Collection)employeeList)) {
                return;
            }
            for (OrgEmployeeReDomain orgEmployeeReDomain : employeeList) {
                HrOrg hrOrg;
                UmUserReDomainBean userByPcode = this.getUserByPcode(orgEmployeeReDomain.getUserinfoCode(), tenantCode);
                if (null == userByPcode || StringUtils.isBlank((String)userByPcode.getUserOcode())) continue;
                param.put("employeeId", userByPcode.getUserOcode());
                ApiResponse apiResponse = hrOrgAndEmpApiV2.findEmpsV3(param);
                List data = apiResponse.getData();
                Map employeeMap = (Map)data.get(data.size() - 1);
                if (MapUtil.isEmpty((Map)employeeMap)) continue;
                if (!Objects.equals(userByPcode.getUserRelname(), employeeMap.get("name").toString())) {
                    userByPcode.setUserRelname(employeeMap.get("name").toString());
                    updateUserFlag = 1;
                }
                if (!Objects.equals(userByPcode.getUserSex(), employeeMap.get("sex").toString())) {
                    userByPcode.setUserSex(employeeMap.get("sex").toString());
                    updateUserFlag = 1;
                }
                if (!Objects.equals(userByPcode.getUserBirthday(), employeeMap.get("birthday").toString())) {
                    userByPcode.setUserBirthday(employeeMap.get("birthday").toString());
                    updateUserFlag = 1;
                }
                if (!Objects.equals(userByPcode.getUserPhone(), employeeMap.get("mobile").toString())) {
                    userByPcode.setUserPhone(employeeMap.get("mobile").toString());
                    updateUserFlag = 2;
                }
                if (updateUserFlag > 0) {
                    this.updateUser(userByPcode);
                }
                if (updateUserFlag > 1) {
                    UmUserinfoReDomain userinfoReDomain = this.getUserinfo(orgEmployeeReDomain.getUserinfoCode(), tenantCode);
                    if (null == userinfoReDomain) continue;
                    UmUserinfoDomainBean umUserinfoDomainBean = new UmUserinfoDomainBean();
                    userinfoReDomain.setUserinfoPhone(employeeMap.get("mobile").toString());
                    try {
                        BeanUtils.copyAllPropertysNotNull((Object)umUserinfoDomainBean, (Object)userinfoReDomain);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.updateUserinfo(umUserinfoDomainBean);
                }
                if (1 != Integer.parseInt(employeeMap.get("flag").toString())) {
                    this.deleteEmployee(orgEmployeeReDomain.getEmployeeId());
                    continue;
                }
                if (!Objects.equals(orgEmployeeReDomain.getEmployeeName(), employeeMap.get("name").toString())) {
                    orgEmployeeReDomain.setEmployeeName(employeeMap.get("name").toString());
                    updateEmpFlag = 1;
                }
                if (!Objects.equals(orgEmployeeReDomain.getEmployeePhone(), employeeMap.get("mobile").toString())) {
                    orgEmployeeReDomain.setEmployeePhone(employeeMap.get("mobile").toString());
                    updateEmpFlag = 1;
                }
                if (companyMap.get(orgEmployeeReDomain.getCompanyCode()) == null) {
                    hrOrgRequest.setNodeId(employeeMap.get("companyNodeId").toString());
                    HrOrgResponse hrOrgResponse = hrOrgAndEmpApiV1.findOrgs(hrOrgRequest);
                    if (hrOrgResponse == null || ListUtil.isEmpty((Collection)hrOrgResponse.getOrgs())) continue;
                    hrOrg = (HrOrg)hrOrgResponse.getOrgs().get(hrOrgResponse.getOrgs().size() - 1);
                    companyMap.put(orgEmployeeReDomain.getCompanyCode(), hrOrg);
                } else {
                    hrOrg = (HrOrg)companyMap.get(orgEmployeeReDomain.getCompanyCode());
                }
                if (hrOrg != null && !Objects.equals(orgEmployeeReDomain.getCompanyShortname(), hrOrg.getFullName())) {
                    String companyOcode = null;
                    if (qjCompanyMap.get(orgEmployeeReDomain.getCompanyCode()) == null) {
                        OrgCompanyReDomain companyByCode = this.getCompanyByCode(orgEmployeeReDomain.getCompanyCode(), tenantCode);
                        companyOcode = companyByCode.getCompanyOcode();
                        qjCompanyMap.put(orgEmployeeReDomain.getCompanyCode(), companyByCode.getCompanyOcode());
                    } else {
                        companyOcode = (String)qjCompanyMap.get(orgEmployeeReDomain.getCompanyCode());
                    }
                    if (companyOcode.equals(hrOrg.getNodeId())) {
                        orgEmployeeReDomain.setCompanyShortname(hrOrg.getFullName());
                    }
                    updateEmpFlag = 2;
                }
                if (updateEmpFlag > 0) {
                    this.updateEmployee((OrgEmployeeDomain)orgEmployeeReDomain);
                }
                if (updateEmpFlag <= 1) continue;
                this.deleteEmployee(orgEmployeeReDomain.getEmployeeId());
            }
            Integer n = page;
            Integer n2 = page = Integer.valueOf(page + 1);
        } while (total > (long)page.intValue() * (long)rows);
    }

    protected QueryResult<OrgEmployeeReDomain> queryEmployeePage(Integer page, Integer rows, String tenantCode) {
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        String apiCode = "org.employee.queryEmployeePage";
        param.put("tenantCode", tenantCode);
        param.put("page", String.valueOf(page));
        param.put("rows", String.valueOf(rows));
        DataHaihangHrServiceImpl.makePage(param);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("map", JsonUtil.buildNormalBinder().toJson(param));
        this.logger.error("hh.DataHaihangHrServiceImpl.queryEmployeePage.param", (Object)JsonUtil.buildNormalBinder().toJson(param));
        String queryEmployeeStr = this.internalInvoke(apiCode, params);
        return (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(queryEmployeeStr, QueryResult.class);
    }

    protected UmUserReDomainBean getUserByPcode(String userinfoCode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        String apiCode = "um.user.getUserByPcode";
        param.put("userPcode", userinfoCode);
        param.put("tenantCode", tenantCode);
        this.logger.error("hh.DataHaihangHrServiceImpl.getUserByPcode.param", param);
        String umUserStr = this.internalInvoke(apiCode, param);
        if (umUserStr == null) {
            return null;
        }
        return (UmUserReDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(umUserStr, UmUserReDomainBean.class);
    }

    protected UmUserinfoReDomain getUserinfo(String userinfoCode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        String apiCode = "um.user.getUserinfoByCode";
        param.put("userinfoCode", userinfoCode);
        param.put("tenantCode", tenantCode);
        this.logger.error("hh.DataHaihangHrServiceImpl.getUserinfo.param", param);
        String userinfoStr = this.internalInvoke(apiCode, param);
        return (UmUserinfoReDomain)JsonUtil.buildNormalBinder().getJsonToObject(userinfoStr, UmUserinfoReDomain.class);
    }

    protected OrgCompanyReDomain getCompanyByCode(String companyCode, String tenantCode) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        String apiCode = "org.company.getCompanyByCode";
        param.put("companyCode", companyCode);
        param.put("tenantCode", tenantCode);
        this.logger.error("hh.DataHaihangHrServiceImpl.getCompanyByCode.param", param);
        String companyStr = this.internalInvoke(apiCode, param);
        return (OrgCompanyReDomain)JsonUtil.buildNormalBinder().getJsonToObject(companyStr, OrgCompanyReDomain.class);
    }

    protected void updateUser(UmUserDomainBean umUserDomainBean) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        String apiCode = "um.user.updateUser";
        param.put("umUserDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
        this.logger.error("hh.DataHaihangHrServiceImpl.updateUser.param", param);
        String result = this.internalInvoke(apiCode, param);
        this.logger.error("hh.DataHaihangHrServiceImpl.updateUser.result", (Object)result);
    }

    protected void updateUserinfo(UmUserinfoDomainBean umUserinfoDomainBean) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        String apiCode = "um.user.updateUserinfo";
        param.put("umUserinfoDomainBean", JsonUtil.buildNormalBinder().toJson((Object)umUserinfoDomainBean));
        this.logger.error("hh.DataHaihangHrServiceImpl.updateUserinfo.param", param);
        String result = this.internalInvoke(apiCode, param);
        this.logger.error("hh.DataHaihangHrServiceImpl.updateUserinfo.result", (Object)result);
    }

    protected void deleteEmployee(Integer employeeId) {
        HashMap<String, Integer> param = new HashMap<String, Integer>(1);
        String apiCode = "org.employee.deleteEmployee";
        param.put("employeeId", employeeId);
        this.logger.error("hh.DataHaihangHrServiceImpl.deleteEmployee.param", param);
        String result = this.internalInvoke(apiCode, param);
        this.logger.error("hh.DataHaihangHrServiceImpl.deleteEmployee.result", (Object)result);
    }

    protected void updateEmployee(OrgEmployeeDomain orgEmployeeDomain) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        String apiCode = "org.employee.updateEmployee";
        param.put("orgEmployeeDomain", JsonUtil.buildNormalBinder().toJson((Object)orgEmployeeDomain));
        this.logger.error("hh.DataHaihangHrServiceImpl.updateEmployee.param", param);
        String result = this.internalInvoke(apiCode, param);
        this.logger.error("hh.DataHaihangHrServiceImpl.updateEmployee.result", (Object)result);
    }

    public static void makePage(Map<String, Object> map) {
        String rows;
        if (null == map || map.isEmpty()) {
            return;
        }
        String page = (String)map.get(ui_page);
        if (null == page) {
            return;
        }
        if (StringUtils.isBlank((String)page)) {
            page = "1";
        }
        if (StringUtils.isBlank((String)(rows = (String)map.get(ui_rows))) || "0".equals(rows)) {
            rows = "10";
        }
        map.put(dao_startRow, Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue());
        map.put(dao_endRow, Long.valueOf(Long.valueOf(rows).intValue() * Long.valueOf(page).intValue()).intValue());
        map.put(ui_rows, Long.valueOf(rows).intValue());
        map.put(ui_page, Long.valueOf(page).intValue());
    }
}

