/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl;

import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ext.bus.jushuitan.api.GoodsMessageService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.EditSkuDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.RsSkuReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.returnout.OrderMessageReturn;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl.DateBaseService;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class GoodsMessageServiceImpl
extends DateBaseService
implements GoodsMessageService {
    private static String SYS_CODE = "jst.GoodsMessageServiceImpl";

    @Override
    public OrderMessageReturn sendSku(String app_key, String action_code, String timestamp, String version, String charset, String biz, String sign, String tenantCode) {
        logger.info(SYS_CODE + ".sendSku.app_key", (Object)app_key);
        logger.info(SYS_CODE + ".sendSku.action_code", (Object)action_code);
        logger.info(SYS_CODE + ".sendSku.timestamp", (Object)timestamp);
        logger.info(SYS_CODE + ".sendSku.version", (Object)version);
        logger.info(SYS_CODE + ".sendSku.charset", (Object)charset);
        logger.info(SYS_CODE + ".sendSku.biz", (Object)biz);
        logger.info(SYS_CODE + ".sendSku.sign", (Object)sign);
        logger.info(SYS_CODE + ".sendSku.tenantCode", (Object)tenantCode);
        if (StringUtils.isBlank((String)tenantCode)) {
            return new OrderMessageReturn("-1", "\u6267\u884c\u5931\u8d25");
        }
        OrderMessageReturn orderMessageReturn = new OrderMessageReturn("0", "\u6267\u884c\u6210\u529f");
        Map bizMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(biz, String.class, Object.class);
        if (MapUtil.isEmpty((Map)bizMap)) {
            logger.info(SYS_CODE + ".bizMap is null");
            return new OrderMessageReturn("-1", "\u6267\u884c\u5931\u8d25");
        }
        Object qty = bizMap.get("qty");
        if (null == qty) {
            logger.info(SYS_CODE + ".qty is null", (Object)tenantCode);
            return orderMessageReturn;
        }
        BigDecimal bigDecimal = new BigDecimal(qty.toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("goodsType", "00");
        map.put("tenantCode", tenantCode);
        map.put("skuNo", bizMap.get("skuId").toString());
        QueryResult<RsSkuReDomain> rsSkuReDomainQueryResult = this.querySkuListByMap(map);
        for (RsSkuReDomain rsSku : rsSkuReDomainQueryResult.getList()) {
            if (bigDecimal.compareTo(rsSku.getGoodsSupplynum()) != 0 || bigDecimal.compareTo(rsSku.getGoodsNum()) != 0) {
                EditSkuDomain editSkuDomain = new EditSkuDomain();
                editSkuDomain.setSkuId(rsSku.getSkuId());
                editSkuDomain.setSkuCode(rsSku.getSkuCode());
                editSkuDomain.setGoodsCode(rsSku.getGoodsCode());
                editSkuDomain.setTenantCode(rsSku.getTenantCode());
                editSkuDomain.setGoodsNum(bigDecimal);
                editSkuDomain.setGoodsSupplynum(editSkuDomain.getGoodsNum());
                this.sendUpdateSkuEdit(editSkuDomain);
                continue;
            }
            logger.info(SYS_CODE + ".rsSku." + rsSku.getSkuCode(), (Object)rsSku.getGoodsSupplynum());
        }
        return orderMessageReturn;
    }
}

