/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.GoodsUploadDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.RsSkuReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.ShopGoodsUploadDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.UmUserinfo;
import com.yqbsoft.laser.service.ext.bus.jushuitan.request.GoodsUploadRequest;
import com.yqbsoft.laser.service.ext.bus.jushuitan.request.ShopGoodsQueryRequest;
import com.yqbsoft.laser.service.ext.bus.jushuitan.request.ShopGoodsUploadRequest;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.GoodsUploadResponse;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.ShopGoodsQueryResponse;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.ShopGoodsQueryResponseDatas;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.ShopGoodsUploadResponse;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.GoodsService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl.DateBaseService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.util.SignUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GoodsServiceImpl
extends DateBaseService
implements GoodsService {
    private static final String SYS_CODE = "jst.GoodsServiceImpl";

    @Override
    public String upLoadGoods(List<RsSkuReDomain> skuList) throws ApiException {
        if (ListUtil.isEmpty(skuList)) {
            this.logger.error("jst.GoodsServiceImpl.upLoadGoods skuList is empty");
            return "jst.GoodsServiceImpl.upLoadGoods skuList is empty";
        }
        String tenantCode = skuList.get(0).getTenantCode();
        String url = this.getDdFalgSetting(tenantCode, "goodsUploadUrl", "goodsUploadUrl", "");
        String appkey = this.getDdFalgSetting(tenantCode, "jstappkey", "jstappkey", "");
        String secret = this.getDdFalgSetting(tenantCode, "jstsecret", "jstsecret", "");
        String access_token = this.gettoken("jushuitan", tenantCode);
        GoodsUploadRequest goodsUploadRequest = this.makeGoodsUploadRequest(skuList);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        params.put("biz", JsonUtil.buildNonNullBinder().toJson((Object)goodsUploadRequest));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = this.buildQuery(params);
        String responseStr = this.execute(parmStr, url);
        if (StringUtils.isBlank((String)responseStr)) {
            this.logger.error("jst.GoodsServiceImpl.upLoadGoods responseStr is null");
            return "jst.GoodsServiceImpl.upLoadGoods responseStr is null";
        }
        GoodsUploadResponse goodsUploadResponse = (GoodsUploadResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, GoodsUploadResponse.class);
        if (null == goodsUploadResponse) {
            this.logger.error("jst.GoodsServiceImpl.upLoadGoods goodsUploadResponse is null", (Object)responseStr);
            return "jst.GoodsServiceImpl.upLoadGoods goodsUploadResponse is null" + responseStr;
        }
        if (0 != goodsUploadResponse.getCode()) {
            this.logger.error("jst.GoodsServiceImpl.upLoadGoods goodsUploadResponse is error", (Object)goodsUploadResponse.getMsg());
            return "jst.GoodsServiceImpl.upLoadGoods goodsUploadResponse is error" + goodsUploadResponse.getMsg();
        }
        return "success";
    }

    @Override
    public String upLoadShopGoods(List<RsSkuReDomain> skuList) throws ApiException {
        if (ListUtil.isEmpty(skuList)) {
            this.logger.error("jst.GoodsServiceImpl.upLoadShopGoods skuList is empty");
            return "jst.GoodsServiceImpl.upLoadShopGoods skuList is empty";
        }
        String tenantCode = skuList.get(0).getTenantCode();
        UmUserinfo user = this.getUser(skuList.get(0).getTenantCode(), skuList.get(0).getMemberCode());
        if (null == user) {
            this.logger.error("jst.GoodsServiceImpl.upLoadShopGoods user is null");
            return "jst.GoodsServiceImpl.upLoadShopGoods user is null";
        }
        String shopId = user.getCompanyCode();
        if (StringUtils.isBlank((String)shopId)) {
            this.logger.error("jst.GoodsServiceImpl.upLoadShopGoods shopId is null");
            return "jst.GoodsServiceImpl.upLoadShopGoods shopId is null";
        }
        String url = this.getDdFalgSetting(tenantCode, "shopGoodsUploadUrl", "shopGoodsUploadUrl", "");
        String appkey = this.getDdFalgSetting(tenantCode, "jstappkey", "jstappkey", "");
        String secret = this.getDdFalgSetting(tenantCode, "jstsecret", "jstsecret", "");
        String access_token = this.gettoken("jushuitan", tenantCode);
        ShopGoodsUploadRequest shopGoodsUploadRequest = this.makeShopGoodsUploadRequest(skuList, Integer.parseInt(shopId));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        params.put("biz", JsonUtil.buildNonNullBinder().toJson((Object)shopGoodsUploadRequest));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = this.buildQuery(params);
        String responseStr = this.execute(parmStr, url);
        if (StringUtils.isBlank((String)responseStr)) {
            this.logger.error("jst.GoodsServiceImpl.upLoadShopGoods responseStr is null");
            return "jst.GoodsServiceImpl.upLoadShopGoods responseStr is null";
        }
        ShopGoodsUploadResponse shopGoodsUploadResponse = (ShopGoodsUploadResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, ShopGoodsUploadResponse.class);
        if (null == shopGoodsUploadResponse) {
            this.logger.error("jst.GoodsServiceImpl.upLoadGoods shopGoodsUploadResponse is null", (Object)responseStr);
            return "jst.GoodsServiceImpl.upLoadShopGoods shopGoodsUploadResponse is null" + responseStr;
        }
        if (0 != shopGoodsUploadResponse.getCode()) {
            this.logger.error("jst.GoodsServiceImpl.upLoadGoods shopGoodsUploadResponse is error", (Object)shopGoodsUploadResponse.getMsg());
            return "jst.GoodsServiceImpl.upLoadShopGoods shopGoodsUploadResponse is error" + shopGoodsUploadResponse.getMsg();
        }
        return "success";
    }

    @Override
    public List<ShopGoodsQueryResponseDatas> queryShopGoods(Integer shopId, String skuNo, String tenantCode) throws ApiException {
        if (null == shopId || StringUtils.isBlank((String)skuNo)) {
            this.logger.error("jst.GoodsServiceImpl.queryShopGoods param is null", (Object)(shopId + "--" + skuNo));
            return null;
        }
        String url = this.getDdFalgSetting(tenantCode, "shopGoodsQueryUrl", "shopGoodsQueryUrl", "");
        String appkey = this.getDdFalgSetting(tenantCode, "jstappkey", "jstappkey", "");
        String secret = this.getDdFalgSetting(tenantCode, "jstsecret", "jstsecret", "");
        String access_token = this.gettoken("jushuitan", tenantCode);
        ShopGoodsQueryRequest shopGoodsQueryRequest = new ShopGoodsQueryRequest();
        shopGoodsQueryRequest.setShop_id(shopId);
        shopGoodsQueryRequest.setSku_ids(skuNo);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        params.put("biz", JsonUtil.buildNonNullBinder().toJson((Object)shopGoodsQueryRequest));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = this.buildQuery(params);
        String responseStr = this.execute(parmStr, url);
        if (StringUtils.isBlank((String)responseStr)) {
            this.logger.error("jst.GoodsServiceImpl.queryShopGoods responseStr is null");
            return null;
        }
        ShopGoodsQueryResponse shopGoodsQueryResponse = (ShopGoodsQueryResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, ShopGoodsQueryResponse.class);
        if (null == shopGoodsQueryResponse) {
            this.logger.error("jst.GoodsServiceImpl.queryShopGoods shopGoodsQueryResponse is null", (Object)responseStr);
            return null;
        }
        if (0 != shopGoodsQueryResponse.getCode()) {
            this.logger.error("jst.GoodsServiceImpl.queryShopGoods shopGoodsQueryResponse is error", (Object)shopGoodsQueryResponse.getMsg());
            return null;
        }
        if (null == shopGoodsQueryResponse.getData()) {
            this.logger.error("jst.GoodsServiceImpl.queryShopGoods shopGoodsQueryResponseData is null", (Object)responseStr);
            return null;
        }
        if (ListUtil.isEmpty(shopGoodsQueryResponse.getData().getDatas())) {
            this.logger.error("jst.GoodsServiceImpl.queryShopGoods shopGoodsQueryResponseDatas is null", (Object)responseStr);
            return null;
        }
        return shopGoodsQueryResponse.getData().getDatas();
    }

    @Override
    public String queryInventory(String ids, String startTime, String endTime, Integer page, Integer size) throws ApiException {
        return null;
    }

    private ShopGoodsUploadRequest makeShopGoodsUploadRequest(List<RsSkuReDomain> skuList, Integer shopId) {
        ShopGoodsUploadRequest shopGoodsUploadRequest = new ShopGoodsUploadRequest();
        ArrayList<ShopGoodsUploadDomain> shopGoodsUploadDomains = new ArrayList<ShopGoodsUploadDomain>();
        ShopGoodsUploadDomain shopGoodsUploadDomain = null;
        for (RsSkuReDomain rsSkuReDomain : skuList) {
            shopGoodsUploadDomain = new ShopGoodsUploadDomain();
            shopGoodsUploadDomains.add(shopGoodsUploadDomain);
            shopGoodsUploadDomain.setSku_id(rsSkuReDomain.getSkuNo());
            shopGoodsUploadDomain.setI_id(rsSkuReDomain.getSkuNo());
            shopGoodsUploadDomain.setName(rsSkuReDomain.getGoodsName());
            shopGoodsUploadDomain.setShop_i_id(rsSkuReDomain.getSkuCode());
            shopGoodsUploadDomain.setShop_sku_id(rsSkuReDomain.getSkuCode());
            shopGoodsUploadDomain.setShop_id(shopId);
        }
        shopGoodsUploadRequest.setItems(shopGoodsUploadDomains);
        return shopGoodsUploadRequest;
    }

    private GoodsUploadRequest makeGoodsUploadRequest(List<RsSkuReDomain> skuList) {
        GoodsUploadRequest goodsUploadRequest = new GoodsUploadRequest();
        ArrayList<GoodsUploadDomain> goodsUploadDomains = new ArrayList<GoodsUploadDomain>();
        GoodsUploadDomain goodsUploadDomain = null;
        String picPre = this.getPicPre(skuList.get(0).getTenantCode());
        for (RsSkuReDomain rsSkuReDomain : skuList) {
            goodsUploadDomain = new GoodsUploadDomain();
            goodsUploadDomains.add(goodsUploadDomain);
            goodsUploadDomain.setSku_id(rsSkuReDomain.getSkuNo());
            goodsUploadDomain.setI_id(rsSkuReDomain.getSkuNo());
            goodsUploadDomain.setBrand(rsSkuReDomain.getBrandName());
            goodsUploadDomain.setVc_name(rsSkuReDomain.getClasstreeName());
            goodsUploadDomain.setS_price(rsSkuReDomain.getPricesetNprice());
            goodsUploadDomain.setPic(picPre + rsSkuReDomain.getDataPic());
            goodsUploadDomain.setName(rsSkuReDomain.getGoodsName());
            goodsUploadDomain.setC_price(rsSkuReDomain.getPricesetBaseprice());
            goodsUploadDomain.setMarket_price(rsSkuReDomain.getPricesetMakeprice());
        }
        goodsUploadRequest.setItems(goodsUploadDomains);
        return goodsUploadRequest;
    }
}

