/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OcContractReDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OrderGoodsDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.OrderPayDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.UmUserinfo;
import com.yqbsoft.laser.service.ext.bus.jushuitan.request.OrderUploadRequest;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrderUploadData;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrderUploadDatas;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OrderUploadResponse;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.OrderService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl.DateBaseService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.util.SignUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class OrderServiceImpl
extends DateBaseService
implements OrderService {
    private static final String SYS_CODE = "OrderServiceImpl";

    @Override
    public String saveOrder(OcContractReDomain ocContractDomain) {
        String shopId;
        if (null == ocContractDomain) {
            this.logger.error("OrderServiceImpl.saveOrder is null");
            return "error";
        }
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("OrderServiceImpl.saveOrder goodsList is null", (Object)ocContractDomain.getContractBillcode());
            return "error";
        }
        UmUserinfo user = this.getUser(ocContractDomain.getTenantCode(), ocContractDomain.getMemberCode());
        if (null == user) {
            this.logger.error("OrderServiceImpl.saveOrder getUser is null");
            return "error";
        }
        if (null == ocContractDomain.getGmtCreate()) {
            ocContractDomain.setGmtCreate(new Date());
        }
        if (null == ocContractDomain.getGmtModified()) {
            ocContractDomain.setGmtModified(ocContractDomain.getGmtCreate());
        }
        if (StringUtils.isBlank((String)(shopId = user.getCompanyCode()))) {
            this.logger.error("OrderServiceImpl.saveOrder shopId  is null");
            return "error";
        }
        ArrayList<OrderUploadRequest> orderUploadRequests = new ArrayList<OrderUploadRequest>();
        OrderUploadRequest orderUploadRequest = new OrderUploadRequest();
        orderUploadRequest.setShop_id(Integer.parseInt(shopId));
        orderUploadRequest.setSo_id(ocContractDomain.getContractBillcode());
        orderUploadRequest.setOrder_date(this.getDataStr(ocContractDomain.getGmtCreate()));
        orderUploadRequest.setShop_status(this.getState(ocContractDomain.getDataState()));
        orderUploadRequest.setShop_buyer_id(ocContractDomain.getMemberBcode());
        this.makeAddress(orderUploadRequest, ocContractDomain.getGoodsReceiptArrdess());
        orderUploadRequest.setReceiver_name(ocContractDomain.getGoodsReceiptMem());
        orderUploadRequest.setReceiver_phone(ocContractDomain.getGoodsReceiptPhone());
        orderUploadRequest.setPay_amount(ocContractDomain.getContractMoney());
        if (StringUtils.isBlank((String)ocContractDomain.getFreight())) {
            ocContractDomain.setFreight("0");
        }
        if (2 == ocContractDomain.getDataState()) {
            OrderPayDomain orderPayDomain = new OrderPayDomain();
            orderPayDomain.setOuter_pay_id("*************");
            orderPayDomain.setPay_date(this.getDataStr(ocContractDomain.getGmtCreate()));
            orderPayDomain.setAmount(ocContractDomain.getContractMoney());
            orderPayDomain.setBuyer_account(ocContractDomain.getMemberBcode());
            orderPayDomain.setSeller_account(ocContractDomain.getMemberCode());
            orderPayDomain.setPayment("\u7ebf\u4e0a");
            orderUploadRequest.setPay(orderPayDomain);
        }
        orderUploadRequest.setFreight(new BigDecimal(ocContractDomain.getFreight()));
        orderUploadRequest.setShop_modified(this.getDataStr(ocContractDomain.getGmtModified()));
        String picUrl = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "picUrl", "picUrl", "");
        ArrayList<OrderGoodsDomain> orderGoodsDomains = new ArrayList<OrderGoodsDomain>();
        OrderGoodsDomain orderGoodsDomain = null;
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            orderGoodsDomain = new OrderGoodsDomain();
            orderGoodsDomain.setSku_id(ocContractGoodsDomain.getSkuNo());
            orderGoodsDomain.setShop_sku_id(ocContractGoodsDomain.getSkuCode());
            orderGoodsDomain.setAmount(ocContractGoodsDomain.getContractGoodsMoney());
            orderGoodsDomain.setBase_price(ocContractGoodsDomain.getContractGoodsInmoney());
            orderGoodsDomain.setQty(ocContractGoodsDomain.getGoodsCamount().intValue());
            orderGoodsDomain.setName(ocContractGoodsDomain.getSkuName());
            orderGoodsDomain.setOuter_oi_id(ocContractGoodsDomain.getContractGoodsCode());
            orderGoodsDomain.setPic(picUrl + ocContractGoodsDomain.getDataPic());
            orderGoodsDomains.add(orderGoodsDomain);
        }
        orderUploadRequest.setItems(orderGoodsDomains);
        orderUploadRequests.add(orderUploadRequest);
        String url = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "saveOrderUrl", "saveOrderUrl", "");
        String appkey = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "jstappkey", "jstappkey", "");
        String secret = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "jstsecret", "jstsecret", "");
        String access_token = this.gettoken("jushuitan", ocContractDomain.getTenantCode());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        params.put("biz", JsonUtil.buildNonNullBinder().toJson(orderUploadRequests));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = this.buildQuery(params);
        String responseStr = this.execute(parmStr, url);
        if (StringUtils.isBlank((String)responseStr)) {
            this.logger.error("OrderServiceImpl.saveOrder responseStr is null");
            return "error";
        }
        OrderUploadResponse orderUploadResponse = (OrderUploadResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, OrderUploadResponse.class);
        if (0 != orderUploadResponse.getCode()) {
            this.logger.error("OrderServiceImpl.saveOrder orderUploadResponse is error", (Object)orderUploadResponse.getMsg());
            return "error";
        }
        OrderUploadData data = orderUploadResponse.getData();
        if (null == data) {
            this.logger.error("OrderServiceImpl.saveOrder data is error", (Object)responseStr);
            return "error";
        }
        List<OrderUploadDatas> datas = data.getDatas();
        if (ListUtil.isEmpty(datas)) {
            this.logger.error("OrderServiceImpl.saveOrder datas is error", (Object)responseStr);
            return "error";
        }
        for (OrderUploadDatas orderUploadDatas : datas) {
            if (orderUploadDatas.isIssuccess()) {
                this.updateContractContractNbillcode(ocContractDomain.getContractBillcode(), orderUploadDatas.getO_id().toString(), ocContractDomain.getTenantCode());
                continue;
            }
            this.logger.error("OrderServiceImpl.saveOrder orderUploadDatas is error", (Object)responseStr);
            return "error";
        }
        return "success";
    }

    @Override
    public String saveOrderCancelAfterPay(OcContractReDomain ocContractDomain) {
        String shopId;
        if (null == ocContractDomain) {
            this.logger.error("OrderServiceImpl.saveOrderCancelAfterPay is null");
            return "error";
        }
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("OrderServiceImpl.saveOrderCancelAfterPay goodsList is null", (Object)ocContractDomain.getContractBillcode());
            return "error";
        }
        UmUserinfo user = this.getUser(ocContractDomain.getTenantCode(), ocContractDomain.getMemberCode());
        if (null == user) {
            this.logger.error("OrderServiceImpl.saveOrderCancelAfterPay getUser is null");
            return "error";
        }
        String picUrl = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "picUrl", "picUrl", "");
        if (null == ocContractDomain.getGmtCreate()) {
            ocContractDomain.setGmtCreate(new Date());
        }
        if (null == ocContractDomain.getGmtModified()) {
            ocContractDomain.setGmtModified(ocContractDomain.getGmtCreate());
        }
        if (StringUtils.isBlank((String)(shopId = user.getCompanyCode()))) {
            this.logger.error("OrderServiceImpl.saveOrderCancelAfterPay shopId  is null");
            return "error";
        }
        ArrayList<OrderUploadRequest> orderUploadRequests = new ArrayList<OrderUploadRequest>();
        OrderUploadRequest orderUploadRequest = new OrderUploadRequest();
        orderUploadRequest.setShop_id(Integer.parseInt(shopId));
        orderUploadRequest.setSo_id(ocContractDomain.getContractBillcode());
        orderUploadRequest.setOrder_date(this.getDataStr(ocContractDomain.getGmtCreate()));
        orderUploadRequest.setShop_status("TRADE_CLOSED");
        orderUploadRequest.setShop_buyer_id(ocContractDomain.getMemberBcode());
        this.makeAddress(orderUploadRequest, ocContractDomain.getGoodsReceiptArrdess());
        orderUploadRequest.setReceiver_name(ocContractDomain.getGoodsReceiptMem());
        orderUploadRequest.setReceiver_phone(ocContractDomain.getGoodsReceiptPhone());
        orderUploadRequest.setPay_amount(ocContractDomain.getContractMoney());
        if (StringUtils.isBlank((String)ocContractDomain.getFreight())) {
            ocContractDomain.setFreight("0");
        }
        orderUploadRequest.setFreight(new BigDecimal(ocContractDomain.getFreight()));
        orderUploadRequest.setShop_modified(this.getDataStr(ocContractDomain.getGmtModified()));
        ArrayList<OrderGoodsDomain> orderGoodsDomains = new ArrayList<OrderGoodsDomain>();
        OrderGoodsDomain orderGoodsDomain = null;
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            orderGoodsDomain = new OrderGoodsDomain();
            orderGoodsDomain.setSku_id(ocContractGoodsDomain.getSkuNo());
            orderGoodsDomain.setShop_sku_id(ocContractGoodsDomain.getSkuCode());
            orderGoodsDomain.setAmount(ocContractGoodsDomain.getContractGoodsMoney());
            orderGoodsDomain.setBase_price(ocContractGoodsDomain.getContractGoodsInmoney());
            orderGoodsDomain.setQty(ocContractGoodsDomain.getGoodsCamount().intValue());
            orderGoodsDomain.setName(ocContractGoodsDomain.getSkuName());
            orderGoodsDomain.setOuter_oi_id(ocContractGoodsDomain.getContractGoodsCode());
            orderGoodsDomain.setPic(picUrl + ocContractGoodsDomain.getDataPic());
            orderGoodsDomains.add(orderGoodsDomain);
        }
        orderUploadRequest.setItems(orderGoodsDomains);
        orderUploadRequests.add(orderUploadRequest);
        String url = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "saveOrderUrl", "saveOrderUrl", "");
        String appkey = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "jstappkey", "jstappkey", "");
        String secret = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "jstsecret", "jstsecret", "");
        String access_token = this.gettoken("jushuitan", ocContractDomain.getTenantCode());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        params.put("biz", JsonUtil.buildNonNullBinder().toJson(orderUploadRequests));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = this.buildQuery(params);
        String responseStr = this.execute(parmStr, url);
        if (StringUtils.isBlank((String)responseStr)) {
            this.logger.error("OrderServiceImpl.saveOrderCancelAfterPay responseStr is null");
            return "error";
        }
        OrderUploadResponse orderUploadResponse = (OrderUploadResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, OrderUploadResponse.class);
        if (0 != orderUploadResponse.getCode()) {
            this.logger.error("OrderServiceImpl.saveOrderCancelAfterPay orderUploadResponse is error", (Object)orderUploadResponse.getMsg());
            return "error";
        }
        OrderUploadData data = orderUploadResponse.getData();
        if (null == data) {
            this.logger.error("OrderServiceImpl.saveOrderCancelAfterPay data is error", (Object)responseStr);
            return "error";
        }
        List<OrderUploadDatas> datas = data.getDatas();
        if (ListUtil.isEmpty(datas)) {
            this.logger.error("OrderServiceImpl.saveOrderCancelAfterPay datas is error", (Object)responseStr);
            return "error";
        }
        return "success";
    }

    private void makeAddress(OrderUploadRequest orderUploadRequest, String goodsReceiptArrdess) {
        if (StringUtils.isBlank((String)goodsReceiptArrdess)) {
            return;
        }
        String[] split = goodsReceiptArrdess.split(",");
        if (split.length != 4) {
            this.logger.error("OrderServiceImpl.makeAddress is error", (Object)goodsReceiptArrdess);
            throw new ApiException("\u5730\u5740\u4fe1\u606f\u9519\u8bef");
        }
        orderUploadRequest.setReceiver_state(split[0]);
        orderUploadRequest.setReceiver_city(split[1]);
        orderUploadRequest.setReceiver_district(split[2]);
        orderUploadRequest.setReceiver_address(split[3]);
    }

    @Override
    public String saveOrderCancelBeforePay(OcContractReDomain ocContractDomain) {
        String shopId;
        if (null == ocContractDomain) {
            this.logger.error("OrderServiceImpl.saveOrderCancelBeforePay is null");
            return "error";
        }
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("OrderServiceImpl.saveOrderCancelBeforePay goodsList is null", (Object)ocContractDomain.getContractBillcode());
            return "error";
        }
        String picUrl = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "picUrl", "picUrl", "");
        UmUserinfo user = this.getUser(ocContractDomain.getTenantCode(), ocContractDomain.getMemberCode());
        if (null == user) {
            this.logger.error("OrderServiceImpl.saveOrderCancelBeforePay getUser is null");
            return "error";
        }
        if (null == ocContractDomain.getGmtCreate()) {
            ocContractDomain.setGmtCreate(new Date());
        }
        if (null == ocContractDomain.getGmtModified()) {
            ocContractDomain.setGmtModified(ocContractDomain.getGmtCreate());
        }
        if (StringUtils.isBlank((String)(shopId = user.getCompanyCode()))) {
            this.logger.error("OrderServiceImpl.saveOrderCancelBeforePay shopId  is null");
            return "error";
        }
        ArrayList<OrderUploadRequest> orderUploadRequests = new ArrayList<OrderUploadRequest>();
        OrderUploadRequest orderUploadRequest = new OrderUploadRequest();
        orderUploadRequest.setShop_id(Integer.parseInt(shopId));
        orderUploadRequest.setSo_id(ocContractDomain.getContractBillcode());
        orderUploadRequest.setOrder_date(this.getDataStr(ocContractDomain.getGmtCreate()));
        orderUploadRequest.setShop_status("TRADE_CLOSED_BY_TAOBAO");
        orderUploadRequest.setShop_buyer_id(ocContractDomain.getMemberBcode());
        this.makeAddress(orderUploadRequest, ocContractDomain.getGoodsReceiptArrdess());
        orderUploadRequest.setReceiver_name(ocContractDomain.getGoodsReceiptMem());
        orderUploadRequest.setReceiver_phone(ocContractDomain.getGoodsReceiptPhone());
        orderUploadRequest.setPay_amount(ocContractDomain.getContractMoney());
        if (StringUtils.isBlank((String)ocContractDomain.getFreight())) {
            ocContractDomain.setFreight("0");
        }
        orderUploadRequest.setFreight(new BigDecimal(ocContractDomain.getFreight()));
        orderUploadRequest.setShop_modified(this.getDataStr(ocContractDomain.getGmtModified()));
        ArrayList<OrderGoodsDomain> orderGoodsDomains = new ArrayList<OrderGoodsDomain>();
        OrderGoodsDomain orderGoodsDomain = null;
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            orderGoodsDomain = new OrderGoodsDomain();
            orderGoodsDomain.setSku_id(ocContractGoodsDomain.getSkuNo());
            orderGoodsDomain.setShop_sku_id(ocContractGoodsDomain.getSkuCode());
            orderGoodsDomain.setAmount(ocContractGoodsDomain.getContractGoodsMoney());
            orderGoodsDomain.setBase_price(ocContractGoodsDomain.getContractGoodsInmoney());
            orderGoodsDomain.setQty(ocContractGoodsDomain.getGoodsCamount().intValue());
            orderGoodsDomain.setName(ocContractGoodsDomain.getSkuName());
            orderGoodsDomain.setOuter_oi_id(ocContractGoodsDomain.getContractGoodsCode());
            orderGoodsDomain.setPic(picUrl + ocContractGoodsDomain.getDataPic());
            orderGoodsDomains.add(orderGoodsDomain);
        }
        orderUploadRequest.setItems(orderGoodsDomains);
        orderUploadRequests.add(orderUploadRequest);
        String url = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "saveOrderUrl", "saveOrderUrl", "");
        String appkey = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "jstappkey", "jstappkey", "");
        String secret = this.getDdFalgSetting(ocContractDomain.getTenantCode(), "jstsecret", "jstsecret", "");
        String access_token = this.gettoken("jushuitan", ocContractDomain.getTenantCode());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        params.put("biz", JsonUtil.buildNonNullBinder().toJson(orderUploadRequests));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = this.buildQuery(params);
        String responseStr = this.execute(parmStr, url);
        if (StringUtils.isBlank((String)responseStr)) {
            this.logger.error("OrderServiceImpl.saveOrderCancelBeforePay responseStr is null");
            return "error";
        }
        OrderUploadResponse orderUploadResponse = (OrderUploadResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, OrderUploadResponse.class);
        if (0 != orderUploadResponse.getCode()) {
            this.logger.error("OrderServiceImpl.saveOrderCancelBeforePay orderUploadResponse is error", (Object)orderUploadResponse.getMsg());
            return "error";
        }
        OrderUploadData data = orderUploadResponse.getData();
        if (null == data) {
            this.logger.error("OrderServiceImpl.saveOrderCancelBeforePay data is error", (Object)responseStr);
            return "error";
        }
        List<OrderUploadDatas> datas = data.getDatas();
        if (ListUtil.isEmpty(datas)) {
            this.logger.error("OrderServiceImpl.saveOrderCancelBeforePay datas is error", (Object)responseStr);
            return "error";
        }
        return "success";
    }

    protected void updateContractContractNbillcode(String contractBillcode, String contractNbillcode, String tenantCode) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        String apiCode = "oc.contract.updateContractContractNbillcode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("contractBillcode", contractBillcode);
        paramMap.put("contractNbillcode", contractNbillcode);
        paramMap.put("tenantCode", tenantCode);
        String s = this.internalInvoke(apiCode, paramMap);
        this.logger.error("OrderServiceImpl.updateContractContractNbillcode." + s, (Object)((Object)paramMap).toString());
    }

    private String getDataStr(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    private String getState(Integer dataState) {
        if (1 == dataState) {
            return "WAIT_BUYER_PAY";
        }
        if (2 == dataState) {
            return "WAIT_SELLER_SEND_GOODS";
        }
        if (3 == dataState) {
            return "WAIT_BUYER_CONFIRM_GOODS";
        }
        if (4 == dataState) {
            return "TRADE_FINISHED";
        }
        return "error";
    }
}

