/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl;

import com.yqbsoft.laser.service.ext.bus.jushuitan.request.ShopQueryRequest;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.ShopQueryResponse;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.ShopQueryResponseDatas;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.ShopService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl.DateBaseService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.util.SignUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ShopServiceImpl
extends DateBaseService
implements ShopService {
    private static String SYS_CODE = "jst.ShopServiceImpl";

    @Override
    public List<ShopQueryResponseDatas> queryShopPage(Integer page, Integer size, List<Integer> ids, String tenantCode) {
        String url = this.getDdFalgSetting(tenantCode, "querShopUrl", "querShopUrl", "");
        String appkey = this.getDdFalgSetting(tenantCode, "jstappkey", "jstappkey", "");
        String secret = this.getDdFalgSetting(tenantCode, "jstsecret", "jstsecret", "");
        String access_token = this.gettoken("jushuitan", tenantCode);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("access_token", access_token);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        ShopQueryRequest shopQueryRequest = new ShopQueryRequest();
        shopQueryRequest.setShop_ids(ids);
        shopQueryRequest.setPage_index(page);
        shopQueryRequest.setPage_size(size);
        params.put("biz", JsonUtil.buildNormalBinder().toJson((Object)shopQueryRequest));
        String sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parm = this.buildQuery(params);
        String resPonseStr = this.execute(parm, url);
        if (StringUtils.isBlank((String)resPonseStr)) {
            this.logger.error(SYS_CODE + ".queryShopPage resPonseStr is null");
            return new ArrayList<ShopQueryResponseDatas>();
        }
        ShopQueryResponse shopQueryResponse = (ShopQueryResponse)JsonUtil.buildNormalBinder().getJsonToObject(resPonseStr, ShopQueryResponse.class);
        if (null == shopQueryResponse) {
            this.logger.error(SYS_CODE + ".queryShopPage shopQueryResponse is null", (Object)resPonseStr);
            return new ArrayList<ShopQueryResponseDatas>();
        }
        if (null == shopQueryResponse.getData()) {
            this.logger.error(SYS_CODE + ".queryShopPage shopQueryResponseData is null", (Object)resPonseStr);
            return new ArrayList<ShopQueryResponseDatas>();
        }
        if (ListUtil.isEmpty(shopQueryResponse.getData().getDatas())) {
            this.logger.error(SYS_CODE + ".queryShopPage shopQueryResponseDatas is null", (Object)resPonseStr);
            return new ArrayList<ShopQueryResponseDatas>();
        }
        return shopQueryResponse.getData().getDatas();
    }
}

