/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl;

import com.yqbsoft.laser.service.ext.bus.jushuitan.api.OauthMessageService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.domain.DisOauthTokenDomain;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OauthResponse;
import com.yqbsoft.laser.service.ext.bus.jushuitan.response.OauthResponseData;
import com.yqbsoft.laser.service.ext.bus.jushuitan.returnout.OauthMessageReturn;
import com.yqbsoft.laser.service.ext.bus.jushuitan.service.impl.DateBaseService;
import com.yqbsoft.laser.service.ext.bus.jushuitan.util.SignUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class OauthMessageServiceImpl
extends DateBaseService
implements OauthMessageService {
    private static String SYS_CODE = "jst.OauthMessageServiceImpl";

    @Override
    public OauthMessageReturn sendToken(String tenantCode, String app_key, String code, String state, String sign) {
        logger.error(SYS_CODE + "sendToken start parm", (Object)(tenantCode + "=" + app_key + "=" + code + "=" + state + "=" + sign));
        OauthMessageReturn oauthMessageReturn = new OauthMessageReturn();
        oauthMessageReturn.setCode(0);
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)code)) {
            oauthMessageReturn.setCode(-1);
            return oauthMessageReturn;
        }
        String url = OauthMessageServiceImpl.getDdFalgSetting(tenantCode, "sendTokenUrl", "sendTokenUrl", "");
        String appkey = OauthMessageServiceImpl.getDdFalgSetting(tenantCode, "jstappkey", "jstappkey", "");
        String secret = OauthMessageServiceImpl.getDdFalgSetting(tenantCode, "jstsecret", "jstsecret", "");
        HashMap<String, String> signatureVerificationParam = new HashMap<String, String>();
        signatureVerificationParam.put("app_key", app_key);
        signatureVerificationParam.put("code", code);
        signatureVerificationParam.put("state", state);
        if (!this.signatureVerification(signatureVerificationParam, secret, sign)) {
            logger.error(SYS_CODE + ".sendToken signatureVerification is false", (Object)(JsonUtil.buildNormalBinder().toJson(signatureVerificationParam) + "=" + sign));
            oauthMessageReturn.setCode(-1);
            return oauthMessageReturn;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appkey);
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("grant_type", "authorization_code");
        params.put("charset", "utf-8");
        params.put("code", code);
        sign = SignUtil.getSign(secret, params);
        params.put("sign", sign);
        String parmStr = OauthMessageServiceImpl.buildQuery(params);
        String responseStr = OauthMessageServiceImpl.execute(parmStr, url);
        if (StringUtils.isBlank((String)responseStr)) {
            logger.error(SYS_CODE + ".sendToken responseStr is null");
            oauthMessageReturn.setCode(-1);
            return oauthMessageReturn;
        }
        OauthResponse oauthResponse = (OauthResponse)JsonUtil.buildNormalBinder().getJsonToObject(responseStr, OauthResponse.class);
        if (0 != oauthResponse.getCode()) {
            logger.error(SYS_CODE + ".sendToken responseStr is error", (Object)oauthResponse.getMsg());
            oauthMessageReturn.setCode(-1);
            return oauthMessageReturn;
        }
        if (null == oauthResponse.getData()) {
            logger.error(SYS_CODE + ".sendToken oauthResponse is error", (Object)responseStr);
            oauthMessageReturn.setCode(-1);
            return oauthMessageReturn;
        }
        String res = this.saveDisTokenForJst(oauthResponse.getData(), tenantCode, state);
        if (!"success".equals(res)) {
            logger.error(SYS_CODE + ".sendToken saveDisTokenForJst is error", (Object)responseStr);
            oauthMessageReturn.setCode(-1);
            return oauthMessageReturn;
        }
        return oauthMessageReturn;
    }

    private boolean signatureVerification(Map<String, String> params, String secret, String sign) {
        String sign1 = SignUtil.getSign(secret, params);
        boolean equals = sign.equals(sign1);
        if (equals) {
            return equals;
        }
        logger.error(SYS_CODE + ".signatureVerification", (Object)(sign + "===" + sign1));
        return equals;
    }

    private String saveDisTokenForJst(OauthResponseData oauthResponseData, String tenantCode, String state) {
        if (null == oauthResponseData) {
            logger.error(SYS_CODE + ".saveDisToken.json");
            return "error";
        }
        String api = "dis.oauth.saveOauthToken";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        DisOauthTokenDomain disOauthTokenDomain = new DisOauthTokenDomain();
        disOauthTokenDomain.setChannelCode("jushuitan");
        disOauthTokenDomain.setChannelName("\u805a\u6c34\u6f6d");
        disOauthTokenDomain.setMemberCode(state);
        disOauthTokenDomain.setMemberName("\u805a\u6c34\u6f6d");
        disOauthTokenDomain.setOauthTokenExpireIn(Integer.valueOf(oauthResponseData.getExpires_in()));
        disOauthTokenDomain.setOauthTokenRefreshToken(oauthResponseData.getRefresh_token());
        disOauthTokenDomain.setOauthTokenToken(oauthResponseData.getAccess_token());
        Long updateTime = new Date().getTime() + (long)disOauthTokenDomain.getOauthTokenExpireIn().intValue();
        disOauthTokenDomain.setOauthTokenUpdateTime(new Date(updateTime));
        disOauthTokenDomain.setTenantCode(tenantCode);
        paramMap.put("disOauthTokenDomain", JsonUtil.buildNormalBinder().toJson((Object)disOauthTokenDomain));
        this.internalInvoke(api, paramMap);
        return "success";
    }
}

